<?php 
    function get_nested_menu_array($menu_name) {
    $menu_items = wp_get_nav_menu_items($menu_name);
    $menu = [];

    if (!$menu_items) {
        return $menu;
    }

    // Index all items by their ID
    $items_by_id = [];
    foreach ($menu_items as $item) {
        $items_by_id[$item->ID] = [
            'ID'       => $item->ID,
            'title'    => $item->title,
            'url'      => $item->url,
            'parent'   => $item->menu_item_parent,
            'children' => []
        ];
    }

    // Build tree
    foreach ($items_by_id as $id => &$item) {
        if ($item['parent'] && isset($items_by_id[$item['parent']])) {
            $items_by_id[$item['parent']]['children'][] = &$item;
        }
    }
    unset($item); // Break reference

    // Return only top-level items
    $nested_menu = [];
    foreach ($items_by_id as $item) {
        if (empty($item['parent'])) {
            $nested_menu[] = $item;
        }
    }

    return $nested_menu;
}

// Usage
$menu_name = 'footer';
$menu_items = get_nested_menu_array($menu_name);
// echo "<pre>";
// print_r($menu_items);
// echo "</pre>";
// die;


?>


<footer class="footerSection">
        <div class="btx-main-wrapper contanerPadding">
            <!-- Header Section -->
            <header class="btx-header-zone">
                <div class="btx-header-container">
                    <div class="btx-title-section">
                        <h2 class="modern-news-heading">
                            <?php
                                $let_talk_head = get_field("let_talk_head", "option");
                                echo $let_talk_head ? $let_talk_head : 'Not Available';                            
                            ?>
                        </h2>
                        <?php
                            $let_talk_paragraph = get_field("let_talk_paragraph", "option");
                            echo $let_talk_paragraph ? $let_talk_paragraph : 'Not Available';                            
                        ?>
                    </div>
                    <?php
                        $let_talk_btn = get_field("let_talk_btn", "option");
                        echo $let_talk_btn ? $let_talk_btn : 'Not Available';                            
                    ?>
                </div>
            </header>

            <!-- Main Content Area -->
            <main class="btx-content-area">
                <!-- Marketplace and Locations Section -->
                <section class="btx-marketplace-zone">
                    <div class="btx-marketplace-content">
                        <!-- Left Side - BuildTwin Info -->
                        <div class="btx-brand-section">
                            <?php
                                $buildTwin_head = get_field("buildTwin_head", "option");
                                echo $buildTwin_head ? $buildTwin_head : 'Not Available';  
                                $buildTwin_btn = get_field("buildTwin_btn", "option");
                                echo $buildTwin_btn ? $buildTwin_btn : 'Not Available';                            
                            ?>
                        </div>

                        <!-- Right Side - Location Grid -->
                        <div class="btx-locations-container">
                            
                            <!-- <div class="btx-location-card">
                                <div class="btx-location-graphic btx-usa-graphic">
                                    <img src="/wp-content/uploads/2025/07/Screenshot-2025-07-03-145238.png" alt="">
                                </div>
                                <span class="btx-location-label">USA</span>
                            </div> -->
                            <?php if (have_rows('buildtwin_country', 'option')): ?>
                                <?php while (have_rows('buildtwin_country', 'option')): the_row(); ?>
                                    <?php
                                        $image = get_sub_field('buildtwin_img');
                                        $country = get_sub_field('country');
                                    ?>
                                    <div class="btx-location-card">
                                        <div class="btx-location-graphic btx-<?php echo strtolower($country); ?>-graphic">
                                            <?php if (!empty($image)): ?>
                                                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($country); ?>">
                                            <?php endif; ?>
                                        </div>
                                        <span class="btx-location-label">
                                                <?php
                                echo $country ? $country : 'Not Available';                             
                            ?></span>
                                    </div>
                                <?php endwhile; ?>
                            <?php else: ?>
                                <p>No BuildTwin country data found.</p>
                            <?php endif; ?>


                        </div>
                    </div>
                </section>

                <!-- Categories Section -->
                <section class="btx-categories-zone">
                    <div class="btx-categories-grid">
                        <!-- Column 1: Sectors -->
                        <?php
                            if (isset($menu_items) && is_array($menu_items)) {
                                foreach ($menu_items as $parent) {
                                    if (!isset($parent['title']) || !is_string($parent['title'])) {
                                        continue; // skip if parent title is missing or invalid
                                    }

                                    echo '<div class="btx-category-col">';
                                    if (trim($parent['title']) !== "Menu Item") {
                                        echo '<h3 class="btx-category-heading">' . htmlspecialchars($parent['title']) . '</h3>';
                                    }
                                    if (isset($parent['children']) && is_array($parent['children']) && count($parent['children']) > 0) {
                                        echo '<ul class="btx-category-items">';
                                        foreach ($parent['children'] as $child) {
                                            if (!isset($child['title']) || !is_string($child['title'])) {
                                                continue; // skip if child title is missing or invalid
                                            }

                                            $childUrl = isset($child['url']) && is_string($child['url']) ? $child['url'] : '#';

                                            echo '<li><a href="' . htmlspecialchars($childUrl) . '" class="btx-item-link">' . htmlspecialchars($child['title']) . '</a></li>';
                                        }
                                        echo '</ul>';
                                    } else {
                                        echo '<p class="btx-no-items">No items available.</p>';
                                    }

                                    echo '</div>';
                                }
                            } else {
                                echo '<p>Error: Invalid or missing menu data.</p>';
                            }
                        ?>
                    </div>
                </section>
            </main>
        </div>
    </footer>

    <?php wp_footer(); ?>
    <script>
        AOS.init({
            duration: 1300, // 1000ms = 1 second
            // once: true      // only animate once when scrolling down
        });
    </script>
</body>

</html>