  document.addEventListener('DOMContentLoaded', function () {
            const testimonials = document.querySelectorAll('.testimonial-item');
            const prevBtn = document.querySelector('.testimonial-prev');
            const nextBtn = document.querySelector('.testimonial-next');
            let currentIndex = 0;

            function showTestimonial(index) {
                // Hide all testimonials
                testimonials.forEach(testimonial => {
                    testimonial.classList.remove('active');
                });

                // Show current testimonial
                testimonials[index].classList.add('active');

                // Update button states
                updateButtonStates();
            }

            function updateButtonStates() {
                // Disable prev button if at first testimonial
                if (currentIndex === 0) {
                    prevBtn.classList.add('disabled');
                } else {
                    prevBtn.classList.remove('disabled');
                }

                // Disable next button if at last testimonial
                if (currentIndex === testimonials.length - 1) {
                    nextBtn.classList.add('disabled');
                } else {
                    nextBtn.classList.remove('disabled');
                }
            }

            // Previous button click
            prevBtn.addEventListener('click', function () {
                if (!this.classList.contains('disabled')) {
                    currentIndex = Math.max(0, currentIndex - 1);
                    showTestimonial(currentIndex);
                }
            });

            // Next button click
            nextBtn.addEventListener('click', function () {
                if (!this.classList.contains('disabled')) {
                    currentIndex = Math.min(testimonials.length - 1, currentIndex + 1);
                    showTestimonial(currentIndex);
                }
            });

            // Initialize
            updateButtonStates();
        });