<?php
define('Version', time());

require_once get_template_directory() . '/helpers.php';

function enqueueChildStyle()
{
    // Custom CSS files with unique handles
    wp_enqueue_style('nave-css', get_template_directory_uri() . '/assets/css/nav.css', array(), Version, 'all');
    wp_enqueue_style('home-css', get_template_directory_uri() . '/assets/css/homepage.css', array(), Version, 'all');
    wp_enqueue_style('contact-css', get_template_directory_uri() . '/assets/css/contact.css', array(), Version, 'all');
    // Font Awesome
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css', array(), null, 'all');
     // Google Fonts
    wp_enqueue_style('google-fonts', 'https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap', array(), null);

    // Font Awesome
    wp_enqueue_style('fontawesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css', array(), '6.0.0');

    // Slick Carousel
    wp_enqueue_style('slick-css', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css', array(), '1.8.1');
    wp_enqueue_style('slick-theme-css', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css', array('slick-css'), '1.8.1');

    // AOS Animation Library
    wp_enqueue_style('aos-css', 'https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css', array(), '2.3.4');
}
add_action('wp_enqueue_scripts', 'enqueueChildStyle');


function enqueue_custom_scripts() {
    // Optionally deregister WordPress's default jQuery if you need a specific version
    wp_deregister_script('jquery');

    // Enqueue jQuery from CDN
    wp_enqueue_script('jquery-cdn', 'https://code.jquery.com/jquery-3.6.0.min.js', array(), '3.6.0', true);

    // Bootstrap (if needed, remove if not using)
    wp_enqueue_script('bootstrap-bundle', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js', array('jquery-cdn'), '5.3.3', true);

    // Slick Carousel
    wp_enqueue_script('slick-carousel', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js', array('jquery-cdn'), '1.8.1', true);

    // AOS Animation Library
    wp_enqueue_script('aos', 'https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js', array(), '2.3.4', true);

    // Local custom JS
    wp_enqueue_script('main-js', get_template_directory_uri() . '/assets/js/main.js', array('jquery-cdn'), '1.0', true);

    // AOS Init Inline Script
    wp_add_inline_script('aos', 'AOS.init({ duration: 1300 });');
}
add_action('wp_enqueue_scripts', 'enqueue_custom_scripts');

function allow_svg_upload($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'allow_svg_upload');

add_theme_support( 'menus' );
add_action('acf/init', 'my_acf_op_init');



function my_acf_op_init()
{

  // Check function exists.
  if (function_exists('acf_add_options_page')) {

    // Register options page.
    $option_page = acf_add_options_page(array(
      'page_title'    => __('Theme Settings'),
      'menu_title'    => __('Theme Settings'),
      'menu_slug'     => 'theme-general-settings',
      'capability'    => 'edit_posts',
      'redirect'      => false
    ));
  }
}





add_action('wpcf7_mail_sent', 'custom_save_submission_to_db');

function custom_save_submission_to_db($contact_form) {
    $submission = WPCF7_Submission::get_instance();

    if ($submission) {
        $data = $submission->get_posted_data();

        global $wpdb;
        $table = $wpdb->prefix . 'your_custom_table'; // Create this table first

        $wpdb->insert($table, [
            'first_name'   => sanitize_text_field($data['first-name']),
            'last_name'    => sanitize_text_field($data['last-name']),
            'email'        => sanitize_email($data['your-email']),
            'phone'        => sanitize_text_field($data['phone-number']),
            'job_title'    => sanitize_text_field($data['job-title']),
            'company_name' => sanitize_text_field($data['company-name']),
            'country'      => sanitize_text_field($data['country']),
            'message'      => sanitize_textarea_field($data['your-message']),
            'submitted_at' => current_time('mysql')
        ]);
    }
}


function register_footer_menu() {
    register_nav_menu('footer', __('Footer Menu'));
}
add_action('init', 'register_footer_menu');

?>
