<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.6.0
 */

defined('ABSPATH') || exit;

get_header();


// Include breadcrumb template
 Egns\Helper\Egns_Helper::egns_template_part('breadcrumb', 'templates/breadcrumb-archive');

?>

<div class="shop-page pt-120 mb-120">
	<div class="container">
		<div class="egns-nexaq-product-archive">
			<?php if (woocommerce_product_loop()) : ?>
				<div class="woocommerce-archive-header">
					<?php do_action('woocommerce_before_shop_loop'); ?>
				</div>
				<div class="row g-4">
					<?php while (have_posts()) : the_post(); ?>
						<div class="col-lg-<?php echo \Egns\Helper\Egns_Helper::egns_get_theme_option('product_column') ?> col-md-6">
							<?php do_action('egns_nexaq_shop_page_product_card'); ?>
						</div>
					<?php endwhile; ?>
				</div>
				<div class="row">
                    <div class="col-lg-12 d-flex justify-content-center">
                        <div class="innerpage-pagination-area">
                            <?php
                            // Pagination
                            echo Egns\Inc\Blog_Helper::egns_pagination();
                            ?>
                        </div>
                    </div>
				</div>
			<?php else : ?>
				<?php do_action('egns_nexaq_shop_page_no_products'); ?>
			<?php endif; ?>
		</div>

	</div>
</div>

<?php
get_footer();