<?php

/**
 * The main template file
 *
 * Template Name: Project Info Flow Template
 *
 * @link https:   //developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package vernex
 * @since 1.0.0
 * 
 */
get_header();

if (!is_front_page()) {
    $posts_per_page_option = Egns\Helper\Egns_Helper::egns_get_theme_option('posts_per_page_option_portfolio');
    // Include breadcrumb template
    Egns\Helper\Egns_Helper::egns_template_part('breadcrumb', 'templates/breadcrumb-archive');
}

?>



<div class="project-info-flow-page sec-mar">
    <div class="container-fluid">
        <div class="row gx-xxl-5 gx-xl-4 gx-lg-3 g-4 gy-xl-5" id="project-archive-info-flow">
            <?php
            $args = array(
                'post_type'      => 'project',
                'post_status'    => 'publish',
                'posts_per_page' => 8,
                'paged'          => (get_query_var('paged')) ? get_query_var('paged') : 1
            );
            $wp_query = new WP_Query($args);

            if ($wp_query->have_posts()) {

                while ($wp_query->have_posts()):
                    $wp_query->the_post();
            ?>
                    <?php echo apply_filters('egns_filter_blog_single_template', Egns\Helper\Egns_Helper::egns_get_template_part('project', 'parts/archive-info-flow')); ?>

            <?php
                endwhile;
            } else {
                // Include global posts not found
                Egns\Helper\Egns_Helper::egns_template_part('content', 'templates/posts-not-found');
            }
            ?>
        </div>
        <div class="row">
            <div class="col-lg-12 d-flex justify-content-center">
                <div id="archive-load-more-project-info-flow" class="load-more-for-project-btn">
                    <button class="primary-btn2 bounce_up mt-70">
                        <span>
                            <?php echo esc_html__('Load More', 'vernex'); ?>
                            <svg viewBox="0 0 13 20">
                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                            </svg>
                            <img src="<?php echo esc_sql(get_template_directory_uri() . '/assets/img/loading.gif') ?>" class="loading-gif" style="display: none; height:14px; width:14px" alt="<?php echo esc_attr__('image', 'vernex') ?>" />
                        </span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>