<?php

/**
 * The main template file
 *
 * Template Name: Blog Grid Template
 *
 * @link https:   //developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package vernex
 * @since 1.0.0
 * 
 */

get_header();

if (!is_front_page()):
    // Include breadcrumb template
    Egns\Helper\Egns_Helper::egns_template_part('breadcrumb', 'templates/breadcrumb-page');
endif;

?>
<div class="blog-grid-page pt-120 mb-120">
    <div class="container">
        <div class="row gy-5">
            <?php
            $args = array(
                'post_type'      => 'post',
                'post_status'    => 'publish',
                'posts_per_page' => 9,
                'paged'          => (get_query_var('paged')) ? get_query_var('paged') : 1
            );
            $wp_query = new WP_Query($args);

            if ($wp_query->have_posts()) {

                while ($wp_query->have_posts()):
                    $wp_query->the_post();

                    echo apply_filters('egns_filter_blog_single_template', Egns\Helper\Egns_Helper::egns_get_template_part('blog', 'templates/grid/post/post', get_post_format() ? get_post_format() : 'default'));

                endwhile;

            } else {
                // Include global posts not found
                Egns\Helper\Egns_Helper::egns_template_part('content', 'templates/posts-not-found');
            }
            ?>
        </div>
        <?php if (!empty(Egns\Inc\Blog_Helper::egns_pagination())): ?>
            <div class="row wow animate fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
                <div class="col-lg-12 d-flex justify-content-center">
                    <div class="innerpage-pagination-area">
                        <?php
                        // Pagination
                        echo Egns\Inc\Blog_Helper::egns_pagination();
                        ?>
                    </div>
                </div>
            </div>
        <?php endif ?>
    </div>
</div>

<?php get_footer(); ?>