<?php
$gallery_data = Egns\Helper\Egns_Helper::egns_properties_value('vernex_properties_gallery');

?>
<div class="property-details-page pt-120 mb-120">
    <div class="container">
        <div class="property-details-img-grp mb-70">
            <div class="row g-4">
                <?php if (has_post_thumbnail()): ?>
                    <div class="col-lg-4 col-md-6">
                        <?php the_post_thumbnail() ?>
                    </div>
                <?php else : ?>
                    <?php if (!empty($gallery_data)): ?>
                        <div class="col-lg-4 col-md-6">
                            <img src="<?php echo esc_url($gallery_data[0]['vernex_gallery_item']['url']) ?>" alt="<?php echo esc_attr__('Image', 'vernex') ?>">
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
                <div class="col-lg-4 col-md-6">
                    <div class="video-and-img-area">
                        <div class="row g-4">
                            <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('vernex_properties_video_poster', 'url'))): ?>
                                <div class="col-lg-12">
                                    <div class="video-area">
                                        <img src="<?php echo esc_url(Egns\Helper\Egns_Helper::egns_properties_value('vernex_properties_video_poster', 'url')) ?>" alt="<?php echo esc_attr__('Image', 'vernex') ?>">
                                        <a data-fancybox="video-player"
                                            href="<?php echo esc_url(Egns\Helper\Egns_Helper::egns_properties_value('vernex_properties_video_link')) ?>" class="play-btn">
                                            <div class="icon">
                                                <svg class="video-circle" x="0px" y="0px"
                                                    width="57px" viewBox="0 0 206 206"
                                                    style="enable-background:new 0 0 206 206;" xml:space="preserve">
                                                    <circle class="circle" stroke-miterlimit="10" cx="103" cy="103"
                                                        r="100"></circle>
                                                    <path class="circle-half top-half" stroke-width="4"
                                                        stroke-miterlimit="10"
                                                        d="M16.4,53C44,5.2,105.2-11.2,153,16.4s64.2,88.8,36.6,136.6">
                                                    </path>
                                                    <path class="circle-half bottom-half" stroke-width="4"
                                                        stroke-miterlimit="10"
                                                        d="M189.6,153C162,200.8,100.8,217.2,53,189.6S-11.2,100.8,16.4,53">
                                                    </path>
                                                </svg>
                                                <svg class="play-icon" width="18" height="21" viewBox="0 0 22 26">
                                                    <path
                                                        d="M21.0414 12.6872C21.0414 11.9857 20.68 11.3397 20.0741 10.9581L3.71746 0.667707C3.05587 0.252161 2.24905 0.221801 1.5565 0.588432C0.866106 0.954858 0.453125 1.63119 0.453125 2.39695V22.9762C0.453125 23.742 0.866072 24.4181 1.55755 24.7847C1.87989 24.9547 2.22564 25.0392 2.57141 25.0392C2.96897 25.0392 3.36391 24.927 3.71724 24.7054L20.0739 14.4166C20.68 14.0348 21.0414 13.3888 21.0414 12.6874V12.6872ZM19.4837 13.5246L3.12701 23.8134C2.80597 24.015 2.41492 24.0287 2.07958 23.8524C1.74423 23.6749 1.5435 23.3475 1.5435 22.976V2.39676C1.5435 2.02528 1.74423 1.69657 2.07958 1.52035C2.2363 1.43855 2.40452 1.39701 2.57165 1.39701C2.76458 1.39701 2.9562 1.45119 3.12725 1.55956L19.4839 11.85C19.7817 12.0376 19.9526 12.3438 19.9526 12.6887C19.9523 13.0323 19.7815 13.337 19.4837 13.5246Z" />
                                                </svg>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($gallery_data)): ?>
                                <div class="col-lg-12">
                                    <div class="video-bottom-img">
                                        <img src="<?php echo esc_url($gallery_data[1]['vernex_gallery_item']['url']) ?>" alt="<?php echo esc_attr__('Image', 'vernex') ?>">
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php if (!empty($gallery_data)): ?>
                    <div class="col-lg-4">
                        <img src="<?php echo esc_url($gallery_data[2]['vernex_gallery_item']['url']) ?>" alt="<?php echo esc_attr__('Image', 'vernex') ?>">
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="row gy-5">
            <div class="col-lg-8">
                <div class="property-details-content-wrap">
                    <div class="title-and-pricing-area mb-50">
                        <div class="title-area">
                            <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('peoperties_tag_text'))):
                                $selected_tag = Egns\Helper\Egns_Helper::egns_properties_value('peoperties_tag_text');
                                $options      = array(
                                    'rent'   => 'For Rent',
                                    'sell'   => 'For Sale',
                                    'others' => "Other's",
                                );
                            ?>
                                <span><?php echo esc_html($options[$selected_tag]); ?></span>
                            <?php endif; ?>
                            <h2><?php the_title() ?></h2>
                            <div class="address-area">
                                <div class="icon">
                                    <svg width="23" height="33" viewBox="0 0 23 33">
                                        <path
                                            d="M11.5894 0.502504L11.5895 0.502506C15.3686 0.579597 18.7668 2.59493 20.683 5.90177C22.6428 9.28383 22.696 13.3415 20.8268 16.7631L12.6449 31.7387L12.6436 31.7411L12.6384 31.7503L12.6379 31.7514C12.3668 32.2224 11.8869 32.5 11.346 32.5C10.805 32.5 10.325 32.2225 10.0539 31.7513L10.0534 31.7503L10.0482 31.7411L10.0469 31.7387L1.86503 16.763C-0.0042938 13.3415 0.0489118 9.28383 2.00871 5.90178C3.92497 2.59492 7.32314 0.579597 11.1022 0.502506L11.1023 0.502504C11.2643 0.499165 11.4274 0.499165 11.5894 0.502504ZM6.20521 10.3125C6.20521 13.1475 8.51084 15.4532 11.3458 15.4532C14.1809 15.4532 16.4865 13.1475 16.4865 10.3125C16.4865 7.47754 14.1808 5.17191 11.3458 5.17191C8.51084 5.17191 6.20521 7.47754 6.20521 10.3125Z" />
                                    </svg>
                                </div>
                                <div class="content">
                                    <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('peoperties_location_title'))): ?>
                                        <span><?php echo esc_html(Egns\Helper\Egns_Helper::egns_properties_value('peoperties_location_title')); ?></span>
                                    <?php endif; ?>
                                    <a
                                        href="<?php echo esc_url(Egns\Helper\Egns_Helper::egns_project_value('peoperties_location_url', 'url')); ?>"><?php echo esc_html(Egns\Helper\Egns_Helper::egns_properties_value('peoperties_exact_location')); ?></a>
                                </div>
                            </div>
                        </div>
                        <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('peoperties_regular_price'))): ?>
                            <div class="price">
                                <h4><?php echo esc_html(Egns\Helper\Egns_Helper::egns_properties_value('peoperties_regular_price')); ?></h4>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="details-area mb-70">
                        <h2> <?php echo esc_html__('Details', 'vernex'); ?></h2>
                        <?php $properties_info = Egns\Helper\Egns_Helper::egns_properties_value('properties_info_list');
                        if (!empty($properties_info)): ?>
                            <div class="property-details-table">
                                <div class="row g-0">
                                    <?php
                                    if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('properties_info_list'))):
                                        foreach ($properties_info as $step_data1) :
                                    ?>
                                            <div class="col-md-6">
                                                <div class="single-item">
                                                    <div class="title">
                                                        <?php if (!empty($step_data1['phone_bnr_icoproperties_label_iconn_svg']['url'])): ?>
                                                            <img src="<?php echo esc_url($step_data1['phone_bnr_icoproperties_label_iconn_svg']['url']); ?>" alt="<?php esc_attr_e('icon', 'vernex'); ?>">
                                                        <?php endif; ?>
                                                        <?php if (!empty($step_data1['properties_label_text'])): ?>
                                                            <h6><?php echo esc_html($step_data1['properties_label_text']); ?></h6>
                                                        <?php endif; ?>
                                                    </div>
                                                    <svg width="43" height="6" viewBox="0 0 43 6">
                                                        <path
                                                            d="M0.333333 3C0.333333 4.47276 1.52724 5.66667 3 5.66667C4.47276 5.66667 5.66667 4.47276 5.66667 3C5.66667 1.52724 4.47276 0.333333 3 0.333333C1.52724 0.333333 0.333333 1.52724 0.333333 3ZM43 3L38 0.113249V5.88675L43 3ZM3 3.5H38.5V2.5H3V3.5Z" />
                                                    </svg>
                                                    <?php if (!empty($step_data1['properties_content_text'])): ?>
                                                        <span><?php echo esc_html($step_data1['properties_content_text']); ?></span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php the_content(); ?>
                    <div class="nav-and-tab-area mb-70">
                        <nav>
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                <button class="nav-link active" id="nav-photo-tab" data-bs-toggle="tab" data-bs-target="#nav-photo" type="button" role="tab" aria-controls="nav-photo" aria-selected="true">
                                    <svg width="24" height="24" viewBox="0 0 24 24">
                                        <g>
                                            <path
                                                d="M0.694576 20.4118L0.670576 20.4358C0.346586 19.7278 0.142591 18.9238 0.0585938 18.0358C0.142591 18.9118 0.370585 19.7038 0.694576 20.4118ZM8.39836 10.0561C9.15579 10.0561 9.88221 9.75518 10.4178 9.2196C10.9534 8.68401 11.2543 7.95759 11.2543 7.20016C11.2543 6.44272 10.9534 5.71631 10.4178 5.18072C9.88221 4.64513 9.15579 4.34424 8.39836 4.34424C7.64092 4.34424 6.91451 4.64513 6.37892 5.18072C5.84333 5.71631 5.54244 6.44272 5.54244 7.20016C5.54244 7.95759 5.84333 8.68401 6.37892 9.2196C6.91451 9.75518 7.64092 10.0561 8.39836 10.0561Z" />
                                            <path
                                                d="M17.0275 0.000488281H6.9718C2.60393 0.000488281 0 2.60441 0 6.97229V17.028C0 18.336 0.227993 19.4759 0.671981 20.4359C1.70395 22.7158 3.91189 23.9998 6.9718 23.9998H17.0275C21.3954 23.9998 23.9993 21.3959 23.9993 17.028V6.97229C23.9993 2.60441 21.3954 0.000488281 17.0275 0.000488281ZM22.0434 12.6001C21.1074 11.7962 19.5954 11.7962 18.6595 12.6001L13.6676 16.884C12.7316 17.688 11.2197 17.688 10.2837 16.884L9.87572 16.548C9.02374 15.804 7.66778 15.732 6.70781 16.38L2.21994 19.3919C1.95594 18.72 1.79995 17.94 1.79995 17.028V6.97229C1.79995 3.58839 3.5879 1.80044 6.9718 1.80044H17.0275C20.4114 1.80044 22.1994 3.58839 22.1994 6.97229V12.7321L22.0434 12.6001Z" />
                                        </g>
                                    </svg>
                                    <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('peoperties_image_text'))): ?>
                                        <?php echo esc_html(Egns\Helper\Egns_Helper::egns_properties_value('peoperties_image_text')); ?>
                                    <?php endif; ?>
                                </button>
                                <button class="nav-link" id="nav-video-tab" data-bs-toggle="tab"
                                    data-bs-target="#nav-video" type="button" role="tab" aria-controls="nav-video"
                                    aria-selected="false">
                                    <svg width="24" height="24" viewBox="0 0 24 24">
                                        <g>
                                            <path
                                                d="M12 0C5.37257 0 0 5.37257 0 12C0 18.6274 5.37257 24 12 24C18.6274 24 24 18.6274 24 12C23.9929 5.37554 18.6245 0.00708147 12 0ZM17.0536 12.3823C16.9706 12.549 16.8355 12.6841 16.6688 12.7671V12.7714L9.8117 16.2C9.38822 16.4116 8.87343 16.2399 8.66179 15.8164C8.60162 15.696 8.57065 15.5631 8.57139 15.4286V8.57144C8.57119 8.09804 8.95474 7.71413 9.42815 7.71388C9.56128 7.71382 9.6926 7.74477 9.8117 7.80428L16.6688 11.2329C17.0925 11.444 17.2648 11.9586 17.0536 12.3823Z" />
                                        </g>
                                    </svg>
                                    <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('peoperties_video_text'))): ?>
                                        <?php echo esc_html(Egns\Helper\Egns_Helper::egns_properties_value('peoperties_video_text')); ?>
                                    <?php endif; ?>
                                </button>
                            </div>
                        </nav>
                        <div class="tab-content" id="nav-tabContent">
                            <div class="tab-pane fade show active" id="nav-photo" role="tabpanel"
                                aria-labelledby="nav-photo-tab">
                                <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('peoperties_image_tab', 'url'))): ?>
                                    <img src="<?php echo esc_url(Egns\Helper\Egns_Helper::egns_properties_value('peoperties_image_tab', 'url')); ?>" alt="<?php echo esc_attr__('image', 'vernex'); ?>">
                                <?php endif; ?>
                            </div>
                            <div class="tab-pane fade" id="nav-video" role="tabpanel" aria-labelledby="nav-video-tab">
                                <div class="video-area">
                                    <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('peoperties_video_image', 'url'))): ?>
                                        <img src="<?php echo esc_url(Egns\Helper\Egns_Helper::egns_properties_value('peoperties_video_image', 'url')); ?>" alt="<?php echo esc_attr__('video-image', 'vernex'); ?>">
                                    <?php endif; ?>
                                    <a data-fancybox="video-player"
                                        href="<?php echo esc_url(Egns\Helper\Egns_Helper::egns_properties_value('peoperties_video_tab', 'url')); ?>" class="play-btn">
                                        <div class="icon">
                                            <svg class="video-circle" x="0px" y="0px"
                                                width="57px" viewBox="0 0 206 206"
                                                style="enable-background:new 0 0 206 206;" xml:space="preserve">
                                                <circle class="circle" stroke-miterlimit="10" cx="103" cy="103"
                                                    r="100"></circle>
                                                <path class="circle-half top-half" stroke-width="4"
                                                    stroke-miterlimit="10"
                                                    d="M16.4,53C44,5.2,105.2-11.2,153,16.4s64.2,88.8,36.6,136.6">
                                                </path>
                                                <path class="circle-half bottom-half" stroke-width="4"
                                                    stroke-miterlimit="10"
                                                    d="M189.6,153C162,200.8,100.8,217.2,53,189.6S-11.2,100.8,16.4,53">
                                                </path>
                                            </svg>
                                            <svg class="play-icon" width="18" height="21" viewBox="0 0 22 26">
                                                <path
                                                    d="M21.0414 12.6872C21.0414 11.9857 20.68 11.3397 20.0741 10.9581L3.71746 0.667707C3.05587 0.252161 2.24905 0.221801 1.5565 0.588432C0.866106 0.954858 0.453125 1.63119 0.453125 2.39695V22.9762C0.453125 23.742 0.866072 24.4181 1.55755 24.7847C1.87989 24.9547 2.22564 25.0392 2.57141 25.0392C2.96897 25.0392 3.36391 24.927 3.71724 24.7054L20.0739 14.4166C20.68 14.0348 21.0414 13.3888 21.0414 12.6874V12.6872ZM19.4837 13.5246L3.12701 23.8134C2.80597 24.015 2.41492 24.0287 2.07958 23.8524C1.74423 23.6749 1.5435 23.3475 1.5435 22.976V2.39676C1.5435 2.02528 1.74423 1.69657 2.07958 1.52035C2.2363 1.43855 2.40452 1.39701 2.57165 1.39701C2.76458 1.39701 2.9562 1.45119 3.12725 1.55956L19.4839 11.85C19.7817 12.0376 19.9526 12.3438 19.9526 12.6887C19.9523 13.0323 19.7815 13.337 19.4837 13.5246Z" />
                                            </svg>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="nearby-table-area mb-70">
                        <h2><?php echo esc_html__('Whats Nearby', 'vernex'); ?></h2>
                        <?php $properties_nearby_info = Egns\Helper\Egns_Helper::egns_properties_value('properties_nearby_list');
                        if (!empty($properties_nearby_info)): ?>
                            <div class="property-details-table">
                                <div class="row g-0">
                                    <?php
                                    if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('properties_nearby_list'))):
                                        foreach ($properties_nearby_info as $step_data2) :
                                    ?>
                                            <div class="col-md-6">
                                                <div class="single-item">
                                                    <div class="title">
                                                        <?php if (!empty($step_data2['properties_nearby_text'])): ?>
                                                            <h6><?php echo esc_html($step_data2['properties_nearby_text']); ?></h6>
                                                        <?php endif; ?>
                                                    </div>
                                                    <svg width="43" height="6" viewBox="0 0 43 6">
                                                        <path
                                                            d="M0.333333 3C0.333333 4.47276 1.52724 5.66667 3 5.66667C4.47276 5.66667 5.66667 4.47276 5.66667 3C5.66667 1.52724 4.47276 0.333333 3 0.333333C1.52724 0.333333 0.333333 1.52724 0.333333 3ZM43 3L38 0.113249V5.88675L43 3ZM3 3.5H38.5V2.5H3V3.5Z" />
                                                    </svg>
                                                    <?php if (!empty($step_data2['properties_nearby_value_text'])): ?>
                                                        <span><?php echo esc_html($step_data2['properties_nearby_value_text']); ?></span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="attachment-area">
                        <h2><?php echo esc_html__('Property Attachment', 'vernex'); ?></h2>
                        <?php $properties_attachment_info = Egns\Helper\Egns_Helper::egns_properties_value('properties_attachment_file_list');
                        if (!empty($properties_attachment_info)): ?>
                            <ul class="attachment-list">
                                <?php
                                if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('properties_attachment_file_list'))):
                                    foreach ($properties_attachment_info as $step_data3) :
                                ?>
                                        <li class="single-attachment">
                                            <a href="<?php echo esc_url($step_data3['properties_attachment_file']) ?>" download="property_details.pdf">
                                                <div class="icon">
                                                    <?php if (!empty($step_data3['properties_attachment_file_tab']['url'])): ?>
                                                        <img src="<?php echo esc_url($step_data3['properties_attachment_file_tab']['url']); ?>" alt="<?php esc_attr_e('icon', 'vernex'); ?>">
                                                    <?php endif; ?>

                                                </div>
                                                <div class="content">
                                                    <?php if (!empty($step_data3['properties_attachment_text'])): ?>
                                                        <h6><?php echo wp_kses($step_data3['properties_attachment_text'], wp_kses_allowed_html('post')); ?></h6>
                                                    <?php endif; ?>
                                                </div>
                                            </a>
                                        </li>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="property-details-sidebar">
                    <div class="profile-area mb-40">
                        <div class="profile-img">
                            <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('properties_sidebar_profile_image', 'url'))): ?>
                                <img src="<?php echo esc_url(Egns\Helper\Egns_Helper::egns_properties_value('properties_sidebar_profile_image', 'url')); ?>" alt="<?php echo esc_attr__('video-image', 'vernex'); ?>">
                            <?php endif; ?>
                        </div>
                        <div class="name-and-designation">
                            <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('properties_sidebar_profile_name'))): ?>
                                <h4><?php echo esc_html(Egns\Helper\Egns_Helper::egns_properties_value('properties_sidebar_profile_name')); ?></h4>
                            <?php endif; ?>
                            <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('properties_sidebar_profile_designation'))): ?>
                                <span><?php echo esc_html(Egns\Helper\Egns_Helper::egns_properties_value('properties_sidebar_profile_designation')); ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="contact-area">
                            <div class="icon">
                                <svg width="33" height="33" viewBox="0 0 33 33">
                                    <g>
                                        <path
                                            d="M26.0798 20.4417C25.4042 19.7383 24.5894 19.3622 23.7257 19.3622C22.869 19.3622 22.0472 19.7313 21.3437 20.4348L19.1428 22.6287C18.9617 22.5312 18.7806 22.4407 18.6065 22.3501C18.3558 22.2248 18.119 22.1063 17.917 21.981C15.8554 20.6716 13.9818 18.9652 12.1849 16.7573C11.3143 15.6569 10.7292 14.7305 10.3044 13.7903C10.8755 13.2679 11.4048 12.7247 11.9202 12.2023C12.1153 12.0073 12.3103 11.8053 12.5053 11.6103C13.9679 10.1477 13.9679 8.25321 12.5053 6.79058L10.6039 4.88917C10.388 4.67326 10.1651 4.45038 9.95615 4.22751C9.53826 3.79569 9.09947 3.34993 8.64675 2.93204C7.97116 2.26341 7.16323 1.9082 6.31352 1.9082C5.4638 1.9082 4.64195 2.26341 3.94546 2.93204C3.9385 2.939 3.9385 2.939 3.93153 2.94597L1.56347 5.33492C0.671971 6.22643 0.163535 7.31295 0.0520969 8.57359C-0.11506 10.6073 0.483919 12.5018 0.943601 13.7415C2.07191 16.7852 3.75741 19.606 6.27173 22.6287C9.32235 26.2713 12.9928 29.1478 17.1857 31.1746C18.7876 31.9338 20.9258 32.8323 23.3148 32.9855C23.461 32.9924 23.6143 32.9994 23.7536 32.9994C25.3625 32.9994 26.7136 32.4213 27.7723 31.2721C27.7793 31.2582 27.7932 31.2512 27.8002 31.2373C28.1623 30.7985 28.5802 30.4015 29.019 29.9767C29.3185 29.6911 29.625 29.3916 29.9244 29.0782C30.614 28.3608 30.9761 27.525 30.9761 26.6683C30.9761 25.8047 30.607 24.9759 29.9036 24.2794L26.0798 20.4417ZM28.5733 27.7758C28.5663 27.7758 28.5663 27.7827 28.5733 27.7758C28.3016 28.0683 28.023 28.3329 27.7235 28.6255C27.2708 29.0573 26.8111 29.51 26.3793 30.0184C25.6759 30.7707 24.8471 31.1259 23.7605 31.1259C23.6561 31.1259 23.5446 31.1259 23.4401 31.1189C21.3716 30.9866 19.4493 30.1786 18.0075 29.4891C14.0654 27.5807 10.6039 24.8714 7.72739 21.4377C5.35237 18.5752 3.76438 15.9285 2.71268 13.0868C2.06495 11.3526 1.82814 10.0014 1.93261 8.72682C2.00226 7.91193 2.31568 7.23633 2.89377 6.65825L5.26879 4.28323C5.61007 3.96284 5.97224 3.78872 6.32745 3.78872C6.76624 3.78872 7.12145 4.05339 7.34432 4.27626C7.35129 4.28323 7.35825 4.29019 7.36522 4.29716C7.79007 4.69415 8.19404 5.10508 8.61889 5.54387C8.8348 5.76675 9.05768 5.98962 9.28056 6.21946L11.182 8.12087C11.9202 8.85915 11.9202 9.54171 11.182 10.28C10.98 10.482 10.785 10.6839 10.583 10.879C9.99794 11.4779 9.44075 12.0351 8.8348 12.5784C8.82088 12.5923 8.80694 12.5993 8.79998 12.6132C8.201 13.2122 8.31244 13.7972 8.43781 14.1942C8.44477 14.2151 8.45174 14.236 8.4587 14.2569C8.95321 15.4549 9.64969 16.5832 10.7084 17.9274L10.7153 17.9344C12.6376 20.3024 14.6644 22.1481 16.9001 23.562C17.1857 23.7431 17.4782 23.8894 17.7568 24.0287C18.0075 24.154 18.2444 24.2724 18.4463 24.3978C18.4742 24.4117 18.5021 24.4326 18.5299 24.4465C18.7667 24.5649 18.9896 24.6207 19.2194 24.6207C19.7975 24.6207 20.1597 24.2585 20.2781 24.1401L22.6601 21.7581C22.8969 21.5213 23.273 21.2357 23.7118 21.2357C24.1436 21.2357 24.4988 21.5074 24.7147 21.7442C24.7217 21.7511 24.7217 21.7511 24.7286 21.7581L28.5663 25.5958C29.2837 26.3062 29.2837 27.0375 28.5733 27.7758Z" />
                                        <path
                                            d="M17.8325 7.8506C19.6573 8.15705 21.315 9.0207 22.6383 10.344C23.9616 11.6673 24.8183 13.325 25.1317 15.1498C25.2083 15.6095 25.6053 15.9299 26.0581 15.9299C26.1138 15.9299 26.1625 15.9229 26.2182 15.9159C26.7336 15.8323 27.0749 15.3448 26.9914 14.8294C26.6152 12.6215 25.5705 10.6087 23.9756 9.01373C22.3806 7.41877 20.3678 6.37404 18.1599 5.99794C17.6445 5.91436 17.1639 6.25564 17.0734 6.76408C16.9828 7.27251 17.3171 7.76702 17.8325 7.8506Z" />
                                        <path
                                            d="M32.9629 14.557C32.3431 10.9213 30.6297 7.61301 27.997 4.98029C25.3642 2.34757 22.0559 0.634209 18.4203 0.0143347C17.9118 -0.0762086 17.4312 0.272035 17.3407 0.780471C17.2571 1.29587 17.5984 1.77645 18.1138 1.86699C21.3594 2.41722 24.3195 3.95645 26.6736 6.30362C29.0278 8.65774 30.56 11.6178 31.1103 14.8634C31.1869 15.3231 31.5839 15.6435 32.0366 15.6435C32.0923 15.6435 32.1411 15.6365 32.1968 15.6296C32.7052 15.553 33.0535 15.0654 32.9629 14.557Z" />
                                    </g>
                                </svg>
                            </div>
                            <div class="content">
                                <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('properties_sidebar_profile_contact_text'))): ?>
                                    <span><?php echo esc_html(Egns\Helper\Egns_Helper::egns_properties_value('properties_sidebar_profile_contact_text')); ?></span>
                                <?php endif; ?>
                                <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('properties_sidebar_profile_contact_num'))): ?>
                                    <a href="<?php echo esc_url(Egns\Helper\Egns_Helper::egns_properties_value('properties_sidebar_profile_contact_num_url', 'url')); ?>"><?php echo esc_html(Egns\Helper\Egns_Helper::egns_properties_value('properties_sidebar_profile_contact_num')); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('properties_sidebar_profile_btn_text'))): ?>
                            <a href="<?php echo esc_url(Egns\Helper\Egns_Helper::egns_properties_value('properties_sidebar_profile_btn_text_url', 'url')); ?>" class="primary-btn2">
                                <span>
                                    <?php echo esc_html(Egns\Helper\Egns_Helper::egns_properties_value('properties_sidebar_profile_btn_text')); ?>
                                    <svg viewBox="0 0 13 20">
                                        <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                    </svg>
                                </span>
                            </a>
                        <?php endif; ?>
                    </div>
                    <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('properties_sidebar_profile_form_shortcode'))): ?>
                        <div class="sidebar-contact-form">
                            <?php echo do_shortcode(Egns\Helper\Egns_Helper::egns_properties_value('properties_sidebar_profile_form_shortcode')); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="related-property-section mb-120">
    <div class="container">
        <div class="row mb-60">
            <div class="col-lg-12 d-flex align-items-center justify-content-between gap-4 flex-wrap">
                <div class="section-title">
                    <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('properties_related_heading_subtile'))): ?>
                        <span><?php echo esc_html(Egns\Helper\Egns_Helper::egns_properties_value('properties_related_heading_subtile')); ?></span>
                    <?php endif; ?>
                    <?php if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('properties_related_heading_title'))): ?>
                        <h2><?php echo esc_html(Egns\Helper\Egns_Helper::egns_properties_value('properties_related_heading_title')); ?></h2>
                    <?php endif; ?>
                </div>
                <div class="slider-btn-grp">
                    <div class="slider-btn related-property-slider-prev">
                        <i class="bi bi-arrow-left"></i>
                    </div>
                    <div class="slider-btn related-property-slider-next">
                        <i class="bi bi-arrow-right"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="related-property-slider-area">
            <div class="row">
                <div class="col-lg-12">
                    <div class="swiper related-property-slider">
                        <div class="swiper-wrapper">
                            <?php
                            // Get the current post ID
                            $current_post_id = get_the_ID();

                            // Get the terms of the current post in a taxonomy
                            $terms = wp_get_post_terms($current_post_id, 'properties-type', array('fields' => 'ids'));

                            if (! empty($terms)) {
                                // Query related posts
                                $related_posts = new WP_Query(array(
                                    'post_type'      => 'properties',
                                    'posts_per_page' => 3,
                                    'post__not_in'   => array($current_post_id),
                                    'tax_query'      => array(
                                        array(
                                            'taxonomy' => 'properties-type',
                                            'field'    => 'term_id',
                                            'terms'    => $terms,
                                        ),
                                    ),
                                ));

                                // Check if there are related posts
                                if ($related_posts->have_posts()) {
                                    while ($related_posts->have_posts()) {
                                        $related_posts->the_post();
                            ?>
                                        <div class="swiper-slide">
                                            <div class="property-card">
                                                <div class="property-img-wrap">
                                                    <a href="<?php the_permalink() ?>" class="property-img">
                                                        <?php if (has_post_thumbnail()): ?>
                                                            <?php the_post_thumbnail(); ?>
                                                        <?php endif; ?></a>
                                                    <div class="price">
                                                        <span> <?php echo esc_html(Egns\Helper\Egns_Helper::egns_properties_value('peoperties_regular_price')); ?></span>
                                                    </div>
                                                </div>
                                                <div class="property-content">
                                                    <?php $properties_short_info = Egns\Helper\Egns_Helper::egns_properties_value('properties_short_info_list');
                                                    if (!empty($properties_short_info)): ?>
                                                        <ul>
                                                            <?php
                                                            if (!empty(Egns\Helper\Egns_Helper::egns_properties_value('properties_short_info_list'))):
                                                                foreach ($properties_short_info as $step_data) :
                                                            ?>
                                                                    <li><?php echo esc_html($step_data['properties_short_info_text']); ?></li>
                                                                <?php endforeach; ?>
                                                            <?php endif; ?>
                                                        </ul>
                                                    <?php endif; ?>
                                                    <h5><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h5>
                                                    <a href="<?php the_permalink() ?>" class="primary-btn">
                                                        <?php echo esc_html__('View Detials', 'vernex'); ?>
                                                        <svg viewBox="0 0 13 20">
                                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                                        </svg>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                            <?php
                                    }
                                }
                                wp_reset_postdata();
                            } else {
                                echo '<h4>No related Properties found.</h4>';
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>