<?php

use Egns\Inc\Header_Helper;
use Egns\Helper\Egns_Helper;

?>


<div class="right-sidebar-menu">
    <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('header_sidebar_logo', 'url'))) : ?>
        <div class="sidebar-logo-area d-flex justify-content-between align-items-center">
            <div class="sidebar-logo-wrap">
                <a href="<?php echo esc_url(home_url('/')); ?>"><img alt="image" src="<?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_sidebar_logo', 'url'); ?>"></a>
            </div>
            <div class="right-sidebar-close-btn">
                <i class="bi bi-x"></i>
            </div>
        </div>
    <?php endif; ?>
    <div class="sidebar-content-wrap">
        <div class="title-area">
            <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('header_sidebar_subtitle'))) : ?>
                <span><?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_sidebar_subtitle'); ?></span>
            <?php endif; ?>
            <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('header_sidebar_title'))) : ?>
                <h2><?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_sidebar_title'); ?></h2>
            <?php endif; ?>
            <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('header_sidebar_short_descp'))) : ?>
                <p><?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_sidebar_short_descp'); ?></p>
            <?php endif; ?>
        </div>
        <ul class="contact-area">
            <?php if (class_exists('CSF') && (Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_contact_info_show') == 1)) :  ?>
                <?php
                $items = (array) Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_contact_info');
                $total_items = count($items);
                $current_index = 0; // Initialize index
                foreach ($items as $item) :
                    $current_index++;
                    $contactType = isset($item['sidebar_contact_type']) ? $item['sidebar_contact_type'] : 'default_value';

                    // Check if any of the contact information fields is not empty
                    $isNotEmpty = (
                        ($contactType === 'phone' && !empty($item['sidebar_phone_info'])) ||
                        ($contactType === 'email' && !empty($item['sidebar_email_info'])) ||
                        ($contactType === 'others' && !empty($item['sidebar_custom_info']))
                    );

                    if ($isNotEmpty) :
                ?>
                        <li>
                            <div class="single-contact">
                                <?php if ($contactType === 'phone' && !empty($item['sidebar_phone_icon_svg']['url'])) :
                                    $phone_icon = $item['sidebar_phone_icon_svg']['url']; ?>
                                    <div class="icon">
                                        <?php Egns\Helper\Egns_Helper::display_svg($phone_icon); ?>
                                    </div>
                                <?php endif; ?>
                                <?php if ($contactType === 'phone') : ?>
                                    <div class="content">
                                        <?php if (!empty($item['sidebar_phone_info_text'])) : ?>
                                            <span><?php echo esc_html($item['sidebar_phone_info_text']); ?></span>
                                        <?php endif; ?>
                                        <h6><a href="tel:<?php echo str_replace([' ', '-', '+'], ['', '', ''], $item['sidebar_phone_info']); ?>"><?php echo esc_html($item['sidebar_phone_info']); ?></a></h6>
                                    </div>
                                <?php elseif ($contactType === 'email') : ?>
                                    <?php if ($contactType === 'email' && !empty($item['sidebar_email_icon_svg']['url'])) :
                                        $email_icon = $item['sidebar_email_icon_svg']['url'];   ?>
                                        <div class="icon">
                                            <?php Egns\Helper\Egns_Helper::display_svg($email_icon) ?>
                                        </div>
                                    <?php endif ?>
                                    <div class="content">
                                        <?php if (!empty($item['sidebar_email_info_text'])) : ?>
                                            <span><?php echo esc_html($item['sidebar_email_info_text']); ?></span>
                                        <?php endif; ?>
                                        <h6><a href="mailto:<?php echo esc_html($item['sidebar_email_info']); ?>"><?php echo esc_html($item['sidebar_email_info']); ?></a></h6>
                                    </div>
                                <?php elseif ($contactType === 'others') : ?>
                                    <?php if ($contactType === 'others' && !empty($item['sidebar_custom_icon_svg']['url'])) :
                                        $others_icon = $item['sidebar_custom_icon_svg']['url'];  ?>
                                        <div class="icon">
                                            <?php Egns\Helper\Egns_Helper::display_svg($others_icon) ?>
                                        </div>
                                    <?php endif ?>
                                    <div class="content">
                                        <?php if (!empty($item['sidebar_custom_title'])) : ?>
                                            <span><?php echo esc_html($item['sidebar_custom_title']); ?></span>
                                        <?php endif; ?>
                                        <?php if (!empty($item['sidebar_custom_info'])) : ?>
                                            <h6><a href="<?php echo esc_html($item['sidebar_custom_link']); ?>"><?php echo esc_html($item['sidebar_custom_info']); ?></a></h6>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <?php if ($current_index < $total_items) : ?>
                                <svg class="arrow" width="8" height="29" viewBox="0 0 8 29" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M1.33333 3C1.33333 4.47276 2.52724 5.66667 4 5.66667C5.47276 5.66667 6.66667 4.47276 6.66667 3C6.66667 1.52724 5.47276 0.333333 4 0.333333C2.52724 0.333333 1.33333 1.52724 1.33333 3ZM3.64645 28.3536C3.84171 28.5488 4.15829 28.5488 4.35355 28.3536L7.53553 25.1716C7.7308 24.9763 7.7308 24.6597 7.53553 24.4645C7.34027 24.2692 7.02369 24.2692 6.82843 24.4645L4 27.2929L1.17157 24.4645C0.976311 24.2692 0.659728 24.2692 0.464466 24.4645C0.269204 24.6597 0.269204 24.9763 0.464466 25.1716L3.64645 28.3536ZM3.5 3V28H4.5V3H3.5Z" />
                                </svg>
                            <?php endif; ?>
                        </li>
                <?php
                    endif;
                endforeach;
                ?>
            <?php endif; ?>
        </ul>
        <ul class="address-area">
            <li class="single-address">
                <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_one_title'))) : ?>
                    <span><?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_one_title'); ?></span>
                <?php endif; ?>
                <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_one_content'))) : ?>
                    <p><?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_one_content'); ?></p>
                <?php endif; ?>
            </li>
            <li class="single-address">
                <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_two_title'))) : ?>
                    <span><?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_two_title'); ?></span>
                <?php endif; ?>
                <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_two_title'))) : ?>
                    <p><?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_two_content'); ?></p>
                <?php endif; ?>
            </li>
        </ul>
    </div>
    <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_copy_right_info'))) : ?>
        <div class="sidebar-bottom-area">
            <p><?php echo wp_kses(Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_copy_right_info'), wp_kses_allowed_html('post')); ?></p>
        </div>
    <?php endif; ?>
</div>


<div class="header-topbar-wrap">
    <div class="topbar-area d-lg-block d-none">
        <div class="container-fluid d-flex flex-nowrap align-items-center justify-content-between">
            <div class="contact-area">
                <ul>
                    <?php
                    if (Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type') == 'phone') {
                        $sidebar_phone_icon = Egns\Helper\Egns_Helper::egns_get_theme_option('phone_icon_svg');

                        // Check if $sidebar_phone_icon is an array and has the 'url' key
                        $phone_icon = is_array($sidebar_phone_icon) && isset($sidebar_phone_icon['url']) ? $sidebar_phone_icon['url'] : '';

                        if ($phone_icon) {
                    ?>
                            <li>
                                <a href="tel:<?php echo preg_replace('/\D/', '', Egns\Helper\Egns_Helper::egns_get_theme_option('phone_contact_info')); ?>">
                                    <?php Egns\Helper\Egns_Helper::display_svg($phone_icon) ?>
                                    <?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('phone_contact_info')); ?>
                                </a>
                            </li>
                        <?php
                        }
                    } elseif (Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type') == 'email') {
                        $sidebar_email_icon = Egns\Helper\Egns_Helper::egns_get_theme_option('email_icon_svg');
                        // Check if $sidebar_phone_icon is an array and has the 'url' key
                        $email_icon = is_array($sidebar_email_icon) && isset($sidebar_email_icon['url']) ? $sidebar_email_icon['url'] : '';
                        if ($email_icon) { ?>
                            <li>
                                <a href="mailto:<?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('email_contact_info')); ?>">
                                    <?php Egns\Helper\Egns_Helper::display_svg($email_icon) ?>
                                    <?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('email_contact_info')); ?>
                                </a>
                            </li>
                        <?php
                        }
                    } elseif (Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type') == 'others') {
                        $sidebar_custom_icon = Egns\Helper\Egns_Helper::egns_get_theme_option('custom_icon_svg');
                        $sidebar_custom_link = Egns\Helper\Egns_Helper::egns_get_theme_option('header_topbar_custom_link');
                        // Check if $sidebar_phone_icon is an array and has the 'url' key
                        $custom_icon = is_array($sidebar_custom_icon) && isset($sidebar_custom_icon['url']) ? $sidebar_custom_icon['url'] : '';
                        $custom_link = is_array($sidebar_custom_link) && isset($sidebar_custom_link['url']) ? $sidebar_custom_link['url'] : '';
                        if ($custom_icon) {
                        ?>
                            <li>
                                <a href="<?php echo esc_url($custom_link); ?>">
                                    <?php Egns\Helper\Egns_Helper::display_svg($custom_icon) ?>
                                    <?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('custom_text')); ?>
                                </a>
                            </li>
                    <?php }
                    } ?>

                    <!--two -->

                    <?php
                    if (Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_two') == 'phone') {
                        $sidebar_phone_icon = Egns\Helper\Egns_Helper::egns_get_theme_option('phone_icon_svg_two');

                        // Check if $sidebar_phone_icon is an array and has the 'url' key
                        $phone_icon = is_array($sidebar_phone_icon) && isset($sidebar_phone_icon['url']) ? $sidebar_phone_icon['url'] : '';

                        if ($phone_icon) {
                    ?>
                            <li>
                                <a href="tel:<?php echo preg_replace('/\D/', '', Egns\Helper\Egns_Helper::egns_get_theme_option('phone_contact_info_two')); ?>">
                                    <?php Egns\Helper\Egns_Helper::display_svg($phone_icon) ?>
                                    <?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('phone_contact_info_two')); ?>
                                </a>
                            </li>
                        <?php
                        }
                    } elseif (Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_two') == 'email') {
                        $sidebar_email_icon = Egns\Helper\Egns_Helper::egns_get_theme_option('email_icon_svg_two');
                        // Check if $sidebar_phone_icon is an array and has the 'url' key
                        $email_icon = is_array($sidebar_email_icon) && isset($sidebar_email_icon['url']) ? $sidebar_email_icon['url'] : '';
                        if ($email_icon) { ?>
                            <li>
                                <a href="mailto:<?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('email_contact_info_two')); ?>">
                                    <?php Egns\Helper\Egns_Helper::display_svg($email_icon) ?>
                                    <?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('email_contact_info_two')); ?>
                                </a>
                            </li>
                        <?php
                        }
                    } elseif (Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_two') == 'others') {
                        $sidebar_custom_icon = Egns\Helper\Egns_Helper::egns_get_theme_option('custom_icon_svg_two');
                        $sidebar_custom_link = Egns\Helper\Egns_Helper::egns_get_theme_option('header_topbar_custom_link_two');
                        // Check if $sidebar_phone_icon is an array and has the 'url' key
                        $custom_icon = is_array($sidebar_custom_icon) && isset($sidebar_custom_icon['url']) ? $sidebar_custom_icon['url'] : '';
                        $custom_link = is_array($sidebar_custom_link) && isset($sidebar_custom_link['url']) ? $sidebar_custom_link['url'] : '';
                        if ($custom_icon) {
                        ?>
                            <li>
                                <a href="<?php echo esc_url($custom_link); ?>">
                                    <?php Egns\Helper\Egns_Helper::display_svg($custom_icon) ?>
                                    <?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('custom_text_two')); ?>
                                </a>
                            </li>
                    <?php }
                    } ?>
                </ul>
            </div>
            <div class="address-area">
                <?php
                $sidebar_address_icon = Egns\Helper\Egns_Helper::egns_get_theme_option('header_topbar_address_icon');
                $sidebar_address_url = Egns\Helper\Egns_Helper::egns_get_theme_option('header_topbar_address_link');

                $address_icon = is_array($sidebar_address_icon) && isset($sidebar_address_icon['url']) ? $sidebar_address_icon['url'] : '';
                $address_url = is_array($sidebar_address_url) && isset($sidebar_address_url['url']) ? $sidebar_address_url['url'] : '';

                if ($address_icon) { ?>
                    <?php Egns\Helper\Egns_Helper::display_svg($address_icon) ?>
                <?php } ?>
                <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('header_topbar_address_text'))) : ?>
                    <a href="<?php echo esc_url($address_url); ?>"><?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('header_topbar_address_text')); ?></a>
                <?php endif; ?>
            </div>
        </div>
    </div>


    <header class="header-area style-2">
        <div class="container-fluid d-flex flex-nowrap align-items-center justify-content-between">
            <div class="header-logo">
                <?php
                if (!empty(Egns\Helper\Egns_Helper::egns_page_option_value('page_header_logo', 'url'))) { ?>
                    <a href="<?php echo esc_url(home_url('/')); ?>"><img alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" class="img-fluid" src="<?php echo Egns\Helper\Egns_Helper::egns_page_option_value('page_header_logo', 'url'); ?>"></a>
                    <?php  } else {
                    if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('header_logo', 'url'))) { ?>
                        <a href="<?php echo esc_url(home_url('/')); ?>"><img alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" class="img-fluid" src="<?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_logo', 'url'); ?>"></a>
                <?php } else {
                        Egns\Helper\Egns_Helper::get_theme_logo(NULL);
                    }
                }
                ?>
            </div>
            <div class="main-menu">
                <div class="mobile-logo-area d-lg-none d-flex justify-content-between">
                    <div class="mobile-logo-wrap">
                        <?php
                        if (!empty(Egns\Helper\Egns_Helper::egns_page_option_value('page_header_mobile_logo', 'url'))) { ?>
                            <a href="<?php echo esc_url(home_url('/')); ?>"><img alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" class="img-fluid" src="<?php echo Egns\Helper\Egns_Helper::egns_page_option_value('page_header_mobile_logo', 'url'); ?>"></a>
                            <?php  } else {
                            if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('header_mobile_logo', 'url'))) { ?>
                                <a href="<?php echo esc_url(home_url('/')); ?>"><img alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" class="img-fluid" src="<?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_mobile_logo', 'url'); ?>"></a>
                        <?php } else {
                                Egns\Helper\Egns_Helper::get_theme_logo(NULL);
                            }
                        }
                        ?>
                    </div>

                    <div class="menu-close-btn">
                        <i class="bi bi-x"></i>
                    </div>

                </div>
                <?php
                Egns_Helper::egns_get_theme_menu('primary-menu', 'nav-menu', '<i class="d-lg-none bi bi-plus dropdown-icon"></i>', 'menu-list', 3);
                ?>
                <?php if (Egns\Helper\Egns_Helper::egns_get_theme_option('header_one_button_enable') == 1) : ?>
                    <div class="btn-area d-lg-none d-flex justify-content-center">
                        <a href="<?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_one_button_link', 'url'); ?>" class="primary-btn">
                            <?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_one_button_label'); ?>
                            <svg viewBox="0 0 13 20">
                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                            </svg>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
            <div class="nav-right d-flex jsutify-content-end align-items-center">
                <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('header_one_sidebar_button_label'))) : ?>
                    <?php if (Egns\Helper\Egns_Helper::egns_get_theme_option('header_sidebar_bottom_enable') == 1) : ?>
                        <div class="right-sidebar-button">
                            <svg width="14" height="14" viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg">
                                <rect width="11.2" height="1.4" rx="0.699998" />
                                <rect x="2.80078" y="5.6" width="11.2" height="2.79999" rx="1.4" />
                                <rect y="12.6" width="11.2" height="1.4" rx="0.699998" />
                            </svg>
                            <span><?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_one_sidebar_button_label'); ?></span>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if (Egns\Helper\Egns_Helper::egns_get_theme_option('header_one_button_enable') == 1) : ?>
                    <a href="<?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_one_button_link', 'url'); ?>" class="primary-btn white d-lg-flex d-none">
                        <?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_one_button_label'); ?>
                        <svg viewBox="0 0 13 20">
                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                        </svg>
                    </a>
                <?php endif; ?>
                <div class="sidebar-button mobile-menu-btn">
                    <svg class="sidebar-toggle-button" width="25" height="25" viewBox="0 0 18 18"
                        xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M1.29608 0.0658336C0.609639 0.31147 0.139209 0.899069 0.0432028 1.63598C-0.0144009 2.09353 -0.0144009 5.4939 0.0432028 5.95146C0.129608 6.59686 0.489632 7.11703 1.07047 7.42046L1.36329 7.57458H3.83545H6.30761L6.59563 7.42046C6.96525 7.2278 7.25807 6.93401 7.45008 6.56314L7.60369 6.27416V3.79372V1.31328L7.45008 1.02429C7.25807 0.653433 6.96525 0.359633 6.59563 0.166978L6.30761 0.0128531L3.90745 0.00322056C1.83372 -0.00641251 1.4785 0.00322056 1.29608 0.0658336ZM6.2356 0.802741C6.52842 0.956866 6.65803 1.08209 6.79244 1.34699L6.90765 1.57336V3.80817V6.03816L6.74924 6.29824C6.53322 6.66429 6.2068 6.85694 5.74117 6.90029C5.54916 6.91956 4.55549 6.92437 3.52343 6.91474L1.65131 6.90029L1.41129 6.77025C1.12807 6.62094 1.00807 6.49571 0.854455 6.20191L0.739248 5.98518V3.79372V1.60226L0.854455 1.38552C1.05607 0.995397 1.33929 0.778659 1.74731 0.706413C1.85292 0.687148 2.85618 0.677515 3.97946 0.677515L6.01959 0.687148L6.2356 0.802741Z">
                        </path>
                        <path
                            d="M11.6647 0.0658336C10.9783 0.31147 10.5079 0.899069 10.4119 1.63598C10.3879 1.82863 10.3687 2.80154 10.3687 3.79372C10.3687 4.7859 10.3879 5.75881 10.4119 5.95146C10.4983 6.59686 10.8583 7.11703 11.4391 7.42046L11.7319 7.57458H14.2041H16.6763L16.9643 7.42046C17.3339 7.2278 17.6267 6.93401 17.8187 6.56314L17.9723 6.27416V3.79372V1.31328L17.8187 1.02429C17.6267 0.653433 17.3339 0.359633 16.9643 0.166978L16.6763 0.0128531L14.2761 0.00322056C12.2024 -0.00641251 11.8471 0.00322056 11.6647 0.0658336ZM16.6043 0.802741C16.9019 0.956866 17.0267 1.08209 17.1611 1.35181L17.2811 1.583L17.2763 3.79854C17.2763 5.73472 17.2667 6.03816 17.1995 6.1682C17.0555 6.45237 16.9067 6.61131 16.6475 6.7558L16.3882 6.90029H14.2041H12.02L11.7799 6.77025C11.4967 6.62094 11.3767 6.49571 11.2231 6.20191L11.1079 5.98518V3.79372V1.60226L11.2231 1.38552C11.4247 0.995397 11.7079 0.778659 12.116 0.706413C12.2216 0.687148 13.2248 0.677515 14.3481 0.677515L16.3882 0.687148L16.6043 0.802741Z">
                        </path>
                        <path
                            d="M1.29608 10.4693C0.609639 10.7149 0.139209 11.3025 0.0432028 12.0394C-0.0144009 12.497 -0.0144009 15.8973 0.0432028 16.3549C0.129608 17.0003 0.489632 17.5205 1.07047 17.8239L1.36329 17.978H3.83545H6.30761L6.59563 17.8239C6.96525 17.6312 7.25807 17.3374 7.45008 16.9666L7.60369 16.6776V14.1972V11.7167L7.45008 11.4277C7.25807 11.0569 6.96525 10.7631 6.59563 10.5704L6.30761 10.4163L3.90745 10.4067C1.83372 10.397 1.4785 10.4067 1.29608 10.4693ZM6.2356 11.2062C6.52842 11.3603 6.65803 11.4855 6.79244 11.7504L6.90765 11.9768V14.2116V16.4416L6.74924 16.7017C6.53322 17.0677 6.2068 17.2604 5.74117 17.3037C5.54916 17.323 4.55549 17.3278 3.52343 17.3182L1.65131 17.3037L1.41129 17.1737C1.12807 17.0244 1.00807 16.8992 0.854455 16.6054L0.739248 16.3886V14.1972V12.0057L0.854455 11.789C1.05607 11.3988 1.33929 11.1821 1.74731 11.1099C1.85292 11.0906 2.85618 11.081 3.97946 11.081L6.01959 11.0906L6.2356 11.2062Z">
                        </path>
                        <path
                            d="M13.2441 10.4934C11.8856 10.8498 10.8583 11.8853 10.5079 13.2531C10.3735 13.7781 10.3735 14.6162 10.5079 15.1412C10.8343 16.4127 11.732 17.3808 12.9945 17.8239C13.3593 17.9491 13.4937 17.9732 14.0601 17.9925C14.617 18.0117 14.7754 17.9973 15.1162 17.9106C16.5179 17.5542 17.5452 16.5283 17.9052 15.1219C18.0348 14.6162 18.03 13.7685 17.9004 13.2531C17.55 11.8757 16.5179 10.8401 15.145 10.4885C14.6314 10.3585 13.7529 10.3585 13.2441 10.4934ZM15.2314 11.2784C15.7066 11.4518 16.0475 11.6782 16.4363 12.0828C17.0075 12.6848 17.2763 13.3639 17.2763 14.2068C17.2763 15.0882 17.0075 15.7288 16.3691 16.3645C15.721 17.0099 15.0826 17.2796 14.2186 17.2845C13.7001 17.2845 13.3113 17.193 12.8121 16.957C12.5336 16.8221 12.3608 16.692 12.0392 16.3694C11.396 15.724 11.132 15.0882 11.132 14.1972C11.132 13.3495 11.396 12.6896 11.972 12.0828C12.3608 11.6782 12.7017 11.4518 13.1817 11.2736C13.7913 11.0521 14.6218 11.0521 15.2314 11.2784Z">
                        </path>
                    </svg>
                </div>
            </div>
        </div>
    </header>
</div>