<?php

use Egns\Inc\Header_Helper;
use Egns\Helper\Egns_Helper;

?>

<div class="sidebar-menu">
    <div class="sidebar-menu-top-area">
        <div class="container d-flex align-items-center justify-content-between">
            <div class="sidebar-menu-logo">
                <?php
                if (!empty(Egns\Helper\Egns_Helper::egns_page_option_value('page_header_logo', 'url'))) { ?>
                    <a href="<?php echo esc_url(home_url('/')); ?>"><img alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" class="img-fluid" src="<?php echo Egns\Helper\Egns_Helper::egns_page_option_value('page_header_logo', 'url'); ?>"></a>
                    <?php  } else {
                    if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('header_logo', 'url'))) { ?>
                        <a href="<?php echo esc_url(home_url('/')); ?>"><img alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" class="img-fluid" src="<?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_logo', 'url'); ?>"></a>
                <?php } else {
                        Egns\Helper\Egns_Helper::get_theme_logo(NULL);
                    }
                }
                ?>
            </div>
            <div class="sidebar-menu-close">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 18 18">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M18 0L11.1686 8.99601L18 18L9.0041 11.1605L0 18L6.83156 8.99601L0 0L9.0041 6.83156L18 0Z"></path>
                </svg>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row g-lg-0 gy-5 align-items-center">
            <div class="col-lg-4 order-lg-1 order-2">
                <div class="sidebar-contact">
                    <div class="contact-area mb-40">
                        <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('header_sidebar_subtitle'))) : ?>
                            <h4><?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_sidebar_subtitle'); ?>
                                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12">
                                    <path d="M10.0035 3.40804L1.41153 12L0 10.5885L8.59097 1.99651H1.01922V0H12V10.9808H10.0035V3.40804Z" />
                                </svg>
                            </h4>
                        <?php endif; ?>
                        <ul class="contact-list">
                            <?php if (class_exists('CSF') && (Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_contact_info_show') == 1)) :  ?>
                                <?php
                                $items = (array) Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_contact_info');
                                $total_items = count($items);
                                $current_index = 0; // Initialize index
                                foreach ($items as $item) :
                                    $current_index++;
                                    $contactType = isset($item['sidebar_contact_type']) ? $item['sidebar_contact_type'] : 'default_value';

                                    // Check if any of the contact information fields is not empty
                                    $isNotEmpty = (
                                        ($contactType === 'phone' && !empty($item['sidebar_phone_info'])) ||
                                        ($contactType === 'email' && !empty($item['sidebar_email_info'])) ||
                                        ($contactType === 'others' && !empty($item['sidebar_custom_info']))
                                    );

                                    if ($isNotEmpty) :
                                ?>
                                        <li>
                                            <div class="single-contact">
                                                <?php if ($contactType === 'phone' && !empty($item['sidebar_phone_icon_svg']['url'])) :
                                                    $phone_icon = $item['sidebar_phone_icon_svg']['url']; ?>
                                                    <div class="icon">
                                                        <?php Egns\Helper\Egns_Helper::display_svg($phone_icon); ?>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if ($contactType === 'phone') : ?>
                                                    <div class="content">
                                                        <?php if (!empty($item['sidebar_phone_info_text'])) : ?>
                                                            <span><?php echo esc_html($item['sidebar_phone_info_text']); ?></span>
                                                        <?php endif; ?>
                                                        <h6><a href="tel:<?php echo str_replace([' ', '-', '+'], ['', '', ''], $item['sidebar_phone_info']); ?>"><?php echo esc_html($item['sidebar_phone_info']); ?></a></h6>
                                                    </div>
                                                <?php elseif ($contactType === 'email') : ?>
                                                    <?php if ($contactType === 'email' && !empty($item['sidebar_email_icon_svg']['url'])) :
                                                        $email_icon = $item['sidebar_email_icon_svg']['url'];   ?>
                                                        <div class="icon">
                                                            <?php Egns\Helper\Egns_Helper::display_svg($email_icon) ?>
                                                        </div>
                                                    <?php endif ?>
                                                    <div class="content">
                                                        <?php if (!empty($item['sidebar_email_info_text'])) : ?>
                                                            <span><?php echo esc_html($item['sidebar_email_info_text']); ?></span>
                                                        <?php endif; ?>
                                                        <h6><a href="mailto:<?php echo esc_html($item['sidebar_email_info']); ?>"><?php echo esc_html($item['sidebar_email_info']); ?></a></h6>
                                                    </div>
                                                <?php elseif ($contactType === 'others') : ?>
                                                    <?php if ($contactType === 'others' && !empty($item['sidebar_custom_icon_svg']['url'])) :
                                                        $others_icon = $item['sidebar_custom_icon_svg']['url'];  ?>
                                                        <div class="icon">
                                                            <?php Egns\Helper\Egns_Helper::display_svg($others_icon) ?>
                                                        </div>
                                                    <?php endif ?>
                                                    <div class="content">
                                                        <?php if (!empty($item['sidebar_custom_title'])) : ?>
                                                            <span><?php echo esc_html($item['sidebar_custom_title']); ?></span>
                                                        <?php endif; ?>
                                                        <?php if (!empty($item['sidebar_custom_info'])) : ?>
                                                            <h6><a href="<?php echo esc_html($item['sidebar_custom_link']); ?>"><?php echo esc_html($item['sidebar_custom_info']); ?></a></h6>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            <?php if ($current_index < $total_items) : ?>
                                                <svg class="arrow" width="8" height="29" viewBox="0 0 8 29" xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M1.33333 3C1.33333 4.47276 2.52724 5.66667 4 5.66667C5.47276 5.66667 6.66667 4.47276 6.66667 3C6.66667 1.52724 5.47276 0.333333 4 0.333333C2.52724 0.333333 1.33333 1.52724 1.33333 3ZM3.64645 28.3536C3.84171 28.5488 4.15829 28.5488 4.35355 28.3536L7.53553 25.1716C7.7308 24.9763 7.7308 24.6597 7.53553 24.4645C7.34027 24.2692 7.02369 24.2692 6.82843 24.4645L4 27.2929L1.17157 24.4645C0.976311 24.2692 0.659728 24.2692 0.464466 24.4645C0.269204 24.6597 0.269204 24.9763 0.464466 25.1716L3.64645 28.3536ZM3.5 3V28H4.5V3H3.5Z" />
                                                </svg>
                                            <?php endif; ?>
                                        </li>
                                <?php
                                    endif;
                                endforeach;
                                ?>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="address-area">
                        <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_title'))) : ?>
                            <h4><?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_title'); ?>
                                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12">
                                    <path d="M10.0035 3.40804L1.41153 12L0 10.5885L8.59097 1.99651H1.01922V0H12V10.9808H10.0035V3.40804Z" />
                                </svg>
                            </h4>
                        <?php endif; ?>
                        <ul class="address-list">
                            <li class="single-address">
                                <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_one_title'))) : ?>
                                    <span><?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_one_title'); ?></span>
                                <?php endif; ?>
                                <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_one_content'))) : ?>
                                    <p><?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_one_content'); ?></p>
                                <?php endif; ?>
                            </li>
                            <li class="single-address">
                                <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_two_title'))) : ?>
                                    <span><?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_two_title'); ?></span>
                                <?php endif; ?>
                                <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_two_title'))) : ?>
                                    <p><?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('sidebar_location_info_two_content'); ?></p>
                                <?php endif; ?>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-lg-8 order-lg-2 order-1">
                <div class="sidebar-menu-wrap">
                    <?php
                    Egns_Helper::egns_get_theme_menu('primary-menu', 'nav-menu', '<span class="dropdown-icon2"><i class="bi bi-plus"></i></span>', 'main-menu', 3);
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Sidebar section -->

<!-- Header Start -->
<header class="header-area style-3">
    <div class="container-fluid d-flex flex-nowrap align-items-center justify-content-between">
        <div class="header-logo">
            <?php
            if (!empty(Egns\Helper\Egns_Helper::egns_page_option_value('page_header_logo', 'url'))) { ?>
                <a href="<?php echo esc_url(home_url('/')); ?>"><img alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" class="img-fluid" src="<?php echo Egns\Helper\Egns_Helper::egns_page_option_value('page_header_logo', 'url'); ?>"></a>
                <?php  } else {
                if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('header_logo', 'url'))) { ?>
                    <a href="<?php echo esc_url(home_url('/')); ?>"><img alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" class="img-fluid" src="<?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_logo', 'url'); ?>"></a>
            <?php } else {
                    Egns\Helper\Egns_Helper::get_theme_logo(NULL);
                }
            }
            ?>
        </div>
        <div class="menu-btn">
            <div class="menu-btn-wrap">
                <div class="icon">
                    <svg width="14" height="14" viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg">
                        <rect width="11.2" height="1.4" rx="0.699998" fill="white" />
                        <rect x="2.80078" y="5.6" width="11.2" height="2.79999" rx="1.4" fill="white" />
                        <rect y="12.6" width="11.2" height="1.4" rx="0.699998" />
                    </svg>
                </div>
                <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('header_menu_bar_text'))) : ?>
                    <span><?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_menu_bar_text'); ?></span>
                <?php endif; ?>
            </div>
        </div>
        <div class="nav-right d-sm-flex jsutify-content-end align-items-center d-none">
            <div class="contact-area d-md-flex d-none">
                <?php if (Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header') == 'phone') {
                    $sidebar_phone_icon = Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header_phone_icon');
                    $phone_icon = is_array($sidebar_phone_icon) && isset($sidebar_phone_icon['url']) ? $sidebar_phone_icon['url'] : '';
                    if (!empty($phone_icon)) :
                ?>
                        <div class="icon">
                            <?php Egns\Helper\Egns_Helper::display_svg($phone_icon) ?>
                        </div>
                    <?php endif; ?>
                    <div class="content">
                        <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header_phone_content_title'))) : ?>
                            <span><?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header_phone_content_title')); ?></span>
                        <?php endif; ?>
                        <a href="tel:<?php echo preg_replace('/\D/', '', Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header_info')); ?>"><?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header_info')); ?></a>
                    </div>
                    <?php } elseif (Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header') == 'email') {
                    $sidebar_email_icon = Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header_email_icon');
                    $email_icon = is_array($sidebar_email_icon) && isset($sidebar_email_icon['url']) ? $sidebar_email_icon['url'] : '';
                    if (!empty($email_icon)) :
                    ?>
                        <div class="icon">
                            <?php Egns\Helper\Egns_Helper::display_svg($email_icon) ?>
                        </div>
                    <?php endif; ?>
                    <div class="content">
                        <span><?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header_email_content_title')); ?></span>
                        <a href="mailto:<?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header_info_text')); ?>"><?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header_info_text')); ?></a>
                    </div>

                    <?php } elseif (Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header') == 'others') {
                    $sidebar_custom_icon = Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header_custom_icon');
                    $sidebar_custom_link = Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header_custom_link');
                    $custom_link = is_array($sidebar_custom_link) && isset($sidebar_custom_link['url']) ? $sidebar_custom_link['url'] : '';
                    $custom_icon = is_array($sidebar_custom_icon) && isset($sidebar_custom_icon['url']) ? $sidebar_custom_icon['url'] : '';
                    if (!empty($custom_icon)) : ?>
                        <div class="icon">
                            <?php Egns\Helper\Egns_Helper::display_svg($custom_icon) ?>
                        </div>
                    <?php endif; ?>
                    <div class="content">
                        <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header_custom_content_title'))) : ?>
                            <span><?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header_custom_content_title')); ?></span>
                        <?php endif; ?>
                        <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header_custom_text'))) : ?>
                            <a href="<?php echo esc_url($custom_link); ?>"><?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('contact_type_header_custom_text')); ?></a>
                        <?php endif; ?>
                    </div>
                <?php  } ?>
            </div>
            <?php if (Egns\Helper\Egns_Helper::egns_get_theme_option('header_one_button_enable') == 1) : ?>
                <a href="<?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_one_button_link', 'url'); ?>" class="primary-btn d-sm-flex d-none">
                    <?php echo Egns\Helper\Egns_Helper::egns_get_theme_option('header_one_button_label'); ?>
                    <svg viewBox="0 0 13 20">
                        <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                    </svg>
                </a>
            <?php endif; ?>
        </div>
    </div>
</header>