<?php
if (class_exists('CSF')) {
    if (get_post_type(get_the_ID()) === 'footer_blocks') {
        return;
    }

    // Retrieve the footer selection slug from theme options
    $footer_page_selection_slug = \Egns\Helper\Egns_Helper::egns_page_option_value('page_footer_shortcode');
    $footer_selection_slug      = $footer_page_selection_slug ?: \Egns\Helper\Egns_Helper::egns_get_theme_option('footer_shortcode');

    if ($footer_selection_slug) {
        // Query all footer_blocks posts
        $footer_posts = get_posts(array(
            'post_type' => 'footer_blocks',
            'posts_per_page' => -1, // Get all footer blocks
            'orderby' => 'date',
            'order' => 'ASC'
        ));

        // Initialize the index to -1 (not found)
        $index = -1;

        // Loop through footer_blocks to find the matching post and its index
        foreach ($footer_posts as $key => $footer_post) {
            if ($footer_post->post_name === $footer_selection_slug) {
                $index = $key; // Set index if matching post is found
                break;
            }
        }
    }


    if ($footer_selection_slug) {
        $footer_post = get_page_by_path($footer_selection_slug, OBJECT, 'footer_blocks');

        if ($footer_post && is_object($footer_post)) {
            if (class_exists('Elementor\Plugin')) {
?>

                <?php
                // Render Elementor footer content
                echo Elementor\Plugin::$instance->frontend->get_builder_content_for_display($footer_post->ID);
                ?>

            <?php
            } else {
                // Render non-Elementor content
                echo apply_filters('the_content', $footer_post->post_content);
            }
        } else { ?>
            <div class="footer-section">
                <div class="footer-wrapper">
                    <div class="footer-bottom-wrap">
                        <div class="container">
                            <div class="footer-bottom d-block text-center border-top-0">
                                <div class="copyright-area">
                                    <p><?php echo esc_html__('©Copyright 2025', 'vernex') ?><a href="<?php echo esc_url('https://vernex.egenstheme.com/') ?>"><?php echo esc_html__(' Vernex', 'vernex') ?></a> <?php echo esc_html__('| Design By', 'vernex') ?><a href="<?php echo esc_url('https://www.egenstheme.com/') ?>"><?php echo esc_html__(' Egens Theme', 'vernex') ?></a></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php
        }
    } else { ?>
        <div class="footer-section">
            <div class="footer-wrapper">
                <div class="footer-bottom-wrap">
                    <div class="container">
                        <div class="footer-bottom d-block text-center border-top-0">
                            <?php if (!empty(\Egns\Helper\Egns_Helper::egns_get_theme_option('copyright_text'))): ?>
                                <div class="copyright-area">
                                    <p><?php echo \Egns\Helper\Egns_Helper::egns_get_theme_option('copyright_text'); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php
    }
    wp_reset_postdata();
} else {  ?>
    <div class="footer-section">
        <div class="footer-wrapper">
            <div class="footer-bottom-wrap">
                <div class="container">
                    <div class="footer-bottom d-block text-center border-top-0">
                        <div class="copyright-area">
                            <p><?php echo esc_html__('©Copyright 2025 ', 'vernex') ?><a href="<?php echo esc_url('https://www.vernex-wp.egenstheme.com/') ?>"><?php echo esc_html__(' Vernex', 'vernex') ?></a> <?php echo esc_html__('| Design By ', 'vernex') ?><a href="<?php echo esc_url('https://www.egenstheme.com/') ?>"><?php echo esc_html__('Egens Theme', 'vernex') ?></a></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
}
?>