<?php

use Egns\Inc\Blog_Helper;

// Get the sidebar enable option
$sidebar_enabled = Egns\Helper\Egns_Helper::egns_get_theme_option('sideaber_area_enable');
?>


<div id="post-<?php the_ID(); ?>" <?php post_class('blog-details-page'); ?>>
    <div class="container">
        <div class="row mb-50">
            <div class="col-lg-12">
                <?php Egns\Helper\Egns_Helper::egns_template_part('blog', 'templates/common/single/meta'); ?>
                <?php if (Egns\Inc\Blog_Helper::has_egns_embeded_video()) : ?>
                    <?php Egns\Helper\Egns_Helper::egns_template_part('blog', 'templates/standard/parts/video'); ?>
                <?php endif ?>
            </div>
        </div>
        <div class="row gy-5 mb-120 row gy-5 mb-120 justify-content-center">
            <div class="<?php echo is_active_sidebar('blog_sidebar') && $sidebar_enabled ? 'col-lg-8' : 'col-lg-10' ?>">
                <div class="details-content-wrapper mb-80">
                    <?php
                    the_content();
                    Egns\Inc\Blog_Helper::egns_post_pagination();
                    ?>
                </div>
                <?php Egns\Helper\Egns_Helper::egns_template_part('blog', 'templates/common/single/post-tags'); ?>

                <?php Egns\Helper\Egns_Helper::egns_template_part('blog', 'templates/common/single/pagination'); ?>

                <!-- Comments Section -->
                <?php
                //If comments are open or we have at least one comment, load up the comment template.
                if (comments_open() || get_comments_number()) {
                    comments_template();
                }
                ?>
            </div>
            <?php
            // If the option is explicitly set to false or doesn't exist, hide the sidebar
            if ($sidebar_enabled === false || $sidebar_enabled === 'false' || empty($sidebar_enabled)) {
                // Don't show the sidebar
            } else {
                // Show the sidebar
                Egns\Helper\Egns_Helper::egns_template_part('sidebar', 'templates/sidebar');
            }
            ?>
        </div>

    </div>
</div>