<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=yes">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo('pingback_url') ?>">
	<?php wp_head(); ?>
</head>

<?php

// Initialize $addClass
$addClass = '';

// Check if WooCommerce-related pages
if (class_exists('WooCommerce') && (is_shop() || is_product_category() || is_product_tag() || is_product())) {
	$addClass = 'gsap-gone';
} else {
	$addClass = 'tt-magic-cursor';
}

// Retrieve header menu style from page option
$page_option_value = Egns\Helper\Egns_Helper::egns_page_option_value('page_header_menu_style');

// Treat 'select_themeOption' or an empty value as invalid and fallback to theme option
if (empty($page_option_value) || $page_option_value === 'select_themeOption') {
	$header_menu_style = Egns\Helper\Egns_Helper::egns_get_theme_option('header_menu_style');
} else {
	$header_menu_style = $page_option_value;
}

// Fallback to a default value if header_menu_style is still empty
if (empty($header_menu_style)) {
	$header_menu_style = 'default_header'; // Replace with your desired default style
}

// Add 'header_six' class if header_menu_style is set to 'header_six'
if ($header_menu_style === 'header_six') {
	$addClass .= ' header_six'; // Append header_six to $addClass
}

// Determine body ID if needed
$body_id = ($header_menu_style === 'header_six') ? 'header-six' : '';

?>

<body <?php body_class($addClass); ?> <?php echo !empty($body_id) ? 'id="$body_id"' : '' ?> itemscope itemtype="https://schema.org/WebPage">

	<?php
	// Hook to include default WordPress hook after body tag open
	if (function_exists('wp_body_open')) {
		wp_body_open();
	}
	?>

	<div class="scroll-progress-wrap">
		<span><?php echo esc_html__('SCROLL', 'vernex'); ?></span>
		<div class="progress-container">
			<div id="progressbar" class="progress-bar"></div>
		</div>
	</div>

	<div id="magic-cursor">
		<div id="ball"></div>
	</div>

	<!-- app -->
	<div id="app" class="main-container">

		<?php
		// Hook to include page header template
		do_action('egns_action_page_header_template');
		?>