<?php

if (!class_exists('Egns_Handler')) {

	/**
	 * Main theme class with configuration
	 */

	class Egns_Handler
	{

		/**
		 * Initializes a singleton instance
		 *
		 * @return \Egns_Handler
		 */
		private static $instance;


		public static function get_instance()
		{
			if (is_null(self::$instance)) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * Main Class Constructor
		 */
		public function __construct()
		{

			// Include all require files
			require_once get_template_directory() . '/helpers/constants.php';
			require_once get_template_directory() . '/helpers/search_query.php';
			require_once EGNS_HELPERS_ROOT_DIR . '/theme_setup.php';
			require_once EGNS_HELPERS_ROOT_DIR . '/assets.php';
			require_once EGNS_HELPERS_ROOT_DIR . '/helper.php';
			require_once EGNS_HELPERS_ROOT_DIR . '/breadcrumb.php';
			require_once EGNS_HELPERS_ROOT_DIR . '/comments.php';
			require_once EGNS_HELPERS_ROOT_DIR . '/woo-hooks-mutated.php';
			require_once EGNS_HELPERS_ROOT_DIR . '/custom-with-ajax.php';
			require_once EGNS_INC_ROOT_DIR . '/plugins/tgma/activation.php';

			// Instantiation helper classes
			new Egns\Helper\Egns_Assets();
			new Egns\Helper\Egns_Theme_Setup();
			new Egns\Helper\Egns_Helper();
		}
	}

	Egns_Handler::get_instance();
}


/**
 * Remove p tag from contact form 7
 */
add_filter('wpcf7_autop_or_not', '__return_false');


/**
 * Change the number of related products output
 */
function vernex_move_comment_field($fields)
{
	$comment_field = $fields['comment'];
	unset($fields['comment']);
	$fields['comment'] = $comment_field;
	return $fields;
}
add_filter('comment_form_fields', 'vernex_move_comment_field', 10, 3);



/**
 *Codestar Fontawesome 5 
 */
if (!function_exists('your_prefix_enqueue_fa5')) {
	function your_prefix_enqueue_fa5()
	{
		wp_enqueue_style('fa5', 'https://use.fontawesome.com/releases/v5.13.0/css/all.css', array(), '5.13.0', 'all');
		wp_enqueue_style('fa5-v4-shims', 'https://use.fontawesome.com/releases/v5.13.0/css/v4-shims.css', array(), '5.13.0', 'all');
	}
	add_action('wp_enqueue_scripts', 'your_prefix_enqueue_fa5');
}


// Automatically use the custom template for posts in 'footer_blocks' post type
function set_footer_blocks_template($template)
{
	if (is_singular('footer_blocks')) {
		// Specify the path to your custom template file
		$custom_template = locate_template('template-footer-blocks.php');

		// If the custom template exists, use it
		if ($custom_template) {
			return $custom_template;
		}
	}
	return $template;
}
add_filter('template_include', 'set_footer_blocks_template');
