<?php

/**
 * The template for displaying archive pages
 *
 * @link https: //developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package vernex
 */

get_header();

if (!is_front_page()) {
    $posts_per_page_option = Egns\Helper\Egns_Helper::egns_get_theme_option('posts_per_page_option_project');

    // Include breadcrumb template
    Egns\Helper\Egns_Helper::egns_template_part('breadcrumb', 'templates/breadcrumb-archive');
}

?>
<div class="project-grid-page pt-120 mb-120">
    <div class="container">
        <div class="row gy-5" id="project-archive">
            <?php
            $args = array(
                'post_type'      => 'project',
                'post_status'    => 'publish',
                'posts_per_page' => $posts_per_page_option,
                'paged'          => (get_query_var('paged')) ? get_query_var('paged') : 1,
            );
            $wp_query = new WP_Query($args);
            $num      = 0;

            if ($wp_query->have_posts()) {

                while ($wp_query->have_posts()):
                    $num++;
                    $wp_query->the_post();

                    Egns\Helper\Egns_Helper::egns_template_part('project', 'parts/archive-content');

                endwhile;
            } else {
                // Include global posts not found
                Egns\Helper\Egns_Helper::egns_template_part('content', 'templates/posts-not-found');
            }
            ?>
        </div>
        <div class="row">
            <div class="col-lg-12 d-flex justify-content-center">
                <div id="archive-load-more-project" class="load-more-for-project-btn">
                    <button class="primary-btn2 bounce_up mt-70">
                        <span>
                            <?php echo esc_html__('Load More', 'vernex'); ?>
                            <svg viewBox="0 0 13 20">
                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                            </svg>
                            <img src="<?php echo esc_sql(get_template_directory_uri() . '/assets/img/loading.gif') ?>" class="loading-gif" style="display: none; height:14px; width:14px" alt="<?php echo esc_attr__('image', 'vernex') ?>" />
                        </span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>