<?php

// Popular Posts Widget
class Egns_Popular_Posts_Widget extends WP_Widget
{
    function __construct()
    {
        parent::__construct(
            // Base ID
            'egns_popular_posts',

            // Widget Name
            __('Egns Popular Posts', 'vernex-core'),

            // Widget Description
            array('description' => __('Displays popular posts', 'vernex-core'))
        );
    }

    // Frontend display of the widget
    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        $number_of_posts = !empty($instance['number_of_posts']) ? $instance['number_of_posts'] : 3;

        echo $args['before_widget'];

        // Display widget title
        if (!empty($title)) {
            echo $args['before_title'] . $title . $args['after_title'];
        }

        // Query popular posts by comment count
        $popular_posts = new WP_Query(array(
            'posts_per_page' => $number_of_posts,
            'orderby' => 'comment_count',
            'order' => 'DESC'
        ));

        // Loop through popular posts
        if ($popular_posts->have_posts()) :
            while ($popular_posts->have_posts()) : $popular_posts->the_post();
?>
                <div class="recent-post-widget mb-20">
                    <div class="recent-post-img">
                        <a href="<?php the_permalink(); ?>">
                            <?php
                            if (has_post_thumbnail()) {
                                the_post_thumbnail('thumbnail');
                            } else {
                                echo '<img src="' . esc_url(get_template_directory_uri() . '/assets/img/inner-pages/default-image.png') . '" alt="' . esc_attr(get_the_title()) . '">';
                            }
                            ?>
                        </a>
                    </div>
                    <div class="recent-post-content">
                        <a href="<?php echo esc_url(get_permalink()); ?>"><?php echo get_the_date('d F, Y'); ?></a>
                        <h6><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h6>
                    </div>
                </div>
        <?php
            endwhile;
            wp_reset_postdata();
        else :
            echo '<p>' . __('No popular posts available', 'vernex-core') . '</p>';
        endif;

        echo $args['after_widget'];
    }

    // Widget backend form
    public function form($instance)
    {
        $title = isset($instance['title']) ? $instance['title'] : __('Popular Posts', 'vernex-core');
        $number_of_posts = isset($instance['number_of_posts']) ? $instance['number_of_posts'] : 3;
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php _e('Title:', 'vernex-core'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text"
                value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number_of_posts')); ?>"><?php _e('Number of Posts:', 'vernex-core'); ?></label>
            <input class="tiny-text" id="<?php echo esc_attr($this->get_field_id('number_of_posts')); ?>"
                name="<?php echo esc_attr($this->get_field_name('number_of_posts')); ?>" type="number"
                step="1" min="1" value="<?php echo esc_attr($number_of_posts); ?>" size="3">
        </p>
<?php
    }

    // Updating widget replacing old instances with new values
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? sanitize_text_field($new_instance['title']) : '';
        $instance['number_of_posts'] = (!empty($new_instance['number_of_posts'])) ? intval($new_instance['number_of_posts']) : 3;
        return $instance;
    }
}

// Register the widget
function register_egns_popular_posts_widget()
{
    register_widget('Egns_Popular_Posts_Widget');
}
add_action('widgets_init', 'register_egns_popular_posts_widget');