<?php


class Custom_Widget extends WP_Widget
{

    public function __construct()
    {
        // Widget initialization
        parent::__construct(
            // Base ID of our widget
            'footer_one_company_info_widget',

            // Widget name
            'Egns Footer Company Info',

            // Widget description
            array('description' => 'A custom widget that allows you to display office address, map, and button.')
        );
    }

    public function widget($args, $instance)
    {
        // Widget output
        echo $args['before_widget'];

        // Widget content
?>

        <?php if (!empty($instance['footer_one_widget_subtitle'] || $instance['footer_one_widget_title'] || $instance['footer_one_widget_content'])) : ?>

            <div class="footer-widget">
                <div class="widget-title two">
                    <?php if (!empty($instance['footer_one_widget_subtitle'])) : ?>
                        <span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14">
                                <g>
                                    <path d="M6.6304 0.338424C6.67018 -0.112811 7.32982 -0.112807 7.3696 0.338428L7.72654 4.38625C7.75291 4.68505 8.10454 4.83069 8.33443 4.63804L11.4491 2.02821C11.7963 1.73728 12.2627 2.20368 11.9718 2.55089L9.36197 5.66556C9.1693 5.89546 9.31496 6.24709 9.61374 6.27346L13.6615 6.6304C14.1128 6.67018 14.1128 7.32982 13.6615 7.3696L9.61374 7.72654C9.31496 7.75291 9.1693 8.10454 9.36197 8.33443L11.9718 11.4491C12.2627 11.7963 11.7963 12.2627 11.4491 11.9718L8.33443 9.36197C8.10454 9.1693 7.75291 9.31496 7.72654 9.61374L7.3696 13.6615C7.32982 14.1128 6.67018 14.1128 6.6304 13.6615L6.27346 9.61374C6.24709 9.31496 5.89546 9.1693 5.66556 9.36197L2.55089 11.9718C2.20368 12.2627 1.73729 11.7963 2.02822 11.4491L4.63804 8.33443C4.83069 8.10454 4.68504 7.75291 4.38625 7.72654L0.338424 7.3696C-0.112811 7.32982 -0.112807 6.67018 0.338428 6.6304L4.38625 6.27346C4.68505 6.24709 4.83069 5.89546 4.63804 5.66556L2.02821 2.55089C1.73728 2.20368 2.20368 1.73729 2.55089 2.02822L5.66556 4.63804C5.89546 4.83069 6.24709 4.68504 6.27346 4.38625L6.6304 0.338424Z" />
                                </g>
                            </svg>
                            <?php echo esc_html($instance['footer_one_widget_subtitle']) ?>
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14">
                                <g>
                                    <path d="M6.6304 0.338424C6.67018 -0.112811 7.32982 -0.112807 7.3696 0.338428L7.72654 4.38625C7.75291 4.68505 8.10454 4.83069 8.33443 4.63804L11.4491 2.02821C11.7963 1.73728 12.2627 2.20368 11.9718 2.55089L9.36197 5.66556C9.1693 5.89546 9.31496 6.24709 9.61374 6.27346L13.6615 6.6304C14.1128 6.67018 14.1128 7.32982 13.6615 7.3696L9.61374 7.72654C9.31496 7.75291 9.1693 8.10454 9.36197 8.33443L11.9718 11.4491C12.2627 11.7963 11.7963 12.2627 11.4491 11.9718L8.33443 9.36197C8.10454 9.1693 7.75291 9.31496 7.72654 9.61374L7.3696 13.6615C7.32982 14.1128 6.67018 14.1128 6.6304 13.6615L6.27346 9.61374C6.24709 9.31496 5.89546 9.1693 5.66556 9.36197L2.55089 11.9718C2.20368 12.2627 1.73729 11.7963 2.02822 11.4491L4.63804 8.33443C4.83069 8.10454 4.68504 7.75291 4.38625 7.72654L0.338424 7.3696C-0.112811 7.32982 -0.112807 6.67018 0.338428 6.6304L4.38625 6.27346C4.68505 6.24709 4.83069 5.89546 4.63804 5.66556L2.02821 2.55089C1.73728 2.20368 2.20368 1.73729 2.55089 2.02822L5.66556 4.63804C5.89546 4.83069 6.24709 4.68504 6.27346 4.38625L6.6304 0.338424Z" />
                                </g>
                            </svg>
                        </span>
                    <?php endif; ?>
                    <?php if (!empty($instance['footer_one_widget_title'])) : ?>
                        <h3> <?php echo esc_html($instance['footer_one_widget_title']) ?></h3>
                    <?php endif; ?>
                </div>
                <?php if (!empty($instance['footer_one_widget_content'])) : ?>
                    <div class="content">
                        <p><?php echo esc_html($instance['footer_one_widget_content']) ?></p>
                    </div>
                <?php endif; ?>
                <ul class="rating-area">
                    <li>
                        <a href="https://clutch.co/" class="single-rating">
                            <div class="review">
                                <span>Review On</span>
                                <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/img/home1/icon/clutch-logo.svg'); ?>" alt="<?php echo esc_attr__('image', 'vernex-core') ?>" class="logo-dark">
                                <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/img/home1/icon/clutch-logo-white.svg'); ?>" alt="<?php echo esc_attr__('image', 'vernex-core') ?>" class="logo-light">
                            </div>
                            <div class="rating">
                                <ul class="star">
                                    <li><i class="bi bi-star-fill"></i></li>
                                    <li><i class="bi bi-star-fill"></i></li>
                                    <li><i class="bi bi-star-fill"></i></li>
                                    <li><i class="bi bi-star-fill"></i></li>
                                    <li><i class="bi bi-star-half"></i></li>
                                </ul>
                                <span>(50 reviews)</span>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="https://www.google.com/" class="single-rating google">
                            <div class="review">
                                <span>Review On</span>
                                <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/img/home1/icon/google-logo.svg'); ?>" alt="<?php echo esc_attr__('image', 'vernex-core') ?>">
                            </div>
                            <div class="rating">
                                <ul class="star">
                                    <li><i class="bi bi-star-fill"></i></li>
                                    <li><i class="bi bi-star-fill"></i></li>
                                    <li><i class="bi bi-star-fill"></i></li>
                                    <li><i class="bi bi-star-fill"></i></li>
                                    <li><i class="bi bi-star-half"></i></li>
                                </ul>
                                <span>(50 reviews)</span>
                            </div>
                        </a>
                    </li>
                </ul>
            </div>
        <?php endif; ?>

    <?php
        echo $args['after_widget'];
    }


    public function form($instance)
    {
        // Widget form fields
        $footer_one_subtitle = !empty($instance['footer_one_widget_subtitle']) ? esc_attr($instance['footer_one_widget_subtitle']) : '';
        $footer_one_title = !empty($instance['footer_one_widget_title']) ? esc_attr($instance['footer_one_widget_title']) : '';
        $footer_one_content = !empty($instance['footer_one_widget_content']) ? $instance['footer_one_widget_content'] : '';


        // Display the form
    ?>

        <!-- Address Fields  -->
        <p>
            <label for="<?php echo $this->get_field_id('footer_one_widget_subtitle'); ?>"><?php echo esc_html__(' Sub-Title : ', 'vernex-core') ?></label>
            <input class="widefat" type="text" id="<?php echo $this->get_field_id('footer_one_widget_subtitle'); ?>" name="<?php echo $this->get_field_name('footer_one_widget_subtitle'); ?>" value="<?php echo $footer_one_subtitle; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('footer_one_widget_title'); ?>"><?php echo esc_html__(' Title : ', 'vernex-core') ?></label>
            <input class="widefat" type="text" id="<?php echo $this->get_field_id('footer_one_widget_title'); ?>" name="<?php echo $this->get_field_name('footer_one_widget_title'); ?>" value="<?php echo $footer_one_title; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('footer_one_widget_content'); ?>"><?php echo esc_html__(' Content :', 'vernex-core') ?></label>
            <textarea class="widefat" name="<?php echo $this->get_field_name('footer_one_widget_content'); ?>" id="<?php echo $this->get_field_id('footer_one_widget_content'); ?>" cols="30" rows="5"><?php echo $footer_one_content; ?></textarea>
        </p>



<?php
    }



    public function update($new_instance, $old_instance)
    {
        // Save widget form values
        $instance = array();

        $instance['footer_one_widget_subtitle'] = (!empty($new_instance['footer_one_widget_subtitle'])) ? $new_instance['footer_one_widget_subtitle'] : '';
        $instance['footer_one_widget_title'] = (!empty($new_instance['footer_one_widget_title'])) ? $new_instance['footer_one_widget_title'] : '';
        $instance['footer_one_widget_content'] = (!empty($new_instance['footer_one_widget_content'])) ? $new_instance['footer_one_widget_content'] : '';


        return $instance;
    }
}

function register_footer_one_company_info_widget()
{
    // Register the widget
    register_widget('Custom_Widget');
}
add_action('widgets_init', 'register_footer_one_company_info_widget');
