<?php
/*-------------------------------------------------------
		  ** Header Topbar
--------------------------------------------------------*/
// Create a simple general section

CSF::createSection($prefix, array(
	'parent' => 'header_options',
	'title'  => esc_html__('Header Topbar', 'vernex-core'),
	'id'     => 'theme_header_topbar_section',
	'icon'   => 'fa fa-wheelchair',
	'fields' => array(

		//------------------------- Header Sidebar Content --------------------------//
		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Topbar Content', 'vernex-core') . '</h3>'
		),

		array(
			'id'      => 'header_topbar_bottom_enable',
			'title'   => esc_html__('Enable Topbar', 'vernex-core'),
			'type'    => 'switcher',
			'desc'    => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable Social Links Options', 'vernex-core'),  wp_kses_allowed_html('vernex-core')),
			'default' => true,
		),

		array(
			'id'      => 'contact_type',
			'type'    => 'radio',
			'title'   => esc_html__('Contact Type', 'vernex-core'),
			'options' => array(
				'phone'  => esc_html('Phone'),
				'email'  => esc_html('Email'),
				'others' => esc_html('Others'),
			),
			'default' => 'phone',
		),

		array(
			'id'         => 'phone_icon_svg',
			'type'       => 'media',
			'title'      => esc_html__('Icon (SVG)', 'vernex-core'),
			'default'  => array(
				'url'         => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES  . '/topbar/phone.svg'),
				'id'          => 'contact_icon',
				'thumbnail'   => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES  . '/topbar/phone.svg'),
				'alt'         => esc_attr('content-icons'),
				'title'       => esc_html('Icon'),
			),
			'dependency' => array(
				array('contact_type', '==', 'phone'),
			),
		),

		array(
			'id'         => 'phone_contact_info',
			'type'       => 'text',
			'default' => esc_html__('+91 656 786 53', 'vernex-core'),
			'title'      => esc_html__('Contact Information', 'vernex-core'),
			'dependency' => array(
				array('contact_type', '==', 'phone'),
			),
		),

		array(
			'id'         => 'email_icon_svg',
			'type'       => 'media',
			'title'      => esc_html__('Icon (SVG)', 'vernex-core'),
			'default'  => array(
				'url'         => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES  . '/topbar/email.svg'),
				'id'          => 'email_icon',
				'thumbnail'   => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES  . '/topbar/email.svg'),
				'alt'         => esc_attr('content-icons'),
				'title'       => esc_html('Icon'),
			),
			'dependency' => array(
				array('contact_type', '==', 'email'),
			),
		),

		array(
			'id'         => 'email_contact_info',
			'type'       => 'text',
			'default' => esc_html__('info@example.com', 'vernex-core'),
			'title'      => esc_html__('Contact Information', 'vernex-core'),
			'dependency' => array(
				array('contact_type', '==', 'email'),
			),
		),

		array(
			'id'         => 'custom_icon_svg',
			'type'       => 'media',
			'title'      => esc_html__('Icon (SVG)', 'vernex-core'),
			'dependency' => array(
				array('contact_type', '==', 'others'),
			),
		),
		array(
			'id'         => 'custom_text',
			'type'       => 'text',
			'title'      => esc_html__('Custom Text', 'vernex-core'),
			'dependency' => array(
				array('contact_type', '==', 'others'),
			),
		),

		array(
			'id'      => 'header_topbar_custom_link',
			'type'    => 'link',
			'title'   => esc_html__('Custom Link', 'vernex-core'),
			'default' => array(
				'url'    => '#',
				'target' => '_blank'
			),
			'dependency' => array(
				array('contact_type', '==', 'others'),
			),
		),

		array(
			'id'      => 'contact_type_two',
			'type'    => 'radio',
			'title'   => esc_html__('Contact Type', 'vernex-core'),
			'options' => array(
				'phone'  => esc_html('Phone'),
				'email'  => esc_html('Email'),
				'others' => esc_html('Others'),
			),
			'default' => 'phone',
		),

		array(
			'id'         => 'phone_icon_svg_two',
			'type'       => 'media',
			'title'      => esc_html__('Icon (SVG)', 'vernex-core'),
			'default'  => array(
				'url'         => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES  . '/topbar/phone.svg'),
				'id'          => 'contact_icon',
				'thumbnail'   => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES  . '/topbar/phone.svg'),
				'alt'         => esc_attr('content-icons'),
				'title'       => esc_html('Icon'),
			),
			'dependency' => array(
				array('contact_type_two', '==', 'phone'),
			),
		),

		array(
			'id'         => 'phone_contact_info_two',
			'type'       => 'text',
			'default' => esc_html__('+91 656 786 53', 'vernex-core'),
			'title'      => esc_html__('Contact Information', 'vernex-core'),
			'dependency' => array(
				array('contact_type_two', '==', 'phone'),
			),
		),

		array(
			'id'         => 'email_icon_svg_two',
			'type'       => 'media',
			'title'      => esc_html__('Icon (SVG)', 'vernex-core'),
			'default'  => array(
				'url'         => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES  . '/topbar/email.svg'),
				'id'          => 'email_icon',
				'thumbnail'   => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES  . '/topbar/email.svg'),
				'alt'         => esc_attr('content-icons'),
				'title'       => esc_html('Icon'),
			),
			'dependency' => array(
				array('contact_type_two', '==', 'email'),
			),
		),
		array(
			'id'         => 'email_contact_info_two',
			'type'       => 'text',
			'default' => esc_html__('info@example.com', 'vernex-core'),
			'title'      => esc_html__('Contact Information', 'vernex-core'),
			'dependency' => array(
				array('contact_type_two', '==', 'email'),
			),
		),

		array(
			'id'         => 'custom_icon_svg_two',
			'type'       => 'media',
			'title'      => esc_html__('Icon (SVG)', 'vernex-core'),
			'dependency' => array(
				array('contact_type_two', '==', 'others'),
			),
		),
		array(
			'id'         => 'custom_text_two',
			'type'       => 'text',
			'title'      => esc_html__('Custom Text', 'vernex-core'),
			'dependency' => array(
				array('contact_type_two', '==', 'others'),
			),
		),

		array(
			'id'      => 'header_topbar_custom_link_two',
			'type'    => 'link',
			'title'   => esc_html__('Custom Link', 'vernex-core'),
			'default' => array(
				'url'    => '#',
				'target' => '_blank'
			),
			'dependency' => array(
				array('contact_type_two', '==', 'others'),
			),
		),

		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Address Area', 'vernex-core') . '</h3>'
		),

		// address section
		array(
			'id'         => 'header_topbar_address_icon',
			'type'       => 'media',
			'title'      => esc_html__('Address Icon (SVG)', 'vernex-core'),
		),
		array(
			'id'         => 'header_topbar_address_text',
			'type'       => 'text',
			'title'      => esc_html__('Address Text', 'vernex-core'),
			'default' => esc_html__('Capital Office, 124 City Road, London', 'vernex-core'),
		),

		array(
			'id'      => 'header_topbar_address_link',
			'type'    => 'link',
			'title'   => esc_html__('Address Link', 'vernex-core'),
			'default' => array(
				'url'    => '#',
				'target' => '_blank'
			),
		),
	),



));
