<?php
/*-------------------------------------------------------
		  ** Header Options
--------------------------------------------------------*/
// Create a simple general section

CSF::createSection($prefix, array(
	'parent' => 'header_options',
	'title'  => esc_html__('Header Sidebar', 'vernex-core'),
	'id'     => 'theme_header_options',
	'icon'   => 'fa fa-id-card-o',

	'fields' => array(

		//------------------------- Header Sidebar Content --------------------------//
		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Sidebar Content', 'vernex-core') . '</h3>'
		),
		array(
			'id'      => 'header_sidebar_bottom_enable',
			'title'   => esc_html__('Enable Content', 'vernex-core'),
			'type'    => 'switcher',
			'desc'    => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable Social Links Options', 'vernex-core'),  wp_kses_allowed_html('vernex-core')),
			'default' => true,
		),

		array(
			'id'      => 'header_sidebar_logo',
			'title'   => esc_html__('Upload Sidebar Logo', 'vernex-core'),
			'type'    => 'media',
			'desc'    => wp_kses(__('you can upload <mark>Sidebar Logo</mark> for header', 'vernex-core'), wp_kses_allowed_html('post')),
			'default' => array(
				'url'       => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/logo/logo.svg'),
				'id'        => 'logo1',
				'thumbnail' => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/logo/logo.svg'),
				'alt'       => esc_attr('logo-dark'),
				'title'     => esc_html('Logo'),
			),
		),


		array(
			'id'         => 'header_sidebar_subtitle',
			'type'       => 'text',
			'title'      => esc_html__('Subtitle', 'vernex-core'),
			'default'    => esc_html__('Get In Touch With Us', 'vernex-core'),
			'dependency' => array(
				array('header_sidebar_bottom_enable', '==', 'true'),
			),
		),
		array(
			'id'         => 'header_sidebar_title',
			'type'       => 'text',
			'title'      => esc_html__('Title', 'vernex-core'),
			'default'    => esc_html__('Connect With Vernex', 'vernex-core'),
			'dependency' => array(
				array('header_sidebar_bottom_enable', '==', 'true'),
			),
		),
		array(
			'id'         => 'header_sidebar_short_descp',
			'type'       => 'textarea',
			'title'      => esc_html__('Short Description', 'vernex-core'),
			'default'    => esc_html__("Ready to take the first step towards unlocking opportunity realizing goals, and embracing innovation?", 'vernex-core'),
			'dependency' => array(
				array('header_sidebar_bottom_enable', '==', 'true'),
			),
		),

		//Contact Info
		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Sidebar Contact Info', 'vernex-core') . '</h3>',
		),

		// Header Topbar Contact Info Show Hide 
		array(
			'id'         => 'sidebar_contact_info_show',
			'type'       => 'switcher',
			'title'      => esc_html__('Show Sidebar Contact Info', 'vernex-core'),
			'desc'       => wp_kses(__('you can set <mark>On / Off</mark> to show/hide Contact Info options', 'vernex-core'), wp_kses_allowed_html('post')),
			'default'    => 1,
		),

		array(
			'id'         => 'sidebar_contact_info',
			'type'       => 'repeater',
			'title'      => esc_html__('Sidebar Contact Information', 'vernex-core'),
			'dependency' => array(
				array('sidebar_contact_info_show', '==', '1'),
			),
			'fields'     => array(
				array(
					'id'      => 'sidebar_contact_type',
					'type'    => 'radio',
					'title'   => esc_html__('Contact Type', 'vernex-core'),
					'options' => array(
						'phone'  => esc_html('Phone'),
						'email'  => esc_html('Email'),
						'others' => esc_html('Others'),
					),
					'default' => 'phone',
				),
				// Fields for phone type
				array(
					'id'         => 'sidebar_phone_icon_svg',
					'type'       => 'media',
					'title'      => esc_html__('Icon (SVG)', 'vernex-core'),
					'dependency' => array(
						array('sidebar_contact_type', '==', 'phone'),
					),
				),
				array(
					'id'         => 'sidebar_phone_info_text',
					'type'       => 'text',
					'title'      => esc_html__('Contact Info Text', 'vernex-core'),
					'default'    => esc_html__('To More Inquiry', 'vernex-core'),
					'dependency' => array(
						array('sidebar_contact_type', '==', 'phone'),
					),
				),
				array(
					'id'         => 'sidebar_phone_info',
					'type'       => 'text',
					'title'      => esc_html__('Phone Number', 'vernex-core'),
					'default'    => esc_html__('+91 656 786 53', 'vernex-core'),
					'dependency' => array(
						array('sidebar_contact_type', '==', 'phone'),
					),
				),
				// Fields for email type
				array(
					'id'         => 'sidebar_email_icon_svg',
					'type'       => 'media',
					'title'      => esc_html__('Icon (SVG)', 'vernex-core'),
					'dependency' => array(
						array('sidebar_contact_type', '==', 'email'),
					),
				),
				array(
					'id'         => 'sidebar_email_info_text',
					'type'       => 'text',
					'title'      => esc_html__('Contact Info Text', 'vernex-core'),
					'default'    => esc_html__('Email:', 'vernex-core'),
					'dependency' => array(
						array('sidebar_contact_type', '==', 'email'),
					),
				),
				array(
					'id'         => 'sidebar_email_info',
					'type'       => 'text',
					'title'      => esc_html__('Email Address', 'vernex-core'),
					'default'    => esc_html__('info@example.com', 'vernex-core'),
					'dependency' => array(
						array('sidebar_contact_type', '==', 'email'),
					),
				),
				// Fields for custom type
				array(
					'id'         => 'sidebar_custom_icon_svg',
					'type'       => 'media',
					'title'      => esc_html__('Icon (SVG)', 'vernex-core'),
					'dependency' => array(
						array('sidebar_contact_type', '==', 'others'),
					),
				),
				array(
					'id'         => 'sidebar_custom_title',
					'type'       => 'text',
					'title'      => esc_html__('Custom Info Text', 'vernex-core'),
					'default'    => esc_html__('Office Address 01', 'vernex-core'),
					'dependency' => array(
						array('sidebar_contact_type', '==', 'others'),
					),
				),
				array(
					'id'         => 'sidebar_custom_info',
					'type'       => 'text',
					'title'      => esc_html__('Custom Information', 'vernex-core'),
					'default'    => esc_html__('Custom Info', 'vernex-core'), // Set your default custom info here
					'dependency' => array(
						array('sidebar_contact_type', '==', 'others'),
					),
				),
				array(
					'id'         => 'sidebar_custom_link',
					'type'       => 'text',
					'title'      => esc_html__('Custom Link', 'vernex-core'),
					'default'    => esc_html__('#', 'vernex-core'),
					'dependency' => array(
						array('sidebar_contact_type', '==', 'others'),
					),
				),
			),
			'default'    => array(
				array(
					'sidebar_contact_type'      => 'phone',
					'sidebar_phone_icon_svg'    => array(
						'url'       => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/sidebar/sidebar-phone.svg'),
						'id'        => 'phone_icon',
						'thumbnail' => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/sidebar/sidebar-phone.svg'),
						'alt'       => esc_attr('content-icons'),
						'title'     => esc_html('Icon'),
					),
					'sidebar_phone_info_text'   => esc_html__('CALL ANY TIME', 'vernex-core'),
					'sidebar_phone_info'        => esc_html__('+990-737 621 432', 'vernex-core'),
				),
				array(
					'sidebar_contact_type'      => 'others',
					'sidebar_custom_icon_svg'   => array(
						'url'       => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/sidebar/sidebar-location.svg'),
						'id'        => 'custom_icon',
						'thumbnail' => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/sidebar/sidebar-location.svg'),
						'alt'       => esc_attr('content-icons'),
						'title'     => esc_html('Icon'),
					),
					'sidebar_custom_title'   => esc_html__('ADDRESS', 'vernex-core'),
					'sidebar_custom_info'       => esc_html__('Dhaka, Bangladesh', 'vernex-core'), // Default custom info
					'sidebar_custom_link'   => esc_html__('#', 'vernex-core'),
				),
				array(
					'sidebar_contact_type'      => 'email',
					'sidebar_email_icon_svg'    => array(
						'url'       => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/sidebar/sidebar-email.svg'),
						'id'        => 'email_icon',
						'thumbnail' => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/sidebar/sidebar-email.svg'),
						'alt'       => esc_attr('content-icons'),
						'title'     => esc_html('Icon'),
					),
					'sidebar_email_info_text'   => esc_html__('SAY HELLO', 'vernex-core'),
					'sidebar_email_info'        => esc_html__('info@example.com', 'vernex-core'),
				),

			),
		),

		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Location Info', 'vernex-core') . '</h3>',
		),

		array(
			'id'         => 'sidebar_location_info_title',
			'type'       => 'text',
			'title'      => esc_html__('Location Title', 'vernex-core'),
			'default'    => esc_html__('Office Address', 'vernex-core'),
		),

		array(
			'id'         => 'sidebar_location_info_one_title',
			'type'       => 'text',
			'title'      => esc_html__('Address Title One', 'vernex-core'),
			'default'    => esc_html__('NEW YORK', 'vernex-core'),
		),

		array(
			'id'         => 'sidebar_location_info_one_content',
			'type'       => 'text',
			'title'      => esc_html__('Address Content One', 'vernex-core'),
			'default'    => esc_html__('8204 Glen Ridge DriveEndicott, NY 13760', 'vernex-core'),
		),

		array(
			'id'         => 'sidebar_location_info_two_title',
			'type'       => 'text',
			'title'      => esc_html__('Address Title Two', 'vernex-core'),
			'default'    => esc_html__('WASHINGTON DC', 'vernex-core'),
		),

		array(
			'id'         => 'sidebar_location_info_two_content',
			'type'       => 'text',
			'title'      => esc_html__('Address Content Two', 'vernex-core'),
			'default'    => esc_html__('8204 Glen Ridge DriveEndicott, NY 13760', 'vernex-core'),
		),

		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Copyright Info', 'vernex-core') . '</h3>',
		),

		array(
			'id'         => 'sidebar_copy_right_info',
			'type'       => 'textarea',
			'title'      => esc_html__('Copyright Info', 'nexaq-core'),
			'default'    => wp_kses(__('Copyright 2025 <a href="http://vernex-wp.egenstheme.com">Vernex</a> | Design By <a href="https://www.egenslab.com/">Egens Lab</a>', 'nexaq-core'), wp_kses_allowed_html('post')),
		),

	),

));
