<?php
/*-----------------------------------
		Footer Options  
------------------------------------*/

use Egns_Core\Egns_Helper;

CSF::createSection($prefix, array(
	'parent' => 'footer_options',
	'title'  => esc_html__('Footer Options', 'vernex-core'),
	'id'     => 'theme_footer_options',
	'icon'   => 'fa fa-id-card-o',
	'fields' => array(
		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Footer Options', 'vernex-core') . '</h3>'
		),

		array(
			'id'          => 'footer_shortcode',
			'type'        => 'select',
			'title'       => esc_html__('Choose Footer', 'vernex-core'),
			'placeholder' => esc_html__('Select Footer', 'vernex-core'),
			'desc'        => wp_kses(__('Footer list comming from custom post type <mark>Footer Blocks</mark>, select footer otherwise show only copyright text', 'vernex-core'), wp_kses_allowed_html('post')),
			'options'     => \Egns_Core\Egns_Helper::get_header_footer(),
			'default'     => 'footer-one',
		),

		//------------------------- Footer Copyright Area Text--------------------------//
		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Footer Copyright Area', 'vernex-core') . '</h3>'
		),

		array(
			'id'      => 'copyright_text',
			'title'   => esc_html__('Copyright Area Text', 'vernex-core'),
			'desc'    => wp_kses(__('write your <mark>Footer Copyright Text</mark> here', 'vernex-core'), wp_kses_allowed_html('post')),
			'type'    => 'textarea',
			'default' => wp_kses(('© Copyright 2025 <a href="https://vernex-wp.egenstheme.com/">Vernex</a> | Design By <a href="https://www.egenslab.com/">Egens Lab</a>'), wp_kses_allowed_html('post')),
			'desc'    => wp_kses(__('When not selected <mark>Elementor Header Footer</mark>, that time this copyright text', 'nexaq-core'), wp_kses_allowed_html('post')),
		),

	),

));
