<?php
/*-------------------------------------------------------
		  ** Breadcrumbs Options
--------------------------------------------------------*/

CSF::createSection($prefix, array(
	'title'  => esc_html__('Breadcrumb', 'vernex-core'),
	'id'     => 'breadcrumb_options',
	'icon'   => 'fa fa-sliders',
	'fields' => array(
		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('Breadcrumb Options', 'vernex-core') . '</h3>'
		),
		array(
			'id'      => 'breadcrumb_enable',
			'title'   => esc_html__('Enable Breadcrumb', 'vernex-core'),
			'type'    => 'switcher',
			'desc'    => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide breadcrumb', 'vernex-core'), wp_kses_allowed_html('post')),
			'default' => true,
		),

		array(
			'id'         => 'breadcrumb_subtitle_text',
			'type'       => 'text',
			'default'    => esc_html__('What We Work', 'vernex-core'),
			'title'      => esc_html__('Breadcrumb Subtitle', 'vernex-core'),
		),

		array(
			'id'         => 'breadcrumb_background_color',
			'type'       => 'color',
			'title'      => 'Background Color',
			'desc'       => esc_html__('set the banner background color', 'vernex-core'),
			'dependency' => array('breadcrumb_enable', '==', 'true'),
		),
		array(
			'id'      => 'breadcrumb_bg_image',
			'type'    => 'media',
			'title'   => esc_html__('Background Image', 'vernex-core'),
			'desc'    => esc_html__('set the banner background image', 'vernex-core'),
			'default' => array(
				'url'       => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/breadcrumb/breadcrumb-bg.png'),
				'id'        => 'breadcrumb-img',
				'thumbnail' => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/breadcrumb/breadcrumb-bg.png'),
				'alt'       => esc_attr('breadcrumb-img'),
				'title'     => esc_html('Breadcrumb'),
			),
			'dependency' => array('breadcrumb_enable', '==', 'true'),
		),
	)
));
