<?php
/*-------------------------------------------------------
		   ** 404 page options
--------------------------------------------------------*/

CSF::createSection($prefix, array(
	'id'     => '404_page',
	'title'  => esc_html__('404 Page', 'vernex-core'),
	'icon'   => 'fa fa-exclamation-triangle',
	'fields' => array(
		array(
			'type'    => 'subheading',
			'content' => '<h3>' . esc_html__('404 Page Options', 'vernex-core') . '</h3>',
		),
		array(
			'id'      => '404_image',
			'type'    => 'media',
			'title'   => esc_html__('Error Image', 'vernex-core'),
			'library' => 'image',
			'default' => array(
				'url'       => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/error/error-img.webp'),
				'id'        => '404_image',
				'thumbnail' => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/error/error-img.webp'),
				'alt'       => esc_attr('404 image'),
				'title'     => esc_html('404 image'),
			),
		),
		array(
			'id'      => '404_title',
			'title'   => esc_html__('Title', 'vernex-core'),
			'type'    => 'text',
			'info'    => wp_kses(__('you can change <mark>404</mark> text of 404 page', 'vernex-core'), wp_kses_allowed_html('vernex-core')),
			'default' => wp_kses(__("Sorry! We Can't Find That Page.", 'vernex-core'), wp_kses_allowed_html('post')),

		),
		array(
			'id'      => '404_content',
			'title'   => esc_html__('Description', 'vernex-core'),
			'type'    => 'textarea',
			'info'    => wp_kses(__('you can change <mark>Content</mark> text of 404 page', 'vernex-core'), wp_kses_allowed_html('vernex-core')),
			'default' => esc_html__("OPPS! Something went wrong, web page that is displayed to the user when the server cannot find the requested page.", 'vernex-core')
		),
		array(
			'id'      => '404_button_text',
			'title'   => esc_html__('Button Label', 'vernex-core'),
			'type'    => 'text',
			'info'    => wp_kses(__('you can change <mark>button text</mark> of 404 page', 'vernex-core'), wp_kses_allowed_html('vernex-core')),
			'default' => esc_html__('Go Home', 'vernex-core')
		),

	)
));
