<?php

/*-----------------------------------------
	CONTROL CORE CLASSES FOR AVOID ERRORS
------------------------------------------*/
if (class_exists('CSF')) {

    /*-----------------------------------
	    PAGE METABOX SECTION
	------------------------------------*/
    CSF::createMetabox(
        "EGNS_PROPERTIES_META_ID",
        array(
            'id'              => 'properties_meta_option',
            'title'           => esc_html__('Properties Informations', 'vernex-core'),
            'post_type'       => 'properties',
            'context'         => 'normal',
            'priority'        => 'high',
            'show_restore'    => true,
            'enqueue_webfont' => true,
            'async_webfont'   => false,
            'output_css'      => false,
            'nav'             => 'normal',
            'theme'           => 'dark',
        )
    );


    /*-----------------------------------
		REQUIRE META FILES
	------------------------------------*/

    CSF::createSection(
        "EGNS_PROPERTIES_META_ID",
        array(
            'parent' => 'properties_meta_option',
            'title'  => esc_html__('General', 'vernex-core'),
            'fields' => array(

                // A Subheading
                array(
                    'type'    => 'subheading',
                    'content' => esc_html__('Property Information', 'vernex-core'),
                ),
                array(
                    'id'          => 'peoperties_tag_text',
                    'type'        => 'select',
                    'title'       => esc_html__('Tags', 'vernex-core'),
                    'placeholder' => 'Select an option',
                    'options'     => array(
                        'rent'   => 'For Rent',
                        'sell'   => 'For Sale',
                        'others' => "Other's",
                    ),
                    'attributes'  => array(
                        'style' => 'width: 50%;',
                    ),
                    'default' => 'sell',
                ),

                array(
                    'id'      => 'peoperties_regular_price',
                    'type'    => 'text',
                    'title'   => esc_html__('Price', 'vernex-core'),
                    'default' => '$1,50000',
                    'desc'    => wp_kses(__('Add your property price with <b>Local Currency</b> symbol', 'vernex-core'), wp_kses_allowed_html('post')),
                ),
                array(
                    'id'      => 'peoperties_location_title',
                    'type'    => 'text',
                    'title'   => esc_html__('Location Title', 'vernex-core'),
                    'default' => 'Location',
                ),
                array(
                    'id'      => 'peoperties_exact_location',
                    'type'    => 'text',
                    'title'   => esc_html__('Exact Location', 'vernex-core'),
                    'default' => 'Dhaka, Bangladesh',
                ),
                array(
                    'id'      => 'peoperties_location_url',
                    'type'    => 'text',
                    'title'   => esc_html__('Map Location URL', 'vernex-core'),
                    'default' => '#',
                ),

                // A Subheading
                array(
                    'type'    => 'subheading',
                    'content' => esc_html__('Property Gallery & Video', 'vernex-core'),
                ),

                array(
                    'id'     => 'vernex_properties_gallery',
                    'type'   => 'repeater',
                    'title'  => esc_html__('Gallery Images', 'vernex-core'),
                    'fields' => array(
                        array(
                            'id'    => 'vernex_gallery_item',
                            'type'  => 'media',
                            'title' => esc_html__('Image', 'vernex-core'),
                        ),
                    ),
                    'max' => 3,
                ),
                array(
                    'id'      => 'vernex_properties_video_link',
                    'type'    => 'text',
                    'title'   => esc_html__('Video Link', 'vernex-core'),
                    'default' => 'https://www.youtube.com/watch?v=YKtMErhDpm0'
                ),
                array(
                    'id'    => 'vernex_properties_video_poster',
                    'type'  => 'media',
                    'title' => esc_html__('Video Poster Thumbnail', 'vernex-core'),
                ),


            ),
        )
    );

    CSF::createSection(
        "EGNS_PROPERTIES_META_ID",
        array(
            'parent' => 'properties_meta_option',
            'title'  => esc_html__('Properties Short Info', 'vernex-core'),
            'fields' => array(
                array(
                    'id'     => 'properties_short_info_list',
                    'type'   => 'repeater',
                    'max'    => 3,
                    'title'  => esc_html__('properties Info', 'vernex-core'),
                    'fields' => array(

                        array(
                            'id'      => 'properties_short_info_text',
                            'type'    => 'text',
                            'title'   => esc_html__('Info Text', 'vernex-core'),
                            'default' => 'PENT HOUSE',
                        ),

                    ),
                    'default' => array(
                        array(
                            'properties_short_info_text' => 'PENT HOUSE',

                        ),
                    )
                ),
            ),
        )
    );
    CSF::createSection(
        "EGNS_PROPERTIES_META_ID",
        array(
            'parent' => 'properties_meta_option',
            'title'  => esc_html__('Properties Deatils', 'vernex-core'),
            'fields' => array(
                array(
                    'id'     => 'properties_info_list',
                    'type'   => 'repeater',
                    'title'  => esc_html__('properties Details List', 'vernex-core'),
                    'fields' => array(

                        array(
                            'id'    => 'phone_bnr_icoproperties_label_iconn_svg',
                            'type'  => 'media',
                            'title' => 'Icon (SVG)',
                        ),
                        array(
                            'id'      => 'properties_label_text',
                            'type'    => 'text',
                            'title'   => esc_html__('Label', 'vernex-core'),
                            'default' => 'Property ID:',
                        ),
                        array(
                            'id'      => 'properties_content_text',
                            'type'    => 'text',
                            'title'   => esc_html__('Value', 'vernex-core'),
                            'default' => 'A654198',
                        ),
                    ),
                    'default' => array(
                        array(
                            'properties_label_text'   => 'Property ID:',
                            'properties_content_text' => 'A654198'
                        ),
                    )
                ),
            ),
        )
    );

    CSF::createSection(
        "EGNS_PROPERTIES_META_ID",
        array(
            'parent' => 'properties_meta_option',
            'title'  => esc_html__('Select Media Tab', 'vernex-core'),
            'fields' => array(
                array(
                    'id'      => 'peoperties_image_text',
                    'type'    => 'text',
                    'title'   => esc_html__('Photo Text', 'vernex-core'),
                    'default' => 'Photo',
                ),
                array(
                    'id'    => 'peoperties_image_tab',
                    'type'  => 'media',
                    'title' => 'Image',
                ),

                array(
                    'id'      => 'peoperties_video_text',
                    'type'    => 'text',
                    'title'   => esc_html__('Video Text', 'vernex-core'),
                    'default' => 'Video',
                ),
                array(
                    'id'    => 'peoperties_video_image',
                    'type'  => 'media',
                    'title' => 'Video Image',
                ),

                array(
                    'id'    => 'peoperties_video_tab',
                    'type'  => 'link',
                    'title' => 'Video',
                ),

            ),
        )
    );

    CSF::createSection(
        "EGNS_PROPERTIES_META_ID",
        array(
            'parent' => 'properties_meta_option',
            'title'  => esc_html__('Nearby Info', 'vernex-core'),
            'fields' => array(
                array(
                    'id'     => 'properties_nearby_list',
                    'type'   => 'repeater',
                    'title'  => esc_html__('Nearby Info List', 'vernex-core'),
                    'fields' => array(
                        array(
                            'id'      => 'properties_nearby_text',
                            'type'    => 'text',
                            'title'   => esc_html__('Label', 'vernex-core'),
                            'default' => 'School',
                        ),
                        array(
                            'id'      => 'properties_nearby_value_text',
                            'type'    => 'text',
                            'title'   => esc_html__('Value', 'vernex-core'),
                            'default' => '50m',
                        ),
                    ),
                    'default' => array(
                        array(
                            'properties_nearby_text'       => 'School',
                            'properties_nearby_value_text' => '50m'
                        ),
                    )
                ),

            ),
        )
    );

    CSF::createSection(
        "EGNS_PROPERTIES_META_ID",
        array(
            'parent' => 'properties_meta_option',
            'title'  => esc_html__('Properties Attachment', 'vernex-core'),
            'fields' => array(
                array(
                    'id'     => 'properties_attachment_file_list',
                    'type'   => 'repeater',
                    'max'    => 2,
                    'title'  => esc_html__(' Attachment List', 'vernex-core'),
                    'fields' => array(

                        array(
                            'id'      => 'properties_attachment_text',
                            'type'    => 'text',
                            'title'   => esc_html__('Pdf Text', 'vernex-core'),
                            'default' => wp_kses('License <span>pdf</span>', wp_kses_allowed_html('post')),
                        ),

                        array(
                            'id'    => 'properties_attachment_file_tab',
                            'type'  => 'media',
                            'title' => 'Icon',
                        ),

                        array(
                            'id'    => 'properties_attachment_file',
                            'type'  => 'upload',
                            'title' => 'Upload',
                        ),


                    ),

                ),
            ),
        )
    );

    CSF::createSection(
        "EGNS_PROPERTIES_META_ID",
        array(
            'parent' => 'properties_meta_option',
            'title'  => esc_html__('Sidebar Profile Area', 'vernex-core'),
            'fields' => array(

                array(
                    'id'    => 'properties_sidebar_profile_image',
                    'type'  => 'media',
                    'title' => 'Image',
                ),

                array(
                    'id'      => 'properties_sidebar_profile_name',
                    'type'    => 'text',
                    'title'   => esc_html__('Name', 'vernex-core'),
                    'default' => 'William Benjamin',
                ),

                array(
                    'id'      => 'properties_sidebar_profile_designation',
                    'type'    => 'text',
                    'title'   => esc_html__('Designation', 'vernex-core'),
                    'default' => 'Real estate agent',
                ),

                array(
                    'id'      => 'properties_sidebar_profile_contact_text',
                    'type'    => 'text',
                    'title'   => esc_html__('Contact Title', 'vernex-core'),
                    'default' => 'Call Any Time',
                ),
                array(
                    'id'      => 'properties_sidebar_profile_contact_num',
                    'type'    => 'text',
                    'title'   => esc_html__('Contact Number', 'vernex-core'),
                    'default' => '2-965-871-8617',
                ),
                array(
                    'id'    => 'properties_sidebar_profile_contact_num_url',
                    'type'  => 'link',
                    'title' => 'Number Url',
                ),
                array(
                    'id'      => 'properties_sidebar_profile_btn_text',
                    'type'    => 'text',
                    'title'   => esc_html__('Button Text', 'vernex-core'),
                    'default' => 'SEND MESSAGE',
                ),
                array(
                    'id'    => 'properties_sidebar_profile_btn_text_url',
                    'type'  => 'link',
                    'title' => 'Button Url',
                ),
                array(
                    'id'    => 'properties_sidebar_profile_form_shortcode',
                    'type'  => 'text',
                    'title' => esc_html__('Form Shortcode', 'vernex-core'),

                ),

            ),
        )
    );

    CSF::createSection(
        "EGNS_PROPERTIES_META_ID",
        array(
            'parent' => 'properties_meta_option',
            'title'  => esc_html__('Related Properties Heading', 'vernex-core'),
            'fields' => array(

                array(
                    'id'      => 'properties_related_heading_subtile',
                    'type'    => 'text',
                    'title'   => esc_html__('Sub Title', 'vernex-core'),
                    'default' => 'Building Trust Since 2005',
                ),

                array(
                    'id'      => 'properties_related_heading_title',
                    'type'    => 'text',
                    'title'   => esc_html__('Title', 'vernex-core'),
                    'default' => 'Related Property',
                ),

            ),
        )
    );
}
