<?php

/*-----------------------------------------
	CONTROL CORE CLASSES FOR AVOID ERRORS
------------------------------------------*/
if (class_exists('CSF')) {

    /*-----------------------------------
	    PAGE METABOX SECTION
	------------------------------------*/
    CSF::createMetabox(
        "EGNS_PROJECT_META_ID",
        array(
            'id'              => 'project_meta_option',
            'title'           => esc_html__('Project Informations', 'vernex-core'),
            'post_type'       => 'project',
            'context'         => 'normal',
            'priority'        => 'high',
            'show_restore'    => true,
            'enqueue_webfont' => true,
            'async_webfont'   => false,
            'output_css'      => false,
            'nav'             => 'normal',
            'theme'           => 'dark',
        )
    );


    /*-----------------------------------
		REQUIRE META FILES
	------------------------------------*/

    CSF::createSection(
        "EGNS_PROJECT_META_ID",
        array(
            'parent' => 'project_meta_option',
            'title'           => esc_html__('Project Info', 'vernex-core'),
            'fields' => array(
                array(
                    'id'     => 'project_info_list',
                    'type'   => 'repeater',
                    'title'  => esc_html__('Project Info List', 'vernex-core'),
                    'fields' => array(
                        array(
                            'id'    => 'project_label_text',
                            'type'  => 'text',
                            'title' => esc_html__('Label', 'vernex-core'),
                            'default' => 'Location:',
                        ),
                        array(
                            'id'    => 'project_content_text',
                            'type'  => 'text',
                            'title' => esc_html__('Content', 'vernex-core'),
                            'default' => '7 Lake Street, London',
                        ),
                    ),
                    'default' => array(
                        array(
                            'project_label_text' => 'Client:',
                            'project_content_text' => 'Egens Lab'
                        ),
                    )
                ),
            ),
        )
    );
    CSF::createSection(
        "EGNS_PROJECT_META_ID",
        array(
            'parent' => 'project_meta_option',
            'title'           => esc_html__('Sidebar Banner', 'vernex-core'),
            'fields' => array(
                array(
                    'id'      => 'project_sidebar_banner_enable',
                    'title'   => esc_html__('Enable/Disable', 'vernex-core'),
                    'type'    => 'switcher',
                    'desc'    => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable Banner area', 'vernex-core'), wp_kses_allowed_html('post')),
                    'default' => true,
                ),
                array(
                    'id'      => 'project_sidebar_banner_image',
                    'type'    => 'media',
                    'title'   => 'Banner Image',
                    'library' => 'image',
                ),
                array(
                    'id'    => 'project_sidebar_banner_title_text',
                    'type'  => 'text',
                    'title' => esc_html__('Title', 'vernex-core'),
                    'default' => wp_kses('Ready to <span>work with us?</span>', wp_kses_allowed_html('post')),
                ),

                array(
                    'id'    => 'project_sidebar_banner_button_link',
                    'type'  => 'link',
                    'title' => esc_html__('Button Link', 'vernex-core'),
                ),
                array(
                    'id'    => 'project_sidebar_banner_button_text',
                    'type'  => 'text',
                    'title' => esc_html__('Button Text', 'vernex-core'),
                    'default' => 'Get a QUOTE',
                ),

            ),
        )
    );
}
