<?php
// Control core classes for avoid errors
if (class_exists('CSF')) {

    $prefix = 'egns_taxonomy_cat';

    // Create taxonomy options
    CSF::createTaxonomyOptions($prefix, array(
        'title'     => 'Text',
        'taxonomy'  => 'category',
        'data_type' => 'serialize',   // The type of the database save options. `serialize` or `unserialize`
    ));


    // Create a section
    CSF::createSection($prefix, array(
        'fields' => array(

            array(
                'id'      => 'post_category_logo',
                'type'    => 'media',
                'title'   => esc_html__('Upload Category Logo', 'vernex-core'),
                'desc'    => esc_html__('Category logo', 'vernex-core'),
                'library' => 'image',
            ),

            array(
                'id'      => 'post_category_thumb',
                'type'    => 'media',
                'title'   => esc_html__('Upload Category thumb', 'vernex-core'),
                'desc'    => esc_html__('Upload thumbnail', 'vernex-core'),
                'library' => 'image',
            ),

        )
    ));
}
