<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Why_Choose_Us_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_why_choose_us';
    }

    public function get_title()
    {
        return esc_html__('EG Why Choose Us', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_why_choose_us_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_genaral_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),
                    'style_three' => esc_html__('Style Three', 'vernex-core'),

                ],
                'default' => 'style_one',
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_genaral_header_subtitle',
            [
                'label'       => esc_html__('Header Subtitle', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Why Choose Us', 'vernex-core'),
                'placeholder' => esc_html__('write your subtitle here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_why_choose_us_section_genaral_style_selection' => ['style_one', 'style_two'],
                ]
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_genaral_header_title',
            [
                'label'       => esc_html__('Header Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Building Your Dreams.', 'vernex-core'),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_why_choose_us_section_genaral_style_selection' => ['style_one', 'style_two'],
                ]
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_genaral_style_three_header_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Why Choose <br> Vernex <span></span>', wp_kses_allowed_html('post')),
                'label_block' => true,
                'placeholder' => esc_html__('Type your title here', 'vernex-core'),
                'condition' => [
                    'vernex_why_choose_us_section_genaral_style_selection' => ['style_three']
                ],

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_genaral_header_description',
            [
                'label'       => esc_html__('Header Description', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default'     => esc_html__('We understand your needs and delivery digitaloi marketing through unique selling oneto homeles proposition Our team of expert.', 'vernex-core'),
                'placeholder' => esc_html__('write your description here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_why_choose_us_section_genaral_style_selection' => ['style_one', 'style_two'],
                ]
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_genaral_content_title',
            [
                'label'       => esc_html__('Content Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('SINCE 1962', 'vernex-core'),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_why_choose_us_section_genaral_style_selection' => 'style_one'
                ]
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_genaral_content_description',
            [
                'label'       => esc_html__('Content Description', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default'     => esc_html__('Sed Nissl eros, condominium nec risussit abet finibus cons sem fused. Advantage of these limited-time offers & start. Here are various categories that can be featured on a construction website to cover different aspects and specialties within the industry.', 'vernex-core'),
                'placeholder' => esc_html__('write your description here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_why_choose_us_section_genaral_style_selection' => 'style_one'
                ]
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_genaral_content_button',
            [
                'label'       => esc_html__('Button Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('About Us More', 'vernex-core'),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_genaral_content_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_genaral_content_video_button_text',
            [
                'label'       => esc_html__('Video Button Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('SEE SUCCESS STORY', 'vernex-core'),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_why_choose_us_section_genaral_style_selection' => 'style_two'
                ]
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_genaral_content_video_button_url',
            [
                'label' => esc_html__('Video URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
                'condition' => [
                    'vernex_why_choose_us_section_genaral_style_selection' => 'style_two'
                ]
            ]
        );

        // Repeater
        $repeater = new \Elementor\Repeater();

        // accordion title
        $repeater->add_control(
            'vernex_why_choose_us_section_genaral_counter_number',
            [
                'label' => esc_html__('Counter Number', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('130'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your counter number here', 'vernex-core'),
            ]
        );

        $repeater->add_control(
            'vernex_why_choose_us_section_genaral_counter_show_sign',
            [
                'label' => esc_html__("Show Sign?", 'vernex-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vernex-core'),
                'label_off' => esc_html__('No', 'vernex-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        // accordion Description
        $repeater->add_control(
            'vernex_why_choose_us_section_genaral_counter_title',
            [
                'label' => esc_html__('Counter Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Project Completed'),
                'placeholder' => esc_html__('Type your counter title here', 'vernex-core'),
            ]
        );


        $this->add_control(
            'vernex_why_choose_us_section_genaral_counter_list',
            [
                'label' => esc_html__('Counter List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'vernex_why_choose_us_section_genaral_counter_number' => esc_html('130'),
                        'vernex_why_choose_us_section_genaral_counter_title' => esc_html('Project Completed'),

                    ],
                    [
                        'vernex_why_choose_us_section_genaral_counter_number' => esc_html('5'),
                        'vernex_why_choose_us_section_genaral_counter_title' => esc_html('Winning Award'),

                    ],
                    [
                        'vernex_why_choose_us_section_genaral_counter_number' => esc_html('1'),
                        'vernex_why_choose_us_section_genaral_counter_title' => esc_html('Awesome Client'),

                    ],

                ],
                'title_field' => '{{{ vernex_why_choose_us_section_genaral_counter_number }}}',
                'condition' => [
                    'vernex_why_choose_us_section_genaral_style_selection' => 'style_one'
                ]

            ]
        );

        $choose_three = new \Elementor\Repeater();

        $choose_three->add_control(
            'vernex_why_choose_us_section_genaral_style_three_icon',
            [
                'label'     => esc_html__('Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => []
            ]
        );


        $choose_three->add_control(
            'vernex_why_choose_us_section_genaral_style_three_title',
            [
                'label'     => esc_html__('Service Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Residential'),
                'label_block' => true,
            ]
        );

        $choose_three->add_control(
            'vernex_why_choose_us_section_genaral_style_three_description',
            [
                'label'     => esc_html__('Service Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html('Conduct a thoroug need effortless assessment the understand your current marketing.'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_genaral_style_three_list',
            [
                'label'     => esc_html__('Why Choose Us List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $choose_three->get_controls(),
                'default'   => [
                    [
                        'vernex_why_choose_us_section_genaral_style_three_title'    => wp_kses('5 Years in Business', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_why_choose_us_section_genaral_style_three_title'    => wp_kses('Licensed & Insured', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_why_choose_us_section_genaral_style_three_title'    => wp_kses('Service Warranty', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_why_choose_us_section_genaral_style_three_title'    => wp_kses('Competitive Bids', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_why_choose_us_section_genaral_style_three_title'    => wp_kses('No Hidden Charges', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_why_choose_us_section_genaral_style_three_title'    => wp_kses('On-Time & On-Budget', wp_kses_allowed_html('post')),

                    ],
                ],
                'title_field'    => '{{{ vernex_why_choose_us_section_genaral_style_three_title }}}',
                'condition' => [
                    'vernex_why_choose_us_section_genaral_style_selection' => 'style_three',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_genaral_style_one_background_image',
            [
                'label' => esc_html__('Background Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'vernex_why_choose_us_section_genaral_style_selection' => 'style_one'
                ]
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_genaral_style_one_banner_image',
            [
                'label' => esc_html__('Banner Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'vernex_why_choose_us_section_genaral_style_selection' => 'style_two'
                ]
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_why_choose_us_section_style_one_genaral',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_why_choose_us_section_genaral_style_selection' => ['style_one'],
                ]
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_subtitle',
            [
                'label'     => esc_html__('Header Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_why_choose_us_section_style_one_genaral_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_title',
            [
                'label'     => esc_html__('Header Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_why_choose_us_section_style_one_genaral_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_description',
            [
                'label'     => esc_html__('Header Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_why_choose_us_section_style_one_genaral_description_typ',
                'selector' => '{{WRAPPER}} .section-title p',

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_content_title',
            [
                'label'     => esc_html__('Content Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_why_choose_us_section_style_one_genaral_content_title_typ',
                'selector' => '{{WRAPPER}} .why-choose-us-content h5',

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_content_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .why-choose-us-content h5' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_content_description',
            [
                'label'     => esc_html__('Content Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_why_choose_us_section_style_one_genaral_content_description_typ',
                'selector' => '{{WRAPPER}} .home1-why-choose-us-section .why-choose-us-content-wrap .why-choose-us-content p',

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_content_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-why-choose-us-section .why-choose-us-content-wrap .why-choose-us-content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_content_button',
            [
                'label'     => esc_html__('Content Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_why_choose_us_section_style_one_genaral_content_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn',

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_content_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_content_button_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );


        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_content_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_content_button_hover_icon_color',
            [
                'label'     => esc_html__('Hover Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_counter_number',
            [
                'label'     => esc_html__('Counter Number', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_why_choose_us_section_style_one_genaral_counter_number_typ',
                'selector' => '{{WRAPPER}} .home1-why-choose-us-section .why-choose-counter-area .counter-list .single-counter .number h2',

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_counter_number_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-why-choose-us-section .why-choose-counter-area .counter-list .single-counter .number h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_counter_title',
            [
                'label'     => esc_html__('Counter Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_why_choose_us_section_style_one_genaral_counter_title_typ',
                'selector' => '{{WRAPPER}} .home1-why-choose-us-section .why-choose-counter-area .counter-list .single-counter .content p',

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_one_genaral_counter_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-why-choose-us-section .why-choose-counter-area .counter-list .single-counter .content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_why_choose_us_section_style_two_genaral',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_why_choose_us_section_genaral_style_selection' => ['style_two'],
                ]
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_why_choose_us_section_style_two_genaral_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_subtitle_after_color',
            [
                'label'     => esc_html__('After Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_why_choose_us_section_style_two_genaral_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_description',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_why_choose_us_section_style_two_genaral_description_typ',
                'selector' => '{{WRAPPER}} .section-title p',

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_description_button_one',
            [
                'label'     => esc_html__('Button One', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_why_choose_us_section_style_two_genaral_description_button_one_typ',
                'selector' => '{{WRAPPER}} .primary-btn2 span',

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_description_button_one_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_description_button_one_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_description_button_one_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_description_button_one_icon_after_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_description_button_one_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_description_button_two',
            [
                'label'     => esc_html__('Button Two', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_why_choose_us_section_style_two_genaral_description_button_two_typ',
                'selector' => '{{WRAPPER}} .home3-why-choose-section .why-choose-content .btn-and-video-area .video-area h6',

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_description_button_two_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-why-choose-section .why-choose-content .btn-and-video-area .video-area h6' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_description_button_two_video_icon_color_one',
            [
                'label'     => esc_html__('Icon Color One', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-why-choose-section .why-choose-content .btn-and-video-area .video-area .icon .video-circle' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_two_genaral_description_button_two_video_icon_color_two',
            [
                'label'     => esc_html__('Icon Color Two', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-why-choose-section .why-choose-content .btn-and-video-area .video-area .icon .play-icon' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_why_choose_us_section_style_three_genaral',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_why_choose_us_section_genaral_style_selection' => ['style_three'],
                ]
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_three_genaral_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_why_choose_us_section_style_three_genaral_title_typ',
                'selector' => '{{WRAPPER}} .section-title2 h2',

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_three_genaral_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title2 h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_three_genaral_content_title',
            [
                'label'     => esc_html__('Content Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_why_choose_us_section_style_three_genaral_content_title_typ',
                'selector' => '{{WRAPPER}} .home4-why-choose-section .single-content h4',

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_three_genaral_content_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-why-choose-section .single-content h4' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_three_genaral_content_description',
            [
                'label'     => esc_html__('Content Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_why_choose_us_section_style_three_genaral_content_description_typ',
                'selector' => '{{WRAPPER}} .home4-why-choose-section .single-content p',

            ]
        );

        $this->add_control(
            'vernex_why_choose_us_section_style_three_genaral_content_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-why-choose-section .single-content p' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $counters = $settings['vernex_why_choose_us_section_genaral_counter_list'];
        $choose_three = $settings['vernex_why_choose_us_section_genaral_style_three_list'];
?>

        <?php if ($settings['vernex_why_choose_us_section_genaral_style_selection'] == 'style_one') : ?>
            <div class="home1-why-choose-us-section">
                <div class="container">
                    <div class="row gy-5 align-items-center justify-content-between">
                        <div class="col-xl-4 col-lg-5 col-md-7">
                            <div class="why-choose-us-content-wrap">
                                <div class="section-title wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                    <?php if (!empty($settings['vernex_why_choose_us_section_genaral_header_subtitle'])) : ?>
                                        <span><?php echo esc_html($settings['vernex_why_choose_us_section_genaral_header_subtitle']); ?></span>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_why_choose_us_section_genaral_header_title'])) : ?>
                                        <h2><?php echo esc_html($settings['vernex_why_choose_us_section_genaral_header_title']); ?></h2>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_why_choose_us_section_genaral_header_description'])) : ?>
                                        <p><?php echo esc_html($settings['vernex_why_choose_us_section_genaral_header_description']); ?></p>
                                    <?php endif; ?>
                                </div>
                                <div class="why-choose-us-content">
                                    <?php if (!empty($settings['vernex_why_choose_us_section_genaral_content_title'])) : ?>
                                        <h5><?php echo esc_html($settings['vernex_why_choose_us_section_genaral_content_title']); ?></h5>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_why_choose_us_section_genaral_content_description'])) : ?>
                                        <p><?php echo esc_html($settings['vernex_why_choose_us_section_genaral_content_description']); ?></p>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_why_choose_us_section_genaral_content_button'])) : ?>
                                        <a href="<?php echo esc_url($settings['vernex_why_choose_us_section_genaral_content_button_url']['url']); ?>" class="primary-btn">
                                            <?php echo esc_html($settings['vernex_why_choose_us_section_genaral_content_button']); ?>
                                            <svg viewBox="0 0 13 20">
                                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                            </svg>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-2 col-lg-3 col-md-4 wow animate fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="why-choose-counter-area">
                                <ul class="counter-list">
                                    <?php foreach ($counters as $counter) : ?>
                                        <li class="single-counter">
                                            <?php if (!empty($counter['vernex_why_choose_us_section_genaral_counter_number'])) : ?>
                                                <div class="number">
                                                    <h2 class="counter"><?php echo esc_html($counter['vernex_why_choose_us_section_genaral_counter_number']); ?></h2>
                                                    <?php if ($counter['vernex_why_choose_us_section_genaral_counter_show_sign'] == 'yes') : ?>
                                                        <span><?php echo esc_html__('K', 'vernex-core'); ?></span>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endif; ?>
                                            <?php if (!empty($counter['vernex_why_choose_us_section_genaral_counter_title'])) : ?>
                                                <div class="content">
                                                    <p><?php echo esc_html($counter['vernex_why_choose_us_section_genaral_counter_title']); ?></p>
                                                </div>
                                            <?php endif; ?>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if (!empty($settings['vernex_why_choose_us_section_genaral_style_one_background_image']['url'])) : ?>
                    <img src="<?php echo esc_url($settings['vernex_why_choose_us_section_genaral_style_one_background_image']['url']); ?>" alt="<?php echo esc_attr__('background-image', 'vernex-core'); ?>" class="bg-img">
                <?php endif; ?>
            </div>
        <?php endif; ?>


        <?php if ($settings['vernex_why_choose_us_section_genaral_style_selection'] == 'style_two') : ?>
            <div class="home3-why-choose-section">
                <div class="container">
                    <div class="row gy-5 align-items-center">
                        <?php if (!empty($settings['vernex_why_choose_us_section_genaral_style_one_banner_image']['url'])) : ?>
                            <div class="col-lg-6 order-lg-1 order-2 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <div class="why-choose-img magnetic-item">
                                    <img src="<?php echo esc_url($settings['vernex_why_choose_us_section_genaral_style_one_banner_image']['url']); ?>" alt="<?php echo esc_attr__('banner-image', 'vernex-core'); ?>">
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="col-lg-6 order-lg-2 order-1 wow animate fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="why-choose-content">
                                <div class="section-title three">
                                    <?php if (!empty($settings['vernex_why_choose_us_section_genaral_header_subtitle'])) : ?>
                                        <span><?php echo esc_html($settings['vernex_why_choose_us_section_genaral_header_subtitle']); ?></span>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_why_choose_us_section_genaral_header_title'])) : ?>
                                        <h2><?php echo esc_html($settings['vernex_why_choose_us_section_genaral_header_title']); ?></h2>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_why_choose_us_section_genaral_header_description'])) : ?>
                                        <p><?php echo esc_html($settings['vernex_why_choose_us_section_genaral_header_description']); ?></p>
                                    <?php endif; ?>
                                </div>
                                <div class="btn-and-video-area">
                                    <?php if (!empty($settings['vernex_why_choose_us_section_genaral_content_button'])) : ?>
                                        <a href="<?php echo esc_url($settings['vernex_why_choose_us_section_genaral_content_button_url']['url']); ?>" class="primary-btn2">
                                            <span>
                                                <?php echo esc_html($settings['vernex_why_choose_us_section_genaral_content_button']); ?>
                                                <svg viewBox="0 0 13 20">
                                                    <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                                </svg>
                                            </span>
                                        </a>
                                    <?php endif; ?>
                                    <a data-fancybox="video-player" href="<?php echo esc_url($settings['vernex_why_choose_us_section_genaral_content_video_button_url']['url']); ?>" class="video-area">
                                        <div class="icon">
                                            <svg class="video-circle" xmlns="http://www.w3.org/2000/svg"
                                                xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="43px"
                                                viewBox="0 0 206 206" style="enable-background:new 0 0 206 206;"
                                                xml:space="preserve">
                                                <circle class="circle" stroke-miterlimit="10" cx="103" cy="103" r="100">
                                                </circle>
                                                <path class="circle-half top-half" stroke-width="4" stroke-miterlimit="10"
                                                    d="M16.4,53C44,5.2,105.2-11.2,153,16.4s64.2,88.8,36.6,136.6"></path>
                                                <path class="circle-half bottom-half" stroke-width="4" stroke-miterlimit="10"
                                                    d="M189.6,153C162,200.8,100.8,217.2,53,189.6S-11.2,100.8,16.4,53">
                                                </path>
                                            </svg>
                                            <svg class="play-icon" width="14" height="16" viewBox="0 0 14 16"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M13.5094 7.92211C13.5094 7.49123 13.2874 7.0944 12.9152 6.86L2.86754 0.538727C2.46113 0.283462 1.96552 0.264813 1.54009 0.490029C1.11599 0.71512 0.862305 1.13058 0.862305 1.60098V14.2425C0.862305 14.7129 1.11597 15.1282 1.54074 15.3535C1.73875 15.4579 1.95113 15.5098 2.16354 15.5098C2.40776 15.5098 2.65036 15.4409 2.8674 15.3048L12.9151 8.98449C13.2874 8.74995 13.5094 8.35313 13.5094 7.92225V7.92211ZM12.5525 8.43653L2.50484 14.7568C2.30763 14.8806 2.06741 14.889 1.86141 14.7808C1.65541 14.6717 1.53211 14.4706 1.53211 14.2424V1.60086C1.53211 1.37266 1.65541 1.17074 1.86141 1.06249C1.95768 1.01224 2.06102 0.986728 2.16368 0.986728C2.2822 0.986728 2.39991 1.02001 2.50498 1.08658L12.5526 7.40785C12.7356 7.52311 12.8405 7.71116 12.8405 7.92304C12.8404 8.13414 12.7355 8.32129 12.5525 8.43653Z" />
                                            </svg>
                                        </div>
                                        <?php if (!empty($settings['vernex_why_choose_us_section_genaral_content_video_button_text'])) : ?>
                                            <h6><?php echo esc_html($settings['vernex_why_choose_us_section_genaral_content_video_button_text']); ?></h6>
                                        <?php endif; ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_why_choose_us_section_genaral_style_selection'] == 'style_three') : ?>
            <div class="home4-why-choose-section">
                <div class="container">
                    <?php if (!empty($settings['vernex_why_choose_us_section_genaral_style_three_header_title'])) : ?>
                        <div class="row mb-70 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="col-lg-12 d-flex justify-content-center">
                                <div class="section-title2">
                                    <h2><?php echo wp_kses($settings['vernex_why_choose_us_section_genaral_style_three_header_title'], wp_kses_allowed_html('post')); ?></h2>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="row justify-content-end">
                        <div class="col-xl-11">
                            <div class="row gy-md-5 gy-4">

                                <?php $classes = array('divider', 'd-flex justify-content-lg-center divider', 'd-flex justify-content-lg-center', 'divider', 'd-flex justify-content-lg-center divider', 'd-flex justify-content-lg-center');
                                $class_count = count($classes);
                                foreach ($choose_three as $index => $choose) :
                                    $class = $classes[$index % $class_count];
                                ?>
                                    <div class="col-lg-4 col-md-6 <?php echo $class; ?> wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                        <div class="single-content border-btm">
                                            <?php if (!empty($choose['vernex_why_choose_us_section_genaral_style_three_icon'])) : ?>
                                                <div class="icon">
                                                    <?php \Elementor\Icons_Manager::render_icon($choose['vernex_why_choose_us_section_genaral_style_three_icon']); ?>
                                                </div>
                                            <?php endif; ?>
                                            <?php if (!empty($choose['vernex_why_choose_us_section_genaral_style_three_title'])) : ?>
                                                <h4>
                                                    <?php echo esc_html($choose['vernex_why_choose_us_section_genaral_style_three_title']); ?>
                                                </h4>
                                            <?php endif; ?>

                                            <?php if (!empty($choose['vernex_why_choose_us_section_genaral_style_three_description'])) : ?>
                                                <p><?php echo esc_html($choose['vernex_why_choose_us_section_genaral_style_three_description']); ?></p>
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>


<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Why_Choose_Us_Widget());
