<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Title_H2_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_title_h2';
    }

    public function get_title()
    {
        return esc_html__('EG Title H2', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_title_h2_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_title_h2_section_genaral_subtitle',
            [
                'label'       => esc_html__('Subtitle', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Your subtitle', 'vernex-core'),
                'placeholder' => esc_html__('Write your subtitle here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_title_h2_section_genaral_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Real Estate Agent Of The Year.', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        // style start
        $this->start_controls_section(
            'vernex_title_h2_style_one_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_title_h2_style_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_title_h2_style_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title.two span',

            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'label'     => esc_html__( 'Background Color', 'vernex-core' ),
                'name'      => 'vernex_title_h2_style_general_subtitle_bg',
                'selector' => '{{WRAPPER}} .section-title.two span',
            ]
        );

        $this->add_control(
            'vernex_title_h2_style_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.two span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_title_h2_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_title_h2_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_title_h2_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
?>
    <div class="section-title two">
        <?php if( !empty( $settings['vernex_title_h2_section_genaral_subtitle'] ) ): ?>
            <span><?php echo esc_html( $settings['vernex_title_h2_section_genaral_subtitle'] ); ?></span>
        <?php endif; ?>
        <h2><?php echo esc_html( $settings['vernex_title_h2_section_genaral_title'] ); ?></h2>
    </div>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Title_H2_Widget());
