<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Vernex_Testimonial_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_testimonial';
    }

    public function get_title()
    {
        return esc_html__('EG Testimonial ', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        //Content One
        $this->start_controls_section(
            'vernex_testimonial_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),
                    'style_three' => esc_html__('Style Three', 'vernex-core'),
                    'style_four' => esc_html__('Style Four', 'vernex-core'),
                    'style_five' => esc_html__('Style Five', 'vernex-core'),
                    'style_six' => esc_html__('Style Six', 'vernex-core'),

                ],
                'default' => 'style_one',
            ]
        );
        $this->end_controls_section();

        //Content One
        $this->start_controls_section(
            'vernex_testimonial_genaral_sec',
            [
                'label' => esc_html__('Heading ', 'vernex-core'),
                'condition' => [
                    'vernex_testimonial_genaral_style_selection' => 'style_one'
                ]
            ]
        );

        $this->add_control(
            'vernex_testimonial_testimony_general_subtitle',
            [
                'label' => esc_html__('Sub Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Client Testimonials'),
                'placeholder' => esc_html__('Type your sub title here', 'vernex-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'vernex_testimonial_testimony_general_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Saying Clients Story.'),
                'placeholder' => esc_html__('Type your sub title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'vernex_testimonial_genaral_content_sec',
            [
                'label' => esc_html__('Testimony', 'vernex-core'),
                'condition' => [
                    'vernex_testimonial_genaral_style_selection' => 'style_one'
                ]
            ]
        );

        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'vernex_testimonial_testimony_content_sec',
            [
                'label' => esc_html__('Testimony', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Excellent Contracting Team!'),
                'placeholder' => esc_html__('Type your  title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_content',
            [
                'label' => esc_html__('Content', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html('“Feel free to customize the key features based onen the services and strategies you offer in each plan. This breakdown helps various potential clients understand the specific value they will receive at each pricing tier These tools are fundamental for your home and industry factory build”.'),
                'placeholder' => esc_html__('Type your content here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_author_cention',
            [
                'label' => esc_html__('Author Section', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_author_image',
            [
                'label' => esc_html__(' Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_author_name',
            [
                'label' => esc_html__(' Name', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Mr. Daniel Scoot'),
                'placeholder' => esc_html__('Type your author name here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_author_designation',
            [
                'label' => esc_html__('Designation', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('CEO at Softconic'),
                'placeholder' => esc_html__('Type your author designation here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_testimonial_content_list',
            [
                'label' => esc_html__('Testimony List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'vernex_testimonial_testimony_title' => esc_html('Excellent Contracting Team!'),
                    ],
                    [
                        'vernex_testimonial_testimony_title' => esc_html('Excellent Contracting Team!'),
                    ],
                    [
                        'vernex_testimonial_testimony_title' => esc_html('Excellent Contracting Team!'),
                    ],



                ],
                'title_field' => '{{{ vernex_testimonial_testimony_title }}}',
            ]
        );


        $this->add_control(
            'vernex_testimonial_author_grp_photos',
            [
                'label' => esc_html__('Group Photos', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_button_text',
            [
                'label' => esc_html__('Button Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html(' Connect With Us'),
                'placeholder' => esc_html__('Type your button text here', 'vernex-core'),
                'label_block' => true,

            ]
        );


        $this->add_control(
            'vernex_testimonial_button_text_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        //Style Two

        $this->start_controls_section(
            'vernex_testimonial_two_genaral_sec',
            [
                'label' => esc_html__('Review Area ', 'vernex-core'),
                'condition' => [
                    'vernex_testimonial_genaral_style_selection' => 'style_two'
                ]
            ]
        );


        $this->add_control(
            'vernex_testimonial_testimony_two_general_heading',
            [
                'label' => esc_html__('Heading', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_testimonial_testimony_two_general_subtitle',
            [
                'label' => esc_html__('Sub Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Our Customers Rave'),
                'placeholder' => esc_html__('Type your sub title here', 'vernex-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'vernex_testimonial_testimony_two_general_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('What Our Clients Say About Us.'),
                'placeholder' => esc_html__('Type your  title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_testimonial_testimony_two_general_review_area',
            [
                'label' => esc_html__('Review Section', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'vernex_testimonial_testimony_two_general_review_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Review On'),
                'placeholder' => esc_html__('Type your  title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_two_genaral_review_review_seelection',
            [
                'label' => esc_html__('Rating From ?', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'general' => esc_html__('General', 'vernex-core'),
                    'others'  => esc_html__('Others', 'vernex-core'),
                ],
                'default' => 'general',
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_two_genaral_review_review_star',
            [
                'label'         => esc_html__('Rating', 'vernex-core'),
                'type'             => Controls_Manager::NUMBER,
                'min'             => 0,
                'max'             => 5,
                'step'             => 1,
                'default'         => 5,
                'dynamic'         => [
                    'active'     => true,
                ],
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_two_genaral_review_review_logo',
            [
                'label' => esc_html__('Review Logo', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'media_types' => ['svg'],
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_two_genaral_review_total_num_sec',
            [
                'label' => esc_html__(' Total Review', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('50 Reviews'),
                'placeholder' => esc_html__('Type your review number here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_two_genaral_review_link',
            [
                'label' => esc_html__('Review Link', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_testimonial_two_genaral_review_list',
            [
                'label' => esc_html__('Review List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'vernex_testimonial_testimony_two_general_review_title' => esc_html('Review On'),
                    ],
                    [
                        'vernex_testimonial_testimony_two_general_review_title' => esc_html('Review On'),
                    ],

                ],
                'title_field' => '{{{ vernex_testimonial_testimony_two_general_review_title }}}',
            ]
        );

        $this->add_control(
            'vernex_testimonial_testimony_sidebar_btn_two_title',
            [
                'label' => esc_html__('Sidebar Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('“From Real Estate Leaders to Global Research”'),
                'placeholder' => esc_html__('Type your sidebar title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'vernex_testimonial_genaral_two_content_sec',
            [
                'label' => esc_html__('Testimony', 'vernex-core'),
                'condition' => [
                    'vernex_testimonial_genaral_style_selection' => 'style_two'
                ]
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'vernex_testimonial_testimony_two_content_sec',
            [
                'label' => esc_html__('Testimony', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_two_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Excellent Contracting Team!'),
                'placeholder' => esc_html__('Type your  title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_two_content',
            [
                'label' => esc_html__('Content', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html('“Feel free to customize the key features based onen the services and strategies you offer in each plan. This breakdown helps various potential clients understand the specific value they will receive at each pricing tier These tools are fundamental for your home and industry factory build”.'),
                'placeholder' => esc_html__('Type your content here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_author_two_cention',
            [
                'label' => esc_html__('Author Section', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_author_two_image',
            [
                'label' => esc_html__(' Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_author_two_name',
            [
                'label' => esc_html__(' Name', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Mr. Daniel Scoot'),
                'placeholder' => esc_html__('Type your author name here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_author_two_designation',
            [
                'label' => esc_html__('Designation', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('CEO at Softconic'),
                'placeholder' => esc_html__('Type your author designation here', 'vernex-core'),
                'label_block' => true,
            ]
        );


        $this->add_control(
            'vernex_testimonial_content_two_list',
            [
                'label' => esc_html__('Testimony List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'vernex_testimonial_testimony_two_title' => esc_html('Excellent Contracting Team!'),
                    ],
                    [
                        'vernex_testimonial_testimony_two_title' => esc_html('Excellent Contracting Team!'),
                    ],
                    [
                        'vernex_testimonial_testimony_two_title' => esc_html('Excellent Contracting Team!'),
                    ],



                ],
                'title_field' => '{{{ vernex_testimonial_testimony_two_title }}}',
            ]
        );


        $this->add_control(
            'vernex_testimonial_two_author_grp_photos',
            [
                'label' => esc_html__('Group Photos', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_two_button_text',
            [
                'label' => esc_html__('Button Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html(' Connect With Us'),
                'placeholder' => esc_html__('Type your button text here', 'vernex-core'),
                'label_block' => true,

            ]
        );


        $this->add_control(
            'vernex_testimonial_two_button_text_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        //Content Three

        $this->start_controls_section(
            'vernex_testimonial_genaral_content_three_sec',
            [
                'label' => esc_html__('Testimonial Content', 'vernex-core'),
                'condition' => [
                    'vernex_testimonial_genaral_style_selection' => 'style_three'
                ]
            ]
        );

        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'vernex_testimonial_testimony_content_three_sec',
            [
                'label' => esc_html__('Testimony', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_author_three_image',
            [
                'label' => esc_html__(' Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_three_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Great Construction Company!'),
                'placeholder' => esc_html__('Type your  title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_three_content',
            [
                'label' => esc_html__('Content', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html('“Feel free to customize the key features based onen the services and strategies you offer in each plan. This breakdown helps various potential clients understand the specific value they will receive at each pricing tier These essential tools are fundamental for your household and industry factory build”.'),
                'placeholder' => esc_html__('Type your content here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_author_three_cention',
            [
                'label' => esc_html__('Author Section', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $repeater->add_control(
            'vernex_testimonial_author_three_name',
            [
                'label' => esc_html__(' Name', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Mr. Daniel Scoot'),
                'placeholder' => esc_html__('Type your author name here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_author_three_designation',
            [
                'label' => esc_html__('Designation', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('CEO at Softconic'),
                'placeholder' => esc_html__('Type your author designation here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_testimonial_content_three_list',
            [
                'label' => esc_html__('Testimony List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'vernex_testimonial_testimony_three_title' => esc_html('Great Construction Company!'),
                    ],
                    [
                        'vernex_testimonial_testimony_three_title' => esc_html('Great Construction Company!'),
                    ],
                    [
                        'vernex_testimonial_testimony_three_title' => esc_html('Great Construction Company!'),
                    ],



                ],
                'title_field' => '{{{ vernex_testimonial_testimony_three_title }}}',
            ]
        );


        $this->add_control(
            'vernex_testimonial_author_grp_three_photos',
            [
                'label' => esc_html__('Group Photos', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_button_three_text',
            [
                'label' => esc_html__('Button Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html(' Connect With Us'),
                'placeholder' => esc_html__('Type your button text here', 'vernex-core'),
                'label_block' => true,

            ]
        );


        $this->add_control(
            'vernex_testimonial_button_three_text_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        //Content Four

        $this->start_controls_section(
            'vernex_testimonial_genaral_content_four_sec',
            [
                'label' => esc_html__('Testimonial Content', 'vernex-core'),
                'condition' => [
                    'vernex_testimonial_genaral_style_selection' => 'style_four'
                ]
            ]
        );


        $this->add_control(
            'vernex_testimonial_four_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Client Say <br> Smile. <span></span>', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('Type your title here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_testimonial_testimony_content_four_before_after_image_sec',
            [
                'label' => esc_html__('Testimony', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'vernex_testimonial_testimony_content_four_before_image_sec',
            [
                'label' => esc_html__('Before Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_content_four_after_image_sec',
            [
                'label' => esc_html__('After Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_content_four_testimony_area',
            [
                'label' => esc_html__('Testimony Content', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_content_four_testimony_area_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html(' Fantastic Construction Firm!'),
                'placeholder' => esc_html__('Type your title  here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_content_four_testimony_area_desc',
            [
                'label' => esc_html__('Description', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html(' “Feel free to customize the key features based onen the services and strategies you offer in each plan. This breakdown helps various potential clients understand”.'),
                'placeholder' => esc_html__('Type your description here', 'vernex-core'),
                'label_block' => true,

            ]
        );


        $repeater->add_control(
            'vernex_testimonial_testimony_content_four_testimony_author_area',
            [
                'label' => esc_html__('Author Area', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_content_four_testimony_author_area_image',
            [
                'label' => esc_html__('Auhtor Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $repeater->add_control(
            'vernex_testimonial_testimony_content_four_testimony_author_area_name',
            [
                'label' => esc_html__('Name', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html(' Gason Santiago'),
                'placeholder' => esc_html__('Type your author name here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_content_four_testimony_author_area_designation',
            [
                'label' => esc_html__('Designation', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('CEO at NEXAQ'),
                'placeholder' => esc_html__('Type your author designation here', 'vernex-core'),
                'label_block' => true,

            ]
        );


        $this->add_control(
            'vernex_testimonial_testimony_content_four_after_before_image_list',
            [
                'label' => esc_html__('Choose Content List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [

                        [
                            'vernex_testimonial_testimony_content_four_testimony_area_title' => esc_html('Fantastic Construction Firm!'),
                        ],
                    ],
                    [

                        [
                            'vernex_testimonial_testimony_content_four_testimony_area_title' => esc_html('Fantastic Construction Firm!'),
                        ],
                    ],
                ],
                'title_field' => '{{{ vernex_testimonial_testimony_content_four_testimony_area_title }}}',
            ]
        );

        $this->end_controls_section();


        //Content Five

        $this->start_controls_section(
            'vernex_testimonial_genaral_content_five_sec',
            [
                'label' => esc_html__('Testimonial Content', 'vernex-core'),
                'condition' => [
                    'vernex_testimonial_genaral_style_selection' => 'style_five'
                ]
            ]
        );


        $this->add_control(
            'vernex_testimonial_testimony_content_five_banner_image_sec',
            [
                'label' => esc_html__('Banner Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_testimony_content_five_testimony_area',
            [
                'label' => esc_html__('Testimony', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'vernex_testimonial_testimony_content_five_testimony_area_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html(' Fantastic Construction Firm!'),
                'placeholder' => esc_html__('Type your title here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_content_five_testimony_area_desc',
            [
                'label' => esc_html__('Description', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html(' “Feel free to customize the key features based onen the services and strategies you offer in each plan. This breakdown helps various potential clients understand”.'),
                'placeholder' => esc_html__('Type your description here', 'vernex-core'),
                'label_block' => true,

            ]
        );


        $repeater->add_control(
            'vernex_testimonial_testimony_content_five_testimony_author_area',
            [
                'label' => esc_html__('Author Area', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_content_five_testimony_author_area_image',
            [
                'label' => esc_html__('Auhtor Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $repeater->add_control(
            'vernex_testimonial_testimony_content_five_testimony_author_area_name',
            [
                'label' => esc_html__('Name', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html(' Gason Santiago'),
                'placeholder' => esc_html__('Type your author name here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_content_five_testimony_author_area_designation',
            [
                'label' => esc_html__('Designation', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('CEO at NEXAQ'),
                'placeholder' => esc_html__('Type your author designation here', 'vernex-core'),
                'label_block' => true,

            ]
        );


        $this->add_control(
            'vernex_testimonial_testimony_content_five_after_content_list',
            [
                'label' => esc_html__('Content List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [

                        [
                            'vernex_testimonial_testimony_content_five_testimony_area_title' => esc_html('Fantastic Construction Firm!'),
                        ],
                        [
                            'vernex_testimonial_testimony_content_five_testimony_area_title' => esc_html('Fantastic Construction Firm!'),
                        ],
                        [
                            'vernex_testimonial_testimony_content_five_testimony_area_title' => esc_html('Fantastic Construction Firm!'),
                        ],
                    ],

                ],
                'title_field' => '{{{ vernex_testimonial_testimony_content_five_testimony_area_title }}}',

            ]
        );


        $this->add_control(
            'vernex_testimonial_testimony_content_five_logo_area',
            [
                'label' => esc_html__('Logo Area', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_testimonial_testimony_content_five_logo_area_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html(' A partner, Not A Vendor:'),
                'placeholder' => esc_html__('Type your title here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'vernex_testimonial_testimony_content_five_logo_area_logo',
            [
                'label' => esc_html__('Logo', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_content_five_logo_area_logo_url',
            [
                'label' => esc_html__('Logo URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'vernex_testimonial_testimony_content_five_logo_area_logo_list',
            [
                'label' => esc_html__('Logo List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                         
                        'vernex_testimonial_testimony_content_five_logo_area_logo' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(), // Set the default logo here
                        ],
                    ],
                    [
                        
                        'vernex_testimonial_testimony_content_five_logo_area_logo' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(), // Set the default logo here
                        ],
                    ],
                    [
                        
                        'vernex_testimonial_testimony_content_five_logo_area_logo' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(), // Set the default logo here
                        ],
                    ],
                ],
            
            ]
        );
        


        $this->end_controls_section();


        //Style Six

        $this->start_controls_section(
            'vernex_testimonial_six_genaral_sec',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'condition' => [
                    'vernex_testimonial_genaral_style_selection' => 'style_six'
                ]
            ]
        );

        $this->add_control(
            'vernex_testimonial_testimony_six_general_heading',
            [
                'label' => esc_html__('Heading', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_testimonial_testimony_six_general_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('See how we have transformed spaces.'),
                'placeholder' => esc_html__('Type your  title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_testimonial_testimony_six_general_content',
            [
                'label' => esc_html__('Content', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html('We understand your needs and deliver digital marketing through unique selling One proposition. Our team of experts is passionate about helping you.'),
                'placeholder' => esc_html__('Type your  content here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_testimonial_testimony_six_general_review_area',
            [
                'label' => esc_html__('Review Area', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'vernex_testimonial_six_genaral_review_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Review On'),
                'placeholder' => esc_html__('Type your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_six_genaral_review_review_seelection',
            [
                'label' => esc_html__('Rating From ?', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'general' => esc_html__('General', 'vernex-core'),
                    'others'  => esc_html__('Others', 'vernex-core'),
                ],
                'default' => 'general',
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_six_genaral_review_review_star',
            [
                'label'         => esc_html__('Rating', 'vernex-core'),
                'type'             => Controls_Manager::NUMBER,
                'min'             => 0,
                'max'             => 5,
                'step'             => 1,
                'default'         => 5,
                'dynamic'         => [
                    'active'     => true,
                ],
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_six_genaral_review_review_logo',
            [
                'label' => esc_html__('Review Logo', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'media_types' => ['svg'],
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_six_genaral_review_total_num_sec',
            [
                'label' => esc_html__(' Total Review', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('50 Reviews'),
                'placeholder' => esc_html__('Type your review number here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_six_genaral_review_link',
            [
                'label' => esc_html__('Review Link', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_testimonial_six_genaral_content_list',
            [
                'label' => esc_html__('Review List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [

                        [
                            'vernex_testimonial_six_genaral_review_title' => esc_html('Review On'),
                        ],
                        [
                            'vernex_testimonial_six_genaral_review_title' => esc_html('Review On'),
                        ],
                    ],

                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_six_author_grp_photos',
            [
                'label' => esc_html__('Group Photos', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_six_button_text',
            [
                'label' => esc_html__('Button Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html(' Connect With Us'),
                'placeholder' => esc_html__('Type your button text here', 'vernex-core'),
                'label_block' => true,

            ]
        );


        $this->add_control(
            'vernex_testimonial_six_button_text_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'vernex_testimonial_genaral_six_content_sec',
            [
                'label' => esc_html__('Testimony', 'vernex-core'),
                'condition' => [
                    'vernex_testimonial_genaral_style_selection' => 'style_six'
                ]
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'vernex_testimonial_testimony_six_content_sec',
            [
                'label' => esc_html__('Testimony', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_six_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Excellent Contracting Team!'),
                'placeholder' => esc_html__('Type your  title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_testimony_six_content',
            [
                'label' => esc_html__('Content', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html('“Feel free to customize the key features based onen the services and strategies you offer in each plan. This breakdown helps various potential clients understand the specific value they will receive at each pricing tier These tools are fundamental for your home and industry factory build”.'),
                'placeholder' => esc_html__('Type your content here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_author_six_cention',
            [
                'label' => esc_html__('Author Section', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_author_six_image',
            [
                'label' => esc_html__('Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_author_six_name',
            [
                'label' => esc_html__(' Name', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Mr. Daniel Scoot'),
                'placeholder' => esc_html__('Type your author name here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_testimonial_author_six_designation',
            [
                'label' => esc_html__('Designation', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('CEO at Softconic'),
                'placeholder' => esc_html__('Type your author designation here', 'vernex-core'),
                'label_block' => true,
            ]
        );


        $this->add_control(
            'vernex_testimonial_content_six_list',
            [
                'label' => esc_html__('Testimony List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'vernex_testimonial_testimony_six_title' => esc_html('Excellent Contracting Team!'),
                    ],
                    [
                        'vernex_testimonial_testimony_six_title' => esc_html('Excellent Contracting Team!'),
                    ],
                    [
                        'vernex_testimonial_testimony_six_title' => esc_html('Excellent Contracting Team!'),
                    ],

                ],
                'title_field' => '{{{ vernex_testimonial_testimony_six_title }}}',
            ]
        );

        $this->end_controls_section();

        // ==================Style One ==================//

        //General Section

        $this->start_controls_section(
            'vernex_testimonial_genaral_sec_style_sec',
            [
                'label' => esc_html__('General  ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_testimonial_genaral_style_selection' => 'style_one'
                ]
            ]
        );


        $this->add_control(
            'vernex_testimonial_genaral_sec_style_sec_bac_color',
            [
                'label'     => esc_html__('Backgound Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-testimonial-section ' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vernex_testimonial_genaral_sec_style_sec_sec_margin',
            [
                'label' => esc_html__('Margin', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .home1-testimonial-section ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vernex_testimonial_genaral_sec_style_sec_padding',
            [
                'label'      => esc_html__('Padding', 'vernex-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .home1-testimonial-section ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'vernex_testimonial_genaral_sec_style',
            [
                'label' => esc_html__('Testimonial Style', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_testimonial_genaral_style_selection' => 'style_one'
                ]
            ]
        );


        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_heading',
            [
                'label' => esc_html__('Heading', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_subtitle',
            [
                'label' => esc_html__(' Sub Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_style_testimonial_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_title',
            [
                'label' => esc_html__(' Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_style_testimonial_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );



        //Content
        $this->add_control(
            'vernex_testimonial_genaral_sec_content_style',
            [
                'label' => esc_html__(' Testimonial Content', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_control(
            'vernex_testimonial_genaral_sec_title_desc_style',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_title_desc_style_typ',
                'selector' => '{{WRAPPER}} .testimonial-card .testimonial-content > span',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_title_desc_style_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content > span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_content_desc_style',
            [
                'label' => esc_html__('  Content', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_content_desc_style_typ',
                'selector' => '{{WRAPPER}} .testimonial-card .testimonial-content p',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_content_desc_style_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content p' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );
        //Author Image SIze
        $this->add_control(
            'vernex_testimonial_genaral_sec_author_image_style',
            [
                'label' => esc_html__(' Author Image Size', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_author_image_style_size_style',
            [
                'label' => esc_html__('Image Size', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-author-img img' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        //Author Name
        $this->add_control(
            'vernex_testimonial_genaral_sec_author_name_style',
            [
                'label' => esc_html__(' Author Name', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_author_name_style_typ',
                'selector' => '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content h5',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_author_name_style_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content h5' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vernex_testimonial_genaral_sec_author_name_style_margin',
            [
                'label' => esc_html__('Margin', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vernex_testimonial_genaral_sec_author_name_style_padding',
            [
                'label'      => esc_html__('Padding', 'vernex-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        //Author Designation
        $this->add_control(
            'vernex_testimonial_genaral_sec_author_designation_style',
            [
                'label' => esc_html__(' Author Designation', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_author_designation_style_typ',
                'selector' => '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content span',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_author_designation_style_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vernex_testimonial_genaral_sec_author_designation_style_margin',
            [
                'label' => esc_html__('Margin', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vernex_testimonial_genaral_sec_author_designation_style_padding',
            [
                'label'      => esc_html__('Padding', 'vernex-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        //Button
        $this->add_control(
            'vernex_testimonial_genaral_sec_btn_style',
            [
                'label' => esc_html__('Button', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_btn_style_typ',
                'selector' => '{{WRAPPER}} .primary-btn',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_btn_style_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => '-webkit-text-fill-color: {{VALUE}};',
                    '{{WRAPPER}} .primary-btn svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();

        // ==================Style Two ==================//

        //General Section

        $this->start_controls_section(
            'vernex_testimonial_genaral_sec_two_style_sec',
            [
                'label' => esc_html__('General  ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_testimonial_genaral_style_selection' => 'style_two'
                ]
            ]
        );


        $this->add_control(
            'vernex_testimonial_genaral_sec_style_two_sec_bac_color',
            [
                'label'     => esc_html__('Backgound Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-testimonial-section ' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vernex_testimonial_genaral_sec_style_sec_two_sec_margin',
            [
                'label' => esc_html__('Margin', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .home2-testimonial-section ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vernex_testimonial_genaral_sec_style_sec_two_padding',
            [
                'label'      => esc_html__('Padding', 'vernex-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .home2-testimonial-section ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_section();

        //Style Two
        $this->start_controls_section(
            'vernex_testimonial_genaral_two_sec_style',
            [
                'label' => esc_html__('Testimonial Style', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_testimonial_genaral_style_selection' => 'style_two'
                ]
            ]
        );


        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_two_heading',
            [
                'label' => esc_html__('Heading', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_two_subtitle',
            [
                'label' => esc_html__(' Sub Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_style_testimonial_two_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title.two span',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_two_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.two span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_two_subtitle_bac_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.two span' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_two_title',
            [
                'label' => esc_html__(' Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_style_testimonial_title_two_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_title_two_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_two_review_area',
            [
                'label' => esc_html__('Review Area', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_two_review_title_area',
            [
                'label' => esc_html__('Title ', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_style_testimonial_two_review_area_title_typ',
                'selector' => '{{WRAPPER}} .home2-testimonial-section .testimonial-left-content .rating-area > li .single-rating .review span',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_two_review_area_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-testimonial-section .testimonial-left-content .rating-area > li .single-rating .review span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_two_review_area_total_review',
            [
                'label' => esc_html__('Total Review', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_style_testimonial_two_review_area_total_review_typ',
                'selector' => '{{WRAPPER}} .home2-testimonial-section .testimonial-left-content .rating-area > li .single-rating .rating span',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_two_review_area_total_review_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-testimonial-section .testimonial-left-content .rating-area > li .single-rating .rating span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        //Content
        $this->add_control(
            'vernex_testimonial_genaral_sec_content_two_style',
            [
                'label' => esc_html__(' Testimonial Content', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_control(
            'vernex_testimonial_genaral_sec_title_desc_two_style',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_title_desc_two_style_typ',
                'selector' => '{{WRAPPER}} .testimonial-card .testimonial-content > span',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_title_desc_two_style_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content > span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_content_two_desc_style',
            [
                'label' => esc_html__(' Content', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_content_two_desc_style_typ',
                'selector' => '{{WRAPPER}} .testimonial-card .testimonial-content p',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_content_desc_two_style_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content p' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        //Author Image SIze
        $this->add_control(
            'vernex_testimonial_genaral_sec_author_image_two_style',
            [
                'label' => esc_html__(' Author Image Size', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_author_image_two_style_size_style',
            [
                'label' => esc_html__('Image Size', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-img img' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        //Author Name
        $this->add_control(
            'vernex_testimonial_genaral_sec_author_name_two_style',
            [
                'label' => esc_html__(' Author Name', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_author_name_two_style_typ',
                'selector' => '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content h5',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_author_name_two_style_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content h5' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vernex_testimonial_genaral_sec_author_name_two_style_margin',
            [
                'label' => esc_html__('Margin', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vernex_testimonial_genaral_sec_author_name_two_style_padding',
            [
                'label'      => esc_html__('Padding', 'vernex-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        //Author Designation
        $this->add_control(
            'vernex_testimonial_genaral_sec_author_designation_two_style',
            [
                'label' => esc_html__(' Author Designation', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_author_designation_two_style_typ',
                'selector' => '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content span',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_author_designation_two_style_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vernex_testimonial_genaral_sec_author_designation_two_style_margin',
            [
                'label' => esc_html__('Margin', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vernex_testimonial_genaral_sec_author_designation_two_style_padding',
            [
                'label'      => esc_html__('Padding', 'vernex-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        //Button
        $this->add_control(
            'vernex_testimonial_genaral_sec_btn_two_style',
            [
                'label' => esc_html__('Button', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_btn_two_style_typ',
                'selector' => '{{WRAPPER}} .primary-btn',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_btn_two_style_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => '-webkit-text-fill-color: {{VALUE}};',
                    '{{WRAPPER}} .primary-btn svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();


        //Style Three
        $this->start_controls_section(
            'vernex_testimonial_genaral_three_sec_style',
            [
                'label' => esc_html__('Testimonial Style', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_testimonial_genaral_style_selection' => 'style_three'
                ]
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_three_title',
            [
                'label' => esc_html__(' Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_style_testimonial_three_title_typ',
                'selector' => '{{WRAPPER}} .testimonial-card .testimonial-content > span',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_three_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content > span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_three_content',
            [
                'label' => esc_html__('Content', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_style_testimonial_three_content_typ',
                'selector' => '{{WRAPPER}} .testimonial-card .testimonial-content p',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_three_content_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content p' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_three_authoe_area',
            [
                'label' => esc_html__('Author Area', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_three_authoe_area_name',
            [
                'label' => esc_html__('Name', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_style_testimonial_three_authoe_area_name_typ',
                'selector' => '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content h5',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_three_authoe_area_name_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content h5' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_three_authoe_area_designation',
            [
                'label' => esc_html__('Designation', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_style_testimonial_three_authoe_area_designation_typ',
                'selector' => '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content span',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_three_authoe_area_designation_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .testimonial-content .author-area .author-content span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_three_authoe_area_btn',
            [
                'label' => esc_html__('Button', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_style_testimonial_three_authoe_area_btn_typ',
                'selector' => '{{WRAPPER}} .primary-btn',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_three_authoe_area_btn_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();


        //Style Four
        $this->start_controls_section(
            'vernex_testimonial_genaral_four_sec_style',
            [
                'label' => esc_html__('Testimonial Style', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_testimonial_genaral_style_selection' => 'style_four'
                ]
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_four_title',
            [
                'label' => esc_html__(' Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_style_testimonial_three_four_typ',
                'selector' => '{{WRAPPER}} .section-title2 h2',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_four_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title2 h2' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_four_testimony_area',
            [
                'label' => esc_html__(' Testimony Area', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_four_testimony_area_title',
            [
                'label' => esc_html__(' Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_style_testimonial_four_testimony_area_typ',
                'selector' => '{{WRAPPER}} .home4-testimonial-section .testimonial-content-area .testimonial-card-area .testimonial-content-wrap > span',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_four_testimony_area_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-testimonial-section .testimonial-content-area .testimonial-card-area .testimonial-content-wrap > span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_four_testimony_area_desc',
            [
                'label' => esc_html__('Description', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_style_testimonial_four_testimony_area_desc_typ',
                'selector' => '{{WRAPPER}} .home4-testimonial-section .testimonial-content-area .testimonial-card-area .testimonial-content-wrap p',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_four_testimony_area_desc_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-testimonial-section .testimonial-content-area .testimonial-card-area .testimonial-content-wrap p' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_four_testimony_area_author_area',
            [
                'label' => esc_html__('Author Area', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_four_testimony_area_author_area_name',
            [
                'label' => esc_html__('Name', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_style_testimonial_four_testimony_area_author_area_name_typ',
                'selector' => '{{WRAPPER}} .home4-testimonial-section .testimonial-content-area .testimonial-card-area .testimonial-content-wrap .author-area .author-content h5',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_four_testimony_area_author_area_name_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-testimonial-section .testimonial-content-area .testimonial-card-area .testimonial-content-wrap .author-area .author-content h5' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_four_testimony_area_author_area_designation',
            [
                'label' => esc_html__('Designation', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_sec_style_testimonial_four_testimony_area_author_area_designation_typ',
                'selector' => '{{WRAPPER}} .home4-testimonial-section .testimonial-content-area .testimonial-card-area .testimonial-content-wrap .author-area .author-content span',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_sec_style_testimonial_four_testimony_area_author_area_designation_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-testimonial-section .testimonial-content-area .testimonial-card-area .testimonial-content-wrap .author-area .author-content span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //Style Five
        $this->start_controls_section(
            'vernex_testimonial_genaral_five_sec_style',
            [
                'label' => esc_html__('Testimonial Style', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_testimonial_genaral_style_selection' => 'style_five'
                ]
            ]
        );


        $this->add_control(
            'vernex_testimonial_genaral_five_sec_style_bac_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-testimonial-section' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_five_sec_style_title',
            [
                'label' => esc_html__(' Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_five_sec_style_typ',
                'selector' => '{{WRAPPER}} .home5-testimonial-section .testimonial-card-area .testimonial-content-wrap > span',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_five_sec_style_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-testimonial-section .testimonial-card-area .testimonial-content-wrap > span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_five_sec_style_desc',
            [
                'label' => esc_html__('Description', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_five_sec_style_desc_typ',
                'selector' => '{{WRAPPER}} .home5-testimonial-section .testimonial-card-area .testimonial-content-wrap p',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_five_sec_style_desc_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-testimonial-section .testimonial-card-area .testimonial-content-wrap p' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_five_sec_style_author_area',
            [
                'label' => esc_html__('Author Area', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_five_sec_style_author_area_name',
            [
                'label' => esc_html__('Name', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_five_sec_style_author_area_typ',
                'selector' => '{{WRAPPER}} .home5-testimonial-section .testimonial-card-area .testimonial-content-wrap .author-area .author-content h5',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_five_sec_style_author_area_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-testimonial-section .testimonial-card-area .testimonial-content-wrap .author-area .author-content h5' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_five_sec_style_author_area_designation',
            [
                'label' => esc_html__('Designation', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_five_sec_style_author_area_designation_typ',
                'selector' => '{{WRAPPER}} .home5-testimonial-section .testimonial-card-area .testimonial-content-wrap .author-area .author-content span',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_five_sec_style_author_area_designation_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-testimonial-section .testimonial-card-area .testimonial-content-wrap .author-area .author-content span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_five_sec_style_logo_sec',
            [
                'label' => esc_html__('Logo Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_testimonial_genaral_five_sec_style_logo_sec_typ',
                'selector' => '{{WRAPPER}} .logo-section .logo-wrap .logo-title h6',

            ]
        );

        $this->add_control(
            'vernex_testimonial_genaral_five_sec_style_logo_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo-section .logo-wrap .logo-title h6' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );



        $this->end_controls_section();
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $data = $settings['vernex_testimonial_content_list'];
        $data2 = $settings['vernex_testimonial_content_two_list'];
        $data3 = $settings['vernex_testimonial_content_three_list'];
        $data4 = $settings['vernex_testimonial_testimony_content_four_after_before_image_list'];
        $data5 = $settings['vernex_testimonial_testimony_content_five_after_content_list'];
        $data6 = $settings['vernex_testimonial_content_six_list'];
        $data7 = $settings['vernex_testimonial_two_genaral_review_list'];
        $data8 = $settings['vernex_testimonial_six_genaral_content_list'];
        $data9 = $settings['vernex_testimonial_testimony_content_five_logo_area_logo_list'];



?>

        <?php if (is_admin()) : ?>
            <script>
                // Home1 Testimonial Slider
                var swiper = new Swiper(".home1-testimonial-slider", {
                    slidesPerView: 1,
                    spaceBetween: 10,
                    speed: 2000,
                    effect: 'fade', // Use the fade effect
                    fadeEffect: {
                        crossFade: true // Enable cross-fade transition
                    },
                    autoplay: {
                        delay: 3000, // Autoplay duration in milliseconds
                        disableOnInteraction: false,
                    },
                    navigation: {
                        nextEl: ".testimonial-slider-next",
                        prevEl: ".testimonial-slider-prev",
                    },
                });

                var swiper = new Swiper(".home4-testimonial-img-slider", {
                    spaceBetween: 10,
                    slidesPerView: 1,
                    freeMode: true,
                    watchSlidesProgress: true,
                    allowTouchMove: false,
                    speed: 2000,
                    effect: 'fade', // Use the fade effect
                    fadeEffect: {
                        crossFade: true // Enable cross-fade transition
                    },

                    // autoplay: {
                    // 	delay: 3000, // Autoplay duration in milliseconds
                    // 	disableOnInteraction: false,
                    // },
                });

                var swiper2 = new Swiper(".home4-testimonial-content-slider", {
                    spaceBetween: 10,
                    speed: 2000,
                    effect: 'fade', // Use the fade effect
                    fadeEffect: {
                        crossFade: true // Enable cross-fade transition
                    },
                    // autoplay: {
                    // 	delay: 3000, // Autoplay duration in milliseconds
                    // 	disableOnInteraction: false,
                    // },
                    navigation: {
                        nextEl: ".home4-testimonial-next",
                        prevEl: ".home4-testimonial-prev",
                    },
                    thumbs: {
                        swiper: swiper,
                    },
                });

                jQuery(document).ready(function() {
                    if (jQuery(".container1").length) {
                        jQuery(".container1").twentytwenty();
                    }
                });

                var swiper = new Swiper(".home5-testimonial-slider", {
                    spaceBetween: 10,
                    speed: 2000,
                    effect: 'fade', // Use the fade effect
                    fadeEffect: {
                        crossFade: true // Enable cross-fade transition
                    },
                    autoplay: {
                        delay: 3000, // Autoplay duration in milliseconds
                        disableOnInteraction: false,
                    },
                    navigation: {
                        nextEl: ".home4-testimonial-next",
                        prevEl: ".home4-testimonial-prev",
                    },
                });
            </script>
        <?php endif ?>

        <?php if ($settings['vernex_testimonial_genaral_style_selection'] == 'style_one') : ?>
            <div class="home1-testimonial-section">
                <div class="container-fluid-xl container">
                    <div class="row g-xl-4 gy-5 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-xl-4 d-xl-block d-flex align-items-end justify-content-between flex-wrap gap-3">
                            <div class="section-title">
                                <?php if (!empty($settings['vernex_testimonial_testimony_general_subtitle'])) :   ?>
                                    <span> <?php echo esc_html($settings['vernex_testimonial_testimony_general_subtitle']) ?></span>
                                <?php endif ?>
                                <?php if (!empty($settings['vernex_testimonial_testimony_general_title'])) :   ?>
                                    <h2><?php echo esc_html($settings['vernex_testimonial_testimony_general_title']) ?></h2>
                                <?php endif ?>
                            </div>
                            <div class="slider-btn-grp">
                                <div class="slider-btn testimonial-slider-prev">
                                    <i class="bi bi-arrow-left"></i>
                                </div>
                                <div class="slider-btn testimonial-slider-next">
                                    <i class="bi bi-arrow-right"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-8">
                            <div class="testimonial-slider-area">
                                <div class="swiper home1-testimonial-slider">
                                    <div class="swiper-wrapper">
                                        <?php foreach ($data as  $item) : ?>
                                            <div class="swiper-slide">
                                                <div class="testimonial-card">
                                                    <div class="testimonial-author-img">
                                                        <?php if (!empty($item['vernex_testimonial_author_image']['url'])) :   ?>
                                                            <img src="<?php echo esc_url($item['vernex_testimonial_author_image']['url']) ?>" alt="<?php echo esc_attr__('auth-image', 'vernex-core') ?>">
                                                        <?php endif ?>
                                                        <svg class="quote" width="126" height="127" viewBox="0 0 126 127" xmlns="http://www.w3.org/2000/svg">
                                                            <g>
                                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                                    d="M84.0557 118.313L84.0529 118.314C83.6215 118.418 83.0219 118.451 82.3838 118.395C81.7471 118.339 81.1484 118.202 80.7167 118.018L80.7078 118.015C80.3071 117.849 80.0305 117.699 79.7798 117.496C79.5267 117.291 79.257 116.997 78.9216 116.498C78.2281 115.467 77.3641 113.734 75.839 110.522C73.2229 105.023 72.9886 104.324 72.9064 103.17C72.7987 101.514 73.203 100.371 74.1027 99.4441L74.1083 99.4383L74.1139 99.4323C74.1141 99.4321 74.1148 99.4314 74.116 99.4302L74.1225 99.4238C74.1284 99.4182 74.1366 99.4106 74.1475 99.401C74.16 99.3899 74.1751 99.3771 74.1928 99.3625C74.2061 99.3516 74.221 99.3396 74.2375 99.3266C74.3146 99.2658 74.4159 99.1919 74.5419 99.1054C74.7941 98.9325 75.1215 98.7257 75.5061 98.4964C76.2737 98.0388 77.2375 97.5103 78.2179 97.0101C83.4212 94.3813 87.4554 91.5308 90.5928 88.1023C93.7355 84.668 95.9414 80.6943 97.5411 75.8698C98.9485 71.6139 99.9298 65.926 99.9298 61.8381L99.9298 59.0273L78.8402 59.0273L77.7603 58.4831C77.1487 58.1855 76.3686 57.5764 76.088 57.2229L76.0831 57.2166L76.078 57.2104C76.0525 57.1794 76.0281 57.1496 76.0045 57.1209C75.6527 56.6928 75.5001 56.5072 75.3667 56.1427C75.2093 55.7128 75.0764 55.0009 74.9895 53.5076C74.822 50.627 74.8391 45.2381 74.874 34.2966L74.8774 33.217L74.9504 12.2815L75.3747 11.4845C75.3749 11.4841 75.375 11.4838 75.3752 11.4835C75.6535 10.963 76.1264 10.3815 76.6813 9.8779C77.2417 9.36923 77.8094 9.00908 78.2408 8.85758C78.2432 8.85689 78.3123 8.83644 78.5084 8.81138C78.6973 8.78726 78.9636 8.76359 79.3342 8.74157C80.075 8.69756 81.1824 8.66293 82.8236 8.63662C86.1026 8.58406 91.4594 8.56543 100.16 8.56543L121.194 8.56543L121.978 8.98946C121.979 8.98966 121.979 8.98986 121.979 8.99006C123.037 9.56631 124.046 10.6106 124.542 11.5892L124.544 11.5924C124.628 11.7576 124.752 12.0455 124.822 14.6798C124.889 17.2268 124.914 21.7886 124.951 30.2661C125 41.0871 124.926 50.9069 124.755 54.3974L124.755 54.4011C124.203 66.6099 122.796 75.7923 120.063 83.3963C117.339 90.9789 113.28 97.0392 107.352 102.977L107.35 102.979C103.684 106.674 101.251 108.641 96.8965 111.559L96.8955 111.56C95.2427 112.671 92.432 114.269 89.797 115.65C88.4837 116.338 87.2268 116.965 86.1936 117.444C85.1268 117.939 84.3847 118.235 84.0557 118.313ZM122.456 8.11113L121.447 7.56543L100.16 7.56543C82.7614 7.56543 78.7008 7.63985 77.9134 7.9127C76.7075 8.33438 75.1817 9.72344 74.4927 11.0133L73.9512 12.0303L73.8774 33.2135C73.8129 53.5535 73.786 55.7338 74.7964 57.1987C74.943 57.4113 75.1114 57.6088 75.3048 57.8445C75.6985 58.3406 76.6091 59.0352 77.3227 59.3824L78.6024 60.0273L98.9298 60.0273L98.9298 61.8381C98.9298 65.8068 97.97 71.3879 96.5919 75.5551C93.4665 84.9809 88.0278 90.934 77.7657 96.1182C75.7723 97.1352 73.8282 98.2762 73.3852 98.7475C72.2532 99.9133 71.7856 101.352 71.9087 103.237C72.0071 104.626 72.3516 105.519 74.9356 110.951C77.9626 117.326 78.5286 118.194 80.3251 118.938C81.4325 119.41 83.1552 119.559 84.2872 119.286C86.0591 118.864 94.0571 114.672 97.4532 112.39C101.858 109.438 104.344 107.429 108.06 103.684C120.094 91.6285 124.647 78.9533 125.754 54.4463C125.926 50.924 126 41.0766 125.951 30.2617C125.877 13.3201 125.852 11.9559 125.434 11.1373C124.843 9.97148 123.687 8.78086 122.456 8.11113Z" />
                                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                                    d="M49.0465 84.3359C43.4602 98.7971 30.8356 111.199 14.2734 118.492C11.1727 119.856 8.24415 119.385 6.49689 117.252C6.10314 116.756 4.50353 113.68 2.95314 110.455L2.93395 110.415C0.172048 104.626 0.123059 104.523 0.123059 102.815C0.147667 99.6404 1.13204 98.4746 5.66017 96.2918C14.4457 92.0254 19.6137 87.1885 23.0098 79.9951C24.6094 76.5969 25.4215 74.1412 26.1844 70.3213C26.6766 67.8408 27.3164 62.359 27.3164 60.4986C27.3164 60.0273 27.0457 60.0273 17.0297 60.0274L6.74297 60.0274L5.46329 59.3824C4.74962 59.0352 3.83907 58.3406 3.44532 57.8445C3.25197 57.6088 3.08352 57.4113 2.9369 57.1987C1.92656 55.7338 1.9535 53.5535 2.01797 33.2135L2.01805 33.1921C2.0918 12.0799 2.09198 12.0299 2.6086 11.0381C3.34688 9.67383 4.33125 8.70645 5.66016 8.08633C6.76758 7.56543 6.93985 7.56543 28.1777 7.56543L49.5879 7.56543L50.5969 8.11113C51.9012 8.80566 52.9594 9.87227 53.55 11.0877C53.993 11.9807 54.0176 12.9232 54.0176 33.7344C54.0176 56.3066 53.9191 59.3576 52.8856 67.4688C52.0734 73.9428 50.6461 80.2184 49.0465 84.3359ZM49.3348 8.56543L28.1777 8.56543C17.5503 8.56543 12.2143 8.56551 9.39297 8.63028C7.97395 8.66286 7.23998 8.71124 6.80305 8.77478C6.43084 8.82891 6.30838 8.88652 6.09262 8.98801L6.0858 8.99123L6.08302 8.99253C4.9693 9.51223 4.13762 10.3165 3.49168 11.5074C3.48872 11.513 3.48581 11.5186 3.48293 11.5241C3.39285 11.6966 3.34617 11.786 3.29678 12.1034C3.23397 12.507 3.1838 13.2077 3.14682 14.5993C3.07339 17.3625 3.05491 22.6414 3.01797 33.2167C3.01797 33.2165 3.01797 33.2168 3.01797 33.2167L3.01453 34.2966C2.97967 45.2381 2.96251 50.627 3.1301 53.5076C3.21698 55.0009 3.3499 55.7128 3.50729 56.1427C3.64068 56.5072 3.79324 56.6928 4.145 57.1209C4.16859 57.1496 4.19309 57.1794 4.21853 57.2104L4.22361 57.2166L4.22859 57.2229C4.50919 57.5764 5.28921 58.1856 5.90083 58.4832L6.98072 59.0274L17.103 59.0274C22.0464 59.0274 24.6317 59.0273 25.9737 59.0873C26.6041 59.1154 27.109 59.1587 27.46 59.2866C27.6656 59.3615 27.9532 59.5117 28.1435 59.8299C28.317 60.12 28.3165 60.4079 28.3164 60.4927L28.3164 60.4986C28.3164 62.4455 27.6653 67.9961 27.1653 70.5159L27.165 70.5171C26.3865 74.4152 25.5492 76.9483 23.9145 80.421L23.9141 80.4221C20.3993 87.8667 15.0379 92.8495 6.097 97.1913L6.0944 97.1926C3.82272 98.2877 2.62774 99.0475 1.96544 99.8284C1.36785 100.533 1.13491 101.342 1.12306 102.819C1.12309 103.251 1.12757 103.511 1.16441 103.772C1.19973 104.023 1.26996 104.306 1.43251 104.743C1.77244 105.656 2.45241 107.083 3.8551 110.023C4.62619 111.627 5.40859 113.192 6.04561 114.415C6.3645 115.027 6.64445 115.548 6.86687 115.944C6.97823 116.142 7.07238 116.304 7.14791 116.427C7.18562 116.489 7.21662 116.537 7.24119 116.574C7.25336 116.593 7.26296 116.606 7.27017 116.616C7.27379 116.622 7.27641 116.625 7.27806 116.627C8.66502 118.312 11.0628 118.812 13.8705 117.577C30.2331 110.372 42.6392 98.1473 48.1137 83.9756L48.1144 83.9738C49.6738 79.9597 51.087 73.7719 51.8933 67.3443L51.8936 67.3423C52.918 59.3034 53.0176 56.3138 53.0176 33.7344C53.0176 23.3224 53.0114 17.8979 52.9501 14.9626C52.8884 12.0022 52.7612 11.7469 52.6595 11.5427C52.6577 11.5392 52.6559 11.5356 52.6542 11.5321L52.6506 11.5248C52.1611 10.5174 51.2629 9.59872 50.1269 8.99379L49.3348 8.56543Z" />
                                                            </g>
                                                        </svg>
                                                    </div>
                                                    <div class="testimonial-content">
                                                        <?php if (!empty($item['vernex_testimonial_testimony_title'])) :   ?>
                                                            <span><?php echo esc_html($item['vernex_testimonial_testimony_title']) ?></span>
                                                        <?php endif ?>
                                                        <?php if (!empty($item['vernex_testimonial_testimony_content'])) :   ?>
                                                            <p><?php echo esc_html($item['vernex_testimonial_testimony_content']) ?></p>
                                                        <?php endif ?>
                                                        <div class="author-area">
                                                            <div class="author-content">
                                                                <?php if (!empty($item['vernex_testimonial_author_name'])) :   ?>
                                                                    <h5><?php echo esc_html($item['vernex_testimonial_author_name']) ?></h5>
                                                                <?php endif ?>
                                                                <?php if (!empty($item['vernex_testimonial_author_designation'])) :   ?>
                                                                    <span><?php echo esc_html($item['vernex_testimonial_author_designation']) ?></span>
                                                                <?php endif ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                                <div class="contact-btn-area">
                                    <?php if (!empty($settings['vernex_testimonial_author_grp_photos']['url'])) :   ?>
                                        <img src="<?php echo esc_url($settings['vernex_testimonial_author_grp_photos']['url']) ?>" alt="<?php echo esc_attr__('auth-image', 'vernex-core') ?>">
                                    <?php endif ?>
                                    <?php if (!empty($settings['vernex_testimonial_button_text'])) :   ?>
                                        <a href="<?php echo esc_url($settings['vernex_testimonial_button_text_url']['url']) ?>" class="primary-btn">
                                            <?php echo esc_html($settings['vernex_testimonial_button_text']) ?>
                                            <svg viewBox="0 0 13 20">
                                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                            </svg>
                                        </a>
                                    <?php endif ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif ?>

        <?php if ($settings['vernex_testimonial_genaral_style_selection'] == 'style_two') : ?>
            <div class="home2-testimonial-section">
                <div class="container">
                    <div class="row justify-content-end mb-70 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-lg-10">
                            <div class="section-title two">
                                <?php if (!empty($settings['vernex_testimonial_testimony_two_general_subtitle'])) :   ?>
                                    <span> <?php echo esc_html($settings['vernex_testimonial_testimony_two_general_subtitle']) ?></span>
                                <?php endif ?>
                                <?php if (!empty($settings['vernex_testimonial_testimony_two_general_title'])) :   ?>
                                    <h2> <?php echo esc_html($settings['vernex_testimonial_testimony_two_general_title']) ?></h2>
                                <?php endif ?>
                            </div>
                        </div>
                    </div>
                    <div class="row gy-5">
                        <div class="col-xl-4 col-lg-5 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="testimonial-left-content">
                                <ul class="rating-area">
                                    <?php foreach ($data7 as  $item) : ?>
                                        <li>
                                            <a href="<?php echo esc_url($item['vernex_testimonial_two_genaral_review_link']['url']) ?>" class="single-rating">
                                                <div class="review">
                                                    <?php if (!empty($item['vernex_testimonial_testimony_two_general_review_title'])) :   ?>
                                                        <span><?php echo esc_html($item['vernex_testimonial_testimony_two_general_review_title']) ?></span>
                                                    <?php endif ?>
                                                    <?php if (!empty($item['vernex_testimonial_two_genaral_review_review_logo']['url'])) :   ?>
                                                        <img src="<?php echo esc_url($item['vernex_testimonial_two_genaral_review_review_logo']['url']) ?>" alt="<?php echo esc_attr__('author-image', 'vernex-core') ?>">
                                                    <?php endif ?>
                                                </div>
                                                <div class="rating">
                                                    <?php if ('general' == $item['vernex_testimonial_two_genaral_review_review_seelection']) { ?>
                                                        <ul class="star">
                                                            <?php $rank_counter = intval($item['vernex_testimonial_two_genaral_review_review_star']);
                                                            $rank_counter = max(0, min(5, $rank_counter)); ?>
                                                            <?php for ($i = 1; $i <= 5; $i++) : ?>
                                                                <?php if ($i <= $rank_counter) : ?>
                                                                    <li><i class="bi bi-star-fill"></i></li>
                                                                <?php endif ?>
                                                            <?php endfor; ?>
                                                        </ul>
                                                    <?php } ?>

                                                    <?php if ('others' == $item['vernex_testimonial_two_genaral_review_review_seelection']) { ?>
                                                        <ul class="tripadvisor">
                                                            <?php $rank_counter = intval($item['vernex_testimonial_two_genaral_review_review_star']);
                                                            $rank_counter = max(0, min(5, $rank_counter)); ?>
                                                            <?php for ($i = 1; $i <= 5; $i++) : ?>
                                                                <?php if ($i <= $rank_counter) : ?>
                                                                    <li><i class="bi bi-star-fill"></i></li>
                                                                <?php endif ?>
                                                            <?php endfor; ?>
                                                        </ul>
                                                    <?php } ?>
                                                    <span><?php echo esc_html($item['vernex_testimonial_two_genaral_review_total_num_sec']) ?></span>
                                                </div>
                                            </a>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                                <div class="slider-btn-area">
                                    <?php if (!empty($settings['vernex_testimonial_testimony_sidebar_btn_two_title'])) :   ?>
                                        <h4><?php echo esc_html($settings['vernex_testimonial_testimony_sidebar_btn_two_title']) ?></h4>
                                    <?php endif ?>
                                    <div class="slider-btn-grp">
                                        <div class="slider-btn testimonial-slider-prev">
                                            <i class="bi bi-arrow-left"></i>
                                        </div>
                                        <div class="slider-btn testimonial-slider-next">
                                            <i class="bi bi-arrow-right"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-8 col-lg-7">
                            <div class="testimonial-slider-area">
                                <div class="swiper home1-testimonial-slider">
                                    <div class="swiper-wrapper">
                                        <?php foreach ($data2 as  $item) : ?>
                                            <div class="swiper-slide">
                                                <div class="testimonial-card style-2">
                                                    <div class="testimonial-content">
                                                        <svg class="quote" width="46" height="42" viewBox="0 0 126 127"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <g>
                                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                                    d="M84.0557 118.313L84.0529 118.314C83.6215 118.418 83.0219 118.451 82.3838 118.395C81.7471 118.339 81.1484 118.202 80.7167 118.018L80.7078 118.015C80.3071 117.849 80.0305 117.699 79.7798 117.496C79.5267 117.291 79.257 116.997 78.9216 116.498C78.2281 115.467 77.3641 113.734 75.839 110.522C73.2229 105.023 72.9886 104.324 72.9064 103.17C72.7987 101.514 73.203 100.371 74.1027 99.4441L74.1083 99.4383L74.1139 99.4323C74.1141 99.4321 74.1148 99.4314 74.116 99.4302L74.1225 99.4238C74.1284 99.4182 74.1366 99.4106 74.1475 99.401C74.16 99.3899 74.1751 99.3771 74.1928 99.3625C74.2061 99.3516 74.221 99.3396 74.2375 99.3266C74.3146 99.2658 74.4159 99.1919 74.5419 99.1054C74.7941 98.9325 75.1215 98.7257 75.5061 98.4964C76.2737 98.0388 77.2375 97.5103 78.2179 97.0101C83.4212 94.3813 87.4554 91.5308 90.5928 88.1023C93.7355 84.668 95.9414 80.6943 97.5411 75.8698C98.9485 71.6139 99.9298 65.926 99.9298 61.8381L99.9298 59.0273L78.8402 59.0273L77.7603 58.4831C77.1487 58.1855 76.3686 57.5764 76.088 57.2229L76.0831 57.2166L76.078 57.2104C76.0525 57.1794 76.0281 57.1496 76.0045 57.1209C75.6527 56.6928 75.5001 56.5072 75.3667 56.1427C75.2093 55.7128 75.0764 55.0009 74.9895 53.5076C74.822 50.627 74.8391 45.2381 74.874 34.2966L74.8774 33.217L74.9504 12.2815L75.3747 11.4845C75.3749 11.4841 75.375 11.4838 75.3752 11.4835C75.6535 10.963 76.1264 10.3815 76.6813 9.8779C77.2417 9.36923 77.8094 9.00908 78.2408 8.85758C78.2432 8.85689 78.3123 8.83644 78.5084 8.81138C78.6973 8.78726 78.9636 8.76359 79.3342 8.74157C80.075 8.69756 81.1824 8.66293 82.8236 8.63662C86.1026 8.58406 91.4594 8.56543 100.16 8.56543L121.194 8.56543L121.978 8.98946C121.979 8.98966 121.979 8.98986 121.979 8.99006C123.037 9.56631 124.046 10.6106 124.542 11.5892L124.544 11.5924C124.628 11.7576 124.752 12.0455 124.822 14.6798C124.889 17.2268 124.914 21.7886 124.951 30.2661C125 41.0871 124.926 50.9069 124.755 54.3974L124.755 54.4011C124.203 66.6099 122.796 75.7923 120.063 83.3963C117.339 90.9789 113.28 97.0392 107.352 102.977L107.35 102.979C103.684 106.674 101.251 108.641 96.8965 111.559L96.8955 111.56C95.2427 112.671 92.432 114.269 89.797 115.65C88.4837 116.338 87.2268 116.965 86.1936 117.444C85.1268 117.939 84.3847 118.235 84.0557 118.313ZM122.456 8.11113L121.447 7.56543L100.16 7.56543C82.7614 7.56543 78.7008 7.63985 77.9134 7.9127C76.7075 8.33438 75.1817 9.72344 74.4927 11.0133L73.9512 12.0303L73.8774 33.2135C73.8129 53.5535 73.786 55.7338 74.7964 57.1987C74.943 57.4113 75.1114 57.6088 75.3048 57.8445C75.6985 58.3406 76.6091 59.0352 77.3227 59.3824L78.6024 60.0273L98.9298 60.0273L98.9298 61.8381C98.9298 65.8068 97.97 71.3879 96.5919 75.5551C93.4665 84.9809 88.0278 90.934 77.7657 96.1182C75.7723 97.1352 73.8282 98.2762 73.3852 98.7475C72.2532 99.9133 71.7856 101.352 71.9087 103.237C72.0071 104.626 72.3516 105.519 74.9356 110.951C77.9626 117.326 78.5286 118.194 80.3251 118.938C81.4325 119.41 83.1552 119.559 84.2872 119.286C86.0591 118.864 94.0571 114.672 97.4532 112.39C101.858 109.438 104.344 107.429 108.06 103.684C120.094 91.6285 124.647 78.9533 125.754 54.4463C125.926 50.924 126 41.0766 125.951 30.2617C125.877 13.3201 125.852 11.9559 125.434 11.1373C124.843 9.97148 123.687 8.78086 122.456 8.11113Z" />
                                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                                    d="M49.0465 84.3359C43.4602 98.7971 30.8356 111.199 14.2734 118.492C11.1727 119.856 8.24415 119.385 6.49689 117.252C6.10314 116.756 4.50353 113.68 2.95314 110.455L2.93395 110.415C0.172048 104.626 0.123059 104.523 0.123059 102.815C0.147667 99.6404 1.13204 98.4746 5.66017 96.2918C14.4457 92.0254 19.6137 87.1885 23.0098 79.9951C24.6094 76.5969 25.4215 74.1412 26.1844 70.3213C26.6766 67.8408 27.3164 62.359 27.3164 60.4986C27.3164 60.0273 27.0457 60.0273 17.0297 60.0274L6.74297 60.0274L5.46329 59.3824C4.74962 59.0352 3.83907 58.3406 3.44532 57.8445C3.25197 57.6088 3.08352 57.4113 2.9369 57.1987C1.92656 55.7338 1.9535 53.5535 2.01797 33.2135L2.01805 33.1921C2.0918 12.0799 2.09198 12.0299 2.6086 11.0381C3.34688 9.67383 4.33125 8.70645 5.66016 8.08633C6.76758 7.56543 6.93985 7.56543 28.1777 7.56543L49.5879 7.56543L50.5969 8.11113C51.9012 8.80566 52.9594 9.87227 53.55 11.0877C53.993 11.9807 54.0176 12.9232 54.0176 33.7344C54.0176 56.3066 53.9191 59.3576 52.8856 67.4688C52.0734 73.9428 50.6461 80.2184 49.0465 84.3359ZM49.3348 8.56543L28.1777 8.56543C17.5503 8.56543 12.2143 8.56551 9.39297 8.63028C7.97395 8.66286 7.23998 8.71124 6.80305 8.77478C6.43084 8.82891 6.30838 8.88652 6.09262 8.98801L6.0858 8.99123L6.08302 8.99253C4.9693 9.51223 4.13762 10.3165 3.49168 11.5074C3.48872 11.513 3.48581 11.5186 3.48293 11.5241C3.39285 11.6966 3.34617 11.786 3.29678 12.1034C3.23397 12.507 3.1838 13.2077 3.14682 14.5993C3.07339 17.3625 3.05491 22.6414 3.01797 33.2167C3.01797 33.2165 3.01797 33.2168 3.01797 33.2167L3.01453 34.2966C2.97967 45.2381 2.96251 50.627 3.1301 53.5076C3.21698 55.0009 3.3499 55.7128 3.50729 56.1427C3.64068 56.5072 3.79324 56.6928 4.145 57.1209C4.16859 57.1496 4.19309 57.1794 4.21853 57.2104L4.22361 57.2166L4.22859 57.2229C4.50919 57.5764 5.28921 58.1856 5.90083 58.4832L6.98072 59.0274L17.103 59.0274C22.0464 59.0274 24.6317 59.0273 25.9737 59.0873C26.6041 59.1154 27.109 59.1587 27.46 59.2866C27.6656 59.3615 27.9532 59.5117 28.1435 59.8299C28.317 60.12 28.3165 60.4079 28.3164 60.4927L28.3164 60.4986C28.3164 62.4455 27.6653 67.9961 27.1653 70.5159L27.165 70.5171C26.3865 74.4152 25.5492 76.9483 23.9145 80.421L23.9141 80.4221C20.3993 87.8667 15.0379 92.8495 6.097 97.1913L6.0944 97.1926C3.82272 98.2877 2.62774 99.0475 1.96544 99.8284C1.36785 100.533 1.13491 101.342 1.12306 102.819C1.12309 103.251 1.12757 103.511 1.16441 103.772C1.19973 104.023 1.26996 104.306 1.43251 104.743C1.77244 105.656 2.45241 107.083 3.8551 110.023C4.62619 111.627 5.40859 113.192 6.04561 114.415C6.3645 115.027 6.64445 115.548 6.86687 115.944C6.97823 116.142 7.07238 116.304 7.14791 116.427C7.18562 116.489 7.21662 116.537 7.24119 116.574C7.25336 116.593 7.26296 116.606 7.27017 116.616C7.27379 116.622 7.27641 116.625 7.27806 116.627C8.66502 118.312 11.0628 118.812 13.8705 117.577C30.2331 110.372 42.6392 98.1473 48.1137 83.9756L48.1144 83.9738C49.6738 79.9597 51.087 73.7719 51.8933 67.3443L51.8936 67.3423C52.918 59.3034 53.0176 56.3138 53.0176 33.7344C53.0176 23.3224 53.0114 17.8979 52.9501 14.9626C52.8884 12.0022 52.7612 11.7469 52.6595 11.5427C52.6577 11.5392 52.6559 11.5356 52.6542 11.5321L52.6506 11.5248C52.1611 10.5174 51.2629 9.59872 50.1269 8.99379L49.3348 8.56543Z" />
                                                            </g>
                                                        </svg>
                                                        <?php if (!empty($item['vernex_testimonial_testimony_two_title'])) :   ?>
                                                            <span><?php echo esc_html($item['vernex_testimonial_testimony_two_title']) ?></span>
                                                        <?php endif ?>
                                                        <?php if (!empty($item['vernex_testimonial_testimony_two_content'])) :   ?>
                                                            <p><?php echo esc_html($item['vernex_testimonial_testimony_two_content']) ?></p>
                                                        <?php endif ?>
                                                        <div class="author-area">
                                                            <div class="author-img">
                                                                <?php if (!empty($item['vernex_testimonial_author_two_image']['url'])) :   ?>
                                                                    <img src="<?php echo esc_url($item['vernex_testimonial_author_two_image']['url']) ?>" alt="<?php echo esc_attr__('author-image', 'vernex-core') ?>">
                                                                <?php endif ?>
                                                            </div>
                                                            <div class="author-content">
                                                                <?php if (!empty($item['vernex_testimonial_author_two_name'])) :   ?>
                                                                    <h5><?php echo esc_html($item['vernex_testimonial_author_two_name']) ?></h5>
                                                                <?php endif ?>
                                                                <?php if (!empty($item['vernex_testimonial_author_two_designation'])) :   ?>
                                                                    <span><?php echo esc_html($item['vernex_testimonial_author_two_designation']) ?></span>
                                                                <?php endif ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                                <div class="contact-btn-area">
                                    <?php if (!empty($settings['vernex_testimonial_two_author_grp_photos']['url'])) :   ?>
                                        <img src="<?php echo esc_url($settings['vernex_testimonial_two_author_grp_photos']['url']) ?>" alt="<?php echo esc_attr__('author-image', 'vernex-core') ?>">
                                    <?php endif ?>
                                    <?php if (!empty($settings['vernex_testimonial_two_button_text'])) :   ?>
                                        <a href="<?php echo esc_url($settings['vernex_testimonial_two_button_text_url']['url']) ?>" class="primary-btn">
                                            <?php echo esc_html($settings['vernex_testimonial_two_button_text']) ?>
                                            <svg viewBox="0 0 13 20">
                                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                            </svg>
                                        </a>
                                    <?php endif ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif ?>



        <?php if ($settings['vernex_testimonial_genaral_style_selection'] == 'style_three') : ?>
            <div class="home3-testimonial-section">
                <div class="container">
                    <div class="testimonial-slider-wrap">
                        <div class="row justify-content-center">
                            <div class="col-xl-8 col-lg-10">
                                <div class="testimonial-slider">
                                    <div class="swiper home1-testimonial-slider">
                                        <div class="swiper-wrapper">
                                            <?php foreach ($data3 as  $item) : ?>
                                                <div class="swiper-slide">
                                                    <div class="testimonial-card style-3">
                                                        <div class="testimonial-author-img-wrap">
                                                            <div class="testimonial-author-img">
                                                                <?php if (!empty($item['vernex_testimonial_author_three_image']['url'])) :   ?>
                                                                    <img src="<?php echo esc_url($item['vernex_testimonial_author_three_image']['url']) ?>" alt="<?php echo esc_attr__('author-image', 'vernex-core') ?>">
                                                                <?php endif ?>
                                                            </div>
                                                            <svg class="quote" width="88" height="79" viewBox="0 0 126 127" xmlns="http://www.w3.org/2000/svg">
                                                                <g>
                                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                                        d="M84.0557 118.313L84.0529 118.314C83.6215 118.418 83.0219 118.451 82.3838 118.395C81.7471 118.339 81.1484 118.202 80.7167 118.018L80.7078 118.015C80.3071 117.849 80.0305 117.699 79.7798 117.496C79.5267 117.291 79.257 116.997 78.9216 116.498C78.2281 115.467 77.3641 113.734 75.839 110.522C73.2229 105.023 72.9886 104.324 72.9064 103.17C72.7987 101.514 73.203 100.371 74.1027 99.4441L74.1083 99.4383L74.1139 99.4323C74.1141 99.4321 74.1148 99.4314 74.116 99.4302L74.1225 99.4238C74.1284 99.4182 74.1366 99.4106 74.1475 99.401C74.16 99.3899 74.1751 99.3771 74.1928 99.3625C74.2061 99.3516 74.221 99.3396 74.2375 99.3266C74.3146 99.2658 74.4159 99.1919 74.5419 99.1054C74.7941 98.9325 75.1215 98.7257 75.5061 98.4964C76.2737 98.0388 77.2375 97.5103 78.2179 97.0101C83.4212 94.3813 87.4554 91.5308 90.5928 88.1023C93.7355 84.668 95.9414 80.6943 97.5411 75.8698C98.9485 71.6139 99.9298 65.926 99.9298 61.8381L99.9298 59.0273L78.8402 59.0273L77.7603 58.4831C77.1487 58.1855 76.3686 57.5764 76.088 57.2229L76.0831 57.2166L76.078 57.2104C76.0525 57.1794 76.0281 57.1496 76.0045 57.1209C75.6527 56.6928 75.5001 56.5072 75.3667 56.1427C75.2093 55.7128 75.0764 55.0009 74.9895 53.5076C74.822 50.627 74.8391 45.2381 74.874 34.2966L74.8774 33.217L74.9504 12.2815L75.3747 11.4845C75.3749 11.4841 75.375 11.4838 75.3752 11.4835C75.6535 10.963 76.1264 10.3815 76.6813 9.8779C77.2417 9.36923 77.8094 9.00908 78.2408 8.85758C78.2432 8.85689 78.3123 8.83644 78.5084 8.81138C78.6973 8.78726 78.9636 8.76359 79.3342 8.74157C80.075 8.69756 81.1824 8.66293 82.8236 8.63662C86.1026 8.58406 91.4594 8.56543 100.16 8.56543L121.194 8.56543L121.978 8.98946C121.979 8.98966 121.979 8.98986 121.979 8.99006C123.037 9.56631 124.046 10.6106 124.542 11.5892L124.544 11.5924C124.628 11.7576 124.752 12.0455 124.822 14.6798C124.889 17.2268 124.914 21.7886 124.951 30.2661C125 41.0871 124.926 50.9069 124.755 54.3974L124.755 54.4011C124.203 66.6099 122.796 75.7923 120.063 83.3963C117.339 90.9789 113.28 97.0392 107.352 102.977L107.35 102.979C103.684 106.674 101.251 108.641 96.8965 111.559L96.8955 111.56C95.2427 112.671 92.432 114.269 89.797 115.65C88.4837 116.338 87.2268 116.965 86.1936 117.444C85.1268 117.939 84.3847 118.235 84.0557 118.313ZM122.456 8.11113L121.447 7.56543L100.16 7.56543C82.7614 7.56543 78.7008 7.63985 77.9134 7.9127C76.7075 8.33438 75.1817 9.72344 74.4927 11.0133L73.9512 12.0303L73.8774 33.2135C73.8129 53.5535 73.786 55.7338 74.7964 57.1987C74.943 57.4113 75.1114 57.6088 75.3048 57.8445C75.6985 58.3406 76.6091 59.0352 77.3227 59.3824L78.6024 60.0273L98.9298 60.0273L98.9298 61.8381C98.9298 65.8068 97.97 71.3879 96.5919 75.5551C93.4665 84.9809 88.0278 90.934 77.7657 96.1182C75.7723 97.1352 73.8282 98.2762 73.3852 98.7475C72.2532 99.9133 71.7856 101.352 71.9087 103.237C72.0071 104.626 72.3516 105.519 74.9356 110.951C77.9626 117.326 78.5286 118.194 80.3251 118.938C81.4325 119.41 83.1552 119.559 84.2872 119.286C86.0591 118.864 94.0571 114.672 97.4532 112.39C101.858 109.438 104.344 107.429 108.06 103.684C120.094 91.6285 124.647 78.9533 125.754 54.4463C125.926 50.924 126 41.0766 125.951 30.2617C125.877 13.3201 125.852 11.9559 125.434 11.1373C124.843 9.97148 123.687 8.78086 122.456 8.11113Z" />
                                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                                        d="M49.0465 84.3359C43.4602 98.7971 30.8356 111.199 14.2734 118.492C11.1727 119.856 8.24415 119.385 6.49689 117.252C6.10314 116.756 4.50353 113.68 2.95314 110.455L2.93395 110.415C0.172048 104.626 0.123059 104.523 0.123059 102.815C0.147667 99.6404 1.13204 98.4746 5.66017 96.2918C14.4457 92.0254 19.6137 87.1885 23.0098 79.9951C24.6094 76.5969 25.4215 74.1412 26.1844 70.3213C26.6766 67.8408 27.3164 62.359 27.3164 60.4986C27.3164 60.0273 27.0457 60.0273 17.0297 60.0274L6.74297 60.0274L5.46329 59.3824C4.74962 59.0352 3.83907 58.3406 3.44532 57.8445C3.25197 57.6088 3.08352 57.4113 2.9369 57.1987C1.92656 55.7338 1.9535 53.5535 2.01797 33.2135L2.01805 33.1921C2.0918 12.0799 2.09198 12.0299 2.6086 11.0381C3.34688 9.67383 4.33125 8.70645 5.66016 8.08633C6.76758 7.56543 6.93985 7.56543 28.1777 7.56543L49.5879 7.56543L50.5969 8.11113C51.9012 8.80566 52.9594 9.87227 53.55 11.0877C53.993 11.9807 54.0176 12.9232 54.0176 33.7344C54.0176 56.3066 53.9191 59.3576 52.8856 67.4688C52.0734 73.9428 50.6461 80.2184 49.0465 84.3359ZM49.3348 8.56543L28.1777 8.56543C17.5503 8.56543 12.2143 8.56551 9.39297 8.63028C7.97395 8.66286 7.23998 8.71124 6.80305 8.77478C6.43084 8.82891 6.30838 8.88652 6.09262 8.98801L6.0858 8.99123L6.08302 8.99253C4.9693 9.51223 4.13762 10.3165 3.49168 11.5074C3.48872 11.513 3.48581 11.5186 3.48293 11.5241C3.39285 11.6966 3.34617 11.786 3.29678 12.1034C3.23397 12.507 3.1838 13.2077 3.14682 14.5993C3.07339 17.3625 3.05491 22.6414 3.01797 33.2167C3.01797 33.2165 3.01797 33.2168 3.01797 33.2167L3.01453 34.2966C2.97967 45.2381 2.96251 50.627 3.1301 53.5076C3.21698 55.0009 3.3499 55.7128 3.50729 56.1427C3.64068 56.5072 3.79324 56.6928 4.145 57.1209C4.16859 57.1496 4.19309 57.1794 4.21853 57.2104L4.22361 57.2166L4.22859 57.2229C4.50919 57.5764 5.28921 58.1856 5.90083 58.4832L6.98072 59.0274L17.103 59.0274C22.0464 59.0274 24.6317 59.0273 25.9737 59.0873C26.6041 59.1154 27.109 59.1587 27.46 59.2866C27.6656 59.3615 27.9532 59.5117 28.1435 59.8299C28.317 60.12 28.3165 60.4079 28.3164 60.4927L28.3164 60.4986C28.3164 62.4455 27.6653 67.9961 27.1653 70.5159L27.165 70.5171C26.3865 74.4152 25.5492 76.9483 23.9145 80.421L23.9141 80.4221C20.3993 87.8667 15.0379 92.8495 6.097 97.1913L6.0944 97.1926C3.82272 98.2877 2.62774 99.0475 1.96544 99.8284C1.36785 100.533 1.13491 101.342 1.12306 102.819C1.12309 103.251 1.12757 103.511 1.16441 103.772C1.19973 104.023 1.26996 104.306 1.43251 104.743C1.77244 105.656 2.45241 107.083 3.8551 110.023C4.62619 111.627 5.40859 113.192 6.04561 114.415C6.3645 115.027 6.64445 115.548 6.86687 115.944C6.97823 116.142 7.07238 116.304 7.14791 116.427C7.18562 116.489 7.21662 116.537 7.24119 116.574C7.25336 116.593 7.26296 116.606 7.27017 116.616C7.27379 116.622 7.27641 116.625 7.27806 116.627C8.66502 118.312 11.0628 118.812 13.8705 117.577C30.2331 110.372 42.6392 98.1473 48.1137 83.9756L48.1144 83.9738C49.6738 79.9597 51.087 73.7719 51.8933 67.3443L51.8936 67.3423C52.918 59.3034 53.0176 56.3138 53.0176 33.7344C53.0176 23.3224 53.0114 17.8979 52.9501 14.9626C52.8884 12.0022 52.7612 11.7469 52.6595 11.5427C52.6577 11.5392 52.6559 11.5356 52.6542 11.5321L52.6506 11.5248C52.1611 10.5174 51.2629 9.59872 50.1269 8.99379L49.3348 8.56543Z" />
                                                                </g>
                                                            </svg>
                                                        </div>
                                                        <div class="testimonial-content">
                                                            <?php if (!empty($item['vernex_testimonial_testimony_three_title'])) :   ?>
                                                                <span><?php echo esc_html($item['vernex_testimonial_testimony_three_title']) ?></span>
                                                            <?php endif ?>
                                                            <?php if (!empty($item['vernex_testimonial_testimony_three_content'])) :   ?>
                                                                <p><?php echo esc_html($item['vernex_testimonial_testimony_three_content']) ?></p>
                                                            <?php endif ?>
                                                            <div class="author-area">
                                                                <div class="author-content">
                                                                    <?php if (!empty($item['vernex_testimonial_author_three_name'])) :   ?>
                                                                        <h5><?php echo esc_html($item['vernex_testimonial_author_three_name']) ?></h5>
                                                                    <?php endif ?>
                                                                    <?php if (!empty($item['vernex_testimonial_author_three_designation'])) :   ?>
                                                                        <span><?php echo esc_html($item['vernex_testimonial_author_three_designation']) ?></span>
                                                                    <?php endif ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                    <div class="contact-btn-area">
                                        <?php if (!empty($settings['vernex_testimonial_author_grp_three_photos']['url'])) :   ?>
                                            <img src="<?php echo esc_url($settings['vernex_testimonial_author_grp_three_photos']['url']) ?>" alt="<?php echo esc_attr__('author-image', 'vernex-core') ?>">
                                        <?php endif ?>
                                        <?php if (!empty($settings['vernex_testimonial_button_three_text'])) :   ?>
                                            <a href="<?php echo esc_url($settings['vernex_testimonial_button_three_text_url']['url']) ?>" class="primary-btn">
                                                <?php echo esc_html($settings['vernex_testimonial_button_three_text']) ?>
                                                <svg viewBox="0 0 13 20">
                                                    <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                                </svg>
                                            </a>
                                        <?php endif ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="slider-btn-grp">
                            <div class="slider-btn testimonial-slider-prev">
                                <i class="bi bi-arrow-left"></i>
                            </div>
                            <div class="slider-btn testimonial-slider-next">
                                <i class="bi bi-arrow-right"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif ?>

        <?php if ($settings['vernex_testimonial_genaral_style_selection'] == 'style_four') : ?>
            <div class="home4-testimonial-section">
                <div class="row g-0">
                    <div class="col-xxl-7 col-xl-6 d-lg-block d-none">
                        <div class="swiper home4-testimonial-img-slider">
                            <div class="swiper-wrapper">
                                <?php foreach ($data4 as  $item) : ?>
                                    <div class="swiper-slide">
                                        <div class="testimonial-img">
                                            <div class="preview_image custom_animation">
                                                <div class='twentytwenty-container container1'>
                                                    <?php if (!empty($item['vernex_testimonial_testimony_content_four_before_image_sec']['url'])) :   ?>
                                                        <img src="<?php echo esc_url($item['vernex_testimonial_testimony_content_four_before_image_sec']['url']) ?>" alt="<?php echo esc_attr__('jn', 'vernex-core') ?>">
                                                    <?php endif ?>
                                                    <?php if (!empty($item['vernex_testimonial_testimony_content_four_after_image_sec']['url'])) :   ?>
                                                        <img src="<?php echo esc_url($item['vernex_testimonial_testimony_content_four_after_image_sec']['url']) ?>" alt="<?php echo esc_attr__('jn', 'vernex-core') ?>">
                                                    <?php endif ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-5 col-xl-6">
                        <div class="testimonial-content-area">
                            <div class="section-title2 text-center wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <?php if (!empty($settings['vernex_testimonial_four_title'])) :   ?>
                                    <h2><?php echo wp_kses($settings['vernex_testimonial_four_title'], wp_kses_allowed_html('post')); ?><span></span></h2>
                                <?php endif ?>
                            </div>
                            <div class="testimonial-card-area">
                                <div class="swiper home4-testimonial-content-slider">
                                    <div class="swiper-wrapper">
                                        <?php foreach ($data4 as  $item) : ?>
                                            <div class="swiper-slide">
                                                <div class="testimonial-content-wrap">
                                                    <svg class="quote" width="46" height="42" viewBox="0 0 126 127" xmlns="http://www.w3.org/2000/svg">
                                                        <g>
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M84.0557 118.313L84.0529 118.314C83.6215 118.418 83.0219 118.451 82.3838 118.395C81.7471 118.339 81.1484 118.202 80.7167 118.018L80.7078 118.015C80.3071 117.849 80.0305 117.699 79.7798 117.496C79.5267 117.291 79.257 116.997 78.9216 116.498C78.2281 115.467 77.3641 113.734 75.839 110.522C73.2229 105.023 72.9886 104.324 72.9064 103.17C72.7987 101.514 73.203 100.371 74.1027 99.4441L74.1083 99.4383L74.1139 99.4323C74.1141 99.4321 74.1148 99.4314 74.116 99.4302L74.1225 99.4238C74.1284 99.4182 74.1366 99.4106 74.1475 99.401C74.16 99.3899 74.1751 99.3771 74.1928 99.3625C74.2061 99.3516 74.221 99.3396 74.2375 99.3266C74.3146 99.2658 74.4159 99.1919 74.5419 99.1054C74.7941 98.9325 75.1215 98.7257 75.5061 98.4964C76.2737 98.0388 77.2375 97.5103 78.2179 97.0101C83.4212 94.3813 87.4554 91.5308 90.5928 88.1023C93.7355 84.668 95.9414 80.6943 97.5411 75.8698C98.9485 71.6139 99.9298 65.926 99.9298 61.8381L99.9298 59.0273L78.8402 59.0273L77.7603 58.4831C77.1487 58.1855 76.3686 57.5764 76.088 57.2229L76.0831 57.2166L76.078 57.2104C76.0525 57.1794 76.0281 57.1496 76.0045 57.1209C75.6527 56.6928 75.5001 56.5072 75.3667 56.1427C75.2093 55.7128 75.0764 55.0009 74.9895 53.5076C74.822 50.627 74.8391 45.2381 74.874 34.2966L74.8774 33.217L74.9504 12.2815L75.3747 11.4845C75.3749 11.4841 75.375 11.4838 75.3752 11.4835C75.6535 10.963 76.1264 10.3815 76.6813 9.8779C77.2417 9.36923 77.8094 9.00908 78.2408 8.85758C78.2432 8.85689 78.3123 8.83644 78.5084 8.81138C78.6973 8.78726 78.9636 8.76359 79.3342 8.74157C80.075 8.69756 81.1824 8.66293 82.8236 8.63662C86.1026 8.58406 91.4594 8.56543 100.16 8.56543L121.194 8.56543L121.978 8.98946C121.979 8.98966 121.979 8.98986 121.979 8.99006C123.037 9.56631 124.046 10.6106 124.542 11.5892L124.544 11.5924C124.628 11.7576 124.752 12.0455 124.822 14.6798C124.889 17.2268 124.914 21.7886 124.951 30.2661C125 41.0871 124.926 50.9069 124.755 54.3974L124.755 54.4011C124.203 66.6099 122.796 75.7923 120.063 83.3963C117.339 90.9789 113.28 97.0392 107.352 102.977L107.35 102.979C103.684 106.674 101.251 108.641 96.8965 111.559L96.8955 111.56C95.2427 112.671 92.432 114.269 89.797 115.65C88.4837 116.338 87.2268 116.965 86.1936 117.444C85.1268 117.939 84.3847 118.235 84.0557 118.313ZM122.456 8.11113L121.447 7.56543L100.16 7.56543C82.7614 7.56543 78.7008 7.63985 77.9134 7.9127C76.7075 8.33438 75.1817 9.72344 74.4927 11.0133L73.9512 12.0303L73.8774 33.2135C73.8129 53.5535 73.786 55.7338 74.7964 57.1987C74.943 57.4113 75.1114 57.6088 75.3048 57.8445C75.6985 58.3406 76.6091 59.0352 77.3227 59.3824L78.6024 60.0273L98.9298 60.0273L98.9298 61.8381C98.9298 65.8068 97.97 71.3879 96.5919 75.5551C93.4665 84.9809 88.0278 90.934 77.7657 96.1182C75.7723 97.1352 73.8282 98.2762 73.3852 98.7475C72.2532 99.9133 71.7856 101.352 71.9087 103.237C72.0071 104.626 72.3516 105.519 74.9356 110.951C77.9626 117.326 78.5286 118.194 80.3251 118.938C81.4325 119.41 83.1552 119.559 84.2872 119.286C86.0591 118.864 94.0571 114.672 97.4532 112.39C101.858 109.438 104.344 107.429 108.06 103.684C120.094 91.6285 124.647 78.9533 125.754 54.4463C125.926 50.924 126 41.0766 125.951 30.2617C125.877 13.3201 125.852 11.9559 125.434 11.1373C124.843 9.97148 123.687 8.78086 122.456 8.11113Z" />
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M49.0465 84.3359C43.4602 98.7971 30.8356 111.199 14.2734 118.492C11.1727 119.856 8.24415 119.385 6.49689 117.252C6.10314 116.756 4.50353 113.68 2.95314 110.455L2.93395 110.415C0.172048 104.626 0.123059 104.523 0.123059 102.815C0.147667 99.6404 1.13204 98.4746 5.66017 96.2918C14.4457 92.0254 19.6137 87.1885 23.0098 79.9951C24.6094 76.5969 25.4215 74.1412 26.1844 70.3213C26.6766 67.8408 27.3164 62.359 27.3164 60.4986C27.3164 60.0273 27.0457 60.0273 17.0297 60.0274L6.74297 60.0274L5.46329 59.3824C4.74962 59.0352 3.83907 58.3406 3.44532 57.8445C3.25197 57.6088 3.08352 57.4113 2.9369 57.1987C1.92656 55.7338 1.9535 53.5535 2.01797 33.2135L2.01805 33.1921C2.0918 12.0799 2.09198 12.0299 2.6086 11.0381C3.34688 9.67383 4.33125 8.70645 5.66016 8.08633C6.76758 7.56543 6.93985 7.56543 28.1777 7.56543L49.5879 7.56543L50.5969 8.11113C51.9012 8.80566 52.9594 9.87227 53.55 11.0877C53.993 11.9807 54.0176 12.9232 54.0176 33.7344C54.0176 56.3066 53.9191 59.3576 52.8856 67.4688C52.0734 73.9428 50.6461 80.2184 49.0465 84.3359ZM49.3348 8.56543L28.1777 8.56543C17.5503 8.56543 12.2143 8.56551 9.39297 8.63028C7.97395 8.66286 7.23998 8.71124 6.80305 8.77478C6.43084 8.82891 6.30838 8.88652 6.09262 8.98801L6.0858 8.99123L6.08302 8.99253C4.9693 9.51223 4.13762 10.3165 3.49168 11.5074C3.48872 11.513 3.48581 11.5186 3.48293 11.5241C3.39285 11.6966 3.34617 11.786 3.29678 12.1034C3.23397 12.507 3.1838 13.2077 3.14682 14.5993C3.07339 17.3625 3.05491 22.6414 3.01797 33.2167C3.01797 33.2165 3.01797 33.2168 3.01797 33.2167L3.01453 34.2966C2.97967 45.2381 2.96251 50.627 3.1301 53.5076C3.21698 55.0009 3.3499 55.7128 3.50729 56.1427C3.64068 56.5072 3.79324 56.6928 4.145 57.1209C4.16859 57.1496 4.19309 57.1794 4.21853 57.2104L4.22361 57.2166L4.22859 57.2229C4.50919 57.5764 5.28921 58.1856 5.90083 58.4832L6.98072 59.0274L17.103 59.0274C22.0464 59.0274 24.6317 59.0273 25.9737 59.0873C26.6041 59.1154 27.109 59.1587 27.46 59.2866C27.6656 59.3615 27.9532 59.5117 28.1435 59.8299C28.317 60.12 28.3165 60.4079 28.3164 60.4927L28.3164 60.4986C28.3164 62.4455 27.6653 67.9961 27.1653 70.5159L27.165 70.5171C26.3865 74.4152 25.5492 76.9483 23.9145 80.421L23.9141 80.4221C20.3993 87.8667 15.0379 92.8495 6.097 97.1913L6.0944 97.1926C3.82272 98.2877 2.62774 99.0475 1.96544 99.8284C1.36785 100.533 1.13491 101.342 1.12306 102.819C1.12309 103.251 1.12757 103.511 1.16441 103.772C1.19973 104.023 1.26996 104.306 1.43251 104.743C1.77244 105.656 2.45241 107.083 3.8551 110.023C4.62619 111.627 5.40859 113.192 6.04561 114.415C6.3645 115.027 6.64445 115.548 6.86687 115.944C6.97823 116.142 7.07238 116.304 7.14791 116.427C7.18562 116.489 7.21662 116.537 7.24119 116.574C7.25336 116.593 7.26296 116.606 7.27017 116.616C7.27379 116.622 7.27641 116.625 7.27806 116.627C8.66502 118.312 11.0628 118.812 13.8705 117.577C30.2331 110.372 42.6392 98.1473 48.1137 83.9756L48.1144 83.9738C49.6738 79.9597 51.087 73.7719 51.8933 67.3443L51.8936 67.3423C52.918 59.3034 53.0176 56.3138 53.0176 33.7344C53.0176 23.3224 53.0114 17.8979 52.9501 14.9626C52.8884 12.0022 52.7612 11.7469 52.6595 11.5427C52.6577 11.5392 52.6559 11.5356 52.6542 11.5321L52.6506 11.5248C52.1611 10.5174 51.2629 9.59872 50.1269 8.99379L49.3348 8.56543Z" />
                                                        </g>
                                                    </svg>
                                                    <?php if (!empty($item['vernex_testimonial_testimony_content_four_testimony_area_title'])) :   ?>
                                                        <span><?php echo esc_html($item['vernex_testimonial_testimony_content_four_testimony_area_title']) ?></span>
                                                    <?php endif ?>
                                                    <?php if (!empty($item['vernex_testimonial_testimony_content_four_testimony_area_desc'])) :   ?>
                                                        <p><?php echo esc_html($item['vernex_testimonial_testimony_content_four_testimony_area_desc']) ?></p>
                                                    <?php endif ?>
                                                    <div class="author-area">
                                                        <?php if (!empty($item['vernex_testimonial_testimony_content_four_testimony_author_area_image']['url'])) :   ?>
                                                            <div class="author-img">
                                                                <img src="<?php echo esc_url($item['vernex_testimonial_testimony_content_four_testimony_author_area_image']['url']) ?>" alt="<?php echo esc_attr__('jn', 'vernex-core') ?>">
                                                            </div>
                                                        <?php endif ?>
                                                        <div class="author-content">
                                                            <?php if (!empty($item['vernex_testimonial_testimony_content_four_testimony_author_area_name'])) :   ?>
                                                                <h5><?php echo esc_html($item['vernex_testimonial_testimony_content_four_testimony_author_area_name']) ?></h5>
                                                            <?php endif ?>
                                                            <?php if (!empty($item['vernex_testimonial_testimony_content_four_testimony_author_area_designation'])) :   ?>
                                                                <span><?php echo esc_html($item['vernex_testimonial_testimony_content_four_testimony_author_area_designation']) ?></span>
                                                            <?php endif ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                                <div class="slider-btn-grp">
                                    <div class="slider-btn home4-testimonial-prev">
                                        <i class="bi bi-arrow-left"></i>
                                    </div>
                                    <div class="slider-btn home4-testimonial-next">
                                        <i class="bi bi-arrow-right"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif ?>


        <?php if ($settings['vernex_testimonial_genaral_style_selection'] == 'style_five') : ?>
            <div class="home5-testimonial-section">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-5">
                            <?php if (!empty($settings['vernex_testimonial_testimony_content_five_banner_image_sec']['url'])) :   ?>
                                <div class="testimonial-img magnetic-item">
                                    <img src="<?php echo esc_url($settings['vernex_testimonial_testimony_content_five_banner_image_sec']['url']) ?>" alt="<?php echo esc_attr__('jn', 'vernex-core') ?>">
                                </div>
                            <?php endif ?>
                        </div>
                        <div class="col-lg-7">
                            <div class="testimonial-card-area">
                                <div class="swiper home5-testimonial-slider">
                                    <div class="swiper-wrapper">
                                        <?php foreach ($data5 as  $item) : ?>
                                            <div class="swiper-slide">
                                                <div class="testimonial-content-wrap">
                                                    <svg class="quote" width="46" height="42" viewBox="0 0 126 127" xmlns="http://www.w3.org/2000/svg">
                                                        <g>
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M84.0557 118.313L84.0529 118.314C83.6215 118.418 83.0219 118.451 82.3838 118.395C81.7471 118.339 81.1484 118.202 80.7167 118.018L80.7078 118.015C80.3071 117.849 80.0305 117.699 79.7798 117.496C79.5267 117.291 79.257 116.997 78.9216 116.498C78.2281 115.467 77.3641 113.734 75.839 110.522C73.2229 105.023 72.9886 104.324 72.9064 103.17C72.7987 101.514 73.203 100.371 74.1027 99.4441L74.1083 99.4383L74.1139 99.4323C74.1141 99.4321 74.1148 99.4314 74.116 99.4302L74.1225 99.4238C74.1284 99.4182 74.1366 99.4106 74.1475 99.401C74.16 99.3899 74.1751 99.3771 74.1928 99.3625C74.2061 99.3516 74.221 99.3396 74.2375 99.3266C74.3146 99.2658 74.4159 99.1919 74.5419 99.1054C74.7941 98.9325 75.1215 98.7257 75.5061 98.4964C76.2737 98.0388 77.2375 97.5103 78.2179 97.0101C83.4212 94.3813 87.4554 91.5308 90.5928 88.1023C93.7355 84.668 95.9414 80.6943 97.5411 75.8698C98.9485 71.6139 99.9298 65.926 99.9298 61.8381L99.9298 59.0273L78.8402 59.0273L77.7603 58.4831C77.1487 58.1855 76.3686 57.5764 76.088 57.2229L76.0831 57.2166L76.078 57.2104C76.0525 57.1794 76.0281 57.1496 76.0045 57.1209C75.6527 56.6928 75.5001 56.5072 75.3667 56.1427C75.2093 55.7128 75.0764 55.0009 74.9895 53.5076C74.822 50.627 74.8391 45.2381 74.874 34.2966L74.8774 33.217L74.9504 12.2815L75.3747 11.4845C75.3749 11.4841 75.375 11.4838 75.3752 11.4835C75.6535 10.963 76.1264 10.3815 76.6813 9.8779C77.2417 9.36923 77.8094 9.00908 78.2408 8.85758C78.2432 8.85689 78.3123 8.83644 78.5084 8.81138C78.6973 8.78726 78.9636 8.76359 79.3342 8.74157C80.075 8.69756 81.1824 8.66293 82.8236 8.63662C86.1026 8.58406 91.4594 8.56543 100.16 8.56543L121.194 8.56543L121.978 8.98946C121.979 8.98966 121.979 8.98986 121.979 8.99006C123.037 9.56631 124.046 10.6106 124.542 11.5892L124.544 11.5924C124.628 11.7576 124.752 12.0455 124.822 14.6798C124.889 17.2268 124.914 21.7886 124.951 30.2661C125 41.0871 124.926 50.9069 124.755 54.3974L124.755 54.4011C124.203 66.6099 122.796 75.7923 120.063 83.3963C117.339 90.9789 113.28 97.0392 107.352 102.977L107.35 102.979C103.684 106.674 101.251 108.641 96.8965 111.559L96.8955 111.56C95.2427 112.671 92.432 114.269 89.797 115.65C88.4837 116.338 87.2268 116.965 86.1936 117.444C85.1268 117.939 84.3847 118.235 84.0557 118.313ZM122.456 8.11113L121.447 7.56543L100.16 7.56543C82.7614 7.56543 78.7008 7.63985 77.9134 7.9127C76.7075 8.33438 75.1817 9.72344 74.4927 11.0133L73.9512 12.0303L73.8774 33.2135C73.8129 53.5535 73.786 55.7338 74.7964 57.1987C74.943 57.4113 75.1114 57.6088 75.3048 57.8445C75.6985 58.3406 76.6091 59.0352 77.3227 59.3824L78.6024 60.0273L98.9298 60.0273L98.9298 61.8381C98.9298 65.8068 97.97 71.3879 96.5919 75.5551C93.4665 84.9809 88.0278 90.934 77.7657 96.1182C75.7723 97.1352 73.8282 98.2762 73.3852 98.7475C72.2532 99.9133 71.7856 101.352 71.9087 103.237C72.0071 104.626 72.3516 105.519 74.9356 110.951C77.9626 117.326 78.5286 118.194 80.3251 118.938C81.4325 119.41 83.1552 119.559 84.2872 119.286C86.0591 118.864 94.0571 114.672 97.4532 112.39C101.858 109.438 104.344 107.429 108.06 103.684C120.094 91.6285 124.647 78.9533 125.754 54.4463C125.926 50.924 126 41.0766 125.951 30.2617C125.877 13.3201 125.852 11.9559 125.434 11.1373C124.843 9.97148 123.687 8.78086 122.456 8.11113Z" />
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M49.0465 84.3359C43.4602 98.7971 30.8356 111.199 14.2734 118.492C11.1727 119.856 8.24415 119.385 6.49689 117.252C6.10314 116.756 4.50353 113.68 2.95314 110.455L2.93395 110.415C0.172048 104.626 0.123059 104.523 0.123059 102.815C0.147667 99.6404 1.13204 98.4746 5.66017 96.2918C14.4457 92.0254 19.6137 87.1885 23.0098 79.9951C24.6094 76.5969 25.4215 74.1412 26.1844 70.3213C26.6766 67.8408 27.3164 62.359 27.3164 60.4986C27.3164 60.0273 27.0457 60.0273 17.0297 60.0274L6.74297 60.0274L5.46329 59.3824C4.74962 59.0352 3.83907 58.3406 3.44532 57.8445C3.25197 57.6088 3.08352 57.4113 2.9369 57.1987C1.92656 55.7338 1.9535 53.5535 2.01797 33.2135L2.01805 33.1921C2.0918 12.0799 2.09198 12.0299 2.6086 11.0381C3.34688 9.67383 4.33125 8.70645 5.66016 8.08633C6.76758 7.56543 6.93985 7.56543 28.1777 7.56543L49.5879 7.56543L50.5969 8.11113C51.9012 8.80566 52.9594 9.87227 53.55 11.0877C53.993 11.9807 54.0176 12.9232 54.0176 33.7344C54.0176 56.3066 53.9191 59.3576 52.8856 67.4688C52.0734 73.9428 50.6461 80.2184 49.0465 84.3359ZM49.3348 8.56543L28.1777 8.56543C17.5503 8.56543 12.2143 8.56551 9.39297 8.63028C7.97395 8.66286 7.23998 8.71124 6.80305 8.77478C6.43084 8.82891 6.30838 8.88652 6.09262 8.98801L6.0858 8.99123L6.08302 8.99253C4.9693 9.51223 4.13762 10.3165 3.49168 11.5074C3.48872 11.513 3.48581 11.5186 3.48293 11.5241C3.39285 11.6966 3.34617 11.786 3.29678 12.1034C3.23397 12.507 3.1838 13.2077 3.14682 14.5993C3.07339 17.3625 3.05491 22.6414 3.01797 33.2167C3.01797 33.2165 3.01797 33.2168 3.01797 33.2167L3.01453 34.2966C2.97967 45.2381 2.96251 50.627 3.1301 53.5076C3.21698 55.0009 3.3499 55.7128 3.50729 56.1427C3.64068 56.5072 3.79324 56.6928 4.145 57.1209C4.16859 57.1496 4.19309 57.1794 4.21853 57.2104L4.22361 57.2166L4.22859 57.2229C4.50919 57.5764 5.28921 58.1856 5.90083 58.4832L6.98072 59.0274L17.103 59.0274C22.0464 59.0274 24.6317 59.0273 25.9737 59.0873C26.6041 59.1154 27.109 59.1587 27.46 59.2866C27.6656 59.3615 27.9532 59.5117 28.1435 59.8299C28.317 60.12 28.3165 60.4079 28.3164 60.4927L28.3164 60.4986C28.3164 62.4455 27.6653 67.9961 27.1653 70.5159L27.165 70.5171C26.3865 74.4152 25.5492 76.9483 23.9145 80.421L23.9141 80.4221C20.3993 87.8667 15.0379 92.8495 6.097 97.1913L6.0944 97.1926C3.82272 98.2877 2.62774 99.0475 1.96544 99.8284C1.36785 100.533 1.13491 101.342 1.12306 102.819C1.12309 103.251 1.12757 103.511 1.16441 103.772C1.19973 104.023 1.26996 104.306 1.43251 104.743C1.77244 105.656 2.45241 107.083 3.8551 110.023C4.62619 111.627 5.40859 113.192 6.04561 114.415C6.3645 115.027 6.64445 115.548 6.86687 115.944C6.97823 116.142 7.07238 116.304 7.14791 116.427C7.18562 116.489 7.21662 116.537 7.24119 116.574C7.25336 116.593 7.26296 116.606 7.27017 116.616C7.27379 116.622 7.27641 116.625 7.27806 116.627C8.66502 118.312 11.0628 118.812 13.8705 117.577C30.2331 110.372 42.6392 98.1473 48.1137 83.9756L48.1144 83.9738C49.6738 79.9597 51.087 73.7719 51.8933 67.3443L51.8936 67.3423C52.918 59.3034 53.0176 56.3138 53.0176 33.7344C53.0176 23.3224 53.0114 17.8979 52.9501 14.9626C52.8884 12.0022 52.7612 11.7469 52.6595 11.5427C52.6577 11.5392 52.6559 11.5356 52.6542 11.5321L52.6506 11.5248C52.1611 10.5174 51.2629 9.59872 50.1269 8.99379L49.3348 8.56543Z" />
                                                        </g>
                                                    </svg>
                                                    <?php if (!empty($item['vernex_testimonial_testimony_content_five_testimony_area_title'])) :   ?>
                                                        <span><?php echo esc_html($item['vernex_testimonial_testimony_content_five_testimony_area_title']) ?></span>
                                                    <?php endif ?>
                                                    <?php if (!empty($item['vernex_testimonial_testimony_content_five_testimony_area_desc'])) :   ?>
                                                        <p><?php echo esc_html($item['vernex_testimonial_testimony_content_five_testimony_area_desc']) ?></p>
                                                    <?php endif ?>
                                                    <div class="author-area">
                                                        <?php if (!empty($item['vernex_testimonial_testimony_content_five_testimony_author_area_image']['url'])) :   ?>
                                                            <div class="author-img">
                                                                <img src="<?php echo esc_url($item['vernex_testimonial_testimony_content_five_testimony_author_area_image']['url']) ?>" alt="<?php echo esc_attr__('author-image', 'vernex-core') ?>">
                                                            </div>
                                                        <?php endif ?>
                                                        <div class="author-content">
                                                            <?php if (!empty($item['vernex_testimonial_testimony_content_five_testimony_author_area_name'])) :   ?>
                                                                <h5><?php echo esc_html($item['vernex_testimonial_testimony_content_five_testimony_author_area_name']) ?></h5>
                                                            <?php endif ?>
                                                            <?php if (!empty($item['vernex_testimonial_testimony_content_five_testimony_author_area_designation'])) :   ?>
                                                                <span><?php echo esc_html($item['vernex_testimonial_testimony_content_five_testimony_author_area_designation']) ?></span>
                                                            <?php endif ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                                <div class="slider-btn-grp">
                                    <div class="slider-btn home4-testimonial-prev">
                                        <i class="bi bi-arrow-left"></i>
                                    </div>
                                    <div class="slider-btn home4-testimonial-next">
                                        <i class="bi bi-arrow-right"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="logo-section">
                        <div class="logo-wrap">
                        <?php if (!empty($settings['vernex_testimonial_testimony_content_five_logo_area_title'])) :   ?>
                            <div class="logo-title">
                                <h6><?php echo esc_html($settings['vernex_testimonial_testimony_content_five_logo_area_title']) ?></h6>
                            </div>
                            <?php endif ?>
                            <div class="marquee">
                                <div class="marquee__group">
                                <?php foreach ($data9 as  $item) : ?>
                                    <a href="<?php echo esc_url($item['vernex_testimonial_testimony_content_five_logo_area_logo_url']['url']) ?>"><img src="<?php echo esc_url($item['vernex_testimonial_testimony_content_five_logo_area_logo']['url']) ?>" alt="<?php echo esc_attr__('Logo', 'vernex-core') ?>">
                                    </a>
                                    <?php endforeach; ?>
                                </div>
                                <div aria-hidden="true" class="marquee__group">
                                <?php foreach ($data9 as  $item) : ?>
                                    <a href="<?php echo esc_url($item['vernex_testimonial_testimony_content_five_logo_area_logo_url']['url']) ?>"><img src="<?php echo esc_url($item['vernex_testimonial_testimony_content_five_logo_area_logo']['url']) ?>" alt="<?php echo esc_attr__('Logo', 'vernex-core') ?>">
                                    </a>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif ?>


        <?php if ($settings['vernex_testimonial_genaral_style_selection'] == 'style_six') : ?>
            <div class="home6-testimonial-section">
                <div class="container">
                    <div class="row gy-5 align-items-center">
                        <div class="col-xl-4 col-lg-5 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="testimonial-content-wrap">
                                <div class="section-title">
                                    <?php if (!empty($settings['vernex_testimonial_testimony_six_general_title'])) :   ?>
                                        <h2><?php echo esc_html($settings['vernex_testimonial_testimony_six_general_title']) ?></h2>
                                    <?php endif ?>
                                    <?php if (!empty($settings['vernex_testimonial_testimony_six_general_content'])) :   ?>
                                        <p><?php echo esc_html($settings['vernex_testimonial_testimony_six_general_content']) ?></p>
                                    <?php endif ?>
                                </div>
                                <ul class="rating-area">
                                    <?php foreach ($data8 as  $item) : ?>
                                        <li>
                                            <a href="<?php echo esc_url($item['vernex_testimonial_six_genaral_review_link']['url']) ?>" class="single-rating">
                                                <div class="review">
                                                    <?php if (!empty($item['vernex_testimonial_six_genaral_review_title'])) :   ?>
                                                        <span><?php echo esc_html($item['vernex_testimonial_six_genaral_review_title']) ?></span>
                                                    <?php endif ?>
                                                    <?php if (!empty($item['vernex_testimonial_six_genaral_review_review_logo']['url'])) :   ?>
                                                        <img src="<?php echo esc_url($item['vernex_testimonial_six_genaral_review_review_logo']['url']) ?>" alt="<?php echo esc_attr__('author-image', 'vernex-core') ?>">
                                                    <?php endif ?>
                                                </div>
                                                <div class="rating">
                                                    <?php if ('general' == $item['vernex_testimonial_six_genaral_review_review_seelection']) { ?>
                                                        <ul class="star">
                                                            <?php $rank_counter = intval($item['vernex_testimonial_six_genaral_review_review_star']);
                                                            $rank_counter = max(0, min(5, $rank_counter)); ?>
                                                            <?php for ($i = 1; $i <= 5; $i++) : ?>
                                                                <?php if ($i <= $rank_counter) : ?>
                                                                    <li><i class="bi bi-star-fill"></i></li>
                                                                <?php endif ?>
                                                            <?php endfor; ?>
                                                        </ul>
                                                    <?php } ?>

                                                    <?php if ('others' == $item['vernex_testimonial_six_genaral_review_review_seelection']) { ?>
                                                        <ul class="tripadvisor">
                                                            <?php $rank_counter = intval($item['vernex_testimonial_six_genaral_review_review_star']);
                                                            $rank_counter = max(0, min(5, $rank_counter)); ?>
                                                            <?php for ($i = 1; $i <= 5; $i++) : ?>
                                                                <?php if ($i <= $rank_counter) : ?>
                                                                    <li><i class="bi bi-star-fill"></i></li>
                                                                <?php endif ?>
                                                            <?php endfor; ?>
                                                        </ul>
                                                    <?php } ?>
                                                    <span><?php echo esc_html($item['vernex_testimonial_six_genaral_review_total_num_sec']) ?></span>
                                                </div>
                                            </a>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                                <div class="contact-btn-area">
                                    <?php if (!empty($settings['vernex_testimonial_six_author_grp_photos']['url'])) :   ?>
                                        <img src="<?php echo esc_url($settings['vernex_testimonial_six_author_grp_photos']['url']) ?>" alt="<?php echo esc_attr__('author-image', 'vernex-core') ?>">
                                    <?php endif ?>
                                    <?php if (!empty($settings['vernex_testimonial_six_button_text'])) :   ?>
                                        <a href="<?php echo esc_url($settings['vernex_testimonial_six_button_text_url']['url']) ?>" class="primary-btn">
                                            <?php echo esc_html($settings['vernex_testimonial_six_button_text']) ?>
                                            <svg viewBox="0 0 13 20">
                                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                            </svg>
                                        </a>
                                    <?php endif ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-8 col-lg-7">
                            <div class="testimonial-card-area">
                                <div class="swiper home5-testimonial-slider">
                                    <div class="swiper-wrapper">
                                        <?php foreach ($data6 as  $item) : ?>
                                            <div class="swiper-slide">
                                                <div class="testimonial-content-wrap">
                                                    <svg class="quote" width="46" height="42" viewBox="0 0 126 127" xmlns="http://www.w3.org/2000/svg">
                                                        <g>
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M84.0557 118.313L84.0529 118.314C83.6215 118.418 83.0219 118.451 82.3838 118.395C81.7471 118.339 81.1484 118.202 80.7167 118.018L80.7078 118.015C80.3071 117.849 80.0305 117.699 79.7798 117.496C79.5267 117.291 79.257 116.997 78.9216 116.498C78.2281 115.467 77.3641 113.734 75.839 110.522C73.2229 105.023 72.9886 104.324 72.9064 103.17C72.7987 101.514 73.203 100.371 74.1027 99.4441L74.1083 99.4383L74.1139 99.4323C74.1141 99.4321 74.1148 99.4314 74.116 99.4302L74.1225 99.4238C74.1284 99.4182 74.1366 99.4106 74.1475 99.401C74.16 99.3899 74.1751 99.3771 74.1928 99.3625C74.2061 99.3516 74.221 99.3396 74.2375 99.3266C74.3146 99.2658 74.4159 99.1919 74.5419 99.1054C74.7941 98.9325 75.1215 98.7257 75.5061 98.4964C76.2737 98.0388 77.2375 97.5103 78.2179 97.0101C83.4212 94.3813 87.4554 91.5308 90.5928 88.1023C93.7355 84.668 95.9414 80.6943 97.5411 75.8698C98.9485 71.6139 99.9298 65.926 99.9298 61.8381L99.9298 59.0273L78.8402 59.0273L77.7603 58.4831C77.1487 58.1855 76.3686 57.5764 76.088 57.2229L76.0831 57.2166L76.078 57.2104C76.0525 57.1794 76.0281 57.1496 76.0045 57.1209C75.6527 56.6928 75.5001 56.5072 75.3667 56.1427C75.2093 55.7128 75.0764 55.0009 74.9895 53.5076C74.822 50.627 74.8391 45.2381 74.874 34.2966L74.8774 33.217L74.9504 12.2815L75.3747 11.4845C75.3749 11.4841 75.375 11.4838 75.3752 11.4835C75.6535 10.963 76.1264 10.3815 76.6813 9.8779C77.2417 9.36923 77.8094 9.00908 78.2408 8.85758C78.2432 8.85689 78.3123 8.83644 78.5084 8.81138C78.6973 8.78726 78.9636 8.76359 79.3342 8.74157C80.075 8.69756 81.1824 8.66293 82.8236 8.63662C86.1026 8.58406 91.4594 8.56543 100.16 8.56543L121.194 8.56543L121.978 8.98946C121.979 8.98966 121.979 8.98986 121.979 8.99006C123.037 9.56631 124.046 10.6106 124.542 11.5892L124.544 11.5924C124.628 11.7576 124.752 12.0455 124.822 14.6798C124.889 17.2268 124.914 21.7886 124.951 30.2661C125 41.0871 124.926 50.9069 124.755 54.3974L124.755 54.4011C124.203 66.6099 122.796 75.7923 120.063 83.3963C117.339 90.9789 113.28 97.0392 107.352 102.977L107.35 102.979C103.684 106.674 101.251 108.641 96.8965 111.559L96.8955 111.56C95.2427 112.671 92.432 114.269 89.797 115.65C88.4837 116.338 87.2268 116.965 86.1936 117.444C85.1268 117.939 84.3847 118.235 84.0557 118.313ZM122.456 8.11113L121.447 7.56543L100.16 7.56543C82.7614 7.56543 78.7008 7.63985 77.9134 7.9127C76.7075 8.33438 75.1817 9.72344 74.4927 11.0133L73.9512 12.0303L73.8774 33.2135C73.8129 53.5535 73.786 55.7338 74.7964 57.1987C74.943 57.4113 75.1114 57.6088 75.3048 57.8445C75.6985 58.3406 76.6091 59.0352 77.3227 59.3824L78.6024 60.0273L98.9298 60.0273L98.9298 61.8381C98.9298 65.8068 97.97 71.3879 96.5919 75.5551C93.4665 84.9809 88.0278 90.934 77.7657 96.1182C75.7723 97.1352 73.8282 98.2762 73.3852 98.7475C72.2532 99.9133 71.7856 101.352 71.9087 103.237C72.0071 104.626 72.3516 105.519 74.9356 110.951C77.9626 117.326 78.5286 118.194 80.3251 118.938C81.4325 119.41 83.1552 119.559 84.2872 119.286C86.0591 118.864 94.0571 114.672 97.4532 112.39C101.858 109.438 104.344 107.429 108.06 103.684C120.094 91.6285 124.647 78.9533 125.754 54.4463C125.926 50.924 126 41.0766 125.951 30.2617C125.877 13.3201 125.852 11.9559 125.434 11.1373C124.843 9.97148 123.687 8.78086 122.456 8.11113Z" />
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M49.0465 84.3359C43.4602 98.7971 30.8356 111.199 14.2734 118.492C11.1727 119.856 8.24415 119.385 6.49689 117.252C6.10314 116.756 4.50353 113.68 2.95314 110.455L2.93395 110.415C0.172048 104.626 0.123059 104.523 0.123059 102.815C0.147667 99.6404 1.13204 98.4746 5.66017 96.2918C14.4457 92.0254 19.6137 87.1885 23.0098 79.9951C24.6094 76.5969 25.4215 74.1412 26.1844 70.3213C26.6766 67.8408 27.3164 62.359 27.3164 60.4986C27.3164 60.0273 27.0457 60.0273 17.0297 60.0274L6.74297 60.0274L5.46329 59.3824C4.74962 59.0352 3.83907 58.3406 3.44532 57.8445C3.25197 57.6088 3.08352 57.4113 2.9369 57.1987C1.92656 55.7338 1.9535 53.5535 2.01797 33.2135L2.01805 33.1921C2.0918 12.0799 2.09198 12.0299 2.6086 11.0381C3.34688 9.67383 4.33125 8.70645 5.66016 8.08633C6.76758 7.56543 6.93985 7.56543 28.1777 7.56543L49.5879 7.56543L50.5969 8.11113C51.9012 8.80566 52.9594 9.87227 53.55 11.0877C53.993 11.9807 54.0176 12.9232 54.0176 33.7344C54.0176 56.3066 53.9191 59.3576 52.8856 67.4688C52.0734 73.9428 50.6461 80.2184 49.0465 84.3359ZM49.3348 8.56543L28.1777 8.56543C17.5503 8.56543 12.2143 8.56551 9.39297 8.63028C7.97395 8.66286 7.23998 8.71124 6.80305 8.77478C6.43084 8.82891 6.30838 8.88652 6.09262 8.98801L6.0858 8.99123L6.08302 8.99253C4.9693 9.51223 4.13762 10.3165 3.49168 11.5074C3.48872 11.513 3.48581 11.5186 3.48293 11.5241C3.39285 11.6966 3.34617 11.786 3.29678 12.1034C3.23397 12.507 3.1838 13.2077 3.14682 14.5993C3.07339 17.3625 3.05491 22.6414 3.01797 33.2167C3.01797 33.2165 3.01797 33.2168 3.01797 33.2167L3.01453 34.2966C2.97967 45.2381 2.96251 50.627 3.1301 53.5076C3.21698 55.0009 3.3499 55.7128 3.50729 56.1427C3.64068 56.5072 3.79324 56.6928 4.145 57.1209C4.16859 57.1496 4.19309 57.1794 4.21853 57.2104L4.22361 57.2166L4.22859 57.2229C4.50919 57.5764 5.28921 58.1856 5.90083 58.4832L6.98072 59.0274L17.103 59.0274C22.0464 59.0274 24.6317 59.0273 25.9737 59.0873C26.6041 59.1154 27.109 59.1587 27.46 59.2866C27.6656 59.3615 27.9532 59.5117 28.1435 59.8299C28.317 60.12 28.3165 60.4079 28.3164 60.4927L28.3164 60.4986C28.3164 62.4455 27.6653 67.9961 27.1653 70.5159L27.165 70.5171C26.3865 74.4152 25.5492 76.9483 23.9145 80.421L23.9141 80.4221C20.3993 87.8667 15.0379 92.8495 6.097 97.1913L6.0944 97.1926C3.82272 98.2877 2.62774 99.0475 1.96544 99.8284C1.36785 100.533 1.13491 101.342 1.12306 102.819C1.12309 103.251 1.12757 103.511 1.16441 103.772C1.19973 104.023 1.26996 104.306 1.43251 104.743C1.77244 105.656 2.45241 107.083 3.8551 110.023C4.62619 111.627 5.40859 113.192 6.04561 114.415C6.3645 115.027 6.64445 115.548 6.86687 115.944C6.97823 116.142 7.07238 116.304 7.14791 116.427C7.18562 116.489 7.21662 116.537 7.24119 116.574C7.25336 116.593 7.26296 116.606 7.27017 116.616C7.27379 116.622 7.27641 116.625 7.27806 116.627C8.66502 118.312 11.0628 118.812 13.8705 117.577C30.2331 110.372 42.6392 98.1473 48.1137 83.9756L48.1144 83.9738C49.6738 79.9597 51.087 73.7719 51.8933 67.3443L51.8936 67.3423C52.918 59.3034 53.0176 56.3138 53.0176 33.7344C53.0176 23.3224 53.0114 17.8979 52.9501 14.9626C52.8884 12.0022 52.7612 11.7469 52.6595 11.5427C52.6577 11.5392 52.6559 11.5356 52.6542 11.5321L52.6506 11.5248C52.1611 10.5174 51.2629 9.59872 50.1269 8.99379L49.3348 8.56543Z" />
                                                        </g>
                                                    </svg>
                                                    <?php if (!empty($item['vernex_testimonial_testimony_six_title'])) :   ?>
                                                        <span> <?php echo esc_html($item['vernex_testimonial_testimony_six_title']) ?></span>
                                                    <?php endif ?>
                                                    <?php if (!empty($item['vernex_testimonial_testimony_six_content'])) :   ?>
                                                        <p><?php echo esc_html($item['vernex_testimonial_testimony_six_content']) ?></p>
                                                    <?php endif ?>
                                                    <div class="author-area">
                                                        <?php if (!empty($item['vernex_testimonial_author_six_image']['url'])) :   ?>
                                                            <div class="author-img">
                                                                <img src="<?php echo esc_url($item['vernex_testimonial_author_six_image']['url']) ?>" alt="<?php echo esc_attr__('author-image', 'vernex-core') ?>">
                                                            </div>
                                                        <?php endif ?>
                                                        <div class="author-content">
                                                            <?php if (!empty($item['vernex_testimonial_author_six_name'])) :   ?>
                                                                <h5><?php echo esc_html($item['vernex_testimonial_author_six_name']) ?></h5>
                                                            <?php endif ?>
                                                            <?php if (!empty($item['vernex_testimonial_author_six_designation'])) :   ?>
                                                                <span><?php echo esc_html($item['vernex_testimonial_author_six_designation']) ?></span>
                                                            <?php endif ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                                <div class="slider-btn-grp">
                                    <div class="slider-btn home4-testimonial-prev">
                                        <i class="bi bi-arrow-left"></i>
                                    </div>
                                    <div class="slider-btn home4-testimonial-next">
                                        <i class="bi bi-arrow-right"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif ?>
<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Testimonial_Widget());
