<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Team_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_team';
    }

    public function get_title()
    {
        return esc_html__('EG Team', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_team_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );


        $this->add_control(
            'vernex_team_section_genaral_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),
                    'style_three' => esc_html__('Style Three', 'vernex-core'),
                    'style_four' => esc_html__('Style Four', 'vernex-core'),
                    'style_five' => esc_html__('Style Five', 'vernex-core'),
                    'style_six' => esc_html__('Style Six', 'vernex-core'),

                ],
                'default' => 'style_one',
            ]
        );

        $this->add_control(
            'vernex_team_section_genaral_show_pagination',
            [
                'label' => esc_html__("Show Pagination?", 'vernex-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vernex-core'),
                'label_off' => esc_html__('No', 'vernex-core'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_one', 'style_three', 'style_four'],
                ]
            ]
        );


        $this->add_control(
            'vernex_team_section_genaral_subtitle',
            [
                'label'       => esc_html__('Subtitle', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('The Vernex Team', 'vernex-core'),
                'placeholder' => esc_html__('write your subtitle here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_one', 'style_two', 'style_three', 'style_four'],
                ]
            ]
        );

        $this->add_control(
            'vernex_team_section_genaral_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Our Talented Team.', 'vernex-core'),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_one', 'style_two', 'style_three', 'style_four', 'style_five'],
                ]
            ]
        );

        $this->add_control(
            'vernex_team_section_genaral_description',
            [
                'label'       => esc_html__('Description', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default'     => esc_html__('Sed nisl eros, condimentum nec risus sit amet, finibus conguese.Fusen fringilla est libero sed tempus urna feugiat eu. Curabitur eu feugiat ligu Suspendisse.', 'vernex-core'),
                'placeholder' => esc_html__('write your description here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_three'],
                ]
            ]
        );

        $this->add_control(
            'vernex_team_section_style_one_genaral_title',
            [
                'label'       => esc_html__('Button Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__("Let’s Talk With Us", 'vernex-core'),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_two'],
                ]
            ]
        );

        $this->add_control(
            'vernex_team_section_style_one_genaral_title_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_two'],
                ]
            ]
        );

        $this->add_control(
            'vernex_team_section_genaral_founder_area',
            [
                'label'     => esc_html__('Founder Area', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_one'],
                ]
            ]
        );

        $this->add_control(
            'vernex_team_section_genaral_founder_area_author_image',
            [
                'label' => esc_html__('Author Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),

                ],
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_one'],
                ]
            ]
        );


        $this->add_control(
            'vernex_team_section_genaral_founder_area_author_description',
            [
                'label'       => esc_html__('Author Description', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default'     => esc_html__('We understand your needs and deliver digitaloi marketing through unique selling oneto homeles proposition Our team of expert', 'vernex-core'),
                'placeholder' => esc_html__('write your description here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_one'],
                ]
            ]
        );

        $this->add_control(
            'vernex_team_section_genaral_founder_area_author_designation',
            [
                'label'       => esc_html__('Designation', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Founder at, Vernex', 'vernex-core'),
                'placeholder' => esc_html__('write your designation here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_one'],
                ]
            ]
        );

        $this->add_control(
            'vernex_team_section_genaral_founder_area_author_name',
            [
                'label'       => esc_html__('Name', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Nathan Joshua', 'vernex-core'),
                'placeholder' => esc_html__('write your name here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_one'],
                ]
            ]
        );

        $this->add_control(
            'vernex_team_section_genaral_team_list_area',
            [
                'label'     => esc_html__('Team List Area', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',

            ]
        );

        // Repeater
        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'vernex_team_section_style_one_genaral_team_author_image',
            [
                'label'     => esc_html__('Author Image', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::MEDIA,
                'default'   => [
                    'url'   => \Elementor\Utils::get_placeholder_image_src(),
                ]
            ]
        );

        // accordion title
        $repeater->add_control(
            'vernex_team_section_style_one_genaral_team_author_name',
            [
                'label' => esc_html__('Name', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Eliason Jacob'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your name here', 'vernex-core'),
            ]
        );

        // accordion Description
        $repeater->add_control(
            'vernex_team_section_style_one_genaral_team_author_designation',
            [
                'label' => esc_html__('Designation', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Founder at, Nexaq'),
                'placeholder' => esc_html__('Type your designation here', 'vernex-core'),
            ]
        );


        $this->add_control(
            'vernex_team_section_style_one_genaral_team_list',
            [
                'label' => esc_html__('Team List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'vernex_team_section_style_one_genaral_team_author_name' => esc_html('Eliason Jacob'),
                        'vernex_team_section_style_one_genaral_team_author_designation' => esc_html('Engineers'),

                    ],
                    [
                        'vernex_team_section_style_one_genaral_team_author_name' => esc_html('Mateob Henry'),
                        'vernex_team_section_style_one_genaral_team_author_designation' => esc_html('Architects'),

                    ],
                    [
                        'vernex_team_section_style_one_genaral_team_author_name' => esc_html('Caleb Cooper'),
                        'vernex_team_section_style_one_genaral_team_author_designation' => esc_html('Safety Officers'),

                    ],
                    [
                        'vernex_team_section_style_one_genaral_team_author_name' => esc_html('Olivern James'),
                        'vernex_team_section_style_one_genaral_team_author_designation' => esc_html('Project Manager'),

                    ],
                    [
                        'vernex_team_section_style_one_genaral_team_author_name' => esc_html('Michael Daniel'),
                        'vernex_team_section_style_one_genaral_team_author_designation' => esc_html('Project Manager'),

                    ],


                ],
                'title_field' => '{{{ vernex_team_section_style_one_genaral_team_author_name }}}',
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_one', 'style_four', 'style_six'],
                ]

            ]
        );


        //syle_two content

        // Repeater
        $team_two = new \Elementor\Repeater();

        $team_two->add_control(
            'vernex_team_section_style_two_genaral_team_author_image',
            [
                'label'     => esc_html__('Author Image', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::MEDIA,
                'default'   => [
                    'url'   => \Elementor\Utils::get_placeholder_image_src(),
                ]
            ]
        );

        // accordion title
        $team_two->add_control(
            'vernex_team_section_style_two_genaral_team_author_name',
            [
                'label' => esc_html__('Name', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Cassian Coleson'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your name here', 'vernex-core'),
            ]
        );

        // accordion Description
        $team_two->add_control(
            'vernex_team_section_style_two_genaral_team_author_designation',
            [
                'label' => esc_html__('Designation', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Founder at, Nexaq'),
                'placeholder' => esc_html__('Type your designation here', 'vernex-core'),
            ]
        );


        $team_two->add_control(
            'vernex_team_section_style_two_genaral_team_social_icon',
            [
                'label'     => esc_html__('Social Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => [
                    'value' => 'bx bxl-linkedin',
                    'library' => 'solid',
                ]
            ]
        );

        // accordion Description
        $team_two->add_control(
            'vernex_team_section_style_two_genaral_team_author_social_text',
            [
                'label' => esc_html__('Social Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Linkedin'),
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );


        $team_two->add_control(
            'vernex_team_section_style_two_genaral_team_author_social',
            [
                'label' => esc_html__('Linkedin', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_team_section_style_two_genaral_team_list',
            [
                'label' => esc_html__('Team List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $team_two->get_controls(),
                'default' => [
                    [
                        'vernex_team_section_style_two_genaral_team_author_name' => esc_html('Cassian Coleson'),
                        'vernex_team_section_style_two_genaral_team_author_designation' => esc_html('Founder at, Nexaq'),

                    ],
                    [
                        'vernex_team_section_style_two_genaral_team_author_name' => esc_html('Sebastian Jack'),
                        'vernex_team_section_style_two_genaral_team_author_designation' => esc_html('Web Designer, Nexaq'),

                    ],
                    [
                        'vernex_team_section_style_two_genaral_team_author_name' => esc_html('Violet Scarlett'),
                        'vernex_team_section_style_two_genaral_team_author_designation' => esc_html('UI/UX Designer'),

                    ],
                    [
                        'vernex_team_section_style_two_genaral_team_author_name' => esc_html('Michael Daniel'),
                        'vernex_team_section_style_two_genaral_team_author_designation' => esc_html('Software Developer'),

                    ],


                ],
                'title_field' => '{{{ vernex_team_section_style_two_genaral_team_author_name }}}',
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_two', 'style_five'],
                ]
            ]
        );

        // Repeater
        $team_three = new \Elementor\Repeater();

        $team_three->add_control(
            'vernex_team_section_style_three_genaral_team_author_image',
            [
                'label'     => esc_html__('Author Image', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::MEDIA,
                'default'   => [
                    'url'   => \Elementor\Utils::get_placeholder_image_src(),
                ]
            ]
        );

        // accordion title
        $team_three->add_control(
            'vernex_team_section_style_three_genaral_team_author_name',
            [
                'label' => esc_html__('Name', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Eliason Jacob'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your name here', 'vernex-core'),
            ]
        );

        // accordion Description
        $team_three->add_control(
            'vernex_team_section_style_three_genaral_team_author_designation',
            [
                'label' => esc_html__('Designation', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Founder at, Nexaq'),
                'placeholder' => esc_html__('Type your designation here', 'vernex-core'),
            ]
        );


        // start popcover
        $team_three->add_control(
            'popover_toggle_social',
            [
                'type' => \Elementor\Controls_Manager::POPOVER_TOGGLE,
                'label' => esc_html__('Social Media', 'vernex-core'),
                'label_off' => esc_html('Default'),
                'label_on' => esc_html__('Custom', 'vernex-core'),
                'return_value' => 'yes',
            ]
        );

        $team_three->start_popover();

        $team_three->add_control(
            'website_link_facebook',
            [
                'label' => esc_html__('Facebook', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'default' => [
                    'url' => 'https://www.facebook.com/',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $team_three->add_control(
            'website_link_twitter',
            [
                'label' => esc_html__('Twitter', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'default' => [
                    'url' => 'https://twitter.com/',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $team_three->add_control(
            'website_link_pinterest',
            [
                'label' => esc_html__('Pinterest', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'default' => [
                    'url' => 'https://www.pinterest.com/',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $team_three->add_control(
            'website_link_instagram',
            [
                'label' => esc_html__('Instagram', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'default' => [
                    'url' => 'https://www.instagram.com/',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        //linkedin Link
        $team_three->add_control(
            'website_link_linkedin',
            [
                'label' => esc_html__('Linkedin', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        //reddit Link
        $team_three->add_control(
            'website_link_reddit',
            [
                'label' => esc_html__('Reddit', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        //behance Link
        $team_three->add_control(
            'website_link_behance',
            [
                'label' => esc_html__('Behance', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        //stackoverflow Link
        $team_three->add_control(
            'website_link_stackoverflow',
            [
                'label' => esc_html__('Stackoverflow', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $team_three->end_popover();


        $this->add_control(
            'vernex_team_section_style_three_genaral_team_list',
            [
                'label' => esc_html__('Team List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $team_three->get_controls(),
                'default' => [
                    [
                        'vernex_team_section_style_three_genaral_team_author_name' => esc_html('Eliason Jacob'),
                        'vernex_team_section_style_one_genaral_team_author_designation' => esc_html('Engineers'),

                    ],
                    [
                        'vernex_team_section_style_three_genaral_team_author_name' => esc_html('Mateob Henry'),
                        'vernex_team_section_style_three_genaral_team_author_designation' => esc_html('Architects'),

                    ],
                    [
                        'vernex_team_section_style_three_genaral_team_author_name' => esc_html('Caleb Cooper'),
                        'vernex_team_section_style_three_genaral_team_author_designation' => esc_html('Safety Officers'),

                    ],
                    [
                        'vernex_team_section_style_three_genaral_team_author_name' => esc_html('Olivern James'),
                        'vernex_team_section_style_three_genaral_team_author_designation' => esc_html('Project Manager'),

                    ],
                    [
                        'vernex_team_section_style_three_genaral_team_author_name' => esc_html('Michael Daniel'),
                        'vernex_team_section_style_three_genaral_team_author_designation' => esc_html('Project Manager'),

                    ],


                ],
                'title_field' => '{{{ vernex_team_section_style_three_genaral_team_author_name }}}',
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_three'],
                ]

            ]
        );

        $this->add_control(
            'vernex_team_section_genaral_style_five_counter_area',
            [
                'label'     => esc_html__('Counter Area', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_five'],
                ]

            ]
        );

        // Repeater
        $counter = new \Elementor\Repeater();


        $counter->add_control(
            'vernex_team_style_five_counter_number',
            [
                'label' => esc_html__('Counter Number', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('45'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your number here', 'vernex-core'),
            ]
        );

        $counter->add_control(
            'vernex_team_style_five_counter_sign',
            [
                'label' => esc_html__('Counter Sign', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('+'),
                'placeholder' => esc_html__('Type your sign here', 'vernex-core'),
            ]
        );

        $counter->add_control(
            'vernex_team_style_five_counter_title',
            [
                'label' => esc_html__('Counter Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('FGreen Spaces'),
                'placeholder' => esc_html__('Type your title here', 'vernex-core'),
            ]
        );


        $this->add_control(
            'vernex_team_section_style_five_genaral_counter_list',
            [
                'label' => esc_html__('Counter List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $counter->get_controls(),
                'default' => [
                    [
                        'vernex_team_style_five_counter_number' => esc_html('45'),
                        'vernex_team_style_five_counter_sign' => esc_html('+'),
                        'vernex_team_style_five_counter_title' => esc_html('Green Spaces'),

                    ],
                    [
                        'vernex_team_style_five_counter_number' => esc_html('15'),
                        'vernex_team_style_five_counter_sign' => esc_html(''),
                        'vernex_team_style_five_counter_title' => esc_html('Skilled Professionals'),

                    ],
                    [
                        'vernex_team_style_five_counter_number' => esc_html('5'),
                        'vernex_team_style_five_counter_sign' => esc_html(''),
                        'vernex_team_style_five_counter_title' => esc_html('Years of Experience'),

                    ],
                    [
                        'vernex_team_style_five_counter_number' => esc_html('2'),
                        'vernex_team_style_five_counter_sign' => esc_html('M'),
                        'vernex_team_style_five_counter_title' => esc_html('Square Meters'),

                    ],


                ],
                'title_field' => '{{{ vernex_team_style_five_counter_number }}}',
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_five'],
                ]
            ]
        );

        $this->end_controls_section();



        //style start
        $this->start_controls_section(
            'vernex_team_style_one_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_one'],
                ]
            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_one_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_subtitle_after_color',
            [
                'label'     => esc_html__('After Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_one_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_founder_author_description',
            [
                'label'     => esc_html__('Founder Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_one_general_founder_author_description_typ',
                'selector' => '{{WRAPPER}} .home1-team-section .founder-card .founder-content p',

            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_founder_author_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-team-section .founder-card .founder-content p' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_team_style_one_general_founder_author_designation',
            [
                'label'     => esc_html__('Founder Designation', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_one_general_founder_author_designation_typ',
                'selector' => '{{WRAPPER}} .home1-team-section .founder-card .founder-content .name-and-desig span',

            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_founder_author_designation_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-team-section .founder-card .founder-content .name-and-desig span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_founder_author_name',
            [
                'label'     => esc_html__('Founder Name', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_one_general_founder_author_name_typ',
                'selector' => '{{WRAPPER}} .home1-team-section .founder-card .founder-content .name-and-desig h5',

            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_founder_author_name_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-team-section .founder-card .founder-content .name-and-desig h5' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_team_pagination',
            [
                'label'     => esc_html__('Pagination', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_one_general_team_pagination_typ',
                'selector' => '{{WRAPPER}} .slider-btn-grp .slider-btn i',

            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_team_pagination_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-btn-grp .slider-btn i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_team_pagination_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-btn-grp .slider-btn:hover i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_team_pagination_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-btn-grp .slider-btn' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_team_pagination_hover_background_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-btn-grp .slider-btn:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_team_author_name',
            [
                'label'     => esc_html__('Team Author Name', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_one_general_team_author_name_typ',
                'selector' => '{{WRAPPER}} .team-card .team-content h5',

            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_team_author_name_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-card .team-content h5' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_team_author_designation',
            [
                'label'     => esc_html__('Team Author Designation', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_one_general_team_author_designation_typ',
                'selector' => '{{WRAPPER}} .team-card .team-content span',

            ]
        );

        $this->add_control(
            'vernex_team_style_one_general_team_author_designation_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-card .team-content span' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();


        //style start
        $this->start_controls_section(
            'vernex_team_style_two_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_two'],
                ]
            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_two_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title.two span',

            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.two span' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_team_style_two_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_two_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title.white h2',

            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.white h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_two_general_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn.white',

            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn.white' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_button_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-team-section .team-title-area .contact-btn:hover .primary-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn.white svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_button_hover_icon_color',
            [
                'label'     => esc_html__('Hover Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-team-section .team-title-area .contact-btn:hover .primary-btn svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_button_icon_color_after',
            [
                'label'     => esc_html__('Icon Color After', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn.white::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_button_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-team-section .team-title-area .contact-btn .bg svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_button_hover_bg_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-team-section .team-title-area .contact-btn:hover .bg svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_button_bg_border_color',
            [
                'label'     => esc_html__('Background Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-team-section .team-title-area .contact-btn .bg svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_team_style_two_general_button_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn.white' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_team_desingnation',
            [
                'label'     => esc_html__('Designation', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_two_general_team_desingnation_typ',
                'selector' => '{{WRAPPER}} .home2-team-section .team-card2 .team-content span',

            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_team_desingnation_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-team-section .team-card2 .team-content span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_team_name',
            [
                'label'     => esc_html__('Name', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_two_general_team_name_typ',
                'selector' => '{{WRAPPER}} .home2-team-section .team-card2 .team-content h5',

            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_team_name_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-team-section .team-card2 .team-content h5' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_team_social',
            [
                'label'     => esc_html__('Social', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_two_general_team_social_typ',
                'selector' => '{{WRAPPER}} .home2-team-section .team-card2 .team-img .overlay .social-area > span',

            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_team_social_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-team-section .team-card2 .team-img .overlay .social-area > span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_team_sociadl_icon_bg_color',
            [
                'label'     => esc_html__('Icon Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-team-section .team-card2 .team-img .overlay .social-area .icon span' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_team_style_two_general_team_social_icon_hover_bg_color',
            [
                'label'     => esc_html__('Hover Icon Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-team-section .team-card2 .team-img .overlay .social-area:hover .icon span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_team_social_icon_bg_color',
            [
                'label'     => esc_html__('Icon Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-team-section .team-card2 .team-img .overlay .social-area:hover .icon span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_team_social_left_border_color',
            [
                'label'     => esc_html__('Left Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-team-section .team-card2 .team-img .overlay .social-area > span' => 'border-left: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_two_general_team_social_hover_bg_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-team-section .team-card2 .team-img .overlay .social-area::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_team_style_three_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_three'],
                ]
            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_three_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_subtitle_after_color',
            [
                'label'     => esc_html__('After Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_three_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_description',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_three_general_description_typ',
                'selector' => '{{WRAPPER}} .section-title p',

            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_designation',
            [
                'label'     => esc_html__('Designation', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_three_general_designation_typ',
                'selector' => '{{WRAPPER}} .team-card3 .team-content span',

            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_designation_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-card3 .team-content span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_name',
            [
                'label'     => esc_html__('Name', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_three_general_name_typ',
                'selector' => '{{WRAPPER}} .team-card3 .team-content h5',

            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_name_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-card3 .team-content h5' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_social',
            [
                'label'     => esc_html__('Social', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_three_general_social_typ',
                'selector' => '{{WRAPPER}} .team-card3 .social-list li a',

            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_social_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-card3 .social-list li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_social_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-card3 .social-list li a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_pagination',
            [
                'label'     => esc_html__('Pagination', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_three_general_pagination_typ',
                'selector' => '{{WRAPPER}} .home3-team-section .pagination-area .swiper-pagination1 .swiper-pagination-bullet',

            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_pagination_inactive_color',
            [
                'label'     => esc_html__('InActive Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-team-section .pagination-area .swiper-pagination1 .swiper-pagination-bullet::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_pagination_active_color',
            [
                'label'     => esc_html__('Active Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-team-section .pagination-area .swiper-pagination1 .swiper-pagination-bullet.swiper-pagination-bullet-active::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_three_general_pagination_border_active_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-team-section .pagination-area .swiper-pagination1 .swiper-pagination-bullet' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_team_style_four_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_four'],
                ]
            ]
        );

        $this->add_control(
            'vernex_team_style_four_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_four_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title.four span',

            ]
        );

        $this->add_control(
            'vernex_team_style_four_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.four span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_four_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_four_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title.four h2',

            ]
        );

        $this->add_control(
            'vernex_team_style_four_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.four h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_four_general_pagination',
            [
                'label'     => esc_html__('Pagination', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_four_general_pagination_typ',
                'selector' => '{{WRAPPER}} .slider-btn-grp .slider-btn i',

            ]
        );

        $this->add_control(
            'vernex_team_style_four_general_pagination_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-btn-grp .slider-btn i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_four_general_pagination_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-btn-grp .slider-btn:hover i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_four_general_pagination_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-btn-grp .slider-btn' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_four_general_pagination_hover_background_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-btn-grp .slider-btn:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_team_style_four_general_designation',
            [
                'label'     => esc_html__('Designation', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_four_general_designation_typ',
                'selector' => '{{WRAPPER}} .team-card .team-content span',

            ]
        );

        $this->add_control(
            'vernex_team_style_four_general_designation_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-card .team-content span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_four_general_author_name',
            [
                'label'     => esc_html__('Name', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_four_general_author_name_typ',
                'selector' => '{{WRAPPER}} .team-card .team-content h5',

            ]
        );

        $this->add_control(
            'vernex_team_style_four_general_author_name_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-card .team-content h5' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_team_style_five_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_five'],
                ]
            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_five_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_counter_number',
            [
                'label'     => esc_html__('Counter Number', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_five_general_counter_number_typ',
                'selector' => '{{WRAPPER}} .home6-team-section .counter-area .single-counter .number h2',

            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_counter_number_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-team-section .counter-area .single-counter .number h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_counter_sign',
            [
                'label'     => esc_html__('Counter Sign', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_five_general_counter_sign_typ',
                'selector' => '{{WRAPPER}} .home6-team-section .counter-area .single-counter .number span',

            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_counter_sign_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-team-section .counter-area .single-counter .number span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_counter_title',
            [
                'label'     => esc_html__('Counter Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_five_general_counter_title_typ',
                'selector' => '{{WRAPPER}} .home6-team-section .counter-area .single-counter > span',

            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_counter_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-team-section .counter-area .single-counter > span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_author_designation',
            [
                'label'     => esc_html__('Author Designation', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_five_general_author_designation_typ',
                'selector' => '{{WRAPPER}} .home6-team-section .team-wrap .team-card4 .team-content span',

            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_author_designation_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-team-section .team-wrap .team-card4 .team-content span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_author_name',
            [
                'label'     => esc_html__('Author Name', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_five_general_author_name_typ',
                'selector' => '{{WRAPPER}} .home6-team-section .team-wrap .team-card4 .team-content h5',

            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_author_name_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-team-section .team-wrap .team-card4 .team-content h5' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_social',
            [
                'label'     => esc_html__('Social', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_five_general_social_typ',
                'selector' => '{{WRAPPER}} .home6-team-section .team-wrap .team-card4 .team-img .social-wrap .social-area > span',

            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_social_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-team-section .team-wrap .team-card4 .team-img .social-wrap .social-area > span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_social_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-team-section .team-wrap .team-card4 .team-img .social-wrap .social-area:hover > span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_social_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-team-section .team-wrap .team-card4 .team-img .social-wrap .social-area' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_team_style_five_general_social_hover_bg_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-team-section .team-wrap .team-card4 .team-img .social-wrap .social-area::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_team_style_five_general_social_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-team-section .team-wrap .team-card4 .team-img .social-wrap .social-area .icon span i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_social_icon_hover_color',
            [
                'label'     => esc_html__('Icon Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-team-section .team-wrap .team-card4 .team-img .social-wrap .social-area:hover .icon span i' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_team_style_five_general_social_icon_bg_color',
            [
                'label'     => esc_html__('Icon Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-team-section .team-wrap .team-card4 .team-img .social-wrap .social-area .icon span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_five_general_social_icon_hover_bg_color',
            [
                'label'     => esc_html__('Icon Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-team-section .team-wrap .team-card4 .team-img .social-wrap .social-area:hover .icon span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_team_style_six_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_team_section_genaral_style_selection' => ['style_six'],
                ]
            ]
        );

        $this->add_control(
            'vernex_team_style_six_general_team_designation',
            [
                'label'     => esc_html__('Author Designation', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_six_general_team_designation_typ',
                'selector' => '{{WRAPPER}} .team-card .team-content span',

            ]
        );

        $this->add_control(
            'vernex_team_style_six_general_team_designation_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-card .team-content span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_team_style_six_general_team_name',
            [
                'label'     => esc_html__('Author Name', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_team_style_six_general_team_name_typ',
                'selector' => '{{WRAPPER}} .team-card .team-content h5',

            ]
        );

        $this->add_control(
            'vernex_team_style_six_general_team_name_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-card .team-content h5' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $team_list = $settings['vernex_team_section_style_one_genaral_team_list'];
        $team_two = $settings['vernex_team_section_style_two_genaral_team_list'];
        $team_three = $settings['vernex_team_section_style_three_genaral_team_list'];
        $counters = $settings['vernex_team_section_style_five_genaral_counter_list'];
?>

        <?php if (is_admin()) : ?>
            <script>
                var swiper = new Swiper(".home1-team-slider", {
                    slidesPerView: 1,
                    speed: 1500,
                    spaceBetween: 25,
                    autoplay: {
                        delay: 2500, // Autoplay duration in milliseconds
                        disableOnInteraction: false,
                    },
                    navigation: {
                        nextEl: ".team-slider-next",
                        prevEl: ".team-slider-prev",
                    },
                    breakpoints: {
                        280: {
                            slidesPerView: 1,
                        },
                        386: {
                            slidesPerView: 1,
                        },
                        576: {
                            slidesPerView: 2,
                            spaceBetween: 15,
                        },
                        768: {
                            slidesPerView: 3,
                            spaceBetween: 15,
                        },
                        992: {
                            slidesPerView: 3,
                        },
                        1200: {
                            slidesPerView: 4,
                        },
                        1400: {
                            slidesPerView: 4,
                        },
                    },
                });

                var swiper = new Swiper(".home3-team-slider", {
                    slidesPerView: 1,
                    speed: 1500,
                    spaceBetween: 25,
                    autoplay: {
                        delay: 2500, // Autoplay duration in milliseconds
                        disableOnInteraction: false,
                    },
                    pagination: {
                        el: ".swiper-pagination1",
                        clickable: true,
                    },
                    breakpoints: {
                        280: {
                            slidesPerView: 1,
                        },
                        386: {
                            slidesPerView: 1,
                        },
                        576: {
                            slidesPerView: 1,
                            spaceBetween: 15,
                        },
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 15,
                        },
                        992: {
                            slidesPerView: 3,
                        },
                        1200: {
                            slidesPerView: 3,
                        },
                        1400: {
                            slidesPerView: 3,
                        },
                    },
                });
            </script>

        <?php endif; ?>


        <?php if ($settings['vernex_team_section_genaral_style_selection'] == 'style_one') : ?>
            <div class="home1-team-section">
                <div class="container">
                    <div class="row gy-5 align-items-center justify-content-between mb-70">
                        <div class="col-lg-4 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="section-title">
                                <?php if (!empty($settings['vernex_team_section_genaral_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_team_section_genaral_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_team_section_genaral_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_team_section_genaral_title']); ?></h2>
                                <?php endif; ?>
                            </div>
                            <?php if ($settings['vernex_team_section_genaral_show_pagination'] ==  'yes') : ?>
                                <div class="slider-btn-grp d-lg-flex d-none">
                                    <div class="slider-btn team-slider-prev">
                                        <i class="bi bi-arrow-left"></i>
                                    </div>
                                    <div class="slider-btn team-slider-next">
                                        <i class="bi bi-arrow-right"></i>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-xxl-7 col-lg-8 wow animate fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="founder-card">
                                <?php if (!empty($settings['vernex_team_section_genaral_founder_area_author_image']['url'])) : ?>
                                    <div class="founder-img">
                                        <img src="<?php echo esc_url($settings['vernex_team_section_genaral_founder_area_author_image']['url']); ?>" alt="<?php echo esc_attr__('author-image', 'vernex-core'); ?>">
                                    </div>
                                <?php endif; ?>
                                <div class="founder-content">
                                    <?php if (!empty($settings['vernex_team_section_genaral_founder_area_author_description'])) : ?>
                                        <p><?php echo esc_html($settings['vernex_team_section_genaral_founder_area_author_description']); ?></p>
                                    <?php endif; ?>
                                    <div class="name-and-desig">
                                        <?php if (!empty($settings['vernex_team_section_genaral_founder_area_author_designation'])) : ?>
                                            <span><?php echo esc_html($settings['vernex_team_section_genaral_founder_area_author_designation']); ?></span>
                                        <?php endif; ?>
                                        <?php if (!empty($settings['vernex_team_section_genaral_founder_area_author_name'])) : ?>
                                            <h5><?php echo esc_html($settings['vernex_team_section_genaral_founder_area_author_name']); ?></h5>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php if ($settings['vernex_team_section_genaral_show_pagination'] == 'yes') : ?>
                                <div class="slider-btn-grp d-lg-none d-flex">
                                    <div class="slider-btn team-slider-prev">
                                        <i class="bi bi-arrow-left"></i>
                                    </div>
                                    <div class="slider-btn team-slider-next">
                                        <i class="bi bi-arrow-right"></i>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="swiper home1-team-slider">
                                <div class="swiper-wrapper">
                                    <?php foreach ($team_list as $team) : ?>
                                        <div class="swiper-slide">
                                            <div class="team-card">
                                                <?php if (!empty($team['vernex_team_section_style_one_genaral_team_author_image']['url'])) : ?>
                                                    <div class="team-img">
                                                        <img src="<?php echo esc_url($team['vernex_team_section_style_one_genaral_team_author_image']['url']); ?>" alt="<?php echo esc_attr__('author-image', 'vernex-core'); ?>">
                                                    </div>
                                                <?php endif; ?>
                                                <div class="team-content">
                                                    <?php if (!empty($team['vernex_team_section_style_one_genaral_team_author_designation'])) : ?>
                                                        <span><?php echo esc_html($team['vernex_team_section_style_one_genaral_team_author_designation']); ?></span>
                                                    <?php endif; ?>
                                                    <?php if (!empty($team['vernex_team_section_style_one_genaral_team_author_name'])) : ?>
                                                        <h5><?php echo esc_html($team['vernex_team_section_style_one_genaral_team_author_name']); ?></h5>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_team_section_genaral_style_selection'] == 'style_two') : ?>
            <div class="home2-team-section">
                <div class="container-fluid">
                    <div class="row gy-5 justify-content-between">
                        <div class="col-xl-4">
                            <div class="team-title-area">
                                <div class="section-title two white wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                    <?php if (!empty($settings['vernex_team_section_genaral_subtitle'])) : ?>
                                        <span><?php echo esc_html($settings['vernex_team_section_genaral_subtitle']); ?></span>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_team_section_genaral_title'])) : ?>
                                        <h2><?php echo esc_html($settings['vernex_team_section_genaral_title']); ?></h2>
                                    <?php endif; ?>
                                </div>

                                <?php if (!empty($settings['vernex_team_section_style_one_genaral_title'])) : ?>
                                    <div class="btn_wrapper">
                                        <a href="<?php echo esc_url($settings['vernex_team_section_style_one_genaral_title_url']['url']); ?>" class="contact-btn">
                                            <div class="bg">
                                                <svg width="207" height="125" viewBox="0 0 207 125"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M98.8179 1.5383C101.859 0.539043 105.141 0.539044 108.182 1.5383L115.855 4.05941C117.923 4.73874 120.114 4.96 122.275 4.70783L131.126 3.67539C134.545 3.27661 137.996 4.06554 140.902 5.90984L145.258 8.67445C147.363 10.0106 149.768 10.8008 152.255 10.9738L159.459 11.4747C163.687 11.7687 167.593 13.8378 170.212 17.1704L170.462 17.488C172.457 20.0276 175.22 21.8552 178.337 22.699L183.857 24.1929C187.414 25.1554 190.121 28.0448 190.85 31.6562C191.42 34.48 193.213 36.9058 195.745 38.2797L199.268 40.1913C202.457 41.9219 203.937 45.6977 202.773 49.1345C201.883 51.7612 202.525 54.6647 204.439 56.6713L204.693 56.9365C207.663 60.0506 207.663 64.9494 204.693 68.0635L204.439 68.3287C202.525 70.3353 201.883 73.2388 202.773 75.8655C203.937 79.3023 202.457 83.0781 199.268 84.8087L195.745 86.7203C193.213 88.0942 191.42 90.52 190.85 93.3438C190.121 96.9552 187.414 99.8446 183.857 100.807L178.337 102.301C175.219 103.145 172.457 104.972 170.462 107.512L170.212 107.83C167.593 111.162 163.687 113.231 159.459 113.525L152.255 114.026C149.768 114.199 147.363 114.989 145.258 116.326L140.902 119.09C137.996 120.934 134.545 121.723 131.126 121.325L122.275 120.292C120.114 120.04 117.923 120.261 115.855 120.941L108.182 123.462C105.141 124.461 101.859 124.461 98.8179 123.462L91.1446 120.941C89.0769 120.261 86.8862 120.04 84.7245 120.292L75.874 121.325C72.4554 121.723 69.0038 120.934 66.0979 119.09L61.7421 116.326C59.6369 114.989 57.2319 114.199 54.7446 114.026L47.5415 113.525C43.3132 113.231 39.4067 111.162 36.7879 107.83L36.5383 107.512C34.5426 104.972 31.7805 103.145 28.6628 102.301L23.1426 100.807C19.5863 99.8446 16.8791 96.9552 16.1499 93.3438C15.5797 90.52 13.7871 88.0942 11.255 86.7203L7.73223 84.8087C4.54288 83.0781 3.06307 79.3023 4.22717 75.8655C5.11688 73.2388 4.47481 70.3353 2.56049 68.3287L2.3075 68.0635C-0.663316 64.9494 -0.663313 60.0506 2.3075 56.9365L2.5605 56.6713C4.47481 54.6647 5.11688 51.7612 4.22717 49.1345C3.06307 45.6977 4.54288 41.9219 7.73223 40.1913L11.255 38.2797C13.7871 36.9058 15.5797 34.48 16.1499 31.6562C16.8791 28.0448 19.5863 25.1554 23.1426 24.1929L28.6628 22.699C31.7805 21.8552 34.5426 20.0276 36.5383 17.488L36.7879 17.1704C39.4067 13.8378 43.3132 11.7687 47.5415 11.4747L54.7446 10.9738C57.2319 10.8008 59.6369 10.0106 61.7421 8.67445L66.0979 5.90983C69.0038 4.06554 72.4554 3.27661 75.874 3.67539L84.7245 4.70783C86.8862 4.96 89.0769 4.73874 91.1446 4.05941L98.8179 1.5383Z" />
                                                    <path
                                                        d="M98.974 2.01332C101.914 1.04737 105.086 1.04737 108.026 2.01332L115.699 4.53443C117.836 5.2364 120.1 5.46503 122.333 5.20446L131.184 4.17202C134.489 3.78654 137.825 4.54917 140.634 6.33199L144.99 9.0966C147.165 10.4772 149.65 11.2939 152.221 11.4726L159.424 11.9735C163.511 12.2577 167.287 14.2578 169.819 17.4793L170.212 17.1704L169.819 17.4793L170.069 17.797C172.131 20.4212 174.985 22.3097 178.207 23.1816L183.727 24.6756C187.1 25.5886 189.668 28.3294 190.36 31.7551C190.959 34.7241 192.844 37.2746 195.507 38.7192L199.029 40.6307C202.005 42.2453 203.385 45.7678 202.299 48.9741C201.35 51.777 202.035 54.8752 204.078 57.0165L204.439 56.6713L204.078 57.0165L204.331 57.2817C207.117 60.2026 207.117 64.7974 204.331 67.7183L204.078 67.9835C202.035 70.1248 201.35 73.223 202.299 76.0259C203.385 79.2322 202.005 82.7547 199.029 84.3693L195.507 86.2808C192.844 87.7254 190.959 90.2759 190.36 93.2449C189.668 96.6706 187.1 99.4114 183.727 100.324L178.207 101.818C174.985 102.69 172.131 104.579 170.069 107.203L169.819 107.521C167.287 110.742 163.511 112.742 159.424 113.027L152.221 113.527C149.65 113.706 147.165 114.523 144.99 115.903L140.634 118.668C137.825 120.451 134.489 121.213 131.184 120.828L122.333 119.796C120.1 119.535 117.836 119.764 115.699 120.466L108.026 122.987C105.086 123.953 101.914 123.953 98.974 122.987L91.3006 120.466C89.1641 119.764 86.9004 119.535 84.6666 119.796L75.816 120.828C72.5114 121.213 69.1748 120.451 66.3659 118.668L62.01 115.903C59.8347 114.523 57.3495 113.706 54.7793 113.527L47.5762 113.027C43.4889 112.742 39.7126 110.742 37.181 107.521L36.9314 107.203C34.8692 104.579 32.015 102.69 28.7934 101.818L23.2732 100.324C19.8997 99.4114 17.3317 96.6706 16.64 93.2449C16.0405 90.2759 14.1557 87.7254 11.4935 86.2808L7.97069 84.3692C4.99528 82.7547 3.61473 79.2322 4.70075 76.0259C5.65013 73.223 4.96499 70.1248 2.92227 67.9835L2.66928 67.7183C-0.117241 64.7974 -0.117239 60.2026 2.66928 57.2817L2.92227 57.0165C4.96499 54.8752 5.65013 51.777 4.70075 48.9741C3.61473 45.7678 4.99528 42.2453 7.9707 40.6307L11.4935 38.7192C14.1557 37.2746 16.0405 34.7241 16.64 31.7551C17.3317 28.3294 19.8997 25.5886 23.2732 24.6756L28.7934 23.1816C32.015 22.3097 34.8692 20.4212 36.9314 17.7969L37.181 17.4793C39.7126 14.2578 43.4889 12.2577 47.5762 11.9735L54.7793 11.4726C57.3495 11.2939 59.8347 10.4772 62.01 9.0966L66.3659 6.33199C69.1748 4.54917 72.5115 3.78654 75.816 4.17202L84.6666 5.20446C86.9004 5.46503 89.1641 5.2364 91.3006 4.53443L98.974 2.01332Z"
                                                        stroke-opacity="0.2" />
                                                </svg>
                                            </div>
                                            <div class="primary-btn white">
                                                <?php echo esc_html($settings['vernex_team_section_style_one_genaral_title']); ?>
                                                <svg viewBox="0 0 13 20">
                                                    <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                                </svg>
                                            </div>
                                        </a>
                                    </div>
                                <?php endif ?>
                            </div>
                        </div>
                        <div class="col-xl-8">
                            <div class="row g-md-0 gy-5 team-border">
                                <?php $classes = array('d-flex justify-content-center team-divider', 'd-flex justify-content-center team-divider', 'd-flex justify-content-center', 'd-flex justify-content-center team-divider', 'd-flex justify-content-center team-divider', 'd-flex justify-content-center');
                                $classes_two = array('pb-35 magnetic-item', 'pb-35 magnetic-item', 'pb-35 magnetic-item', 'pt-35 magnetic-item', 'pt-35 magnetic-item', 'pt-35 magnetic-item');
                                $class_count = count($classes);
                                $class_count_two = count($classes_two);
                                foreach ($team_two as $index => $team) : // Use $index from the foreach loop
                                    $class = $classes[$index % $class_count]; // Get class based on current index 
                                    $class_two = $classes_two[$index % $class_count_two]; // Get class based on current index 
                                ?>
                                    <div class="col-md-4 col-sm-6 <?php echo $class; ?>">
                                        <div class="team-card2 <?php echo $class_two; ?>">
                                            <div class="team-img">
                                                <img src="<?php echo esc_url($team['vernex_team_section_style_two_genaral_team_author_image']['url']); ?>" alt="<?php echo esc_attr__('author-image', 'vernex-core'); ?>">
                                                <div class="overlay">
                                                    <a href="<?php echo esc_url($team['vernex_team_section_style_two_genaral_team_author_social']['url']); ?>" class="social-area">
                                                        <?php if (!empty($team['vernex_team_section_style_two_genaral_team_social_icon'])) : ?>
                                                            <div class="icon">
                                                                <span><?php \Elementor\Icons_Manager::render_icon($team['vernex_team_section_style_two_genaral_team_social_icon']); ?></span>
                                                            </div>
                                                        <?php endif; ?>
                                                        <?php if (!empty($team['vernex_team_section_style_two_genaral_team_author_social_text'])) : ?>
                                                            <span><?php echo esc_html($team['vernex_team_section_style_two_genaral_team_author_social_text']); ?></span>
                                                        <?php endif; ?>
                                                    </a>
                                                </div>
                                            </div>
                                            <div class="team-content">
                                                <?php if (!empty($team['vernex_team_section_style_two_genaral_team_author_designation'])) : ?>
                                                    <span><?php echo esc_html($team['vernex_team_section_style_two_genaral_team_author_designation']); ?></span>
                                                <?php endif; ?>
                                                <?php if (!empty($team['vernex_team_section_style_two_genaral_team_author_name'])) : ?>
                                                    <h5><?php echo esc_html($team['vernex_team_section_style_two_genaral_team_author_name']); ?></h5>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if ($settings['vernex_team_section_genaral_style_selection'] == 'style_three') : ?>
                <div class="home3-team-section">
                    <div class="container">
                        <div class="row justify-content-center mb-70 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="col-xl-7 col-lg-8">
                                <div class="section-title three text-center">
                                    <?php if (!empty($settings['vernex_team_section_genaral_subtitle'])) : ?>
                                        <span><?php echo esc_html($settings['vernex_team_section_genaral_subtitle']); ?></span>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_team_section_genaral_title'])) : ?>
                                        <h2><?php echo esc_html($settings['vernex_team_section_genaral_title']); ?></h2>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_team_section_genaral_description'])) : ?>
                                        <p><?php echo esc_html($settings['vernex_team_section_genaral_description']); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="swiper home3-team-slider">
                                    <div class="swiper-wrapper">
                                        <?php foreach ($team_three as $team) : ?>
                                            <div class="swiper-slide">
                                                <div class="team-card3">
                                                    <div class="team-img">
                                                        <img src="<?php echo esc_url($team['vernex_team_section_style_three_genaral_team_author_image']['url']); ?>" alt="<?php echo esc_attr__('author-image', 'vernex-core'); ?>">
                                                    </div>
                                                    <div class="team-content">
                                                        <?php if (!empty($team['vernex_team_section_style_three_genaral_team_author_designation'])) : ?>
                                                            <span><?php echo esc_html($team['vernex_team_section_style_three_genaral_team_author_designation']); ?></span>
                                                        <?php endif; ?>
                                                        <?php if (!empty($team['vernex_team_section_style_three_genaral_team_author_name'])) : ?>
                                                            <h5><?php echo esc_html($team['vernex_team_section_style_three_genaral_team_author_name']); ?></h5>
                                                        <?php endif; ?>
                                                    </div>
                                                    <ul class="social-list">
                                                        <?php if (!empty($team['website_link_instagram']['url'])) : ?>
                                                            <li>
                                                                <a href="<?php echo esc_url($team['website_link_instagram']['url']); ?>"><i class="bx bxl-instagram"></i></a>
                                                            </li>
                                                        <?php endif; ?>
                                                        <?php if (!empty($team['website_link_pinterest']['url'])) : ?>
                                                            <li>
                                                                <a href="<?php echo esc_url($team['website_link_pinterest']['url']); ?>"><i class="bx bxl-pinterest-alt"></i></a>
                                                            </li>
                                                        <?php endif; ?>
                                                        <?php if (!empty($team['website_link_twitter']['url'])) : ?>
                                                            <li>
                                                                <a href="<?php echo esc_url($team['website_link_twitter']['url']); ?>"><i class="bi bi-twitter-x"></i></a>
                                                            </li>
                                                        <?php endif; ?>
                                                        <?php if (!empty($team['website_link_facebook']['url'])) : ?>
                                                            <li>
                                                                <a href="<?php echo esc_url($team['website_link_facebook']['url']); ?>"><i class="bx bxl-facebook"></i></a>
                                                            </li>
                                                        <?php endif; ?>
                                                        <?php if (!empty($team['website_link_linkedin']['url'])) : ?>
                                                            <li>
                                                                <a href="<?php echo esc_url($team['website_link_linkedin']['url']) ?>"><i class='bx bxl-linkedin'></i></a>
                                                            </li>
                                                        <?php endif; ?>
                                                        <?php if (!empty($team['website_link_stackoverflow']['url'])) : ?>
                                                            <li>
                                                                <a href="<?php echo esc_url($team['website_link_stackoverflow']['url']) ?>"><i class='bx bxl-stack-overflow'></i></a>
                                                            </li>
                                                        <?php endif; ?>
                                                        <?php if (!empty($team['website_link_behance']['url'])) : ?>
                                                            <li>
                                                                <a href="<?php echo esc_url($team['website_link_behance']['url']) ?>"><i class='bx bxl-behance'></i></a>
                                                            </li>
                                                        <?php endif; ?>
                                                        <?php if (!empty($team['website_link_reddit']['url'])) : ?>
                                                            <li>
                                                                <a href="<?php echo esc_url($team['website_link_reddit']['url']) ?>"><i class='bx bxl-reddit'></i></a>
                                                            </li>
                                                        <?php endif; ?>
                                                    </ul>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php if ($settings['vernex_team_section_genaral_show_pagination'] == 'yes') : ?>
                            <div class="row pt-50">
                                <div class="col-lg-12 d-flex justify-content-center">
                                    <div class="pagination-area">
                                        <div class="swiper-pagination1"></div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>

            <?php if ($settings['vernex_team_section_genaral_style_selection'] == 'style_four') : ?>
                <div class="home5-team-section">
                    <div class="container">
                        <div class="row g-4 align-items-end justify-content-between mb-70 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="col-xl-6 col-lg-7">
                                <div class="section-title four">
                                    <?php if (!empty($settings['vernex_team_section_genaral_subtitle'])) : ?>
                                        <span><?php echo esc_html($settings['vernex_team_section_genaral_subtitle']); ?></span>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_team_section_genaral_title'])) : ?>
                                        <h2><?php echo esc_html($settings['vernex_team_section_genaral_title']); ?></h2>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php if ($settings['vernex_team_section_genaral_show_pagination'] == 'yes') : ?>
                                <div class="col-lg-3 d-flex justify-content-lg-end">
                                    <div class="slider-btn-grp">
                                        <div class="slider-btn team-slider-prev">
                                            <i class="bi bi-arrow-left"></i>
                                        </div>
                                        <div class="slider-btn team-slider-next">
                                            <i class="bi bi-arrow-right"></i>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="row justify-content-xl-end">
                            <div class="col-xl-10">
                                <div class="swiper home1-team-slider">
                                    <div class="swiper-wrapper">
                                        <?php foreach ($team_list as $team) : ?>
                                            <div class="swiper-slide">
                                                <div class="team-card">
                                                    <?php if (!empty($team['vernex_team_section_style_one_genaral_team_author_image']['url'])) : ?>
                                                        <div class="team-img">
                                                            <img src="<?php echo esc_url($team['vernex_team_section_style_one_genaral_team_author_image']['url']); ?>" alt="<?php echo esc_attr__('author-image', 'vernex-core'); ?>">
                                                        </div>
                                                    <?php endif; ?>
                                                    <div class="team-content">
                                                        <?php if (!empty($team['vernex_team_section_style_one_genaral_team_author_designation'])) : ?>
                                                            <span><?php echo esc_html($team['vernex_team_section_style_one_genaral_team_author_designation']); ?></span>
                                                        <?php endif; ?>
                                                        <?php if (!empty($team['vernex_team_section_style_one_genaral_team_author_name'])) : ?>
                                                            <h5><?php echo esc_html($team['vernex_team_section_style_one_genaral_team_author_name']); ?></h5>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if ($settings['vernex_team_section_genaral_style_selection'] == 'style_five') : ?>
                <div class="home6-team-section">
                    <div class="row g-0">
                        <div class="col-xl-4">
                            <div class="counter-area">
                                <div class="row gy-md-0 gy-4 divider justify-content-between">
                                    <?php $classes = array('', 'd-flex justify-content-sm-end', '', 'd-flex justify-content-sm-end');
                                    $classes_two = array('', 'pl-55', 'two', 'two');
                                    $class_count = count($classes);
                                    $class_count_two = count($classes_two);
                                    foreach ($counters as $index => $counter) : // Use $index from the foreach loop
                                        $class = $classes[$index % $class_count]; // Get class based on current index 
                                        $class_two = $classes_two[$index % $class_count_two]; // Get class based on current index 
                                    ?>
                                        <div class="col-sm-6 <?php echo $class; ?>">
                                            <div class="single-counter <?php echo $class_two; ?>">
                                                <div class="number">
                                                    <?php if (!empty($counter['vernex_team_style_five_counter_number'])) : ?>
                                                        <h2 class="counter"><?php echo esc_html($counter['vernex_team_style_five_counter_number']); ?></h2>
                                                    <?php endif; ?>
                                                    <?php if (!empty($counter['vernex_team_style_five_counter_sign'])) : ?>
                                                        <span><?php echo esc_html($counter['vernex_team_style_five_counter_sign']); ?></span>
                                                    <?php endif; ?>
                                                </div>
                                                <?php if (!empty($counter['vernex_team_style_five_counter_title'])) : ?>
                                                    <span><?php echo esc_html($counter['vernex_team_style_five_counter_title']); ?></span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-8">
                            <div class="team-wrap">
                                <div class="row mb-60 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                    <?php if (!empty($settings['vernex_team_section_genaral_title'])) : ?>
                                        <div class="col-xxl-8 col-lg-10">
                                            <div class="section-title">
                                                <h2><?php echo esc_html($settings['vernex_team_section_genaral_title']); ?></h2>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="team-card-area">
                                    <div class="row g-md-0 g-4 team-border">
                                        <?php $classes = array('team-divider', 'd-flex justify-content-md-center team-divider', 'd-flex justify-content-md-end', 'team-divider', 'd-flex justify-content-md-center team-divider', 'd-flex justify-content-md-end');
                                        $classes_two = array('pb-35 magnetic-item', 'pb-35 magnetic-item', 'pb-35 magnetic-item', 'pt-35 magnetic-item', 'pt-35 magnetic-item', 'pt-35 magnetic-item');
                                        $class_count = count($classes);
                                        $class_count_two = count($classes_two);
                                        foreach ($team_two as $index => $team) : // Use $index from the foreach loop
                                            $class = $classes[$index % $class_count]; // Get class based on current index 
                                            $class_two = $classes_two[$index % $class_count_two]; // Get class based on current index 
                                        ?>
                                            <div class="col-md-4 col-sm-6 <?php echo $class; ?>">
                                                <div class="team-card4 <?php echo $class_two; ?>">

                                                    <div class="team-img">
                                                        <?php if (!empty($team['vernex_team_section_style_two_genaral_team_author_image']['url'])) : ?>
                                                            <img src="<?php echo esc_url($team['vernex_team_section_style_two_genaral_team_author_image']['url']); ?>" alt="<?php echo esc_attr__('author-image', 'vernex-core'); ?>">
                                                        <?php endif; ?>
                                                        <div class="social-wrap">
                                                            <a href="<?php echo esc_url($team['vernex_team_section_style_two_genaral_team_author_social']['url']); ?>" class="social-area">
                                                                <?php if (!empty($team['vernex_team_section_style_two_genaral_team_social_icon'])) : ?>
                                                                    <div class="icon">
                                                                        <span><?php \Elementor\Icons_Manager::render_icon($team['vernex_team_section_style_two_genaral_team_social_icon']); ?></span>
                                                                    </div>
                                                                <?php endif; ?>
                                                                <?php if (!empty($team['vernex_team_section_style_two_genaral_team_author_social_text'])) : ?>
                                                                    <span><?php echo esc_html($team['vernex_team_section_style_two_genaral_team_author_social_text']); ?></span>
                                                                <?php endif; ?>
                                                            </a>
                                                        </div>
                                                    </div>
                                                    <div class="team-content">
                                                        <?php if (!empty($team['vernex_team_section_style_two_genaral_team_author_designation'])) : ?>
                                                            <span><?php echo esc_html($team['vernex_team_section_style_two_genaral_team_author_designation']); ?></span>
                                                        <?php endif; ?>
                                                        <?php if (!empty($team['vernex_team_section_style_two_genaral_team_author_name'])) : ?>
                                                            <h5><?php echo esc_html($team['vernex_team_section_style_two_genaral_team_author_name']); ?></h5>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>


            <?php if ($settings['vernex_team_section_genaral_style_selection'] == 'style_six') : ?>
                <div class="team-page">
                    <div class="container">
                        <div class="row gy-5">
                            <?php foreach ($team_list as $team) : ?>
                                <div class="col-xl-3 col-md-4 col-sm-6 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                    <div class="team-card magnetic-item">
                                        <?php if (!empty($team['vernex_team_section_style_one_genaral_team_author_image']['url'])) : ?>
                                            <div class="team-img">
                                                <img src="<?php echo esc_url($team['vernex_team_section_style_one_genaral_team_author_image']['url']); ?>" alt="">
                                            </div>
                                        <?php endif; ?>
                                        <div class="team-content">
                                            <?php if (!empty($team['vernex_team_section_style_one_genaral_team_author_designation'])) : ?>
                                                <span><?php echo esc_html($team['vernex_team_section_style_one_genaral_team_author_designation']); ?></span>
                                            <?php endif; ?>
                                            <?php if (!empty($team['vernex_team_section_style_one_genaral_team_author_name'])) : ?>
                                                <h5><?php echo esc_html($team['vernex_team_section_style_one_genaral_team_author_name']); ?></h5>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

    <?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Team_Widget());
