<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Support_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_support';
    }

    public function get_title()
    {
        return esc_html__('EG Support', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_support_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );


        $this->add_control(
            'vernex_support_section_genaral_subtitle',
            [
                'label'       => esc_html__('Subtitle', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('We Always Ready For You', 'vernex-core'),
                'placeholder' => esc_html__('write your subtitle here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_support_section_genaral_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Discover our journey commitment to excellence, and our team of dedicated professionals who turn visions into reality.', 'vernex-core'),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_support_section_genaral_contact_button',
            [
                'label'       => esc_html__('Button Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses(' <h2>30</h2>
                                <span>Minute</span>
                                <p>Talk With Us</p> ', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_support_section_genaral_contact_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_support_section_genaral_content_description',
            [
                'label'       => esc_html__('Content Description', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default'     => esc_html__('Sed Nissl eros, condominium nec risussit abet finibus cons sem fused. Advantage of these limited-time offers & start. Here are various categories that can be featured on a construction website to cover different aspects and specialties within the industry. This title is versatile and can be adapted to fit the specific tone and branding of your construction website, ensuring it conveys the comprehensive nature of your services and commitment to quality.', 'vernex-core'),
                'placeholder' => esc_html__('write your description here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_support_section_genaral_content_banner_image',
            [
                'label' => esc_html__('Banner Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),

                ],

            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_support_section_style_one_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_support_section_style_one_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_support_section_style_one_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_support_section_style_one_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_support_section_style_one_general_subtitle_after_color',
            [
                'label'     => esc_html__('After Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_support_section_style_one_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_support_section_style_one_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_support_section_style_one_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_support_section_style_one_general_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_support_section_style_one_general_button_typ',
                'selector' => '{{WRAPPER}} .home1-support-section .support-content .contact-area h2',

            ]
        );

        $this->add_control(
            'vernex_support_section_style_one_general_button_color',
            [
                'label'     => esc_html__('Bold Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-support-section .support-content .contact-area h2' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_support_section_style_one_general_button_semi_bold_color',
            [
                'label'     => esc_html__('Semi Bold Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-support-section .support-content .contact-area span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_support_section_style_one_general_button_general_bold_color',
            [
                'label'     => esc_html__('General Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-support-section .support-content .contact-area p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_support_section_style_one_general_button_hover_bg_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-support-section .support-content .contact-area:hover' => 'box-shadow: inset 0 0 0 10em {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_support_section_style_one_general_content_description',
            [
                'label'     => esc_html__('Content Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_support_section_style_one_general_content_description_typ',
                'selector' => '{{WRAPPER}} .home1-support-section .support-content > p',

            ]
        );

        $this->add_control(
            'vernex_support_section_style_one_general_content_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-support-section .support-content > p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
?>


        <div class="home1-support-section">
            <div class="container">
                <div class="row justify-content-lg-end wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                    <div class="col-xl-9 col-lg-10">
                        <div class="section-title">
                            <?php if (!empty($settings['vernex_support_section_genaral_subtitle'])) : ?>
                                <span><?php echo esc_html($settings['vernex_support_section_genaral_subtitle']); ?></span>
                            <?php endif; ?>
                            <?php if (!empty($settings['vernex_support_section_genaral_title'])) : ?>
                                <h2><?php echo esc_html($settings['vernex_support_section_genaral_title']); ?></h2>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="support-content">
                            <?php if (!empty($settings['vernex_support_section_genaral_contact_button'])) : ?>
                                <div class="btn_wrapper">
                                    <a href="<?php echo esc_url($settings['vernex_support_section_genaral_contact_button_url']['url']); ?>" class="contact-area">
                                        <?php echo wp_kses($settings['vernex_support_section_genaral_contact_button'], wp_kses_allowed_html('post')); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($settings['vernex_support_section_genaral_content_description'])) : ?>
                                <p><?php echo esc_html($settings['vernex_support_section_genaral_content_description']); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php if (!empty($settings['vernex_support_section_genaral_content_banner_image']['url'])) : ?>
                        <div class="col-lg-6 d-lg-block d-none">
                            <div class="support-img magnetic-item">
                                <img src="<?php echo esc_url($settings['vernex_support_section_genaral_content_banner_image']['url']); ?>" alt="<?php echo esc_attr__('banner-image', 'vernex-core'); ?>">
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Support_Widget());
