<?php

namespace Elementor;

use Egns\Helper\Egns_Helper;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Project_Tab_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_projects_tab';
    }

    public function get_title()
    {
        return esc_html__('EG Projects Tab', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {
        // Content Tab
        $this->start_controls_section(
            'vernex_tab_filtering_content_section',
            [
                'label' => esc_html__('General', 'vernex-core'),
            ]
        );

        // Title
        $this->add_control(
            'projects_tab_section_title',
            [
                'label' => esc_html__('Section Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('A glimpse into our creative work.', 'vernex-core'),
            ]
        );

        $this->add_control(
            'number_of_tabs',
            [
                'label'   => esc_html__('Number of Tabs', 'vernex-core'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 3,
                'min'     => 1,
                'step'    => 1,
            ]
        );

        $this->add_control(
            'number_of_projects',
            [
                'label'   => esc_html__('Number of Projects per Tab', 'vernex-core'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 9,
                'min'     => 1,
                'step'    => 1,
            ]
        );

        $this->add_control(
            'vernex_tab_filtering_content_section_custom_button_text',
            [
                'label'       => esc_html__('Button Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('View All Projects', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_tab_filtering_content_section_custom_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        //Start Control Section
        $this->start_controls_section(
            'vernex_projects_tab_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_project_tab_general_section_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_tab_section_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_project_tab_section_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_tab_menu_name',
            [
                'label'     => esc_html__('Menu Name', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_tab_menu_name_typ',
                'selector' => '{{WRAPPER}} .home6-project-section .nav-tabs .nav-link',

            ]
        );

        $this->add_control(
            'vernex_project_tab_menu_name_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-project-section .nav-tabs .nav-link' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_tab_menu_name_active_color',
            [
                'label'     => esc_html__('Active Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-project-section .nav-tabs .nav-link.active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_projects_tab_image_title',
            [
                'label'     => esc_html__('Image Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_projects_tab_image_title_typ',
                'selector' => '{{WRAPPER}} .project-info-flow-card .info-flow-content .project-name a',

            ]
        );

        $this->add_control(
            'vernex_projects_tab_image_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-info-flow-card .info-flow-content .project-name a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'name'      => 'vernex_projects_tab_image_title_bg',
                'selector' => '{{WRAPPER}} .project-info-flow-card .info-flow-content .project-name a',
            ]
        );

        $this->add_control(
            'vernex_projects_tab_image_client_name',
            [
                'label'     => esc_html__('Image Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_projects_tab_image_client_name_typ',
                'selector' => '{{WRAPPER}} .project-info-flow-card .info-flow-content .project-name a',

            ]
        );

        $this->add_control(
            'vernex_projects_tab_image_client_name_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-info-flow-card .info-flow-content .project-name a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'name'      => 'vernex_projects_tab_image_client_name_bg',
                'selector' => '{{WRAPPER}} .project-info-flow-card .info-flow-content .project-name a',
            ]
        );
        $this->end_controls_section();
    }



    // Frontend Output 
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // Fetching all project categories
        $number_of_tabs = $settings['number_of_tabs'];

        $categories = get_terms([
            'taxonomy'   => 'project-category',
            'hide_empty' => true,
            'number'     => $number_of_tabs,
        ]);

        $tabs = [];

        if (!empty($categories) && !is_wp_error($categories)) {
            foreach ($categories as $index => $category) {
                if ($index >= $number_of_tabs) {
                    break;
                }

                // Query projects for this category
                $number_of_projects = $settings['number_of_projects'];

                $projects_query = new \WP_Query([
                    'post_type'      => 'project',
                    'posts_per_page' => $number_of_projects,
                    'post_status'    => 'publish',
                    'tax_query'      => [
                        [
                            'taxonomy' => 'project-category',
                            'field'    => 'term_id',
                            'terms'    => $category->term_id,
                        ],
                    ],
                ]);

                // Add the projects to the tab array
                $tabs[$category->name] = $projects_query;
            }
        }
?>

        <div class="home6-project-section">
            <div class="container-fluid">
                <div class="title-area mb-90">
                    <div class="row align-items-end">
                        <div class="col-lg-5">
                            <?php if (!empty($settings['projects_tab_section_title'])) : ?>
                                <div class="section-title">
                                    <h2><?php echo esc_html($settings['projects_tab_section_title']); ?></h2>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-lg-7 d-flex justify-content-lg-end">
                            <nav>
                                <div class="nav nav-tabs" id="vernex-tab" role="tablist">
                                    <?php $i = 0;
                                    foreach ($tabs as $tab_title => $query) : ?>
                                        <button class="nav-link <?php echo $i === 0 ? 'active' : ''; ?>"
                                            id="tab-<?php echo $i; ?>"
                                            data-bs-toggle="tab"
                                            data-bs-target="#content-<?php echo $i; ?>"
                                            type="button" role="tab">
                                            <?php echo esc_html($tab_title); ?>
                                        </button>
                                    <?php $i++;
                                    endforeach; ?>
                                </div>
                            </nav>
                        </div>
                    </div>
                </div>
                <div class="tab-content" id="nav-tabContent">
                    <?php $i = 0;
                    foreach ($tabs as $tab_title => $query) : ?>
                        <div class="tab-pane fade <?php echo $i === 0 ? 'show active' : ''; ?>"
                            id="content-<?php echo $i; ?>" role="tabpanel">
                            <div class="row gx-xxl-5 g-4 mb-70">
                                <?php
                                $classes = array('', 'pt-80', '', 'pt-80'); // Classes for styling
                                $class_count = count($classes);

                                if ($query->have_posts()) :
                                    $index = 0; // Initialize $index
                                    while ($query->have_posts()) : $query->the_post();
                                        $class = $classes[$index % $class_count]; // Cycle through $classes
                                ?>

                                        <div class="col-lg-3 col-md-4 col-sm-6 <?php echo $class; ?> wow animate fadeInDown">
                                            <div class="project-info-flow-card">
                                                <?php if (has_post_thumbnail()) : ?>
                                                    <a href="<?php the_permalink(); ?>" class="info-flow-img">
                                                        <?php the_post_thumbnail(); ?>
                                                    </a>
                                                <?php endif; ?>
                                                <div class="info-flow-content">
                                                    <?php
                                                    $port_data = Egns_Helper::egns_project_value('project_info_list');
                                                    if (is_array($port_data) && isset($port_data[0])) {
                                                        $first_item = $port_data[0];
                                                        $label_text = isset($first_item['project_label_text']) ? esc_html($first_item['project_label_text']) : '';
                                                        $content_text = isset($first_item['project_content_text']) ? esc_html($first_item['project_content_text']) : '';
                                                    ?>
                                                        <a href="<?php the_permalink(); ?>"><?php echo $label_text; ?> <?php echo $content_text; ?></a>
                                                    <?php
                                                    }
                                                    ?>
                                                    <h6 class="project-name">
                                                        <a href="<?php the_permalink(); ?>">
                                                            <?php the_title(); ?>
                                                        </a>
                                                    </h6>
                                                </div>
                                            </div>
                                        </div>

                                <?php $index++; // Increment $index
                                    endwhile;
                                    wp_reset_postdata(); // Reset post data
                                endif; ?>
                            </div>
                        </div>
                    <?php $i++;
                    endforeach; ?>
                </div>
                <?php if (!empty($settings['vernex_tab_filtering_content_section_custom_button_text'])) : ?>
                    <div class="row">
                        <div class="col-lg-12 d-flex justify-content-center">
                            <a href="<?php echo esc_url($settings['vernex_tab_filtering_content_section_custom_url']['url']); ?>" class="primary-btn3 bounce_up">
                                <span>
                                    <?php echo esc_html($settings['vernex_tab_filtering_content_section_custom_button_text']); ?>
                                    <svg viewBox="0 0 13 20">
                                        <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                    </svg>
                                </span>
                                <i class="corner tl"></i>
                                <i class="corner tr"></i>
                                <i class="corner br"></i>
                                <i class="corner bl"></i>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
<?php
    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Project_Tab_Widget());
