<?php

namespace Elementor;

use Egns\Helper\Egns_Helper;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly

use Elementor\core\Schemes;

class Vernex_Project_Single_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_button';
    }

    public function get_title()
    {
        return esc_html__('EG Project Single', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        // ---------------------------Content one--------------------------//


        $this->start_controls_section(
            'vernex_project_single_section',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_project_single_section_genaral_query_post_per_page',
            [
                'label'       => esc_html__('Posts Per Page', 'vernex-core'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 6,
                'label_block' => false,
            ]
        );

        $this->add_control(
            'selected_project_single',
            [
                'label'       => __('Select Projects', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple'    => true,
                'options'     => Egns_Helper::get_project_post_option(),
            ]
        );

        $this->add_control(
            'vernex_project_single_section_genaral_query_orderby',
            [
                'label'   => esc_html__('Order By', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ID',
                'options' => [
                    'ID'         => esc_html__('Post Id', 'vernex-core'),
                    'author'     => esc_html__('Post Author', 'vernex-core'),
                    'title'      => esc_html__('Title', 'vernex-core'),
                    'post_date'  => esc_html__('Date', 'vernex-core'),
                    'rand'       => esc_html__('Random', 'vernex-core'),
                    'menu_order' => esc_html__('Menu Order', 'vernex-core'),
                ],
            ]
        );

        $this->add_control(
            'vernex_project_single_section_genaral_query_template_order',
            [
                'label'   => esc_html__('Order', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'asc'  => esc_html__('Ascending', 'vernex-core'),
                    'desc' => esc_html__('Descending', 'vernex-core')

                ],
                'default' => 'desc',
            ]
        );

        $this->end_controls_section();

        // =====================Style One=======================//

        $this->start_controls_section(
            'vernex_project_single_style',
            [
                'label' => esc_html__('General', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );

        $this->add_control(
            'vernex_project_single_style_content_name',
            [
                'label'     => esc_html__('Content Name', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_single_style_typ',
                'selector' => '{{WRAPPER}} .project-single-page .project-single-wrapper .project-content-wrap .project-content span',

            ]
        );

        $this->add_control(
            'vernex_project_single_style_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-single-page .project-single-wrapper .project-content-wrap .project-content span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_single_style_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_single_style_title_typ',
                'selector' => '{{WRAPPER}} .project-single-page .project-single-wrapper .project-content-wrap .project-content h2 a',

            ]
        );

        $this->add_control(
            'vernex_project_single_style_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-single-page .project-single-wrapper .project-content-wrap .project-content h2 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_single_style_title_hov_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-single-page .project-single-wrapper .project-content-wrap .project-content h2 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_single_style_category',
            [
                'label'     => esc_html__('Category', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_single_style_category_typ',
                'selector' => '{{WRAPPER}} .project-single-page .project-single-wrapper .project-content-wrap .project-content ul li a',

            ]
        );

        $this->add_control(
            'vernex_project_single_style_category_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-single-page .project-single-wrapper .project-content-wrap .project-content ul li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_single_style_category_hov_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-single-page .project-single-wrapper .project-content-wrap .project-content ul li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'vernex_project_single_style_category_hov_bac_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-single-page .project-single-wrapper .project-content-wrap .project-content ul li a:hover' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $data = $settings['vernex_project_single_bac_image_list'];

        $args = array(
            'post_type'      => 'project',
            'posts_per_page' => $settings['vernex_project_single_section_genaral_query_post_per_page'],
            'orderby'        => $settings['vernex_project_single_section_genaral_query_orderby'],
            'order'          => $settings['vernex_project_single_section_genaral_query_template_order'],
            'offset'         => 0,
            'post_status'    => 'publish',
        );
        if (!empty($selected_post_ids)) {
            $args['post__in'] = $selected_post_ids;
        }
        $query = new \WP_Query($args);

?>

        <?php if (is_admin()) : ?>
            <script>
                // Project Single Slider
                var swiper = new Swiper(".project-single-slider", {
                    slidesPerView: 1,
                    speed: 1500,
                    effect: 'fade',
                    autoplay: {
                        delay: 2500, // Autoplay duration in milliseconds
                        disableOnInteraction: false,
                    },
                    navigation: {
                        nextEl: ".project-single-next",
                        prevEl: ".project-single-prev",
                    },
                });
            </script>
        <?php endif; ?>

        <div class="project-single-page">
            <div class="row">
                <div class="col-lg-12">
                    <div class="swiper project-single-slider">
                        <div class="swiper-wrapper">
                            <?php
                            if ($query->have_posts()) {
                                while ($query->have_posts()) {
                                    $query->the_post();
                            ?>
                                    <div class="swiper-slide">
                                        <div class="project-single-wrapper">
                                            <?php
                                            $post_thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
                                            ?>
                                            <div class="project-bg" style="background-image: linear-gradient(180deg, rgba(0, 0, 0, 0.4) 0%, rgba(0, 0, 0, 0.4) 100%), url(<?php echo $post_thumbnail_url; ?>);"></div>
                                            <div class="project-content-wrap">
                                                <div class="project-content">
                                                    <?php
                                                    $port_data = Egns_Helper::egns_project_value('project_info_list');
                                                    if (is_array($port_data) && isset($port_data[0])) {
                                                        $first_item = $port_data[0];
                                                        $label_text = isset($first_item['project_label_text']) ? esc_html($first_item['project_label_text']) : '';
                                                        $content_text = isset($first_item['project_content_text']) ? esc_html($first_item['project_content_text']) : '';
                                                    ?>
                                                        <span><?php echo $label_text; ?> <?php echo $content_text; ?></span>
                                                    <?php
                                                    }
                                                    ?>
                                                    <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                                    <ul>
                                                        <?php
                                                        $categories = get_the_terms(get_the_ID(), 'project-category');

                                                        if ($categories && !is_wp_error($categories)) {
                                                            foreach ($categories as $category) { ?>
                                                                <li><a href="<?php echo esc_url(get_term_link($category)); ?>"><?php echo esc_html($category->name); ?></a></li>
                                                        <?php
                                                            }
                                                        }
                                                        ?>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                            <?php
                                }
                            }
                            wp_reset_postdata();

                            ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="slider-btn-grp">
                <div class="slider-btn project-single-prev">
                    <i class="bi bi-arrow-left"></i>
                </div>
                <div class="slider-btn project-single-next">
                    <i class="bi bi-arrow-right"></i>
                </div>
            </div>
        </div>


<?php
    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Project_Single_Widget());
