<?php

namespace Elementor;

use Egns\Helper\Egns_Helper;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Project_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_project';
    }

    public function get_title()
    {
        return esc_html__('EG Project', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_project_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_project_section_genaral_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),
                    'style_three' => esc_html__('Style Three', 'vernex-core'),
                    'style_four' => esc_html__('Style Four', 'vernex-core'),

                ],
                'default' => 'style_one',
            ]
        );


        $this->add_control(
            'vernex_project_section_genaral_show_pagination',
            [
                'label' => esc_html__("Show Pagination?", 'vernex-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vernex-core'),
                'label_off' => esc_html__('No', 'vernex-core'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'vernex_project_section_genaral_style_selection' => ['style_one', 'style_three'],
                ]
            ]
        );


        $this->add_control(
            'vernex_project_section_genaral_header_subtitle',
            [
                'label' => esc_html__('Subtitle', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Our Projects'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your subtitle here', 'vernex-core'),
                'condition' => [
                    'vernex_project_section_genaral_style_selection' => ['style_one', 'style_two', 'style_four'],
                ]
            ]
        );

        $this->add_control(
            'vernex_project_section_genaral_header_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Seen Our Working Clean Project.'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your title here', 'vernex-core'),
                'condition' => [
                    'vernex_project_section_genaral_style_selection' => ['style_one', 'style_two', 'style_four'],
                ]
            ]
        );

        $this->add_control(
            'vernex_project_section_genaral_st_three_header_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Makeover <br> Modern.', wp_kses_allowed_html('post')),
                'label_block' => true,
                'placeholder' => esc_html__('Type your title here', 'vernex-core'),
                'condition' => [
                    'vernex_project_section_genaral_style_selection' => ['style_three'],
                ]
            ]
        );

        $this->add_control(
            'vernex_project_section_genaral_header_short_description',
            [
                'label' => esc_html__('Short Description', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Sed nisl eros, condimentum nec risus sit amet, finibus conguese.Fusen fringilla est libero sed tempus urna feugiat eu. Curabitur eu feugiat ligu Suspendisse.'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your description here', 'vernex-core'),
                'condition' => [
                    'vernex_project_section_genaral_style_selection' => ['style_two', 'style_three'],
                ]
            ]
        );

        $this->add_control(
            'vernex_project_section_genaral_header_button_text',
            [
                'label'       => esc_html__('Button Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('View All Project', 'vernex-core'),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_project_section_genaral_header_button_text_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_project_section_genaral_header_vector_image',
            [
                'label' => esc_html__('Vector Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'vernex_project_section_genaral_style_selection' => ['style_two'],
                ]
            ]
        );


        $this->add_control(
            'vernex_project_section_genaral_query_post_per_page',
            [
                'label'       => esc_html__('Posts Per Page', 'vernex-core'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 6,
                'label_block' => false,
            ]
        );

        $this->add_control(
            'selected_project',
            [
                'label'       => __('Select Projects', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple'    => true,
                'options'     => \Egns_Core\Egns_Helper::get_project_options(),
            ]
        );



        $this->add_control(
            'vernex_project_section_genaral_query_orderby',
            [
                'label'   => esc_html__('Order By', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ID',
                'options' => [
                    'ID'         => esc_html__('Post Id', 'vernex-core'),
                    'author'     => esc_html__('Post Author', 'vernex-core'),
                    'title'      => esc_html__('Title', 'vernex-core'),
                    'post_date'  => esc_html__('Date', 'vernex-core'),
                    'rand'       => esc_html__('Random', 'vernex-core'),
                    'menu_order' => esc_html__('Menu Order', 'vernex-core'),
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_genaral_query_template_order',
            [
                'label'   => esc_html__('Order', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'asc'  => esc_html__('Ascending', 'vernex-core'),
                    'desc' => esc_html__('Descending', 'vernex-core')

                ],
                'default' => 'desc',
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_project_section_style_one_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_project_section_genaral_style_selection' => ['style_one'],
                ]
            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_one_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title.white span',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.white span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_one_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title.white h2',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.white h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_one_general_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn.white',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn.white' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_button_bottom_border_color',
            [
                'label'     => esc_html__('Bottom Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn.white' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn.white svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_button_after_icon_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn.white::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_project_title',
            [
                'label'     => esc_html__('Project Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_one_general_project_title_typ',
                'selector' => '{{WRAPPER}} .project-card .project-content h4 a',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_project_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card .project-content h4 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_project_title_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card .project-content h4 a' => 'background: linear-gradient(to bottom, {{VALUE}} 0%, {{VALUE}} 98%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_project_info',
            [
                'label'     => esc_html__('Project Info', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_one_general_project_info_typ',
                'selector' => '{{WRAPPER}} .project-card .project-content span',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_project_info_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card .project-content span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_project_p_button',
            [
                'label'     => esc_html__('Project Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_one_general_project_p_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn2 span',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_project_p_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_project_p_button_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'background-image: linear-gradient(0deg, {{VALUE}}; 0%, {{VALUE}}; 100%)',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_project_p_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_one_general_project_p_button_after_icon_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_project_section_style_two_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_project_section_genaral_style_selection' => ['style_two'],
                ]
            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_two_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_two_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_description',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_two_general_description_typ',
                'selector' => '{{WRAPPER}} .section-title p',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_info',
            [
                'label'     => esc_html__('Project Info', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_two_general_project_info_typ',
                'selector' => '{{WRAPPER}} .project-card2 .project-content-wrap .project-content span',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_info_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card2 .project-content-wrap .project-content span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_title',
            [
                'label'     => esc_html__('Project Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_two_general_project_title_typ',
                'selector' => '{{WRAPPER}} .project-card2 .project-content-wrap .project-content h2 a',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card2 .project-content-wrap .project-content h2 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_title_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card2 .project-content-wrap .project-content h2 a' => 'background: linear-gradient(to bottom, {{VALUE}} 0%, {{VALUE}} 98%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_category',
            [
                'label'     => esc_html__('Project Category', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_two_general_project_category_typ',
                'selector' => '{{WRAPPER}} .project-card2 .project-content-wrap .project-content ul li a',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_category_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card2 .project-content-wrap .project-content ul li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_category_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card2 .project-content-wrap .project-content ul li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_category_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card2 .project-content-wrap .project-content ul li a' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_project_section_style_two_general_project_category_hover_bg_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card2 .project-content-wrap .project-content ul li a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_project_section_style_two_general_project_button',
            [
                'label'     => esc_html__('Project Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_two_general_project_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_button_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_button_after_icon_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_button_two',
            [
                'label'     => esc_html__('Button Two', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_two_general_project_button_two_typ',
                'selector' => '{{WRAPPER}} .primary-btn2 span',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_button_two_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_button_two_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_button_two_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_two_general_project_button_two_after_icon_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span::after' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_project_section_style_two_general_project_button_two_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_project_section_style_three_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_project_section_genaral_style_selection' => ['style_three'],
                ]
            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_three_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title2 h2',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title2 h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_title_after_color',
            [
                'label'     => esc_html__('After Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title2 h2 span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_description',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_three_general_description_typ',
                'selector' => '{{WRAPPER}} .section-title2 p',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title2 p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_three_general_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn2 span',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_button_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_button_after_icon_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_button_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_project_info',
            [
                'label'     => esc_html__('project Info', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_three_general_project_info_typ',
                'selector' => '{{WRAPPER}} .project-card3 .project-content-wrap .project-content span',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_project_info_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card3 .project-content-wrap .project-content span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_project_title',
            [
                'label'     => esc_html__('project Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_three_general_project_title_typ',
                'selector' => '{{WRAPPER}} .project-card3 .project-content-wrap .project-content h3 a',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_project_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card3 .project-content-wrap .project-content h3 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_project_title_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card3 .project-content-wrap .project-content h3 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_project_category',
            [
                'label'     => esc_html__('project Category', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_three_general_project_category_typ',
                'selector' => '{{WRAPPER}} .project-card3 .project-content-wrap .project-content ul li a',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_project_category_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card3 .project-content-wrap .project-content ul li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_project_category_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card3 .project-content-wrap .project-content ul li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_project_category_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card3 .project-content-wrap .project-content ul li a' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_three_general_project_category_hover_bg_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card3 .project-content-wrap .project-content ul li a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();


        //style start
        $this->start_controls_section(
            'vernex_project_section_style_four_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_project_section_genaral_style_selection' => ['style_four'],
                ]
            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_four_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title.four span',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.four span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_subtitle_after_color',
            [
                'label'     => esc_html__('After Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_four_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_four_general_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn2 span',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_button_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_button_after_icon_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span::after' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_project_section_style_four_general_button_two_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_project_info',
            [
                'label'     => esc_html__('Project Info', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_four_general_project_info_typ',
                'selector' => '{{WRAPPER}} .project-card3 .project-content-wrap .project-content span',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_project_info_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card3 .project-content-wrap .project-content span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_project_title',
            [
                'label'     => esc_html__('Project Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_four_general_project_title_typ',
                'selector' => '{{WRAPPER}} .project-card3 .project-content-wrap .project-content h3 a',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_project_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card3 .project-content-wrap .project-content h3 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_project_title_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card3 .project-content-wrap .project-content h3 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_project_category',
            [
                'label'     => esc_html__('Project Category', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_project_section_style_four_general_project_category_typ',
                'selector' => '{{WRAPPER}} .project-card3 .project-content-wrap .project-content ul li a',

            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_project_category_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card3 .project-content-wrap .project-content ul li a' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_project_section_style_four_general_project_category_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card3 .project-content-wrap .project-content ul li a' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_project_category_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card3 .project-content-wrap .project-content ul li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_project_section_style_four_general_project_category_hover_bg_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-card3 .project-content-wrap .project-content ul li a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $selected_post_ids     = $settings['selected_project'];

        $args = array(
            'post_type'      => 'project',
            'posts_per_page' => $settings['vernex_project_section_genaral_query_post_per_page'],
            'orderby'        => $settings['vernex_project_section_genaral_query_orderby'],
            'order'          => $settings['vernex_project_section_genaral_query_template_order'],
            'offset'         => 0,
            'post_status'    => 'publish',
        );
        if (!empty($selected_post_ids)) {
            $args['post__in'] = $selected_post_ids;
        }
        $query = new \WP_Query($args);
?>
        <?php if (is_admin()) : ?>
            <script>
                var swiper = new Swiper(".home1-project-slider", {
                    slidesPerView: 1,
                    speed: 1500,
                    spaceBetween: 25,
                    autoplay: {
                        delay: 2500, // Autoplay duration in milliseconds
                        disableOnInteraction: false,
                    },
                    navigation: {
                        nextEl: ".project-slider-next",
                        prevEl: ".project-slider-prev",
                    },
                    breakpoints: {
                        280: {
                            slidesPerView: 1,
                        },
                        386: {
                            slidesPerView: 1,
                        },
                        576: {
                            slidesPerView: 1,
                            spaceBetween: 15,
                        },
                        768: {
                            slidesPerView: 2,
                        },
                        992: {
                            slidesPerView: 2.7,
                        },
                        1200: {
                            slidesPerView: 3.7,
                        },
                        1400: {
                            slidesPerView: 3.5,
                        },
                    },
                });

                var swiper = new Swiper(".home4-project-slider", {
                    slidesPerView: 1,
                    speed: 1500,
                    spaceBetween: 25,
                    // autoplay: {
                    // 	delay: 2500, // Autoplay duration in milliseconds
                    // 	disableOnInteraction: false,
                    // },
                    navigation: {
                        nextEl: ".project-slider-next",
                        prevEl: ".project-slider-prev",
                    },
                    breakpoints: {
                        280: {
                            slidesPerView: 1,
                        },
                        386: {
                            slidesPerView: 1,
                        },
                        576: {
                            slidesPerView: 1,
                            spaceBetween: 15,
                        },
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 15,
                        },
                        992: {
                            slidesPerView: 2,
                        },
                        1200: {
                            slidesPerView: 2.3,
                        },
                        1400: {
                            slidesPerView: 2.7,
                        },
                    },
                });
            </script>
        <?php endif; ?>


        <?php if ($settings['vernex_project_section_genaral_style_selection'] == 'style_one') : ?>
            <div class="home1-project-section">
                <div class="container">
                    <div class="row gy-4 align-items-center justify-content-between mb-60 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-xl-5 col-lg-6 col-md-8">
                            <div class="section-title white">
                                <?php if (!empty($settings['vernex_project_section_genaral_header_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_project_section_genaral_header_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_project_section_genaral_header_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_project_section_genaral_header_title']); ?></h2>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_project_section_genaral_header_button_text'])) : ?>
                                    <a href="<?php echo esc_url($settings['vernex_project_section_genaral_header_button_text_url']['url']); ?>" class="primary-btn white">
                                        <?php echo esc_html($settings['vernex_project_section_genaral_header_button_text']); ?>
                                        <svg viewBox="0 0 13 20">
                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                        </svg>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <?php if ($settings['vernex_project_section_genaral_show_pagination'] == 'yes') : ?>
                            <div class="col-xl-2 col-md-3 d-flex justify-content-md-end">
                                <div class="slider-btn-grp white">
                                    <div class="slider-btn project-slider-prev">
                                        <i class="bi bi-arrow-left"></i>
                                    </div>
                                    <div class="slider-btn project-slider-next">
                                        <i class="bi bi-arrow-right"></i>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
                <div class="home1-project-slider-wrap">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="swiper home1-project-slider">
                                <div class="swiper-wrapper">
                                    <?php
                                    while ($query->have_posts()) :
                                        $query->the_post();
                                    ?>
                                        <div class="swiper-slide">
                                            <div class="project-card">
                                                <div class="project-img-wrap">
                                                    <?php if (has_post_thumbnail()) : ?>
                                                        <a href="<?php the_permalink(); ?>" class="project-img">
                                                            <?php the_post_thumbnail(); ?>
                                                        </a>
                                                    <?php endif; ?>
                                                    <div class="button-area">
                                                        <a href="<?php the_permalink(); ?>" class="primary-btn2">
                                                            <span>
                                                                <?php echo esc_html__('View Project', 'vernex-core'); ?>
                                                                <svg viewBox="0 0 13 20">
                                                                    <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                                                </svg>
                                                            </span>
                                                        </a>
                                                    </div>
                                                </div>
                                                <div class="project-content">
                                                    <?php
                                                    $port_data = Egns_Helper::egns_project_value('project_info_list');
                                                    if (is_array($port_data) && isset($port_data[0])) {
                                                        $first_item = $port_data[0];
                                                        $label_text = isset($first_item['project_label_text']) ? esc_html($first_item['project_label_text']) : '';
                                                        $content_text = isset($first_item['project_content_text']) ? esc_html($first_item['project_content_text']) : '';
                                                    ?>
                                                        <span><?php echo $label_text; ?> <?php echo $content_text; ?></span>
                                                    <?php
                                                    }
                                                    ?>
                                                    <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile;
                                    wp_reset_postdata();
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_project_section_genaral_style_selection'] == 'style_two') : ?>
            <div class="home3-project-section">
                <div class="container">
                    <div class="row justify-content-center mb-70 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-xxl-7 col-xl-8 col-lg-9">
                            <div class="section-title three text-center">
                                <?php if (!empty($settings['vernex_project_section_genaral_header_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_project_section_genaral_header_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_project_section_genaral_header_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_project_section_genaral_header_title']); ?></h2>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_project_section_genaral_header_short_description'])) : ?>
                                    <p><?php echo esc_html($settings['vernex_project_section_genaral_header_short_description']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="container-fluid">
                    <?php
                    $classes = array('', 'two', '', 'two');
                    $classes_two = array('', 'order-md-1 order-2', '', 'order-md-1 order-2');
                    $class_count = count($classes);
                    $class_count_two = count($classes_two);
                    $post_index = 0; // Initialize post index
                    while ($query->have_posts()) :
                        $query->the_post();
                        // Determine the class based on the post index
                        $class = $classes[$post_index % $class_count];
                        $class_two = $classes_two[$post_index % $class_count_two];

                        // Increment the index for the next post
                        $post_index++;
                    ?>
                        <div class="project-card2 <?php echo $class; ?> mb-40">
                            <div class="row g-4">
                                <div class="col-md-6 <?php echo $class_two; ?> wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                                    <div class="project-content-wrap">
                                        <div class="project-content">
                                            <?php
                                            $port_data = Egns_Helper::egns_project_value('project_info_list');
                                            if (is_array($port_data) && isset($port_data[0])) {
                                                $first_item = $port_data[0];
                                                $label_text = isset($first_item['project_label_text']) ? esc_html($first_item['project_label_text']) : '';
                                                $content_text = isset($first_item['project_content_text']) ? esc_html($first_item['project_content_text']) : '';
                                            ?>
                                                <span><?php echo $label_text; ?> <?php echo $content_text; ?></span>
                                            <?php
                                            }
                                            ?>
                                            <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                            <ul>
                                                <?php
                                                $categories = get_the_terms(get_the_ID(), 'project-category');

                                                if ($categories && !is_wp_error($categories)) {
                                                    foreach ($categories as $category) { ?>
                                                        <li><a href="<?php echo esc_url(get_term_link($category)); ?>"><?php echo esc_html($category->name); ?></a></li>
                                                <?php
                                                    }
                                                }
                                                ?>
                                            </ul>
                                        </div>
                                        <div class="button-area">
                                            <a href="<?php the_permalink(); ?>" class="primary-btn">
                                                <?php echo esc_html__('View Details', 'vernex-core'); ?>
                                                <svg viewBox="0 0 13 20">
                                                    <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                                </svg>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <?php if (has_post_thumbnail()) : ?>
                                    <div class="col-md-6 image-animation-container">
                                        <div class="project-img image-reveal wcf--image-effect-zoom-in overflow-hidden" data-animation-type="scale">
                                            <?php the_post_thumbnail(); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endwhile;
                    wp_reset_postdata();
                    ?>
                    <?php if (!empty($settings['vernex_project_section_genaral_header_button_text'])) : ?>
                        <div class="row pt-80 bounce_up">
                            <div class="col-lg-12 d-flex justify-content-center">
                                <a href="<?php echo esc_url($settings['vernex_project_section_genaral_header_button_text_url']['url']); ?>" class="primary-btn2">
                                    <span>
                                        <?php echo esc_html($settings['vernex_project_section_genaral_header_button_text']); ?>
                                        <svg viewBox="0 0 13 20">
                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                        </svg>
                                    </span>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <?php if (!empty($settings['vernex_project_section_genaral_header_vector_image']['url'])) : ?>
                    <img src="<?php echo esc_url($settings['vernex_project_section_genaral_header_vector_image']['url']); ?>" alt="<?php echo esc_attr__('vector-image', 'vernex-core'); ?>" class="vector">
                <?php endif; ?>
            </div>
        <?php endif; ?>


        <?php if ($settings['vernex_project_section_genaral_style_selection'] == 'style_three') : ?>
            <div class="home4-project-section">
                <div class="row gy-5">
                    <div class="col-xl-3 col-lg-4 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="project-title-area">
                            <div class="section-title2">
                                <?php if (!empty($settings['vernex_project_section_genaral_st_three_header_title'])) : ?>
                                    <h2><?php echo wp_kses($settings['vernex_project_section_genaral_st_three_header_title'], wp_kses_allowed_html('post')); ?><span></span></h2>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_project_section_genaral_header_short_description'])) : ?>
                                    <p><?php echo esc_html($settings['vernex_project_section_genaral_header_short_description']); ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="button-and-slider-area">
                                <?php if (!empty($settings['vernex_project_section_genaral_header_button_text'])) : ?>
                                    <a href="<?php echo esc_url($settings['vernex_project_section_genaral_header_button_text_url']['url']); ?>" class="primary-btn2">
                                        <span>
                                            <?php echo esc_html($settings['vernex_project_section_genaral_header_button_text']); ?>
                                            <svg viewBox="0 0 13 20">
                                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                            </svg>
                                        </span>
                                    </a>
                                <?php endif; ?>

                                <?php if ($settings['vernex_project_section_genaral_show_pagination'] == 'yes') : ?>
                                    <div class="slider-btn-grp">
                                        <div class="slider-btn project-slider-prev">
                                            <i class="bi bi-arrow-left"></i>
                                        </div>
                                        <div class="slider-btn project-slider-next">
                                            <i class="bi bi-arrow-right"></i>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-9 col-lg-8">
                        <div class="project-slider-area">
                            <div class="swiper home4-project-slider">
                                <div class="swiper-wrapper">
                                    <?php
                                    while ($query->have_posts()) :
                                        $query->the_post();
                                    ?>
                                        <div class="swiper-slide">
                                            <div class="project-card3">
                                                <?php if (has_post_thumbnail()) : ?>
                                                    <?php the_post_thumbnail(); ?>
                                                <?php endif; ?>
                                                <div class="project-content-wrap">
                                                    <div class="project-content">
                                                        <?php
                                                        $port_data = Egns_Helper::egns_project_value('project_info_list');
                                                        if (is_array($port_data) && isset($port_data[0])) {
                                                            $first_item = $port_data[0];
                                                            $label_text = isset($first_item['project_label_text']) ? esc_html($first_item['project_label_text']) : '';
                                                            $content_text = isset($first_item['project_content_text']) ? esc_html($first_item['project_content_text']) : '';
                                                        ?>
                                                            <span><?php echo $label_text; ?> <?php echo $content_text; ?></span>
                                                        <?php
                                                        }
                                                        ?>
                                                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                                        <ul>
                                                            <?php
                                                            $categories = get_the_terms(get_the_ID(), 'project-category');

                                                            if ($categories && !is_wp_error($categories)) {
                                                                foreach ($categories as $category) { ?>
                                                                    <li><a href="<?php echo esc_url(get_term_link($category)); ?>"><?php echo esc_html($category->name); ?></a></li>
                                                            <?php
                                                                }
                                                            }
                                                            ?>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile;
                                    wp_reset_postdata();
                                    ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_project_section_genaral_style_selection'] == 'style_four') : ?>
            <div class="home5-project-section">
                <div class="container">
                    <div class="row g-4 justify-content-between align-items-lg-end mb-70">
                        <div class="col-xxl-5 col-lg-7 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="section-title four">
                                <?php if (!empty($settings['vernex_project_section_genaral_header_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_project_section_genaral_header_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_project_section_genaral_header_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_project_section_genaral_header_title']); ?></h2>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if (!empty($settings['vernex_project_section_genaral_header_button_text'])) : ?>
                            <div class="col-lg-3 d-flex justify-content-lg-end btn_wrapper">
                                <a href="<?php echo esc_url($settings['vernex_project_section_genaral_header_button_text_url']['url']); ?>" class="primary-btn2">
                                    <span>
                                        <?php echo esc_html($settings['vernex_project_section_genaral_header_button_text']); ?>
                                        <svg viewBox="0 0 13 20">
                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                        </svg>
                                    </span>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="row gy-5 align-items-center justify-content-between">
                        <?php
                        $classes = array('6', '5', '5', '6', '12');
                        $classes_two = array('', 'order-md-1 order-2', '', 'order-md-1 order-2');
                        $class_count = count($classes);
                        $class_count_two = count($classes_two);
                        $post_index = 0; // Initialize post index
                        while ($query->have_posts()) :
                            $query->the_post();
                            // Determine the class based on the post index
                            $class = $classes[$post_index % $class_count];
                            $class_two = $classes_two[$post_index % $class_count_two];

                            // Increment the index for the next post
                            $post_index++;
                        ?>
                            <div class="col-lg-<?php echo $class; ?> wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <div class="project-card3 magnetic-item">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <?php the_post_thumbnail(); ?>
                                    <?php endif; ?>
                                    <div class="project-content-wrap">
                                        <div class="project-content">
                                            <?php
                                            $port_data = Egns_Helper::egns_project_value('project_info_list');
                                            if (is_array($port_data) && isset($port_data[0])) {
                                                $first_item = $port_data[0];
                                                $label_text = isset($first_item['project_label_text']) ? esc_html($first_item['project_label_text']) : '';
                                                $content_text = isset($first_item['project_content_text']) ? esc_html($first_item['project_content_text']) : '';
                                            ?>
                                                <span><?php echo $label_text; ?> <?php echo $content_text; ?></span>
                                            <?php
                                            }
                                            ?>
                                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                            <ul>
                                                <?php
                                                $categories = get_the_terms(get_the_ID(), 'project-category');
                                                if ($categories && !is_wp_error($categories)) {
                                                    foreach ($categories as $category) { ?>
                                                        <li><a href="<?php echo esc_url(get_term_link($category)); ?>"><?php echo esc_html($category->name); ?></a></li>
                                                <?php
                                                    }
                                                }
                                                ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile;
                        wp_reset_postdata();
                        ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Project_Widget());
