<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Process_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_process';
    }

    public function get_title()
    {
        return esc_html__('EG Process', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_process_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),
                    'style_three' => esc_html__('Style Three', 'vernex-core'),

                ],
                'default' => 'style_one',
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_show_pagination',
            [
                'label' => esc_html__("Show Pagination?", 'vernex-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vernex-core'),
                'label_off' => esc_html__('No', 'vernex-core'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'vernex_process_section_genaral_style_selection' => ['style_three'],
                ]
            ]
        );


        $this->add_control(
            'vernex_process_section_genaral_subtitle',
            [
                'label' => esc_html__('Subtitle', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('How We Work'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your subtitle here', 'vernex-core'),
                'condition' => [
                    'vernex_process_section_genaral_style_selection' => ['style_one'],
                ]

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Our Proven Methodology'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your title here', 'vernex-core'),
                'condition' => [
                    'vernex_process_section_genaral_style_selection' => ['style_one', 'style_three'],
                ]

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_pagination_title',
            [
                'label' => esc_html__('Pagination Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('How We Work'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
                'condition' => [
                    'vernex_process_section_genaral_style_selection' => ['style_three'],
                ]
            ]
        );


        $this->add_control(
            'vernex_process_section_genaral_two_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Our Work <br> Process <span></span>', wp_kses_allowed_html('post')),
                'label_block' => true,
                'placeholder' => esc_html__('Type your title here', 'vernex-core'),
                'condition' => [
                    'vernex_process_section_genaral_style_selection' => ['style_two'],
                ]

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_subtitle_short_description',
            [
                'label' => esc_html__('Short Description', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html('Sed nisl eros, condimentum nec risus sit amet, finibus conguese.Fusen fringilla est libero sed tempus urna feugiat eu. Curabitur eu feugiat ligu Suspendisse.'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your description here', 'vernex-core'),

            ]
        );

        $process_one = new \Elementor\Repeater();

        $process_one->add_control(
            'vernex_process_section_genaral_one_content_icon',
            [
                'label'     => esc_html__('Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => []
            ]
        );


        $process_one->add_control(
            'vernex_process_section_genaral_one_content_number',
            [
                'label' => esc_html__('Step Number', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('STEP : 01'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your number here', 'vernex-core'),

            ]
        );

        $process_one->add_control(
            'vernex_process_section_genaral_one_content_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Pre-Design <br> Discovery Phase', wp_kses_allowed_html('post')),
                'label_block' => true,
                'label_block' => true,
            ]
        );

        $process_one->add_control(
            'vernex_process_section_genaral_one_content_descritption',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html('Conduct a thoroug need effortless assessment the understand your current marketing.'),
                'label_block' => true,
            ]
        );


        $this->add_control(
            'vernex_process_section_genaral_one_content_list',
            [
                'label'     => esc_html__('Process List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $process_one->get_controls(),
                'default'   => [
                    [
                        'vernex_process_section_genaral_one_content_title'    => wp_kses('Pre-Design <br> Discovery Phase', wp_kses_allowed_html('post')),
                        'vernex_process_section_genaral_one_content_number'    => wp_kses('STEP : 01', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_process_section_genaral_one_content_title'    => wp_kses('Conceptual <br> Design', wp_kses_allowed_html('post')),
                        'vernex_process_section_genaral_one_content_number'    => wp_kses('STEP : 02', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_process_section_genaral_one_content_title'    => wp_kses('Construction <br> Administration', wp_kses_allowed_html('post')),
                        'vernex_process_section_genaral_one_content_number'    => wp_kses('STEP : 03', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_process_section_genaral_one_content_title'    => wp_kses('Design <br> Development', wp_kses_allowed_html('post')),
                        'vernex_process_section_genaral_one_content_number'    => wp_kses('STEP : 04', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_process_section_genaral_one_content_title'    => wp_kses('Construction <br> Administration', wp_kses_allowed_html('post')),
                        'vernex_process_section_genaral_one_content_number'    => wp_kses('STEP : 05', wp_kses_allowed_html('post')),

                    ],
                ],
                'title_field'    => '{{{ vernex_process_section_genaral_one_content_title }}}',
                'condition' => [
                    'vernex_process_section_genaral_style_selection' => ['style_one'],
                ]
            ]
        );

        $process_two = new \Elementor\Repeater();


        $process_two->add_control(
            'vernex_process_section_genaral_two_content_number',
            [
                'label' => esc_html__('Step Number', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('STEP : 01'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your number here', 'vernex-core'),

            ]
        );

        $process_two->add_control(
            'vernex_process_section_genaral_two_content_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Discovery Phase', wp_kses_allowed_html('post')),
                'label_block' => true,
                'label_block' => true,
            ]
        );

        $process_two->add_control(
            'vernex_process_section_genaral_two_content_descritption',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html('Conduct a thoroug need effortless assessment the understand your current marketing.'),
                'label_block' => true,
            ]
        );


        $this->add_control(
            'vernex_process_section_genaral_two_content_list',
            [
                'label'     => esc_html__('Process List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $process_two->get_controls(),
                'default'   => [
                    [
                        'vernex_process_section_genaral_two_content_title'    => wp_kses('Planning & Design', wp_kses_allowed_html('post')),
                        'vernex_process_section_genaral_two_content_number'    => wp_kses('STEP : 01', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_process_section_genaral_two_content_title'    => wp_kses('Hiring Professionals', wp_kses_allowed_html('post')),
                        'vernex_process_section_genaral_two_content_number'    => wp_kses('STEP : 02', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_process_section_genaral_two_content_title'    => wp_kses('Finishes & Fixtures', wp_kses_allowed_html('post')),
                        'vernex_process_section_genaral_two_content_number'    => wp_kses('STEP : 03', wp_kses_allowed_html('post')),

                    ],
                ],
                'title_field'    => '{{{ vernex_process_section_genaral_two_content_title }}}',
                'condition' => [
                    'vernex_process_section_genaral_style_selection' => ['style_two'],
                ]
            ]
        );


        $process_three = new \Elementor\Repeater();


        $process_three->add_control(
            'vernex_process_section_genaral_three_content_image',
            [
                'label'     => esc_html__('Content Image', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::MEDIA,
                'default'   => [
                    'url'   => \Elementor\Utils::get_placeholder_image_src(),
                ],

            ]
        );

        $process_three->add_control(
            'vernex_process_section_genaral_three_content_icon',
            [
                'label'     => esc_html__('Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => []
            ]
        );


        $process_three->add_control(
            'vernex_process_section_genaral_three_content_number',
            [
                'label' => esc_html__('Step Number', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('STEP : 01'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your number here', 'vernex-core'),

            ]
        );

        $process_three->add_control(
            'vernex_process_section_genaral_three_content_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Discovery Phase', wp_kses_allowed_html('post')),
                'label_block' => true,
                'label_block' => true,
            ]
        );

        $process_three->add_control(
            'vernex_process_section_genaral_three_content_descritption',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html('Conduct a thoroug need effortless assessment the understand your current marketing.'),
                'label_block' => true,
            ]
        );


        $this->add_control(
            'vernex_process_section_genaral_three_content_list',
            [
                'label'     => esc_html__('Process List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $process_three->get_controls(),
                'default'   => [
                    [
                        'vernex_process_section_genaral_three_content_title'    => wp_kses('Planning & Design', wp_kses_allowed_html('post')),
                        'vernex_process_section_genaral_three_content_number'    => wp_kses('STEP : 01', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_process_section_genaral_three_content_title'    => wp_kses('Hiring Professionals', wp_kses_allowed_html('post')),
                        'vernex_process_section_genaral_three_content_number'    => wp_kses('STEP : 02', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_process_section_genaral_three_content_title'    => wp_kses('Finishes & Fixtures', wp_kses_allowed_html('post')),
                        'vernex_process_section_genaral_three_content_number'    => wp_kses('STEP : 03', wp_kses_allowed_html('post')),

                    ],
                ],
                'title_field'    => '{{{ vernex_process_section_genaral_three_content_title }}}',
                'condition' => [
                    'vernex_process_section_genaral_style_selection' => ['style_three'],
                ]
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_two_content_video_banner_image',
            [
                'label'     => esc_html__('Video Banner Image', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::MEDIA,
                'default'   => [
                    'url'   => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'vernex_process_section_genaral_style_selection' => ['style_two'],
                ]
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_two_content_video_url',
            [
                'label' => esc_html__('Video URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
                'condition' => [
                    'vernex_process_section_genaral_style_selection' => ['style_two'],
                ]
            ]
        );

        $this->end_controls_section();

        //style one start

        $this->start_controls_section(
            'vernex_process_section_genaral_style_one_general',
            [
                'label' => esc_html__('General', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_process_section_genaral_style_selection' => ['style_one'],
                ]

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_one_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_subtitle_after_color',
            [
                'label'     => esc_html__('After Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_one_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_description',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_one_general_description_typ',
                'selector' => '{{WRAPPER}} .section-title p',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_process_section_genaral_style_one_general_step_number',
            [
                'label'     => esc_html__('Step Number', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_one_general_step_number_typ',
                'selector' => '{{WRAPPER}} .home3-process-section .process-card .step-no span',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_step_number_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-process-section .process-card .step-no span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_step_number_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-process-section .process-card:hover .step-no span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_step_number_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-process-section .process-card .step-no' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_step_number_hover_border_color',
            [
                'label'     => esc_html__('Hover Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-process-section .process-card:hover .step-no' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_step_number_hover_bg_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-process-section .process-card:hover .step-no' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_content_title',
            [
                'label'     => esc_html__('Content Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_one_general_content_title_typ',
                'selector' => '{{WRAPPER}} .home3-process-section .process-card .process-content h4',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_content_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-process-section .process-card .process-content h4' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_content_description',
            [
                'label'     => esc_html__('Content Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_one_general_content_description_typ',
                'selector' => '{{WRAPPER}} .home3-process-section .process-card .process-content p',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_content_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-process-section .process-card .process-content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_content_card_and_bg',
            [
                'label'     => esc_html__('Card & Background', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_content_card_and_bg_card_color',
            [
                'label'     => esc_html__('Card Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-process-section .process-card .process-content' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_one_general_content_card_and_bg_card_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-process-section' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style two start

        $this->start_controls_section(
            'vernex_process_section_genaral_style_two_general',
            [
                'label' => esc_html__('General', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_process_section_genaral_style_selection' => ['style_two'],
                ]

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_two_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_two_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title2 h2',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_two_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title2 h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_two_general_description',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_two_general_description_typ',
                'selector' => '{{WRAPPER}} .section-title2 p',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_two_general_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title2 p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_two_general_step_number',
            [
                'label'     => esc_html__('Step Number', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_two_general_step_number_typ',
                'selector' => '{{WRAPPER}} .home4-process-section .process-content .process-list li .single-process span',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_two_general_step_number_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-process-section .process-content .process-list li .single-process span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_two_general_content_title',
            [
                'label'     => esc_html__('Content Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_two_general_content_title_typ',
                'selector' => '{{WRAPPER}} .home4-process-section .process-content .process-list li .single-process h4',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_two_general_content_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-process-section .process-content .process-list li .single-process h4' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_process_section_genaral_style_two_general_content_description',
            [
                'label'     => esc_html__('Content Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_two_general_content_description_typ',
                'selector' => '{{WRAPPER}} .home4-process-section .process-content .process-list li .single-process p',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_two_general_content_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-process-section .process-content .process-list li .single-process p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_two_general_content_video_icon',
            [
                'label'     => esc_html__('Video Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_two_general_content_video_icon_typ',
                'selector' => '{{WRAPPER}} .home4-process-section .process-video-area .play-btn .icon .video-circle',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_two_general_content_video_icon_color',
            [
                'label'     => esc_html__('Color One', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-process-section .process-video-area .play-btn .icon .video-circle' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_two_general_content_video_icon_color_two',
            [
                'label'     => esc_html__('Color Two', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-process-section .process-video-area .play-btn .icon .play-icon' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_two_general_section_bg_color',
            [
                'label'     => esc_html__('Section Background', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_two_general_content_video_icon_color_two_bg',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-process-section' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style two start

        $this->start_controls_section(
            'vernex_process_section_genaral_style_three_general',
            [
                'label' => esc_html__('General', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_process_section_genaral_style_selection' => ['style_three'],
                ]

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_three_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_progress_bar',
            [
                'label'     => esc_html__('Progress Bar', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_three_general_progress_bar_typ',
                'selector' => '{{WRAPPER}} .home6-process-section .progress-area .progress-pagination .swiper-pagination-progressbar-fill',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_progress_bar_color',
            [
                'label'     => esc_html__('Fill Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-process-section .progress-area .progress-pagination .swiper-pagination-progressbar-fill' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_progress_bar_unfill_color',
            [
                'label'     => esc_html__('Unfill Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-process-section .progress-area .progress-pagination' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_progress_title',
            [
                'label'     => esc_html__('Progress Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_three_general_progress_title_typ',
                'selector' => '{{WRAPPER}} .home6-process-section .progress-area span',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_progress_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-process-section .progress-area span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_step_number',
            [
                'label'     => esc_html__('Step Number', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_three_general_step_number_typ',
                'selector' => '{{WRAPPER}} .home6-process-section .process-card-wrap .step-no span',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_step_number_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-process-section .process-card-wrap .step-no span' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_process_section_genaral_style_three_general_step_number_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-process-section .process-card-wrap:hover .step-no span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_step_number_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-process-section .process-card-wrap .step-no' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_step_number_hover_border_color',
            [
                'label'     => esc_html__('Hover Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-process-section .process-card-wrap:hover .step-no' => 'border-color: {{VALUE}};',
                ],
            ]
        );



        $this->add_control(
            'vernex_process_section_genaral_style_three_general_step_number_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-process-section .process-card-wrap .step-no' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_step_number_hover_bg_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-process-section .process-card-wrap:hover .step-no' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_content_title',
            [
                'label'     => esc_html__('Content Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_three_general_content_title_typ',
                'selector' => '{{WRAPPER}} .home6-process-section .process-card-wrap .process-card .process-content h4',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_content_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-process-section .process-card-wrap .process-card .process-content h4' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_content_description',
            [
                'label'     => esc_html__('Content Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_process_section_genaral_style_three_general_content_description_typ',
                'selector' => '{{WRAPPER}} .home6-process-section .process-card-wrap .process-card .process-content p',

            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_content_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-process-section .process-card-wrap .process-card .process-content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_content_card',
            [
                'label'     => esc_html__('Card', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'vernex_process_section_genaral_style_three_general_content_card_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-process-section .process-card-wrap .process-card' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $process_one = $settings['vernex_process_section_genaral_one_content_list'];
        $process_two = $settings['vernex_process_section_genaral_two_content_list'];
        $process_three = $settings['vernex_process_section_genaral_three_content_list'];

?>

        <?php if (is_admin()) : ?>
            <script>
                var swiper = new Swiper(".home3-process-slider", {
                    slidesPerView: 1,
                    speed: 1500,
                    spaceBetween: 25,
                    autoplay: {
                        delay: 2500, // Autoplay duration in milliseconds
                        disableOnInteraction: false,
                    },
                    breakpoints: {
                        280: {
                            slidesPerView: 1,
                        },
                        386: {
                            slidesPerView: 1,
                        },
                        576: {
                            slidesPerView: 2,
                            spaceBetween: 15,
                        },
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 15,
                        },
                        992: {
                            slidesPerView: 3,
                        },
                        1200: {
                            slidesPerView: 4,
                            spaceBetween: 25,
                        },
                        1400: {
                            slidesPerView: 4,
                            spaceBetween: 30,
                        },
                    },
                });

                var swiper = new Swiper(".home6-process-slider", {
                    slidesPerView: 1,
                    speed: 1500,
                    spaceBetween: 25,
                    autoplay: {
                        delay: 2500, // Autoplay duration in milliseconds
                        disableOnInteraction: false,
                    },
                    pagination: {
                        el: ".progress-pagination",
                        type: "progressbar",
                    },
                    breakpoints: {
                        280: {
                            slidesPerView: 1,
                        },
                        386: {
                            slidesPerView: 1,
                        },
                        576: {
                            slidesPerView: 1,
                            spaceBetween: 15,
                        },
                        768: {
                            slidesPerView: 1,
                            spaceBetween: 15,
                        },
                        992: {
                            slidesPerView: 2,
                            spaceBetween: 15,
                        },
                        1200: {
                            slidesPerView: 2,
                        },
                        1400: {
                            slidesPerView: 2,
                        },
                    },
                });
            </script>
        <?php endif; ?>


        <?php if ($settings['vernex_process_section_genaral_style_selection'] == 'style_one') : ?>
            <div class="home3-process-section">
                <div class="container-fluid">
                    <div class="row justify-content-center mb-70 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-lg-7">
                            <div class="section-title three text-center">
                                <?php if (!empty($settings['vernex_process_section_genaral_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_process_section_genaral_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_process_section_genaral_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_process_section_genaral_title']); ?></h2>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_process_section_genaral_subtitle_short_description'])) : ?>
                                    <p><?php echo esc_html($settings['vernex_process_section_genaral_subtitle_short_description']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="process-slider-wrap">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="swiper home3-process-slider">
                                    <div class="swiper-wrapper">
                                        <?php foreach ($process_one as $process) : ?>
                                            <div class="swiper-slide">
                                                <div class="process-card">
                                                    <?php if (!empty($process['vernex_process_section_genaral_one_content_number'])) : ?>
                                                        <div class="step-no">
                                                            <span><?php echo esc_html($process['vernex_process_section_genaral_one_content_number']); ?></span>
                                                        </div>
                                                    <?php endif; ?>
                                                    <div class="process-content">
                                                        <div class="icon">
                                                            <?php \Elementor\Icons_Manager::render_icon($process['vernex_process_section_genaral_one_content_icon']); ?>
                                                        </div>
                                                        <?php if (!empty($process['vernex_process_section_genaral_one_content_title'])) : ?>
                                                            <h4><?php echo wp_kses($process['vernex_process_section_genaral_one_content_title'], wp_kses_allowed_html('post')); ?></h4>
                                                        <?php endif; ?>
                                                        <?php if (!empty($process['vernex_process_section_genaral_one_content_descritption'])) : ?>
                                                            <p><?php echo esc_html($process['vernex_process_section_genaral_one_content_descritption']); ?></p>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_process_section_genaral_style_selection'] == 'style_two') : ?>
            <div class="home4-process-section">
                <div class="container">
                    <div class="row gy-5 justify-content-between">
                        <div class="col-xl-4 col-lg-5">
                            <div class="process-content">
                                <div class="section-title2 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                    <?php if (!empty($settings['vernex_process_section_genaral_two_title'])) : ?>
                                        <h2> <?php echo wp_kses($settings['vernex_process_section_genaral_two_title'], wp_kses_allowed_html('post')); ?></h2>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_process_section_genaral_subtitle_short_description'])) : ?>
                                        <p><?php echo esc_html($settings['vernex_process_section_genaral_subtitle_short_description']); ?></p>
                                    <?php endif; ?>
                                </div>
                                <ul class="process-list">

                                    <?php
                                    $last_process = end($process_two); // Get the last element of the array
                                    foreach ($process_two as $index => $process) : ?>
                                        <li class="wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                            <div class="single-process">
                                                <?php if (!empty($process['vernex_process_section_genaral_two_content_number'])) : ?>
                                                    <span><?php echo esc_html($process['vernex_process_section_genaral_two_content_number']); ?></span>
                                                <?php endif; ?>
                                                <?php if (!empty($process['vernex_process_section_genaral_two_content_title'])) : ?>
                                                    <h4><?php echo esc_html($process['vernex_process_section_genaral_two_content_title']); ?></h4>
                                                <?php endif; ?>
                                                <?php if (!empty($process['vernex_process_section_genaral_two_content_descritption'])) : ?>
                                                    <p><?php echo esc_html($process['vernex_process_section_genaral_two_content_descritption']); ?></p>
                                                <?php endif; ?>
                                            </div>
                                            <?php if ($process !== $last_process): // Show SVG only if not the last element 
                                            ?>
                                                <svg class="arrow" width="8" height="56" viewBox="0 0 8 56" xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M1.33333 3C1.33333 4.47276 2.52724 5.66667 4 5.66667C5.47276 5.66667 6.66667 4.47276 6.66667 3C6.66667 1.52724 5.47276 0.333333 4 0.333333C2.52724 0.333333 1.33333 1.52724 1.33333 3ZM3.64645 55.3536C3.84171 55.5488 4.15829 55.5488 4.35355 55.3536L7.53553 52.1716C7.7308 51.9763 7.7308 51.6597 7.53553 51.4645C7.34027 51.2692 7.02369 51.2692 6.82843 51.4645L4 54.2929L1.17157 51.4645C0.976311 51.2692 0.659728 51.2692 0.464466 51.4645C0.269204 51.6597 0.269204 51.9763 0.464466 52.1716L3.64645 55.3536ZM3.5 3V55H4.5V3H3.5Z" />
                                                </svg>
                                            <?php endif; ?>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-7 wow animate fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="process-video-area">
                                <img src="<?php echo esc_url($settings['vernex_process_section_genaral_two_content_video_banner_image']['url']); ?>" alt="<?php echo esc_attr__('video-banner', 'vernex-core'); ?>">
                                <a data-fancybox="video-player" href="<?php echo esc_url($settings['vernex_process_section_genaral_two_content_video_url']['url']); ?>" class="play-btn">
                                    <div class="icon">
                                        <svg class="video-circle" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                            x="0px" y="0px" width="70px" viewBox="0 0 206 206" style="enable-background:new 0 0 206 206;" xml:space="preserve">
                                            <circle class="circle" stroke-miterlimit="10" cx="103" cy="103" r="100"></circle>
                                            <path class="circle-half top-half" stroke-width="4" stroke-miterlimit="10"
                                                d="M16.4,53C44,5.2,105.2-11.2,153,16.4s64.2,88.8,36.6,136.6"></path>
                                            <path class="circle-half bottom-half" stroke-width="4" stroke-miterlimit="10"
                                                d="M189.6,153C162,200.8,100.8,217.2,53,189.6S-11.2,100.8,16.4,53"></path>
                                        </svg>
                                        <svg class="play-icon" width="22" height="26" viewBox="0 0 22 26" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M21.0414 12.6872C21.0414 11.9857 20.68 11.3397 20.0741 10.9581L3.71746 0.667707C3.05587 0.252161 2.24905 0.221801 1.5565 0.588432C0.866106 0.954858 0.453125 1.63119 0.453125 2.39695V22.9762C0.453125 23.742 0.866072 24.4181 1.55755 24.7847C1.87989 24.9547 2.22564 25.0392 2.57141 25.0392C2.96897 25.0392 3.36391 24.927 3.71724 24.7054L20.0739 14.4166C20.68 14.0348 21.0414 13.3888 21.0414 12.6874V12.6872ZM19.4837 13.5246L3.12701 23.8134C2.80597 24.015 2.41492 24.0287 2.07958 23.8524C1.74423 23.6749 1.5435 23.3475 1.5435 22.976V2.39676C1.5435 2.02528 1.74423 1.69657 2.07958 1.52035C2.2363 1.43855 2.40452 1.39701 2.57165 1.39701C2.76458 1.39701 2.9562 1.45119 3.12725 1.55956L19.4839 11.85C19.7817 12.0376 19.9526 12.3438 19.9526 12.6887C19.9523 13.0323 19.7815 13.337 19.4837 13.5246Z" />
                                        </svg>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_process_section_genaral_style_selection'] == 'style_three') : ?>
            <div class="home6-process-section">
                <div class="container">
                    <div class="row align-items-lg-center justify-content-between mb-80">
                        <?php if (!empty($settings['vernex_process_section_genaral_title'])) : ?>
                            <div class="col-xl-6 col-lg-7 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <div class="section-title">
                                    <h2><?php echo esc_html($settings['vernex_process_section_genaral_title']); ?></h2>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if ($settings['vernex_process_section_genaral_show_pagination'] == 'yes') : ?>
                            <div class="col-lg-5 wow animate fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <div class="progress-area">
                                    <div class="progress-pagination"></div>
                                    <?php if (!empty($settings['vernex_process_section_genaral_pagination_title'])) : ?>
                                        <span><?php echo esc_html($settings['vernex_process_section_genaral_pagination_title']); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="process-slider-wrap">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="swiper home6-process-slider">
                                    <div class="swiper-wrapper">

                                        <?php foreach ($process_three as $process) : ?>
                                            <div class="swiper-slide">
                                                <div class="process-card-wrap">
                                                    <?php if (!empty($process['vernex_process_section_genaral_three_content_number'])) : ?>
                                                        <div class="step-no">
                                                            <span><?php echo esc_html($process['vernex_process_section_genaral_three_content_number']); ?></span>
                                                        </div>
                                                    <?php endif; ?>
                                                    <div class="process-card">
                                                        <?php if (!empty($process['vernex_process_section_genaral_three_content_icon'])) : ?>
                                                            <div class="process-content">
                                                                <?php \Elementor\Icons_Manager::render_icon($process['vernex_process_section_genaral_three_content_icon']); ?>
                                                                <?php if (!empty($process['vernex_process_section_genaral_three_content_title'])) : ?>
                                                                    <h4><?php echo wp_kses($process['vernex_process_section_genaral_three_content_title'], wp_kses_allowed_html('post')); ?></h4>
                                                                <?php endif; ?>
                                                                <?php if (!empty($process['vernex_process_section_genaral_three_content_descritption'])) : ?>
                                                                    <p><?php echo esc_html($process['vernex_process_section_genaral_three_content_descritption']); ?></p>
                                                                <?php endif; ?>
                                                            </div>
                                                        <?php endif ?>
                                                        <?php if (!empty($process['vernex_process_section_genaral_three_content_image']['url'])) : ?>
                                                            <div class="process-img">
                                                                <img src="<?php echo esc_url($process['vernex_process_section_genaral_three_content_image']['url']); ?>" alt="<?php echo esc_attr__('content-image', 'vernex-core'); ?>">
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Process_Widget());
