<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Hero_Banner_One_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_hero_banner_one';
    }

    public function get_title()
    {
        return esc_html__('EG Hero Banner One', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_hero_banner_one_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_section_genaral_show_pagination',
            [
                'label' => esc_html__("Show Pagination?", 'vernex-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vernex-core'),
                'label_off' => esc_html__('No', 'vernex-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_section_genaral_slider_image_gallery',
            [
                'label' => esc_html__('Add Slider Images', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::GALLERY,
                'show_label' => false,
                'default' => [],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_section_genaral_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Building Your Dreams With Precision', 'vernex-core'),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_section_genaral_button_text',
            [
                'label'       => esc_html__('Button Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Start A Project', 'vernex-core'),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_section_genaral_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_hero_banner_one_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_one_style_general_title_typ',
                'selector' => '{{WRAPPER}} .home1-banner-section .banner-content h1',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-banner-section .banner-content h1' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_style_general_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_one_style_general_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn2.white-bg span',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_style_general_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.white-bg span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_style_general_button_bg_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.white-bg span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_style_general_button_bg_icon_color_after',
            [
                'label'     => esc_html__('Icon Color After', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.white-bg span::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_style_general_button_bg_underline_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.white-bg span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_style_general_button_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.white-bg' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_style_general_pagination',
            [
                'label'     => esc_html__('Pagination', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_one_style_general_pagination_typ',
                'selector' => '{{WRAPPER}} .home1-banner-section .pagination-area .swiper-pagination1',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_style_general_pagination_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-banner-section .pagination-area .swiper-pagination1 .swiper-pagination-bullet' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_style_general_pagination_active_dot_color',
            [
                'label'     => esc_html__('Active Dot Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-banner-section .pagination-area .swiper-pagination1 .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_one_style_general_pagination_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-banner-section .pagination-area .swiper-pagination1' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $gallery_image = $settings['vernex_hero_banner_one_section_genaral_slider_image_gallery'] ?? [];

?>

        <?php if (is_admin()) : ?>
            <script>
                // Home1 Banner Slider
                var swiper = new Swiper(".home1-banner-slider", {
                    slidesPerView: 1,
                    speed: 1500,
                    effect: 'fade',
                    autoplay: {
                        delay: 2500, // Autoplay duration in milliseconds
                        disableOnInteraction: false,
                    },
                    pagination: {
                        el: ".swiper-pagination1",
                        clickable: true,
                    },
                });
            </script>
        <?php endif; ?>

        <div class="home1-banner-section">
            <div class="row">
                <div class="col-lg-12">
                    <div class="swiper home1-banner-slider">
                        <div class="swiper-wrapper">
                            <?php if (!empty($gallery_image)) : ?>
                                <?php foreach ($gallery_image as $image) : ?>
                                    <div class="swiper-slide">
                                        <div class="banner-bg" style="background-image: linear-gradient(180deg, rgba(0, 0, 0, 0.2) 0%, rgba(0, 0, 0, 0.2) 100%), url(<?php echo esc_url($image['url']); ?>);"></div>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="banner-content">
                <?php if (!empty($settings['vernex_hero_banner_one_section_genaral_title'])) : ?>
                    <h1><?php echo esc_html($settings['vernex_hero_banner_one_section_genaral_title']); ?></h1>
                <?php endif; ?>
                <?php if (!empty($settings['vernex_hero_banner_one_section_genaral_button_text'])) : ?>
                    <a href="<?php echo esc_url($settings['vernex_hero_banner_one_section_genaral_button_url']['url']); ?>" class="primary-btn2 white-bg">
                        <span>
                            <?php echo esc_html($settings['vernex_hero_banner_one_section_genaral_button_text']); ?>
                            <svg viewBox="0 0 13 20">
                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                            </svg>
                        </span>
                    </a>
                <?php endif; ?>
            </div>
            <?php if ($settings['vernex_hero_banner_one_section_genaral_show_pagination'] ==  'yes') : ?>
                <div class="pagination-area">
                    <div class="swiper-pagination1"></div>
                </div>
            <?php endif; ?>
        </div>


<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Hero_Banner_One_Widget());
