<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Hero_Banner_Four_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_hero_banner_four';
    }

    public function get_title()
    {
        return esc_html__('EG Hero Banner Four', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_hero_banner_four_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_section_genaral_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Building Your Dreams 
                    <span>
                        <svg width="83" height="83" viewBox="0 0 83 83" xmlns="http://www.w3.org/2000/svg">
                            <path d="M27.198 76.1241H36.0225V58.6747H32.0579C31.3289 58.6768 30.62 58.4352 30.0441 57.9881C29.4682 57.5411 29.0583 56.9143 28.8795 56.2075C28.7152 55.5722 28.7461 54.9022 28.9682 54.2848C29.1903 53.6673 29.5933 53.1311 30.1246 52.7461V46.212L33.7961 45.6458V50.7005L37.5149 48.6629V45.0644L41.652 44.4254V46.3964L44.5787 44.7929V0L27.198 7.42977V76.1241ZM41.6521 39.9455L37.515 40.7242V33.1916L41.6521 32.1708V39.9455ZM41.6521 27.6911L37.515 28.8515V21.3131L41.6521 19.9102V27.6911ZM41.6521 8.14307V15.4366L37.515 16.9788L37.5138 9.91857L41.6521 8.14307ZM30.1248 13.0849L33.7985 11.5102L33.7973 18.3663L30.1246 19.7283L30.1248 13.0849ZM30.1248 23.8193L33.7975 22.5754V29.9018L30.1248 30.9306V23.8194V23.8193ZM30.1248 35.0102L33.7975 34.105V41.4314L30.1248 42.1215V35.0103V35.0102ZM65.0244 7.86654V43.8337L58.2138 40.1022C56.6045 39.2205 54.749 39.2205 53.1396 40.1022L46.6221 43.6733V0L65.0244 7.86654ZM8.04692 28.2627V76.1241H25.1547V20.9496L8.04692 28.2627ZM15.3551 64.4609H12.3686V58.7307L15.3558 58.439L15.3551 64.4609ZM15.3568 55.0126L12.3686 55.4218V49.6698L15.3568 49.056V55.0126ZM15.3568 45.6369L12.3686 46.3718V40.6197L15.3568 39.6802V45.6369ZM15.3578 36.2576L12.3688 37.3145V31.9423L15.3589 30.6829L15.3578 36.2576ZM21.855 64.4609H18.4135V58.1388L21.855 57.8023V64.4609ZM21.855 54.1156L18.4135 54.5898V48.4297L21.855 47.7194V54.1156ZM21.855 44.0326L18.4135 44.8804V38.7165L21.855 37.6289V44.0326ZM21.855 33.9458L18.4125 35.1711V29.3986L21.855 27.9399V33.9458ZM79.8904 54.3087L57.2323 41.8942C56.2346 41.3476 55.1196 41.3476 54.1218 41.8942L31.4635 54.3087C30.9612 54.5839 30.7172 55.146 30.8593 55.7009C31.0014 56.2558 31.4855 56.6315 32.0583 56.6315H38.0662V76.1241H42.6598V63.9649H41.3838C41.1128 63.9649 40.8529 63.8572 40.6613 63.6656C40.4697 63.474 40.3621 63.2142 40.3621 62.9432C40.3621 62.6722 40.4697 62.4124 40.6613 62.2208C40.8529 62.0292 41.1128 61.9215 41.3838 61.9215H52.7235C52.9944 61.9215 53.2543 62.0292 53.4459 62.2208C53.6375 62.4124 53.7452 62.6722 53.7452 62.9432C53.7452 63.2142 53.6375 63.474 53.4459 63.6656C53.2543 63.8572 52.9944 63.9649 52.7235 63.9649H51.4474V76.1241H73.2881V56.6315H79.2958C79.8688 56.6315 80.3528 56.2558 80.4948 55.7009C80.6368 55.146 80.3929 54.5839 79.8904 54.3087ZM52.4785 50.015C52.4785 48.2485 53.9105 46.8164 55.677 46.8164C57.4434 46.8164 58.8755 48.2485 58.8755 50.015C58.8755 51.7814 57.4434 53.2135 55.677 53.2135C53.9105 53.2135 52.4785 51.7814 52.4785 50.015ZM62.1464 61.5726H57.6418V56.6317H62.1464V61.5726ZM68.6941 61.5726H64.1897V56.6317H68.6941V61.5726ZM2.46484 81.7219V79.4456C2.46484 78.7427 3.04005 78.1675 3.74296 78.1675H77.7213C78.4242 78.1675 78.9994 78.7427 78.9994 79.4456V81.7219C78.9994 82.4248 78.4242 83 77.7213 83H3.74296C3.04005 83 2.46484 82.4248 2.46484 81.7219Z"></path>
                        </svg>
                        Industry
                    </span>
                    with Precision.', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_section_genaral_logo_circle_icon',
            [
                'label'     => esc_html__('Circle Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => [],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_section_genaral_logo_circle_text',
            [
                'label'       => esc_html__('Circle Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('* TRANSFORMING VISIONS INTO REALITY WITH VERNEX!', 'vernex-core'),
                'placeholder' => esc_html__('write your text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_section_genaral_button_text',
            [
                'label'       => esc_html__('Button Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('SCROLL <br> DOWN', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_section_genaral_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_section_genaral_slider_gallery_images',
            [
                'label' => esc_html__('Slider Gallery Images', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::GALLERY,
                'show_label' => false,
                'default' => [],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_hero_banner_four_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_four_style_general_title_typ',
                'selector' => '{{WRAPPER}} .home4-banner-section .banner-content-wrap .title-area h1',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner-section .banner-content-wrap .title-area h1' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_style_general_title_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner-section .banner-content-wrap .title-area h1 span svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_style_general_title_span_color',
            [
                'label'     => esc_html__('Span Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner-section .banner-content-wrap .title-area h1 span' => '-webkit-text-stroke: 1px {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_style_general_cicle_text',
            [
                'label'     => esc_html__('Circle Text', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_four_style_general_cicle_text_typ',
                'selector' => '{{WRAPPER}} .home4-banner-section .banner-content-wrap .circular-text > svg textpath',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_style_general_cicle_text_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner-section .banner-content-wrap .circular-text > svg textpath' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_style_general_cicle_icon_text_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner-section .banner-content-wrap .circular-text .center-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_style_general_cicle_icon_bg_text_color',
            [
                'label'     => esc_html__('Icon Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner-section .banner-content-wrap .circular-text .center-icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_style_general_style_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_four_style_general_style_button_typ',
                'selector' => '{{WRAPPER}} .home4-banner-section .banner-img-slider-area .scroll-down-btn a span',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_style_general_style_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner-section .banner-img-slider-area .scroll-down-btn a span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_style_general_style_button_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner-section .banner-img-slider-area .scroll-down-btn:hover a span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_style_general_style_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner-section .banner-img-slider-area .scroll-down-btn a svg' => 'fill: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_hero_banner_four_style_general_style_button_hover_icon_color',
            [
                'label'     => esc_html__('Hover Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner-section .banner-img-slider-area .scroll-down-btn:hover a svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_style_general_style_button_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner-section .banner-img-slider-area .scroll-down-btn' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_style_general_style_button_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner-section .banner-img-slider-area .scroll-down-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_four_style_general_style_button_bg_hover_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner-section .banner-img-slider-area .scroll-down-btn:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );



        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $gallery_image = $settings['vernex_hero_banner_four_section_genaral_slider_gallery_images'] ?? [];

?>
        <div class="home4-banner-section">
            <div class="banner-content-wrap">
                <div class="title-area wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                    <?php if (!empty($settings['vernex_hero_banner_four_section_genaral_title'])) :

                        $kses_defaults = wp_kses_allowed_html('post');

                        $svg_args = array(
                            'svg'   => array(
                                'class'           => true,
                                'aria-hidden'     => true,
                                'aria-labelledby' => true,
                                'role'            => true,
                                'xmlns'           => true,
                                'width'           => true,
                                'height'          => true,
                                'viewbox'         => true // <= Must be lower case!
                            ),
                            'g'     => array('fill' => true),
                            'title' => array('title' => true),
                            'path'  => array(
                                'd'               => true,
                                'fill'            => true
                            )
                        );

                        $allowed_tags = array_merge($kses_defaults, $svg_args);

                    ?>
                        <h1><?php echo wp_kses($settings['vernex_hero_banner_four_section_genaral_title'], $allowed_tags)  ?></h1>
                    <?php endif ?>
                </div>

                <?php if (!empty($settings['vernex_hero_banner_four_section_genaral_logo_circle_text'])) : ?>
                    <div class="circular-text btn_wrapper">
                        <svg class="textcircle" width="168" height="168" viewBox="0 0 168 168">
                            <defs>
                                <path id="textcirclePath" d="M84,84 m-76,0 a76,76 0 1,1 152,0 a76,76 0 1,1 -152,0"></path>
                            </defs>
                            <text>
                                <textPath xlink:href="#textcirclePath" textLength="470"> <?php echo esc_html($settings['vernex_hero_banner_four_section_genaral_logo_circle_text']); ?> </textPath>
                            </text>
                        </svg>
                        <?php if (!empty($settings['vernex_hero_banner_four_section_genaral_logo_circle_icon'])) : ?>
                            <div class="center-icon">
                                <?php \Elementor\Icons_Manager::render_icon($settings['vernex_hero_banner_four_section_genaral_logo_circle_icon']); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

            </div>
            <div class="banner-img-slider-area">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="swiper home1-banner-slider">
                            <div class="swiper-wrapper">
                                <?php if (!empty($gallery_image)) : ?>
                                    <?php foreach ($gallery_image as $image) : ?>
                                        <div class="swiper-slide">
                                            <div class="banner-bg" style="background-image: url(<?php echo esc_url($image['url']); ?>);"></div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if (!empty($settings['vernex_hero_banner_four_section_genaral_button_text'])) : ?>
                    <div class="scroll-down-btn" id="scroll-btn">
                        <a href="<?php echo esc_url($settings['vernex_hero_banner_four_section_genaral_button_url']['url']); ?>">
                            <span><?php echo wp_kses($settings['vernex_hero_banner_four_section_genaral_button_text'], $allowed_tags)  ?></span>
                            <svg width="12" height="12" viewBox="0 0 12 12" xmlns="http://www.w3.org/2000/svg">
                                <g>
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M6.9009 11.1111C6.9009 8.94397 8.9009 6.96887 11.0991 6.96887L12 6.96887L12 5.19109L11.0991 5.19109C9.5009 5.19109 8.0018 5.88265 6.9009 6.96798L6.9009 -2.22889e-07L5.0991 -3.01648e-07L5.0991 6.96798C3.9982 5.88265 2.4991 5.19109 0.9009 5.19109L-2.2691e-07 5.19109L-3.04619e-07 6.96887L0.9009 6.96887C3.0982 6.96887 5.0991 8.94397 5.0991 11.1111L5.0991 12L6.9009 12L6.9009 11.1111Z"></path>
                                </g>
                            </svg>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Hero_Banner_Four_Widget());
