<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Hero_Banner_Five_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_hero_banner_five';
    }

    public function get_title()
    {
        return esc_html__('EG Hero Banner Five', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_hero_banner_five_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_section_genaral_banner_slider_area',
            [
                'label'     => esc_html__('Banner Slider Area', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $banner_slider = new \Elementor\Repeater();

        $banner_slider->add_control(
            'vernex_hero_banner_five_section_genaral_banner_slider_area_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Building Your Dreams With Precision', 'vernex-core'),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $banner_slider->add_control(
            'vernex_hero_banner_five_section_genaral_banner_slider_area_bg_image',
            [
                'label' => esc_html__('Banner Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_section_genaral_banner_slider_area_list',
            [
                'label'     => esc_html__('Banner Slider List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $banner_slider->get_controls(),
                'default'   => [
                    [
                        'vernex_hero_banner_five_section_genaral_banner_slider_area_title'    => esc_html__('INTERIOR DESIGN', 'vernex-core'),

                    ],
                    [
                        'vernex_hero_banner_five_section_genaral_banner_slider_area_title'    => esc_html__('LIGHTING DESIGN', 'vernex-core'),

                    ],
                    [
                        'vernex_hero_banner_five_section_genaral_banner_slider_area_title'    => esc_html__('OFFICE INTERIOR', 'vernex-core'),

                    ]
                ],
                'title_field'    => '{{{ vernex_hero_banner_five_section_genaral_banner_slider_area_title }}}',
            ]
        );


        $this->add_control(
            'vernex_hero_banner_five_section_genaral_social_area',
            [
                'label'     => esc_html__('Social Area', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $social_repeater = new \Elementor\Repeater();

        $social_repeater->add_control(
            'vernex_hero_banner_five_section_genaral_social_area_icon',
            [
                'label'     => esc_html__('Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => [
                    'value' => 'bx bxl-facebook',
                    'library' => 'solid',
                ]
            ]
        );

        $social_repeater->add_control(
            'vernex_hero_banner_five_section_genaral_social_area_icon_link',
            [
                'label'     => esc_html__('Social Url', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::URL,
                'options'   => ['url', 'is_external', 'nofollow'],
                'default'   => [
                    'url'         => '#',
                    'is_external' => true,
                    'nofollow'    => true,
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_section_genaral_social_area_social_list',
            [
                'label'     => esc_html__('Social List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $social_repeater->get_controls(),
                'default'   => [
                    [
                        'vernex_hero_banner_five_section_genaral_social_area_icon' => [
                            'value'   => 'bx bxl-facebook',
                            'library' => 'solid',
                        ],
                    ],
                    [
                        'vernex_hero_banner_five_section_genaral_social_area_icon' => [
                            'value'   => 'bi bi-twitter-x',
                            'library' => 'solid',
                        ],
                    ],
                    [
                        'vernex_hero_banner_five_section_genaral_social_area_icon' => [
                            'value'   => 'bx bxl-pinterest-alt',
                            'library' => 'solid',
                        ],
                    ],
                    [
                        'vernex_hero_banner_five_section_genaral_social_area_icon' => [
                            'value'   => 'bx bxl-instagram',
                            'library' => 'solid',
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_section_genaral_counter_area',
            [
                'label'     => esc_html__('Counter Area', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $counter = new \Elementor\Repeater();

        $counter->add_control(
            'vernex_hero_banner_five_section_genaral_counter_area_coun_number',
            [
                'label'       => esc_html__('Number', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('5', 'vernex-core'),
                'placeholder' => esc_html__('write your text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $counter->add_control(
            'vernex_hero_banner_five_section_genaral_counter_area_coun_number_sign',
            [
                'label'       => esc_html__('Sign', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('+', 'vernex-core'),
                'placeholder' => esc_html__('write your text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $counter->add_control(
            'vernex_hero_banner_five_section_genaral_counter_area_counter_title',
            [
                'label'       => esc_html__('Counter Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Regional offices', 'vernex-core'),
                'placeholder' => esc_html__('write your text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_section_genaral_counter_area_list',
            [
                'label'     => esc_html__('Counter List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $counter->get_controls(),
                'default'   => [
                    [
                        'vernex_hero_banner_five_section_genaral_counter_area_coun_number'    => esc_html__('98', 'vernex-core'),
                        'vernex_hero_banner_five_section_genaral_counter_area_coun_number_sign'    => esc_html__('%', 'vernex-core'),
                        'vernex_hero_banner_five_section_genaral_counter_area_counter_title'    => esc_html__('Client Satisfied', 'vernex-core'),

                    ],
                    [
                        'vernex_hero_banner_five_section_genaral_counter_area_coun_number'    => esc_html__('20', 'vernex-core'),
                        'vernex_hero_banner_five_section_genaral_counter_area_counter_title'    => esc_html__('Realized projects', 'vernex-core'),


                    ],
                    [
                        'vernex_hero_banner_five_section_genaral_counter_area_coun_number'    => esc_html__('45', 'vernex-core'),
                        'vernex_hero_banner_five_section_genaral_counter_area_coun_number_sign'    => esc_html__('', 'vernex-core'),
                        'vernex_hero_banner_five_section_genaral_counter_area_counter_title'    => esc_html__('Team members', 'vernex-core'),

                    ],
                    [
                        'vernex_hero_banner_five_section_genaral_counter_area_coun_number'    => esc_html__('5', 'vernex-core'),
                        'vernex_hero_banner_five_section_genaral_counter_area_coun_number_sign'    => esc_html__('+', 'vernex-core'),
                        'vernex_hero_banner_five_section_genaral_counter_area_counter_title'    => esc_html__('Regional offices', 'vernex-core'),

                    ],
                ],
                'title_field'    => '{{{ vernex_hero_banner_five_section_genaral_counter_area_coun_number }}}',
            ]
        );

        $this->end_controls_section();


        //style start
        $this->start_controls_section(
            'vernex_hero_banner_five_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_five_style_general_title_typ',
                'selector' => '{{WRAPPER}} .home5-banner-section .banner-area .banner-wrapper .banner-content h1',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-banner-section .banner-area .banner-wrapper .banner-content h1' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_style_general_social_area',
            [
                'label'     => esc_html__('Social Area', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_five_style_general_social_area_typ',
                'selector' => '{{WRAPPER}} .home5-banner-section .social-list li a',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_style_general_social_area_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-banner-section .social-list li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_style_general_social_area_icon_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-banner-section .social-list li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_style_general_social_card',
            [
                'label'     => esc_html__('Social Card Background', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_style_general_social_card_bg',
            [
                'label'     => esc_html__('Background', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-banner-section .social-list' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_style_general_counter_number',
            [
                'label'     => esc_html__('Counter Number', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_five_style_general_counter_number_typ',
                'selector' => '{{WRAPPER}} .home5-banner-section .banner-area .counter-area ul .single-counter .number h2',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_style_general_counter_number_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-banner-section .banner-area .counter-area ul .single-counter .number h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_style_general_counter_number_sign',
            [
                'label'     => esc_html__('Counter Sign', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_five_style_general_counter_number_sign_typ',
                'selector' => '{{WRAPPER}} .home5-banner-section .banner-area .counter-area ul .single-counter .number span',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_style_general_counter_number_sign_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-banner-section .banner-area .counter-area ul .single-counter .number span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_style_general_counter_number_title',
            [
                'label'     => esc_html__('Counter Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_five_style_general_counter_number_title_typ',
                'selector' => '{{WRAPPER}} .home5-banner-section .banner-area .counter-area ul .single-counter span',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_five_style_general_counter_number_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-banner-section .banner-area .counter-area ul .single-counter span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $sliders = $settings['vernex_hero_banner_five_section_genaral_banner_slider_area_list'];
        $social_list = $settings['vernex_hero_banner_five_section_genaral_social_area_social_list'];
        $counters = $settings['vernex_hero_banner_five_section_genaral_counter_area_list'];

?>

        <?php if (is_admin()) : ?>
            <script>
                var swiper = new Swiper(".home5-banner-slider", {
                    slidesPerView: 1,
                    speed: 1500,
                    effect: 'fade',
                    fadeEffect: {
                        crossFade: true // Enable cross-fade transition
                    },
                    autoplay: {
                        delay: 2500, // Autoplay duration in milliseconds
                        disableOnInteraction: false,
                    },
                    pagination: {
                        el: ".swiper-pagination1",
                        clickable: true,
                    },
                });
            </script>
        <?php endif; ?>
        <div class="home5-banner-section">
            <ul class="social-list">
                <?php foreach ($social_list as $social) : ?>
                    <?php if (!empty($social['vernex_hero_banner_five_section_genaral_social_area_icon'])) : ?>
                        <li><a href="<?php echo esc_url($social['vernex_hero_banner_five_section_genaral_social_area_icon_link']['url']); ?>"><?php \Elementor\Icons_Manager::render_icon($social['vernex_hero_banner_five_section_genaral_social_area_icon']); ?></a></li>
                    <?php endif; ?>
                <?php endforeach; ?>
            </ul>
            <div class="banner-area">
                <div class="swiper home5-banner-slider">
                    <div class="swiper-wrapper">
                        <?php foreach ($sliders as $slider) : ?>
                            <div class="swiper-slide">
                                <div class="banner-wrapper">
                                    <div class="banner-bg" style="background-image: linear-gradient(180deg, rgba(0, 0, 0, 0.3) 0%, rgba(0, 0, 0, 0.3) 100%), url(<?php echo esc_url($slider['vernex_hero_banner_five_section_genaral_banner_slider_area_bg_image']['url']); ?>);"></div>
                                    <?php if (!empty($slider['vernex_hero_banner_five_section_genaral_banner_slider_area_title'])) : ?>
                                        <div class="banner-content">
                                            <h1><?php echo esc_html($slider['vernex_hero_banner_five_section_genaral_banner_slider_area_title']); ?></h1>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php if (!empty($counters)) : ?>
                    <div class="counter-area">
                        <ul>
                            <?php foreach ($counters as $counter) : ?>
                                <li class="single-counter">
                                    <div class="number">
                                        <?php if (!empty($counter['vernex_hero_banner_five_section_genaral_counter_area_coun_number'])) : ?>
                                            <h2 class="counter"><?php echo esc_html($counter['vernex_hero_banner_five_section_genaral_counter_area_coun_number']); ?></h2>
                                        <?php endif; ?>
                                        <?php if (!empty($counter['vernex_hero_banner_five_section_genaral_counter_area_coun_number_sign'])) : ?>
                                            <span><?php echo esc_html($counter['vernex_hero_banner_five_section_genaral_counter_area_coun_number_sign']); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <?php if (!empty($counter['vernex_hero_banner_five_section_genaral_counter_area_counter_title'])) : ?>
                                        <span><?php echo esc_html($counter['vernex_hero_banner_five_section_genaral_counter_area_counter_title']); ?></span>
                                    <?php endif; ?>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
        </div>


<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Hero_Banner_Five_Widget());
