<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Footer_Menu_Two_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_footer_menu_two';
    }

    public function get_title()
    {
        return esc_html__('EG Footer Menu Two', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_footer_menu_two_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_footer_menu_two_section_genaral_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('SOLUTIONS'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        $contact_info = new \Elementor\Repeater();

        $contact_info->add_control(
            'vernex_footer_menu_two_section_genaral_menu_name',
            [
                'label' => esc_html__('Menu Item Name', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Residential'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),

            ]
        );

        $contact_info->add_control(
            'vernex_footer_menu_two_section_genaral_menu_name_url',
            [
                'label' => esc_html__('Menu Item URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_footer_menu_two_section_genaral_menu_list',
            [
                'label'     => esc_html__('Menu List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $contact_info->get_controls(),
                'default'   => [
                    [
                        'vernex_footer_menu_two_section_genaral_menu_name'    => wp_kses('Residential', wp_kses_allowed_html('post')),
                    ],
                    [
                        'vernex_footer_menu_two_section_genaral_menu_name'    => wp_kses('Commercial', wp_kses_allowed_html('post')),
                    ],
                    [
                        'vernex_footer_menu_two_section_genaral_menu_name'    => wp_kses('Industrial', wp_kses_allowed_html('post')),
                    ],
                    [
                        'vernex_footer_menu_two_section_genaral_menu_name'    => wp_kses('Infrastructure', wp_kses_allowed_html('post')),
                    ],
                ],
                'title_field'    => '{{{ vernex_footer_menu_two_section_genaral_menu_name }}}',
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $menu_two = $settings['vernex_footer_menu_two_section_genaral_menu_list'];
?>

        <div class="footer-widget">
            <?php if (!empty($settings['vernex_footer_menu_two_section_genaral_title'])) : ?>
                <div class="widget-title">
                    <h5><?php echo esc_html($settings['vernex_footer_menu_two_section_genaral_title']); ?></h5>
                </div>
            <?php endif; ?>
            <div class="menu-container">
                <ul class="widget-list">
                    <?php foreach ($menu_two as $menu) : ?>
                        <?php if (!empty($menu['vernex_footer_menu_two_section_genaral_menu_name'])) : ?>
                            <li><a href="<?php echo esc_url($menu['vernex_footer_menu_two_section_genaral_menu_name_url']['url']); ?>"><?php echo esc_html($menu['vernex_footer_menu_two_section_genaral_menu_name']); ?></a></li>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Footer_Menu_Two_Widget());
