<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Vernex_Contact_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_contact';
    }

    public function get_title()
    {
        return esc_html__('EG Contact ', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//
        //Content One
        $this->start_controls_section(
            'vernex_contact_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_contact_genaral_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),
                    'style_three' => esc_html__('Style Three', 'vernex-core'),
                    'style_four' => esc_html__('Style Four', 'vernex-core'),
                    'style_five' => esc_html__('Style Five', 'vernex-core'),
                    

                ],
                'default' => 'style_one',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'vernex_contact_section_sec',
            [
                'label' => esc_html__('Contact Information', 'vernex-core'),
                'condition' => [
                    'vernex_contact_genaral_style_selection' => 'style_one'
                ]
            ]
        );

        $this->add_control(
            'vernex_contact_section_bac_image',
            [
                'label' => esc_html__('Background Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'vernex_contact_section_subtitle',
            [
                'label' => esc_html__('Sub Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Building Your Vision'),
                'placeholder' => esc_html__('Type your subtitle here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_contact_section_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Lets Build Dream Something Amazing.'),
                'placeholder' => esc_html__('Type your title here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_contact_section_btn_sec',
            [
                'label' => esc_html__('Button One', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_contact_section_title_button_text',
            [
                'label' => esc_html__('Button Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html(' Connect With Us'),
                'placeholder' => esc_html__('Type your button text here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_contact_section_title_text_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_contact_section_btn_two_sec',
            [
                'label' => esc_html__('Button Two', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_contact_section_title_button_two_text',
            [
                'label' => esc_html__('Button Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html(' Connect With Us'),
                'placeholder' => esc_html__('Type your button text here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_contact_section_title_two_text_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        //Content Two
        $this->start_controls_section(
            'vernex_contact_section_two_sec',
            [
                'label' => esc_html__('Contact Information', 'vernex-core'),
                'condition' => [
                    'vernex_contact_genaral_style_selection' => 'style_two'
                ]
            ]
        );


        $this->add_control(
            'vernex_contact_section_two_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Get In Touch!'),
                'placeholder' => esc_html__('Type your title here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_contact_section_two_desc',
            [
                'label' => esc_html__('Description', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html('Sed nisl eros, condimentum nec risus sit amet, finibus conguese.Fusen fringilla est libero, sed tempus urna feugiat eu. Curabitur eu feugiat ligu Suspendisse nectoraba porttitor velit.'),
                'placeholder' => esc_html__('Type your description here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_contact_section_two_form_shortcode',
            [
                'label' => esc_html__('Shortcode', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html(''),
                'placeholder' => esc_html__('Type your shortcode here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->end_controls_section();

        //Content Three
        $this->start_controls_section(
            'vernex_contact_section_three_sec',
            [
                'label' => esc_html__('Contact Information', 'vernex-core'),
                'condition' => [
                    'vernex_contact_genaral_style_selection' => 'style_three'
                ]
            ]
        );


        $this->add_control(
            'vernex_contact_section_three_subtitle',
            [
                'label' => esc_html__('Sub Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Contact Us'),
                'placeholder' => esc_html__('Type your sub title here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_contact_section_three_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Contact Us Your Cool Interior.'),
                'placeholder' => esc_html__('Type your  title here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_contact_section_three_form_shortcode',
            [
                'label' => esc_html__('Shortcode', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html(''),
                'placeholder' => esc_html__('Type your  shortcode here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->end_controls_section();

        //Content Four
        $this->start_controls_section(
            'vernex_contact_section_four_sec',
            [
                'label' => esc_html__('Contact Information', 'vernex-core'),
                'condition' => [
                    'vernex_contact_genaral_style_selection' => 'style_four'
                ]
            ]
        );

        $this->add_control(
            'vernex_contact_four_section_bac_image',
            [
                'label' => esc_html__('Background Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $this->add_control(
            'vernex_contact_section_four_subtitle',
            [
                'label' => esc_html__('Sub Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Design Your Vision'),
                'placeholder' => esc_html__('Type your sub title here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_contact_section_four_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Lets Build Dream Something Amazing.'),
                'placeholder' => esc_html__('Type your  title here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_contact_section_four_btn_sec',
            [
                'label' => esc_html__('Button One', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_contact_section_title_button_four_text',
            [
                'label' => esc_html__('Button Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html(' Connect With Us'),
                'placeholder' => esc_html__('Type your button text here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_contact_section_title_text_four_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_contact_section_btn_four_sec',
            [
                'label' => esc_html__('Button Two', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_contact_section_title_two_button_four_text',
            [
                'label' => esc_html__('Button Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html(' Connect With Us'),
                'placeholder' => esc_html__('Type your button text here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_contact_section_title_four_text_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->end_controls_section();


        //Content Five
        $this->start_controls_section(
            'vernex_contact_section_five_sec',
            [
                'label' => esc_html__('Contact Information', 'vernex-core'),
                'condition' => [
                    'vernex_contact_genaral_style_selection' => 'style_five'
                ]
            ]
        );

        $this->add_control(
            'vernex_contact_section_heading_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Connect with our team.', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'vernex_contact_section_four_content_type_selection',
            [
                'label'   => esc_html__('Select Type', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'phone' => esc_html__('Phone', 'vernex-core'),
                    'email' => esc_html__('Email', 'vernex-core'),
                ],
                'default' => 'phone',
            ]
        );


        $repeater->add_control(
            'vernex_contact_section_four_icon_image',
            [
                'label' => esc_html__('Contact Icon', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [],
            ]
        );


        $repeater->add_control(
            'vernex_contact_section_four_content_title',
            [
                'label'     => esc_html__('Content Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default'   => esc_html('To More Inquiry'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_contact_section_four_content_phone_number',
            [
                'label'     => esc_html__('Phone Number', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default'   => esc_html('+990-737 621 432'),
                'label_block' => true,
                'condition' => [
                    'vernex_contact_section_four_content_type_selection' => ['phone'],
                ]
            ]
        );

        $repeater->add_control(
            'vernex_contact_section_four_content_email',
            [
                'label'     => esc_html__('Email Address', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default'   => esc_html('example@gmail.com'),
                'label_block' => true,
                'condition' => [
                    'vernex_contact_section_four_content_type_selection' => ['email'],
                ]
            ]
        );

        $this->add_control(
            'contact_style_four_content_list',
            [
                'label'     => esc_html__('Content List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $repeater->get_controls(),
                'default'   => [
                    [
                        'vernex_contact_section_four_content_title'    => __('To More Inquiry', 'vernex-core'),
                    ]
                ],
                'title_field'  => '{{{ vernex_contact_section_four_content_title}}}',

            ]
        );

        $this->add_control(
            'vernex_contact_section_five_form_shortcode',
            [
                'label'     => esc_html__('Shortcode', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default'   => esc_html(''),
                'label_block' => true,
            ]
        );


        $this->end_controls_section();

        // =====================Style One  =======================//

        //contact Section

        $this->start_controls_section(
            'vernex_contact_style_sec',
            [
                'label' => esc_html__('Contact Style ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_contact_genaral_style_selection' => 'style_one'
                ]

            ]
        );

        //title
        $this->add_control(
            'vernex_contact_style_subtitle_sec',
            [
                'label' => esc_html__('Sub Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_contact_style_subtitle_sec_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_contact_style_subtitle_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );


        //title
        $this->add_control(
            'vernex_contact_style_title_sec',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_contact_style_title_sec_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_contact_style_title_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        //Button One
        $this->add_control(
            'vernex_contact_style_button_one_sec',
            [
                'label' => esc_html__('Button One', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_contact_style_button_one_sec_typ',
                'selector' => '{{WRAPPER}} .primary-btn2 span',

            ]
        );

        $this->add_control(
            'vernex_contact_style_button_one_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.white-bg span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_contact_style_button_one_sec_bac_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.white-bg' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        //Button Two
        $this->add_control(
            'vernex_contact_style_button_two_sec',
            [
                'label' => esc_html__('Button Two', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_contact_style_button_two_sec_typ',
                'selector' => '{{WRAPPER}} .primary-btn',

            ]
        );

        $this->add_control(
            'vernex_contact_style_button_two_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn.white' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // =====================Style Two  =======================//

        //contact Section

        $this->start_controls_section(
            'vernex_contact_style_two_sec',
            [
                'label' => esc_html__('Contact Style ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_contact_genaral_style_selection' => 'style_two'
                ]

            ]
        );

        //title
        $this->add_control(
            'vernex_contact_style_title_two_sec',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_contact_style_title_two_sec_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_contact_style_subtitle_two_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        //content
        $this->add_control(
            'vernex_contact_style_content_two_sec',
            [
                'label' => esc_html__('Content', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_contact_style_content_two_sec_typ',
                'selector' => '{{WRAPPER}} .section-title p',

            ]
        );

        $this->add_control(
            'vernex_contact_style_content_two_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        //Button
        $this->add_control(
            'vernex_contact_two_style_button_two_sec',
            [
                'label' => esc_html__('Button', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_contact_two_style_button_two_sec_typ',
                'selector' => '{{WRAPPER}} .primary-btn2 span ',

            ]
        );

        $this->add_control(
            'vernex_contact_two_style_button_two_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'vernex_contact_two_style_button_two_sec_bac_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // =====================Style Three  =======================//

        //contact Section

        $this->start_controls_section(
            'vernex_contact_style_three_sec',
            [
                'label' => esc_html__('Contact Style ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_contact_genaral_style_selection' => 'style_three'
                ]

            ]
        );

        //sub title
        $this->add_control(
            'vernex_contact_style_subtitle_three_sec',
            [
                'label' => esc_html__('Sub Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_contact_style_subtitle_three_sec_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_contact_style_subtitle_three_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        //title
        $this->add_control(
            'vernex_contact_style_title_three_sec',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_contact_style_title_three_sec_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_contact_style_title_three_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // =====================Style Four =======================//

        //contact Section

        $this->start_controls_section(
            'vernex_contact_style_four_sec',
            [
                'label' => esc_html__('Contact Style ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_contact_genaral_style_selection' => 'style_four'
                ]

            ]
        );

        //sub title
        $this->add_control(
            'vernex_contact_style_subtitle_four_sec',
            [
                'label' => esc_html__('Sub Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_contact_style_subtitle_four_sec_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_contact_style_subtitle_four_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        //title
        $this->add_control(
            'vernex_contact_style_title_four_sec',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_contact_style_title_four_sec_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_contact_style_title_four_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );



        //Button One
        $this->add_control(
            'vernex_contact_style_button_four_sec',
            [
                'label' => esc_html__('Button One', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_contact_style_button_four_sec_typ',
                'selector' => '{{WRAPPER}} .primary-btn2 span ',

            ]
        );

        $this->add_control(
            'vernex_contact_style_button_four_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'vernex_contact_style_button_four_sec_bac_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        //Button Two
        $this->add_control(
            'vernex_contact_style_two_button_four_sec',
            [
                'label' => esc_html__('Button Two', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_contact_style_two_button_four_sec_typ',
                'selector' => '{{WRAPPER}} .primary-btn',

            ]
        );

        $this->add_control(
            'vernex_contact_style_two_button_four_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();


        // =====================Style Five =======================//

        //contact Section

        $this->start_controls_section(
            'vernex_contact_style_five_sec',
            [
                'label' => esc_html__('Contact Style ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_contact_genaral_style_selection' => 'style_five'
                ]

            ]
        );

        //title
        $this->add_control(
            'vernex_contact_style_title_five_sec',
            [
                'label' => esc_html__(' Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_contact_style_title_five_sec_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_contact_style_title_five_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        //contact area

        $this->add_control(
            'vernex_contact_style_contact_area_five_sec',
            [
                'label' => esc_html__('Contact Area', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_contact_style_title_contact_area_five_sec_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-contact-section .contact-wrapper .contact-content .contact-list .single-contact .icon svg ' => 'fill: {{VALUE}};',
                ],
            ]
        );

        //Title
        $this->add_control(
            'vernex_contact_style_title_contact_area_five_sec',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_contact_style_title_contact_area_five_sec_typ',
                'selector' => '{{WRAPPER}} .home6-contact-section .contact-wrapper .contact-content .contact-list .single-contact .content span',

            ]
        );

        $this->add_control(
            'vernex_contact_style_title_contact_area_five_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-contact-section .contact-wrapper .contact-content .contact-list .single-contact .content span ' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        //number
        $this->add_control(
            'vernex_contact_style_number_contact_area_five_sec',
            [
                'label' => esc_html__('Number', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_contact_style_number_contact_area_five_sec_typ',
                'selector' => '{{WRAPPER}} .home6-contact-section .contact-wrapper .contact-content .contact-list .single-contact .content h6 a',

            ]
        );

        $this->add_control(
            'vernex_contact_style_number_contact_area_five_sec_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-contact-section .contact-wrapper .contact-content .contact-list .single-contact .content h6 a' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'vernex_contact_style_number_contact_area_five_sec_hov_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-contact-section .contact-wrapper .contact-content .contact-list .single-contact .content h6 a:hover' => '-webkit-text-fill-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $data2 = $settings['contact_style_four_content_list'];
?>

        <?php if ($settings['vernex_contact_genaral_style_selection'] == 'style_one') : ?>
            <div class="home1-footer-top-banner-section" style="background-image: linear-gradient(91.45deg, #000000 27.11%, rgba(0, 0, 0, 0.9) 53.38%, rgba(0, 0, 0, 0.8) 75.41%, rgba(0, 0, 0, 0.5) 98.52%), url(<?php echo !empty($settings['vernex_contact_section_bac_image']['url']) ? esc_url($settings['vernex_contact_section_bac_image']['url']) : '../img/home1/home1-contact-bg.jpg'; ?>); background-size: cover; background-repeat: no-repeat;">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-7">
                            <div class="banner-content">
                                <div class="section-title white wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                    <?php if (!empty($settings['vernex_contact_section_subtitle'])) :   ?>
                                        <span><?php echo esc_html($settings['vernex_contact_section_subtitle']); ?></span>
                                    <?php endif ?>
                                    <?php if (!empty($settings['vernex_contact_section_title'])) :   ?>
                                        <h2><?php echo esc_html($settings['vernex_contact_section_title']); ?></h2>
                                    <?php endif ?>
                                </div>
                                <div class="button-area wow animate fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
                                    <?php if (!empty($settings['vernex_contact_section_title_button_text'])) :   ?>
                                        <a href="<?php echo esc_url($settings['vernex_contact_section_title_text_url']['url']) ?>" class="primary-btn2 white-bg">
                                            <span>
                                                <?php echo esc_html($settings['vernex_contact_section_title_button_text']); ?>
                                                <svg viewBox="0 0 13 20">
                                                    <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                                </svg>
                                            </span>
                                        </a>
                                    <?php endif ?>
                                    <?php if (!empty($settings['vernex_contact_section_title_button_two_text'])) :   ?>
                                        <a href="<?php echo esc_url($settings['vernex_contact_section_title_two_text_url']['url']) ?>" class="primary-btn white">
                                            <?php echo esc_html($settings['vernex_contact_section_title_button_two_text']); ?>
                                            <svg viewBox="0 0 13 20">
                                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                            </svg>
                                        </a>
                                    <?php endif ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif ?>

        <?php if ($settings['vernex_contact_genaral_style_selection'] == 'style_two') : ?>
            <div class="home2-contact-section">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-xl-8 col-lg-10">
                            <div class="section-title two text-center mb-60 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <?php if (!empty($settings['vernex_contact_section_two_title'])) :   ?>
                                    <h2><?php echo esc_html($settings['vernex_contact_section_two_title']); ?></h2>
                                <?php endif ?>
                                <?php if (!empty($settings['vernex_contact_section_two_desc'])) :   ?>
                                    <p><?php echo esc_html($settings['vernex_contact_section_two_desc']); ?></p>
                                <?php endif ?>
                            </div>

                            <?php if (!empty($settings['vernex_contact_section_two_form_shortcode'])) : ?>
                                    <?php echo do_shortcode($settings['vernex_contact_section_two_form_shortcode']);  ?>
                                <?php endif; ?>
                            
                        </div>
                    </div>
                </div>
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/home2/home2-contact-vector1.png" alt="<?php echo esc_attr__('vector-image','vernex-core');?>" class="vector1">

                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/home2/home2-contact-vector2.png" alt="<?php echo esc_attr__('vector-image','vernex-core');?>" class="vector2">

            </div>
        <?php endif ?>

        <?php if ($settings['vernex_contact_genaral_style_selection'] == 'style_three') : ?>
            <div class="home5-contact-section">
                <div class="container">
                    <div class="row justify-content-center mb-70 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-xl-5 col-lg-6">
                            <div class="section-title four text-center">
                                <?php if (!empty($settings['vernex_contact_section_three_subtitle'])) :   ?>
                                    <span><?php echo esc_html($settings['vernex_contact_section_three_subtitle']); ?></span>
                                <?php endif ?>
                                <?php if (!empty($settings['vernex_contact_section_three_title'])) :   ?>
                                    <h2><?php echo esc_html($settings['vernex_contact_section_three_title']); ?></h2>
                                <?php endif ?>
                            </div>
                        </div>
                    </div>
                    <div class="row justify-content-center wow animate fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-xl-8 col-lg-10">
                            <div class="contact-form">
                                
                            <?php if (!empty($settings['vernex_contact_section_three_form_shortcode'])) : ?>
                                    <?php echo do_shortcode($settings['vernex_contact_section_three_form_shortcode']);  ?>
                                <?php endif; ?>
                              
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif ?>


        <?php if ($settings['vernex_contact_genaral_style_selection'] == 'style_four') : ?>
            <div class="home1-footer-top-banner-section two" style="background-image: 
    linear-gradient(90.44deg, rgba(0, 0, 0, 0.75) 0.35%, #000000 35.13%, #000000 65.37%, rgba(0, 0, 0, 0.75) 99.62%), 
    url(<?php echo !empty($settings['vernex_contact_four_section_bac_image']['url']) ? esc_url($settings['vernex_contact_four_section_bac_image']['url']) : '../img/home1/home1-contact-bg.jpg'; ?>); 
    background-size: cover; 
    background-repeat: no-repeat;">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-xl-6 col-lg-8">
                            <div class="banner-content">
                                <div class="section-title four white wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                    <?php if (!empty($settings['vernex_contact_section_four_subtitle'])) :   ?>
                                        <span><?php echo esc_html($settings['vernex_contact_section_four_subtitle']); ?></span>
                                    <?php endif ?>
                                    <?php if (!empty($settings['vernex_contact_section_four_title'])) :   ?>
                                        <h2><?php echo esc_html($settings['vernex_contact_section_four_title']); ?></h2>
                                    <?php endif ?>
                                </div>
                                <div class="button-area wow animate fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
                                    <?php if (!empty($settings['vernex_contact_section_title_button_four_text'])) :   ?>
                                        <a href="<?php echo esc_url($settings['vernex_contact_section_title_text_four_url']['url']) ?>" class="primary-btn2 white-bg">
                                            <span>
                                                <?php echo esc_html($settings['vernex_contact_section_title_button_four_text']); ?>
                                                <svg viewBox="0 0 13 20">
                                                    <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                                </svg>
                                            </span>
                                        </a>
                                    <?php endif ?>
                                    <?php if (!empty($settings['vernex_contact_section_title_two_button_four_text'])) :   ?>
                                        <a href="<?php echo esc_url($settings['vernex_contact_section_title_four_text_url']['url']) ?>" class="primary-btn white">
                                            <?php echo esc_html($settings['vernex_contact_section_title_two_button_four_text']); ?>
                                            <svg viewBox="0 0 13 20">
                                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                            </svg>
                                        </a>
                                    <?php endif ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif ?>


        <?php if ($settings['vernex_contact_genaral_style_selection'] == 'style_five') : ?>
            <div class="home6-contact-section">
                <div class="container">
                    <div class="contact-wrapper">
                        <div class="row gy-5 align-items-center">
                            <div class="col-lg-5 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <div class="contact-content">
                                    <?php if (!empty($settings['vernex_contact_section_heading_title'])) :   ?>
                                        <div class="section-title">
                                            <h2><?php echo esc_html($settings['vernex_contact_section_heading_title']); ?></h2>
                                        </div>
                                    <?php endif; ?>
                                    <svg width="8" height="143" viewBox="0 0 8 143" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M1.33333 3C1.33333 4.47276 2.52724 5.66667 4 5.66667C5.47276 5.66667 6.66667 4.47276 6.66667 3C6.66667 1.52724 5.47276 0.333333 4 0.333333C2.52724 0.333333 1.33333 1.52724 1.33333 3ZM3.64645 142.354C3.84171 142.549 4.1583 142.549 4.35356 142.354L7.53554 139.172C7.7308 138.976 7.7308 138.66 7.53554 138.464C7.34028 138.269 7.0237 138.269 6.82843 138.464L4.00001 141.293L1.17158 138.464C0.976317 138.269 0.659734 138.269 0.464472 138.464C0.26921 138.66 0.26921 138.976 0.464472 139.172L3.64645 142.354ZM3.5 3L3.50001 142L4.50001 142L4.5 3L3.5 3Z" />
                                    </svg>
                                    <ul class="contact-list">
                                        <?php foreach ($data2 as  $item) : ?>
                                            <li class="single-contact">
                                                <?php if (!empty($item['vernex_contact_section_four_icon_image'])) :   ?>
                                                    <div class="icon">
                                                        <?php \Elementor\Icons_Manager::render_icon($item['vernex_contact_section_four_icon_image'], ['aria-hidden' => 'true']); ?>
                                                    </div>
                                                <?php endif; ?>
                                                <div class="content">
                                                    <?php if (!empty($item['vernex_contact_section_four_content_title'])) :   ?>
                                                        <span><?php echo esc_html($item['vernex_contact_section_four_content_title']); ?></span>
                                                    <?php endif ?>

                                                    <h6><a href="<?php if ($item['vernex_contact_section_four_content_type_selection'] == 'phone') : ?>tel:<?php echo preg_replace('/\D/', '', $item['vernex_contact_section_four_content_phone_number']); ?><?php endif; ?><?php if ($item['vernex_contact_section_four_content_type_selection'] == 'email') : ?>mailto:<?php echo esc_html($item['vernex_contact_section_four_content_email']); ?><?php endif; ?>"><?php if ($item['vernex_contact_section_four_content_type_selection'] == 'phone') : ?><?php echo esc_html($item['vernex_contact_section_four_content_phone_number']); ?><?php endif; ?><?php if ($item['vernex_contact_section_four_content_type_selection'] == 'email') : ?><?php echo esc_html($item['vernex_contact_section_four_content_email']); ?><?php endif; ?></a></h6>


                                                </div>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-lg-7 wow animate fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <div class="contact-form-wrap">
               
                                <?php if (!empty($settings['vernex_contact_section_five_form_shortcode'])) : ?>
                                    <?php echo do_shortcode($settings['vernex_contact_section_five_form_shortcode']);  ?>
                                <?php endif; ?>

                                 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif ?>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Contact_Widget());
