<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class Vernex_Button_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_button';
    }

    public function get_title()
    {
        return esc_html__('EG Button', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        // ---------------------------Content one--------------------------//

        $this->start_controls_section(
            'vernex_button_content_general_section',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_button_content_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),
                    'style_three' => esc_html__('Style Three', 'vernex-core'),
                    'style_four' => esc_html__('Style Four', 'vernex-core'),

                ],
                'default' => 'style_one',
            ]
        );

        $this->add_responsive_control(
            'vernex_button_content_align',
            [
                'label'         => esc_html__('Button Align', 'vernex-core'),
                'type'             => \Elementor\Controls_Manager::CHOOSE,
                'options'         => [
                    'left'         => [
                        'title' => esc_html__('Left', 'vernex-core'),
                        'icon'     => 'eicon-text-align-left',
                    ],
                    'center'     => [
                        'title' => esc_html__('Center', 'vernex-core'),
                        'icon'     => 'eicon-text-align-center',
                    ],
                    'right'     => [
                        'title' => esc_html__('Right', 'vernex-core'),
                        'icon'     => 'eicon-text-align-right',
                    ],
                    'justify'     => [
                        'title' => esc_html__('Justified', 'vernex-core'),
                        'icon'     => 'eicon-text-align-justify',
                    ],
                ],
                'default'         => 'center',
                'selectors'     => [
                    '{{WRAPPER}} .btn-align' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();



        $this->start_controls_section(
            'vernex_button_content_section',
            [
                'label' => esc_html__('Button', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_button_content_text',
            [
                'label' => esc_html__('Button Text', 'vernex-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('START A PROJECT', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_button_link',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->end_controls_section();


        // =====================Style One=======================//

        $this->start_controls_section(
            'vernex_button_style_one',
            [
                'label' => esc_html__('Button', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_button_content_style_selection' => 'style_one',
                ],

            ]
        );

        // Tabs
        $this->start_controls_tabs(
            'style_tabs'
        );

        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__(
                    'Normal',
                    'vernex-core'
                ),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_btn_one_typ',
                'selector' => '{{WRAPPER}} .primary-btn2 span',

            ]
        );
        $this->add_control(
            'vernex_btn_one_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'vernex_btn_one_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.white-bg span::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_btn_one_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'vernex_btn_one_border_radius',
            [
                'label'      => __('Border Radius', 'vernex-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .primary-btn2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .primary-btn2::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'vernex_btn_one_margin',
            [
                'label' => esc_html__('Margin', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vernex_btn_one_padding',
            [
                'label'      => __(
                    'Padding',
                    'vernex-core'
                ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .primary-btn2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );
        $this->end_controls_tab();

        $this->end_controls_section();
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        if (!empty($settings['vernex_button_link']['url'])) {
            $this->add_link_attributes('vernex_button_link', $settings['vernex_button_link']);
        }
?>

        <?php if ($settings['vernex_button_content_style_selection'] == 'style_one') : ?>
            <div class="home1-banner-section">
                <a <?php echo $this->get_render_attribute_string('vernex_button_link'); ?> class="primary-btn2 white-bg">
                    <span>
                        <?php echo esc_html($settings['vernex_button_content_text']); ?>
                        <svg viewBox="0 0 13 20">
                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                        </svg>
                    </span>
                </a>
                </div>
            <?php endif; ?>
      

    <?php
    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Button_Widget());
