<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Brand_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_brand';
    }

    public function get_title()
    {
        return esc_html__('EG Brand', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_brand_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_brand_section_genaral_show_header_title',
            [
                'label' => esc_html__("Show Header Section?", 'vernex-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vernex-core'),
                'label_off' => esc_html__('No', 'vernex-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'vernex_brand_section_genaral_subtitle',
            [
                'label'       => esc_html__('Subtitle', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Building Trust Since 2005', 'vernex-core'),
                'placeholder' => esc_html__('write your subtitle here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $this->add_control(
            'vernex_brand_section_genaral_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Our Brand', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );


        $brand = new \Elementor\Repeater();


        $brand->add_control(
            'vernex_brand_section_genaral_brand_logo_image',
            [
                'label' => esc_html__('Brand Logo', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $brand->add_control(
            'vernex_brand_section_genaral_brand_logo_image_url',
            [
                'label' => esc_html__('Brand Logo URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_brand_section_genaral_brand_logo_image_list',
            [
                'label' => esc_html__('Brand Logo List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $brand->get_controls(),
                'default' => [
                    [
                        'vernex_brand_section_genaral_brand_logo_image' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'vernex_brand_section_genaral_brand_logo_image' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_section();


        // style start
        $this->start_controls_section(
            'vernex_brand_section_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_brand_section_style_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_brand_section_style_general_subtitle',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );


        $this->add_control(
            'vernex_brand_section_style_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_brand_section_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_brand_section_style_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );


        $this->add_control(
            'vernex_brand_section_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );



        $this->add_control(
            'vernex_brand_section_style_general_border',
            [
                'label'     => esc_html__('Section Border', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'vernex_brand_section_style_general_border_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .brand-page .logo-wrap .single-logo' => 'border: 0.5px solid {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $brand_logo_list = $settings['vernex_brand_section_genaral_brand_logo_image_list'];
?>

        <div class="brand-page">
            <div class="container">
                <?php if ($settings['vernex_brand_section_genaral_show_header_title'] == 'yes') : ?>
                    <div class="row mb-70">
                        <div class="col-lg-12 d-flex justify-content-center">
                            <div class="section-title">
                                <?php if (!empty($settings['vernex_brand_section_genaral_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_brand_section_genaral_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_brand_section_genaral_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_brand_section_genaral_title']); ?></h2>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="logo-wrap">
                    <div class="row g-0 justify-content-center row-cols-lg-6 row-cols-md-4 row-cols-sm-4 row-cols-2">
                        <?php foreach ($brand_logo_list as $brand_logo) : ?>
                            <div class="col">
                                <?php if (!empty($brand_logo['vernex_brand_section_genaral_brand_logo_image']['url'])) : ?>
                                    <a href="<?php echo esc_url($brand_logo['vernex_brand_section_genaral_brand_logo_image_url']['url']); ?>" class="single-logo">
                                        <img src="<?php echo esc_url($brand_logo['vernex_brand_section_genaral_brand_logo_image']['url']); ?>" alt="<?php echo esc_attr__('brand-logo', 'vernex-core'); ?>">
                                    </a>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>

            </div>
        </div>


<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Brand_Widget());
