<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Blog_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_blog';
    }

    public function get_title()
    {
        return esc_html__('EG Blog', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_blog_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_blog_section_genaral_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),
                    'style_three' => esc_html__('Style Three', 'vernex-core'),
                    'style_four' => esc_html__('Style Four', 'vernex-core'),
                    'style_five' => esc_html__('Style Five', 'vernex-core'),
                    'style_six' => esc_html__('Style Six', 'vernex-core'),

                ],
                'default' => 'style_one',
            ]
        );

        $this->add_control(
            'vernex_blog_section_genaral_show_pagination',
            [
                'label' => esc_html__("Show Pagination?", 'vernex-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vernex-core'),
                'label_off' => esc_html__('No', 'vernex-core'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'vernex_blog_section_genaral_style_selection' => ['style_one', 'style_two'],
                ]
            ]
        );

        $this->add_control(
            'vernex_blog_section_genaral_subtitle',
            [
                'label'         => esc_html__('Subtitle', 'vernex-core'),
                'type'          => \Elementor\Controls_Manager::TEXT,
                'default'       => esc_html__('Industry Insights', 'vernex-core'),
                'placeholder'   => esc_html__('write your subtitle here', 'vernex-core'),
                'label_block'   => true,
                'condition'     => [
                    'vernex_blog_section_genaral_style_selection' => ['style_one', 'style_two', 'style_three', 'style_five'],
                ]
            ]
        );

        $this->add_control(
            'vernex_blog_section_genaral_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('News & Blog Insights.', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_blog_section_genaral_description',
            [
                'label'       => esc_html__('Short Description', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Sed nisl eros, condimentum nec risus sit amet, finibus conguese.Fusen fringilla est libero sed tempus urna feugiat eu. Curabitur eu feugiat ligu Suspendisse.', 'vernex-core'),
                'placeholder' => esc_html__('write your description here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_blog_section_genaral_style_selection' => ['style_three', 'style_four', 'style_five'],
                ]
            ]
        );

        $this->add_control(
            'vernex_blog_section_genaral_button_text',
            [
                'label' => esc_html__('Button Text', 'vernex-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('View All Blog', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_blog_section_genaral_style_selection' => ['style_two', 'style_three', 'style_four', 'style_five', 'style_six'],
                ]

            ]
        );

        $this->add_control(
            'vernex_blog_section_genaral_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
                'condition' => [
                    'vernex_blog_section_genaral_style_selection' => ['style_two', 'style_three', 'style_four', 'style_five', 'style_six'],
                ]
            ]
        );


        $this->add_control(
            'vernex_blog_section_genaral_query_area',
            [
                'label' => esc_html__('Query Area', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'vernex_blog_section_genaral_post_per_page',
            [
                'label'       => esc_html__('Posts Per Page', 'vernex-core'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 3,
                'label_block' => false,
            ]
        );

        $this->add_control(
            'blog_post_list',
            [
                'label'         => __('Post Lists', 'vernex-core'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'label_block'   => true,
                'multiple'      => true,
                'options'       => \Egns_Core\Egns_Helper::get_blog_post_options(),
            ]
        );

        $this->add_control(
            'selected_categories',
            [
                'label' => __('Categories', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => \Egns_Core\Egns_Helper::get_blog_categories(),
            ]
        );

        $this->add_control(
            'vernex_blog_section_genaral_query_order_by',
            [
                'label'   => esc_html__('Order By', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ID',
                'options' => [
                    'ID'         => esc_html__('Post Id', 'vernex-core'),
                    'author'     => esc_html__('Post Author', 'vernex-core'),
                    'title'      => esc_html__('Title', 'vernex-core'),
                    'post_date'  => esc_html__('Date', 'vernex-core'),
                    'rand'       => esc_html__('Random', 'vernex-core'),
                    'menu_order' => esc_html__('Menu Order', 'vernex-core'),
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_section_genaral_query_template_order',
            [
                'label'   => esc_html__('Order', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'asc'  => esc_html__('Ascending', 'vernex-core'),
                    'desc' => esc_html__('Descending', 'vernex-core')

                ],
                'default' => 'desc',
            ]
        );


        $this->add_control(
            'vernex_blog_section_genaral_blog_post_button_text',
            [
                'label' => esc_html__('Blog Post Button Text', 'vernex-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('View Details', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_blog_section_genaral_style_selection' => ['style_three'],
                ]

            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_blog_style_one_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_blog_section_genaral_style_selection' => ['style_one'],
                ]
            ]
        );

        $this->add_control(
            'vernex_blog_style_one_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_one_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_blog_style_one_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_blog_style_one_general_subtitle_after_color',
            [
                'label'     => esc_html__('After Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_one_general_dtitle',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_done_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_blog_style_one_dgeneral_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_one_dgeneral_pagination',
            [
                'label'     => esc_html__('Pagination', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_done_general_pagination_typ',
                'selector' => '{{WRAPPER}} .slider-btn-grp .slider-btn i',

            ]
        );

        $this->add_control(
            'vernex_blog_style_one_general_dpagination_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-btn-grp .slider-btn i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_one_general_dpagination_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-btn-grp .slider-btn:hover i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_one_general_dpagination_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-btn-grp .slider-btn' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_one_general_dpagination_hover_bg_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-btn-grp .slider-btn:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_one_general_date',
            [
                'label'     => esc_html__('Date', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_one_general_date_typ',
                'selector' => '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a.blog-date',

            ]
        );

        $this->add_control(
            'vernex_blog_style_one_general_date_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a.blog-date' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_one_general_date_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a.blog-date:hover' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_blog_style_one_general_category',
            [
                'label'     => esc_html__('Category', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_one_general_category_typ',
                'selector' => '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a',

            ]
        );

        $this->add_control(
            'vernex_blog_style_one_general_category_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_one_general_category_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'vernex_blog_style_one_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_one_general_title_typ',
                'selector' => '{{WRAPPER}} .blog-card .blog-content h4 a',

            ]
        );

        $this->add_control(
            'vernex_blog_style_one_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content h4 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_one_general_title_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content h4 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_blog_style_two_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_blog_section_genaral_style_selection' => ['style_two'],
                ]
            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_two_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title.two span',

            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.two span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_subtitle_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.two span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_two_generadl_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_two_gdeneral_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_blog_style_two_generafl_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_two_general_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn2.transparent span',

            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.transparent span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_button_bottom_border_color',
            [
                'label'     => esc_html__('Bottom Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.transparent span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );


        $this->add_control(
            'vernex_blog_style_two_general_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.transparent span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_button_after_icon_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.transparent span::after' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_blog_style_two_general_button_border',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.transparent' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_category',
            [
                'label'     => esc_html__('Category', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_two_general_category_typ',
                'selector' => '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a.category',

            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_category_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a.category' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_category_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a.category:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_category_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a.category' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_category_hover_border_color',
            [
                'label'     => esc_html__('Hover Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a.category:hover' => 'border: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_blog_style_two_general_category_hover_bg_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a.category:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_date',
            [
                'label'     => esc_html__('Date', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_two_general_date_typ',
                'selector' => '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a',

            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_date_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_date_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_blog_style_two_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_two_general_title_typ',
                'selector' => '{{WRAPPER}} .blog-card .blog-content h4 a',

            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content h4 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_title_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content h4 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_pagination',
            [
                'label'     => esc_html__('Pagination', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_two_general_pagination_typ',
                'selector' => '{{WRAPPER}} .pagination-area .pagination .swiper-pagination-bullet',

            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_pagination_active_color',
            [
                'label'     => esc_html__('Active Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination-area .pagination .swiper-pagination-bullet.swiper-pagination-bullet-active::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_blog_style_two_general_pagination_dbg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination-area .pagination .swiper-pagination-bullet' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_pagination_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination-area .pagination .swiper-pagination-bullet' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_two_general_pagination_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination-area .pagination .swiper-pagination-bullet' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_blog_style_three_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_blog_section_genaral_style_selection' => ['style_three'],
                ]
            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_three_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_three_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_description',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_three_general_description_typ',
                'selector' => '{{WRAPPER}} .section-title p',

            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_three_general_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn2 span',

            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_button_icon_after_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_button_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_button_border_bottom_color',
            [
                'label'     => esc_html__('Border Bottom Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_date',
            [
                'label'     => esc_html__('Date', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_three_general_date_typ',
                'selector' => '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a.blog-date',

            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_date_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a.blog-date' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_blog_style_three_general_date_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a.blog-date:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_category',
            [
                'label'     => esc_html__('Category', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_three_general_category_typ',
                'selector' => '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a',

            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_category_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_blog_style_three_general_category_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_style_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_three_general_style_title_typ',
                'selector' => '{{WRAPPER}} .blog-card .blog-content h4 a',

            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_style_title_oclor',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content h4 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_style_title_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content h4 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_style_post_button',
            [
                'label'     => esc_html__('Post Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_three_general_style_post_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn',

            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_style_post_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_style_post_border_bottom_button_color',
            [
                'label'     => esc_html__('Border Bottom Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_style_post_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_three_general_style_post_button_after_icon_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_blog_style_four_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_blog_section_genaral_style_selection' => ['style_four'],
                ]
            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_four_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title2 h2',

            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title2 h2' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_blog_style_four_general_short_description',
            [
                'label'     => esc_html__('Short Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_four_general_short_description_typ',
                'selector' => '{{WRAPPER}} .section-title2 p',

            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_short_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title2 p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_four_general_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn2 span',

            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_button_icon_after_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_button_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_button_border_bottom_color',
            [
                'label'     => esc_html__('Border Bottom Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_category',
            [
                'label'     => esc_html__('Category', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_four_general_category_typ',
                'selector' => '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a.category',

            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_category_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a.category' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_category_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a.category:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_category_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a.category' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_category_hover_bg_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a.category:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_date',
            [
                'label'     => esc_html__('Date', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_four_general_date_typ',
                'selector' => '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a',

            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_date_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_date_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card.style-2 .blog-content .blog-meta ul li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_style_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_four_general_title_style_typ',
                'selector' => '{{WRAPPER}} .blog-card .blog-content h4 a',

            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_title_style_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content h4 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_four_general_title_style_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content h4 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();


        //style start
        $this->start_controls_section(
            'vernex_blog_style_five_general_style',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_blog_section_genaral_style_selection' => ['style_five'],
                ]
            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_five_general_style_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title.four span',

            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.four span' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_blog_style_five_general_style_after_subtitle_color',
            [
                'label'     => esc_html__('After Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_blog_style_five_general_style_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_five_general_style_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_five_general_style_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn2 span',

            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_button_after_icon_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span::after' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_blog_style_five_general_style_button_bottom_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );


        $this->add_control(
            'vernex_blog_style_five_general_style_button_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_blog_style_five_qgeneral_style_date',
            [
                'label'     => esc_html__('Date', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blogq_style_five_general_style_date_typ',
                'selector' => '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a.blog-date',

            ]
        );

        $this->add_control(
            'vernex_blog_style_five_gqeneral_style_date_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a.blog-date' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_five_geneqral_style_date',
            [
                'label'     => esc_html__('Date', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_five_general_style_date_typ',
                'selector' => '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a.blog-date',

            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_date_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a.blog-date' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_date_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a.blog-date:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_category',
            [
                'label'     => esc_html__('Category', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_five_general_style_category_typ',
                'selector' => '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a',

            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_category_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_category_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_post_title',
            [
                'label'     => esc_html__('Blog Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_five_general_style_post_title_typ',
                'selector' => '{{WRAPPER}} .blog-card .blog-content h4 a',

            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_post_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content h4 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_post_title_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content h4 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_post_button',
            [
                'label'     => esc_html__('Post Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_five_general_style_post_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn',

            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_post_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_post_button_border_bottom_color',
            [
                'label'     => esc_html__('Border Bottom Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_post_button_cicon_olor',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_five_general_style_post_button_after_icon_olor',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_blog_style_six_general_style',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_blog_section_genaral_style_selection' => ['style_six'],
                ]
            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_six_general_style_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_blog_style_six_general_style_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_six_general_style_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn3 span',

            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn3 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_button_bottom_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn3 span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn3 span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_button_hover_icon_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn3 span::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_date',
            [
                'label'     => esc_html__('Date', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_six_general_style_date_typ',
                'selector' => '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a.blog-date',

            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_date_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a.blog-date' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_date_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a.blog-date:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_category',
            [
                'label'     => esc_html__('Category', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_six_general_style_category_typ',
                'selector' => '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a',

            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_category_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_category_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content .blog-meta ul li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_post_title',
            [
                'label'     => esc_html__('Blog Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_six_general_style_post_title_typ',
                'selector' => '{{WRAPPER}} .blog-card .blog-content h4 a',

            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_post_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content h4 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_post_title_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-card .blog-content h4 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_post_button',
            [
                'label'     => esc_html__('Post Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_blog_style_six_general_style_post_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn',

            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_post_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_post_button_border_bottom_color',
            [
                'label'     => esc_html__('Border Bottom Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_post_button_cicon_olor',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_blog_style_six_general_style_post_button_after_icon_olor',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $selected_category_ids = $settings['selected_categories']; // Get the selected category IDs from the control.
        $selected_post_ids = $settings['blog_post_list']; // Get the selected blog post IDs from the control.
        $args = array(
            'post_type'      => 'post',
            'posts_per_page' => $settings['vernex_blog_section_genaral_post_per_page'],
            'orderby'        => $settings['vernex_blog_section_genaral_query_order_by'],
            'order'          => $settings['vernex_blog_section_genaral_query_template_order'],
            'offset'         => 0,
            'post_status'    => 'publish',
        );
        // Add the category filter if any categories are selected
        if (!empty($selected_category_ids)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'category',
                    'field' => 'term_id',
                    'terms' => $selected_category_ids,
                    'operator' => 'IN',
                ),
            );
        }
        // Add Included posts
        if (!empty($selected_post_ids)) {
            $args['post__in'] = $selected_post_ids;
        }
        $query = new \WP_Query($args);
        $num      = 0;
?>


        <?php if (is_admin()) : ?>
            <script>
                var swiper = new Swiper(".home1-blog-slider", {
                    slidesPerView: 1,
                    speed: 1500,
                    spaceBetween: 25,
                    autoplay: {
                        delay: 2500, // Autoplay duration in milliseconds
                        disableOnInteraction: false,
                    },
                    navigation: {
                        nextEl: ".blog-slider-next",
                        prevEl: ".blog-slider-prev",
                    },
                    breakpoints: {
                        280: {
                            slidesPerView: 1,
                        },
                        386: {
                            slidesPerView: 1,
                        },
                        576: {
                            slidesPerView: 1,
                            spaceBetween: 15,
                        },
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 15,
                        },
                        992: {
                            slidesPerView: 2,
                        },
                        1200: {
                            slidesPerView: 2,
                        },
                        1400: {
                            slidesPerView: 2,
                        },
                    },
                });

                var swiper = new Swiper(".home2-blog-slider", {
                    slidesPerView: 1,
                    speed: 1500,
                    spaceBetween: 25,
                    autoplay: {
                        delay: 2500, // Autoplay duration in milliseconds
                        disableOnInteraction: false,
                    },
                    pagination: {
                        el: ".swiper-pagination1",
                        clickable: true,
                    },
                    breakpoints: {
                        280: {
                            slidesPerView: 1,
                        },
                        386: {
                            slidesPerView: 1,
                        },
                        576: {
                            slidesPerView: 1,
                            spaceBetween: 15,
                        },
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 15,
                        },
                        992: {
                            slidesPerView: 3,
                        },
                        1200: {
                            slidesPerView: 3,
                        },
                        1400: {
                            slidesPerView: 3,
                        },
                    },
                });
            </script>
        <?php endif; ?>


        <?php if ($settings['vernex_blog_section_genaral_style_selection'] == 'style_one') : ?>
            <div class="home1-blog-section">
                <div class="container">
                    <div class="row gy-5 align-items-center">
                        <div class="col-lg-4 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="section-title">
                                <?php if (!empty($settings['vernex_blog_section_genaral_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_blog_section_genaral_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_blog_section_genaral_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_blog_section_genaral_title']); ?></h2>
                                <?php endif; ?>
                            </div>
                            <?php if ($settings['vernex_blog_section_genaral_show_pagination'] == 'yes') : ?>
                                <div class="slider-btn-grp">
                                    <div class="slider-btn blog-slider-prev">
                                        <i class="bi bi-arrow-left"></i>
                                    </div>
                                    <div class="slider-btn blog-slider-next">
                                        <i class="bi bi-arrow-right"></i>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-lg-8">
                            <div class="swiper home1-blog-slider">
                                <div class="swiper-wrapper">
                                    <?php
                                    while ($query->have_posts()) :
                                        $query->the_post();
                                        $post_category = get_the_category()[0]->name;
                                    ?>
                                        <div class="swiper-slide">
                                            <div class="blog-card">
                                                <?php if (has_post_thumbnail()) : ?>
                                                    <a href="<?php the_permalink(); ?>" class="blog-img">
                                                        <?php the_post_thumbnail(); ?>
                                                    </a>
                                                <?php endif ?>
                                                <div class="blog-content">
                                                    <div class="blog-meta">
                                                        <ul>
                                                            <li><a href="<?php echo esc_url(home_url(get_the_date('Y/m/d'))) ?>" class="blog-date"> <?php echo get_the_date('j F, Y'); ?></a></li>
                                                            <?php $categories = get_the_category(); ?>
                                                            <?php if (!empty($categories)) : ?>
                                                                <li><a href="<?php echo esc_url(get_category_link($categories[0]->cat_ID)) ?>"><?php echo esc_html($post_category); ?></a></li>
                                                            <?php endif; ?>
                                                        </ul>
                                                    </div>
                                                    <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                    </h4>
                                                </div>
                                            </div>
                                        </div>

                                    <?php endwhile;
                                    wp_reset_postdata();
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_blog_section_genaral_style_selection'] == 'style_two') : ?>
            <div class="home2-blog-section">
                <div class="container">
                    <div class="row g-4 align-items-end justify-content-between mb-60">
                        <div class="col-lg-7">
                            <div class="section-title two wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <?php if (!empty($settings['vernex_blog_section_genaral_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_blog_section_genaral_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_blog_section_genaral_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_blog_section_genaral_title']); ?></h2>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if (!empty($settings['vernex_blog_section_genaral_button_text'])) : ?>
                            <div class="col-xl-3 col-lg-4 d-flex justify-content-lg-end">
                                <a href="<?php echo esc_url($settings['vernex_blog_section_genaral_button_url']['url']); ?>" class="primary-btn2 transparent btn_wrapper">
                                    <span>
                                        <?php echo esc_html($settings['vernex_blog_section_genaral_button_text']); ?>
                                        <svg viewBox="0 0 13 20">
                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                        </svg>
                                    </span>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="swiper home2-blog-slider">
                                <div class="swiper-wrapper">
                                    <?php
                                    while ($query->have_posts()) :
                                        $query->the_post();
                                        $post_category = get_the_category()[0]->name;
                                    ?>
                                        <div class="swiper-slide">
                                            <div class="blog-card style-2">
                                                <?php if (has_post_thumbnail()) : ?>
                                                    <a href="<?php the_permalink(); ?>" class="blog-img">
                                                        <?php the_post_thumbnail(); ?>
                                                    </a>
                                                <?php endif; ?>
                                                <div class="blog-content">
                                                    <div class="blog-meta">
                                                        <ul>
                                                            <?php $categories = get_the_category(); ?>
                                                            <?php if (!empty($categories)) : ?>
                                                                <li><a href="<?php echo esc_url(get_category_link($categories[0]->cat_ID)) ?>" class="category"><?php echo esc_html($post_category); ?></a></li>
                                                            <?php endif; ?>
                                                            <li><a href="<?php echo esc_url(home_url(get_the_date('Y/m/d'))) ?>"><?php echo get_the_date('j F, Y'); ?></a></li>
                                                        </ul>
                                                    </div>
                                                    <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                    </h4>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile;
                                    wp_reset_postdata();
                                    ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if ($settings['vernex_blog_section_genaral_show_pagination'] == 'yes') : ?>
                        <div class="row pt-50">
                            <div class="col-lg-12 d-flex justify-content-center">
                                <div class="pagination-area">
                                    <div class="pagination swiper-pagination1"></div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>


        <?php if ($settings['vernex_blog_section_genaral_style_selection'] == 'style_three') : ?>
            <div class="home3-blog-section">
                <div class="container">
                    <div class="row gy-5 align-items-center wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-lg-6 scroll-sec-title">
                            <div class="section-title three">
                                <?php if (!empty($settings['vernex_blog_section_genaral_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_blog_section_genaral_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_blog_section_genaral_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_blog_section_genaral_title']); ?></h2>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_blog_section_genaral_description'])) : ?>
                                    <p><?php echo esc_html($settings['vernex_blog_section_genaral_description']); ?></p>
                                <?php endif; ?>
                            </div>
                            <?php if (!empty($settings['vernex_blog_section_genaral_button_text'])) : ?>
                                <a href="<?php echo esc_url($settings['vernex_blog_section_genaral_button_url']['url']); ?>" class="primary-btn2">
                                    <span>
                                        <?php echo esc_html($settings['vernex_blog_section_genaral_button_text']); ?>
                                        <svg viewBox="0 0 13 20">
                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                        </svg>
                                    </span>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="blog-card-area">
                        <div class="row g-4 justify-content-end">
                            <?php
                            $classes = array('fadeInDown', 'fadeInDown', 'fadeInDown');
                            $class_count = count($classes);
                            $post_index = 0; // Initialize post index
                            while ($query->have_posts()) :
                                $query->the_post();
                                $post_category = get_the_category()[0]->name;

                                // Determine the class based on the post index
                                $class = $classes[$post_index % $class_count];

                                // Increment the index for the next post
                                $post_index++;
                            ?>
                                <div class="col-lg-9 wow animate <?php echo $class; ?>" data-wow-delay="200ms" data-wow-duration="1500ms">
                                    <div class="blog-card style-3">
                                        <?php if (has_post_thumbnail()) : ?>
                                            <a href="<?php the_permalink(); ?>" class="blog-img">
                                                <?php the_post_thumbnail(); ?>
                                            </a>
                                        <?php endif; ?>
                                        <div class="blog-content-wrap">
                                            <div class="blog-content">
                                                <div class="blog-meta">
                                                    <ul>
                                                        <li><a href="<?php echo esc_url(home_url(get_the_date('Y/m/d'))) ?>" class="blog-date"><?php echo get_the_date('j F, Y'); ?></a></li>
                                                        <?php $categories = get_the_category(); ?>
                                                        <?php if (!empty($categories)) : ?>
                                                            <li><a href="<?php echo esc_url(get_category_link($categories[0]->cat_ID)) ?>"><?php echo esc_html($post_category); ?></a></li>
                                                        <?php endif; ?>
                                                    </ul>
                                                </div>
                                                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                            </div>
                                            <?php if (!empty($settings['vernex_blog_section_genaral_blog_post_button_text'])) : ?>
                                                <div class="details-btn">
                                                    <a href="<?php the_permalink(); ?>" class="primary-btn">
                                                        <?php echo esc_html($settings['vernex_blog_section_genaral_blog_post_button_text']); ?>
                                                        <svg viewBox="0 0 13 20">
                                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                                        </svg>
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile;
                            wp_reset_postdata();
                            ?>
                            <div class="scroll-sec-title-end"></div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>


        <?php if ($settings['vernex_blog_section_genaral_style_selection'] == 'style_four') : ?>
            <div class="home4-blog-section">
                <div class="container">
                    <div class="row gy-5 align-items-center">
                        <div class="col-lg-4 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="blog-title-area">
                                <div class="section-title2">
                                    <?php if (!empty($settings['vernex_blog_section_genaral_title'])) : ?>
                                        <h2><?php echo wp_kses($settings['vernex_blog_section_genaral_title'], wp_kses_allowed_html('post')); ?></h2>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_blog_section_genaral_description'])) : ?>
                                        <p><?php echo esc_html($settings['vernex_blog_section_genaral_description']); ?></p>
                                    <?php endif; ?>
                                </div>
                                <?php if (!empty($settings['vernex_blog_section_genaral_button_text'])) : ?>
                                    <a href="<?php echo esc_url($settings['vernex_blog_section_genaral_button_url']['url']); ?>" class="primary-btn2">
                                        <span>
                                            <?php echo esc_html($settings['vernex_blog_section_genaral_button_text']); ?>
                                            <svg viewBox="0 0 13 20">
                                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                            </svg>
                                        </span>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-lg-8">
                            <div class="row gy-5">
                                <?php
                                while ($query->have_posts()) :
                                    $query->the_post();
                                    $post_category = get_the_category()[0]->name;
                                ?>
                                    <div class="col-md-6 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                        <div class="blog-card style-2">
                                            <?php if (has_post_thumbnail()) : ?>
                                                <a href="<?php the_permalink(); ?>" class="blog-img">
                                                    <?php the_post_thumbnail(); ?>
                                                </a>
                                            <?php endif; ?>
                                            <div class="blog-content">
                                                <div class="blog-meta">
                                                    <ul>
                                                        <?php $categories = get_the_category(); ?>
                                                        <?php if (!empty($categories)) : ?>
                                                            <li><a href="<?php echo esc_url(get_category_link($categories[0]->cat_ID)) ?>" class="category"><?php echo esc_html($post_category); ?></a></li>
                                                        <?php endif; ?>
                                                        <li><a href="<?php echo esc_url(home_url(get_the_date('Y/m/d'))) ?>"><?php echo get_the_date('j F, Y'); ?></a></li>
                                                    </ul>
                                                </div>
                                                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                </h4>
                                            </div>
                                        </div>
                                    </div>
                                <?php endwhile;
                                wp_reset_postdata();
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_blog_section_genaral_style_selection'] == 'style_five') : ?>
            <div class="home5-blog-section">
                <div class="container">
                    <div class="row g-4 justify-content-between align-items-lg-center mb-70 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-xxl-5 col-lg-7">
                            <div class="section-title four">
                                <?php if (!empty($settings['vernex_blog_section_genaral_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_blog_section_genaral_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_blog_section_genaral_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_blog_section_genaral_title']); ?></h2>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if (!empty($settings['vernex_blog_section_genaral_button_text'])) : ?>
                            <div class="col-lg-3 d-flex justify-content-lg-end">
                                <a href="<?php echo esc_url($settings['vernex_blog_section_genaral_button_url']['url']); ?>" class="primary-btn2">
                                    <span>
                                        <?php echo esc_html($settings['vernex_blog_section_genaral_button_text']); ?>
                                        <svg viewBox="0 0 13 20">
                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                        </svg>
                                    </span>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="row gy-5">

                        <?php
                        while ($query->have_posts()) :
                            $query->the_post();
                            $post_category = get_the_category()[0]->name;
                        ?>

                            <div class="col-lg-6 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <div class="blog-card style-4">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <a href="blog-details.html" class="blog-img">
                                            <?php the_post_thumbnail(); ?>
                                        </a>
                                    <?php endif; ?>
                                    <div class="blog-content">
                                        <div class="blog-meta">
                                            <ul>
                                                <li><a href="<?php echo esc_url(home_url(get_the_date('Y/m/d'))) ?>" class="blog-date"><?php echo get_the_date('j F, Y'); ?></a></li>
                                                <?php $categories = get_the_category(); ?>
                                                <?php if (!empty($categories)) : ?>
                                                    <li><a href="<?php echo esc_url(get_category_link($categories[0]->cat_ID)) ?>"><?php echo esc_html($post_category); ?></a></li>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                        <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                        <div class="details-btn">
                                            <a href="<?php the_permalink(); ?>" class="primary-btn">
                                                <?php echo esc_html__('View Details', 'vernex-core'); ?>
                                                <svg viewBox="0 0 13 20">
                                                    <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                                </svg>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile;
                        wp_reset_postdata();
                        ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>


        <?php if ($settings['vernex_blog_section_genaral_style_selection'] == 'style_six') : ?>
            <div class="home6-blog-section">
                <div class="container">
                    <div class="row g-4 align-items-center justify-content-between mb-70">
                        <div class="col-xl-6 col-lg-7 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <?php if (!empty($settings['vernex_blog_section_genaral_title'])) : ?>
                                <div class="section-title">
                                    <h2><?php echo esc_html($settings['vernex_blog_section_genaral_title']); ?></h2>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php if (!empty($settings['vernex_blog_section_genaral_button_text'])) : ?>
                            <div class="col-lg-3 d-flex justify-content-lg-end btn_wrapper">
                                <a href="<?php echo esc_url($settings['vernex_blog_section_genaral_button_url']['url']); ?>" class="primary-btn3">
                                    <span>
                                        <?php echo esc_html($settings['vernex_blog_section_genaral_button_text']); ?>
                                        <svg viewBox="0 0 13 20">
                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                        </svg>
                                    </span>
                                    <i class="corner tl"></i>
                                    <i class="corner tr"></i>
                                    <i class="corner br"></i>
                                    <i class="corner bl"></i>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="row gy-5">
                        <?php
                        if ($query->have_posts()) :
                            $index = 0; // Initialize an index counter
                            while ($query->have_posts()) : $query->the_post();
                                if ($index === 0) : // Display only the first post
                                    $post_category = get_the_category()[0]->name;
                        ?>

                                    <div class="col-lg-5 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                                        <div class="blog-card style-4">
                                            <?php if (has_post_thumbnail()) : ?>
                                                <a href="<?php the_permalink(); ?>" class="blog-img">
                                                    <?php the_post_thumbnail(); ?>
                                                </a>
                                            <?php endif; ?>
                                            <div class="blog-content">
                                                <div class="blog-meta">
                                                    <ul>
                                                        <li><a href="<?php echo esc_url(home_url(get_the_date('Y/m/d'))) ?>" class="blog-date"><?php echo get_the_date('j F, Y'); ?></a></li>
                                                        <?php $categories = get_the_category(); ?>
                                                        <?php if (!empty($categories)) : ?>
                                                            <li><a href="<?php echo esc_url(get_category_link($categories[0]->cat_ID)) ?>"><?php echo esc_html($post_category); ?></a></li>
                                                        <?php endif; ?>
                                                    </ul>
                                                </div>
                                                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                                <div class="details-btn">
                                                    <a href="<?php the_permalink(); ?>" class="primary-btn">
                                                        <?php echo esc_html__('View Details', 'vernex-core'); ?>
                                                        <svg viewBox="0 0 13 20">
                                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                                        </svg>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                        <?php
                                endif;
                                $index++; // Increment the index
                            endwhile;
                            wp_reset_postdata();
                        endif;
                        ?>

                        <div class="col-lg-7">
                            <div class="row gy-xl-5 g-4">

                                <?php
                                // Second Loop: Show all posts except the first (index > 0)
                                if ($query->have_posts()) :
                                    $index = 0; // Reset index counter
                                    while ($query->have_posts()) : $query->the_post();
                                        if ($index > 0) : // Skip the first post
                                            $post_category = get_the_category()[0]->name;
                                ?>
                                            <div class="col-lg-12 wow animate fadeInDown" data-wow-delay="400ms" data-wow-duration="1500ms">
                                                <div class="blog-card style-3">
                                                    <a href="<?php the_permalink(); ?>" class="blog-img">
                                                        <?php the_post_thumbnail(); ?>
                                                    </a>
                                                    <div class="blog-content-wrap">
                                                        <div class="blog-content">
                                                            <div class="blog-meta">
                                                                <ul>
                                                                    <li><a href="<?php echo esc_url(home_url(get_the_date('Y/m/d'))) ?>" class="blog-date"><?php echo get_the_date('j F, Y'); ?></a></li>
                                                                    <?php $categories = get_the_category(); ?>
                                                                    <?php if (!empty($categories)) : ?>
                                                                        <li><a href="<?php echo esc_url(get_category_link($categories[0]->cat_ID)) ?>"><?php echo esc_html($post_category); ?></a></li>
                                                                    <?php endif; ?>
                                                                </ul>
                                                            </div>
                                                            <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                                        </div>
                                                        <div class="details-btn">
                                                            <a href="<?php the_permalink(); ?>" class="primary-btn">
                                                                <?php echo esc_html__('View Details', 'vernex-core'); ?>
                                                                <svg viewBox="0 0 13 20">
                                                                    <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                                                </svg>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                <?php
                                        endif;
                                        $index++; // Increment the index
                                    endwhile;
                                    wp_reset_postdata();
                                endif;
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Blog_Widget());
