<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Banner_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_banner';
    }

    public function get_title()
    {
        return esc_html__('EG Banner', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_banner_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_banner_section_genaral_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),
                    'style_three' => esc_html__('Style Three', 'vernex-core'),
                    'style_four' => esc_html__('Style Four', 'vernex-core'),

                ],
                'default' => 'style_one',
            ]
        );

        $this->add_control(
            'vernex_banner_section_genaral_background_image',
            [
                'label' => esc_html__('Background Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'vernex_banner_section_genaral_style_selection' => ['style_one', 'style_four'],
                ]
            ]
        );

        $this->add_control(
            'vernex_banner_section_genaral_video_url',
            [
                'label' => esc_html__('Video URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => 'https://www.youtube.com/embed/YKtMErhDpm0',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
                'condition' => [
                    'vernex_banner_section_genaral_style_selection' => ['style_one', 'style_four'],
                ]
            ]
        );

        $this->add_control(
            'vernex_banner_section_genaral_video_scroll_text',
            [
                'label' => esc_html__('Round Scroll Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('* YOUR ARCHITECTURE DESIGN * READY HERE '),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
                'condition' => [
                    'vernex_banner_section_genaral_style_selection' => ['style_four'],
                ]
            ]
        );

        $this->add_control(
            'vernex_banner_section_general_background_video',
            [
                'label' => esc_html__('Background Video', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'media_types' => ['video'], // Specify that this control accepts only videos
                'default' => [
                    'url' => '',
                ],
                'condition' => [
                    'vernex_banner_section_genaral_style_selection' => ['style_three'],
                ]
            ]
        );


        // accordion title
        $this->add_control(
            'vernex_banner_section_genaral_title_one',
            [
                'label' => esc_html__('Title One', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Build Your'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
                'condition' => [
                    'vernex_banner_section_genaral_style_selection' => ['style_one', 'style_two', 'style_three'],
                ]
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_two_genaral_left_image',
            [
                'label' => esc_html__('Left Background', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'vernex_banner_section_genaral_style_selection' => ['style_two'],
                ]
            ]
        );



        $this->add_control(
            'vernex_banner_section_style_two_genaral_right_image',
            [
                'label' => esc_html__('Right Background', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'vernex_banner_section_genaral_style_selection' => ['style_two'],
                ]
            ]
        );

        // accordion title
        $this->add_control(
            'vernex_banner_section_genaral_title_two',
            [
                'label' => esc_html__('Title Two', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Own Building.'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
                'condition' => [
                    'vernex_banner_section_genaral_style_selection' => ['style_one', 'style_two', 'style_three'],
                ]
            ]
        );

        $this->add_control(
            'vernex_banner_section_genaral_button_text',
            [
                'label' => esc_html__('Button Text', 'vernex-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('START A PROJECT', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_banner_section_genaral_style_selection' => ['style_two', 'style_three'],
                ]

            ]
        );

        $this->add_control(
            'vernex_banner_section_genaral_button_text_link',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
                'condition' => [
                    'vernex_banner_section_genaral_style_selection' => ['style_two'],
                ]
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_banner_section_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_banner_section_genaral_style_selection' => ['style_one'],
                ]
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_general_title_one',
            [
                'label'     => esc_html__('Title One', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_banner_section_style_general_title_one_typ',
                'selector' => '{{WRAPPER}} .home1-banner2-section .banner-content h2',

            ]
        );

        $this->add_control(
            'vernex_banner_section_style_general_title_one_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-banner2-section .banner-content h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_banner_section_styele_general_title_two',
            [
                'label'     => esc_html__('Title Two', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_bannewr_section_style_general_title_two_typ',
                'selector' => '{{WRAPPER}} .home1-banner2-section .banner-content h2:nth-child(2)',

            ]
        );

        $this->add_control(
            'vernex_banner_section_style_genertal_title_two_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-banner2-section .banner-content h2:nth-child(2)' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_banner_section_style_genqeral_title_two',
            [
                'label'     => esc_html__('Title Two', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_banner_section_style_general_title_two_typ',
                'selector' => '{{WRAPPER}} .home1-banner2-section .banner-content h2:nth-child(2)',

            ]
        );

        $this->add_control(
            'vernex_banner_section_style_general_title_two_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-banner2-section .banner-content h2:nth-child(2)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_general_video_icon',
            [
                'label'     => esc_html__('Video Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_banner_section_style_general_video_icon_typ',
                'selector' => '{{WRAPPER}} .home1-banner2-section .banner-content .video-area .play-btn .icon .play-icon',

            ]
        );

        $this->add_control(
            'vernex_banner_section_style_general_video_icon_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-banner2-section .banner-content .video-area .play-btn .icon .play-icon' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_general_video_icon_two_color',
            [
                'label'     => esc_html__('Icon Two Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-banner2-section .banner-content .video-area .play-btn .icon .video-circle' => 'stroke: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_banner_section_style_two_dgeneral',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_banner_section_genaral_style_selection' => ['style_two'],
                ]
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_two_geneidral_title_one',
            [
                'label'     => esc_html__('Title One', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_banner_seqction_style_two_general_title_one_typ',
                'selector' => '{{WRAPPER}} .home3-banner2-section .banner2-front-img h2',

            ]
        );

        $this->add_control(
            'vernex_banner_section_style_tywo_general_title_one_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-banner2-section .banner2-front-img h2' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_banner_section_style_two_genetral_title_two',
            [
                'label'     => esc_html__('Title Two', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_banner_secqtion_style_two_general_title_two_typ',
                'selector' => '{{WRAPPER}} .home3-banner2-section .banner2-back-img h2',

            ]
        );

        $this->add_control(
            'vernex_banner_section_style_two_genertal_title_two_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-banner2-section .banner2-back-img h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_two_geeneral_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_banner_sewction_style_two_general_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn2.white-bg span',

            ]
        );

        $this->add_control(
            'vernex_banner_section_styleg_two_general_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.white-bg span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_twod_general_button_border_bottom_color',
            [
                'label'     => esc_html__('Border Bottom Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.white-bg span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%)',
                ],
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_two_general_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.white-bg span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_two_general_button_dafter_icon_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2.white-bg span::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_banner_section_style_three_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_banner_section_genaral_style_selection' => ['style_three'],
                ]
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_three_general_title_one',
            [
                'label'     => esc_html__('Title One', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_banner_section_style_three_general_title_one_typ',
                'selector' => '{{WRAPPER}} .home4-banner2-section .banner-content-wrap .banner-content h2',

            ]
        );

        $this->add_control(
            'vernex_banner_section_style_three_general_title_one_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner2-section .banner-content-wrap .banner-content h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_three_general_title_two',
            [
                'label'     => esc_html__('Title Two', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_banner_section_style_three_general_title_two_typ',
                'selector' => '{{WRAPPER}} .home4-banner2-section .banner-content-wrap .banner-content h2:nth-child(2)',

            ]
        );

        $this->add_control(
            'vernex_banner_section_style_three_general_title_two_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner2-section .banner-content-wrap .banner-content h2:nth-child(2)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_three_general_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_banner_section_style_three_general_button_typ',
                'selector' => '{{WRAPPER}} .home4-banner2-section .banner-content-wrap .scroll-down-btn span',

            ]
        );

        $this->add_control(
            'vernex_banner_section_style_three_general_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner2-section .banner-content-wrap .scroll-down-btn span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_three_general_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner2-section .banner-content-wrap .scroll-down-btn .scroll-down-icon svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_three_general_button_icon_hover_color',
            [
                'label'     => esc_html__('Icon Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner2-section .banner-content-wrap .scroll-down-btn:hover .scroll-down-icon svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_three_general_button_icon_border_color',
            [
                'label'     => esc_html__('Icon Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner2-section .banner-content-wrap .scroll-down-btn .scroll-down-icon' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_banner_section_style_three_general_button_icon_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner2-section .banner-content-wrap .scroll-down-btn .scroll-down-icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_banner_section_style_three_general_button_icon_hover_bg_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-banner2-section .banner-content-wrap .scroll-down-btn:hover .scroll-down-icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_banner_section_style_four_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_banner_section_genaral_style_selection' => ['style_four'],
                ]
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_four_general_rounded_scroll_text',
            [
                'label'     => esc_html__('Scroll Text', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_banner_section_style_four_general_rounded_scroll_text_typ',
                'selector' => '{{WRAPPER}} .home6-banner2-section .circular-text > svg text textpath',

            ]
        );

        $this->add_control(
            'vernex_banner_section_style_four_general_rounded_scroll_text_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner2-section .circular-text > svg text textpath' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_four_general_rounded_scroll_icon_border_color',
            [
                'label'     => esc_html__('Icon Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner2-section .circular-text .video-area .play-btn .icon .video-circle' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_four_general_rounded_scroll_icon_bg_color',
            [
                'label'     => esc_html__('Icon Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner2-section .circular-text .video-area .play-btn .icon .video-circle' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_banner_section_style_four_general_rounded_scroll_section_bg_color',
            [
                'label'     => esc_html__('Section Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner2-section .circular-text .video-area' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();

?>

        <?php if ($settings['vernex_banner_section_genaral_style_selection'] == 'style_one') : ?>
            <div class="home1-banner2-section" style="background-image: linear-gradient(180deg, rgba(0, 0, 0, 0.7) 0%, rgba(0, 0, 0, 0.7) 100%), url(<?php if (!empty($settings['vernex_banner_section_genaral_background_image']['url'])); ?><?php echo esc_url($settings['vernex_banner_section_genaral_background_image']['url']); ?>);">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12 d-flex justify-content-center">
                            <div class="banner-content">
                                <div class="video-area">
                                    <?php if (!empty($settings['vernex_banner_section_genaral_title_one'])) : ?>
                                        <h2><?php echo esc_html($settings['vernex_banner_section_genaral_title_one']); ?></h2>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_banner_section_genaral_video_url']['url'])) : ?>
                                        <a data-fancybox="video-player" href="<?php echo esc_url($settings['vernex_banner_section_genaral_video_url']['url']); ?>" class="play-btn">
                                            <div class="icon">
                                                <svg class="video-circle" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                                    x="0px" y="0px" width="77px" viewBox="0 0 206 206" style="enable-background:new 0 0 206 206;" xml:space="preserve">
                                                    <circle class="circle" stroke-miterlimit="10" cx="103" cy="103" r="100"></circle>
                                                    <path class="circle-half top-half" stroke-width="4" stroke-miterlimit="10"
                                                        d="M16.4,53C44,5.2,105.2-11.2,153,16.4s64.2,88.8,36.6,136.6"></path>
                                                    <path class="circle-half bottom-half" stroke-width="4" stroke-miterlimit="10"
                                                        d="M189.6,153C162,200.8,100.8,217.2,53,189.6S-11.2,100.8,16.4,53"></path>
                                                </svg>
                                                <svg class="play-icon" width="23" height="28" viewBox="0 0 23 28" xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M22.8424 14.2559C22.8424 13.4843 22.4449 12.7737 21.7784 12.3539L3.78608 1.03446C3.05833 0.577358 2.17083 0.543963 1.40902 0.947257C0.649591 1.35033 0.195312 2.09429 0.195312 2.93663V25.5738C0.195312 26.4162 0.649555 27.1599 1.41018 27.5632C1.76475 27.7501 2.14507 27.8431 2.52543 27.8431C2.96275 27.8431 3.39718 27.7197 3.78584 27.476L21.7782 16.1583C22.4449 15.7383 22.8424 15.0277 22.8424 14.2561V14.2559ZM21.1289 15.177L3.13659 26.4947C2.78345 26.7165 2.35329 26.7315 1.98441 26.5376C1.61553 26.3424 1.39473 25.9822 1.39473 25.5736V2.93642C1.39473 2.52778 1.61553 2.16621 1.98441 1.97237C2.15681 1.88239 2.34185 1.83669 2.52569 1.83669C2.73791 1.83669 2.9487 1.8963 3.13685 2.0155L21.1292 13.335C21.4568 13.5414 21.6447 13.8781 21.6447 14.2575C21.6444 14.6356 21.4565 14.9707 21.1289 15.177Z" />
                                                </svg>
                                            </div>
                                        </a>
                                    <?php endif; ?>
                                </div>
                                <?php if (!empty($settings['vernex_banner_section_genaral_title_two'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_banner_section_genaral_title_two']); ?></h2>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_banner_section_genaral_style_selection']  == 'style_two') : ?>
            <div class="home3-banner2-section" id="revealSection">
                <div class="banner2-front-img">
                    <?php if (!empty($settings['vernex_banner_section_style_two_genaral_left_image']['url'])) : ?>
                        <img src="<?php echo esc_url($settings['vernex_banner_section_style_two_genaral_left_image']['url']); ?>" alt="<?php echo esc_attr__('left-corner-image', 'vernex-core'); ?>">
                    <?php endif; ?>
                    <?php if (!empty($settings['vernex_banner_section_genaral_title_one'])) : ?>
                        <h2><?php echo esc_html($settings['vernex_banner_section_genaral_title_one']); ?></h2>
                    <?php endif; ?>
                </div>
                <div class="banner2-back-img" id="imageReveal">
                    <img src="<?php echo esc_url($settings['vernex_banner_section_style_two_genaral_right_image']['url']); ?>" alt="<?php echo esc_attr__('right-corner-image', 'vernex-core'); ?>">
                    <?php if (!empty($settings['vernex_banner_section_genaral_title_two'])) : ?>
                        <h2><?php echo esc_html($settings['vernex_banner_section_genaral_title_two']); ?></h2>
                    <?php endif; ?>
                </div>
                <div class="image-handle" id="imageHandle">
                    <svg width="7" height="11" viewBox="0 0 7 11" xmlns="http://www.w3.org/2000/svg">
                        <path d="M7 0L7 11L-4.80825e-07 5.5L7 0Z" />
                    </svg>
                    <svg width="7" height="11" viewBox="0 0 7 11" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0 11V0L7 5.5L0 11Z" />
                    </svg>
                </div>
                <?php if (!empty($settings['vernex_banner_section_genaral_button_text'])) : ?>
                    <div class="button-area">
                        <a href="<?php echo esc_url($settings['vernex_banner_section_genaral_button_text_link']['url']); ?>" class="primary-btn2 white-bg">
                            <span>
                                <?php echo esc_html($settings['vernex_banner_section_genaral_button_text']); ?>
                                <svg viewBox="0 0 13 20">
                                    <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                </svg>
                            </span>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>


        <?php if ($settings['vernex_banner_section_genaral_style_selection']  == 'style_three') : ?>
            <div class="home4-banner2-section ">
                <?php if (!empty($settings['vernex_banner_section_general_background_video']['url'])) : ?>
                    <div class="banner-video">
                        <video autoplay="" loop="" muted="" playsinline="" src="<?php echo esc_url($settings['vernex_banner_section_general_background_video']['url']); ?>"></video>
                    </div>
                <?php endif; ?>
                <div class="video-content">
                    <div class="banner-content-wrap">
                        <div class="banner-content">
                            <?php if (!empty($settings['vernex_banner_section_genaral_title_one'])) : ?>
                                <h2><?php echo esc_html($settings['vernex_banner_section_genaral_title_one']); ?></h2>
                            <?php endif; ?>
                            <?php if (!empty($settings['vernex_banner_section_genaral_title_two'])) : ?>
                                <h2><?php echo esc_html($settings['vernex_banner_section_genaral_title_two']); ?></h2>
                            <?php endif; ?>
                        </div>
                        <?php if (!empty($settings['vernex_banner_section_genaral_button_text'])) : ?>
                            <div class="scroll-down-btn" id="scroll-btn2">
                                <div class="scroll-down-icon">
                                    <svg width="17" height="26" viewBox="0 0 17 26" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M8.49961 0.399902V25.5999M8.49961 25.5999C8.94961 22.2999 11.1096 15.7899 16.1496 16.1499M8.49961 25.5999C7.59961 22.1499 4.80961 15.4299 0.849609 16.1499" />
                                    </svg>
                                </div>
                                <span><?php echo esc_html($settings['vernex_banner_section_genaral_button_text']); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_banner_section_genaral_style_selection'] == 'style_four') : ?>
            <div class="home6-banner2-section" style="background-image: linear-gradient(180deg, rgba(0, 0, 0, 0.5) 0%, rgba(0, 0, 0, 0.5) 100%), url(<?php if (!empty($settings['vernex_banner_section_genaral_background_image']['url'])) : ?> <?php echo esc_url($settings['vernex_banner_section_genaral_background_image']['url']); ?><?php endif; ?>);">
                <div class="circular-text">
                    <!-- <svg class="textcircle" width="168" height="168" viewBox="0 0 168 168">
                        <defs>
                            <path id="textcirclePath" d="M84,84 m-76,0 a76,76 0 1,1 152,0 a76,76 0 1,1 -152,0"></path>
                        </defs>
                        <text>
                            <textPath xlink:href="#textcirclePath" textLength="470"> * YOUR ARCHITECTURE DESIGN * READY HERE</textPath>
                        </text>
                    </svg> -->
                    <?php if (!empty($settings['vernex_banner_section_genaral_video_scroll_text'])) : ?>
                        <svg class="textcircle" width="144" height="144" viewBox="0 0 144 144">
                            <defs>
                                <path id="textcirclePath" d="M72,72 m-64,0 a64,64 0 1,1 128,0 a64,64 0 1,1 -128,0"></path>
                            </defs>
                            <text>
                                <textPath xlink:href="#textcirclePath" textLength="390"><?php echo esc_html($settings['vernex_banner_section_genaral_video_scroll_text']); ?></textPath>
                            </text>
                        </svg>
                    <?php endif; ?>

                    <?php if (!empty($settings['vernex_banner_section_genaral_video_url']['url'])) : ?>
                        <div class="video-area">
                            <a data-fancybox="video-player" href="<?php echo esc_url($settings['vernex_banner_section_genaral_video_url']['url']); ?>" class="play-btn">
                                <div class="icon">
                                    <svg class="video-circle" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                        x="0px" y="0px" width="55px" viewBox="0 0 206 206" style="enable-background:new 0 0 206 206;" xml:space="preserve">
                                        <circle class="circle" stroke-miterlimit="10" cx="103" cy="103" r="100"></circle>
                                        <path class="circle-half top-half" stroke-width="4" stroke-miterlimit="10"
                                            d="M16.4,53C44,5.2,105.2-11.2,153,16.4s64.2,88.8,36.6,136.6"></path>
                                        <path class="circle-half bottom-half" stroke-width="4" stroke-miterlimit="10"
                                            d="M189.6,153C162,200.8,100.8,217.2,53,189.6S-11.2,100.8,16.4,53"></path>
                                    </svg>
                                    <svg class="play-icon" width="17" height="20" viewBox="0 0 17 20" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M16.7448 10.0396C16.7448 9.48848 16.4609 8.98091 15.9848 8.68109L3.1332 0.595746C2.61337 0.269245 1.97945 0.245391 1.4353 0.533459C0.892844 0.821365 0.568359 1.35276 0.568359 1.95444V18.1239C0.568359 18.7255 0.892818 19.2568 1.43612 19.5448C1.68939 19.6783 1.96105 19.7448 2.23273 19.7448C2.5451 19.7448 2.85541 19.6566 3.13302 19.4825L15.9847 11.3985C16.4609 11.0985 16.7448 10.5909 16.7448 10.0398V10.0396ZM15.5209 10.6976L2.66927 18.7817C2.41703 18.94 2.10977 18.9508 1.84629 18.8123C1.5828 18.6728 1.42508 18.4156 1.42508 18.1237V1.95429C1.42508 1.66241 1.5828 1.40414 1.84629 1.26568C1.96943 1.20141 2.1016 1.16877 2.23291 1.16877C2.3845 1.16877 2.53506 1.21134 2.66946 1.29649L15.5211 9.38183C15.7551 9.52926 15.8893 9.76979 15.8893 10.0408C15.8892 10.3108 15.7549 10.5502 15.5209 10.6976Z" />
                                    </svg>
                                </div>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Banner_Widget());
