<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_About_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_about';
    }

    public function get_title()
    {
        return esc_html__('EG About', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_about_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_about_section_genaral_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),
                    'style_three' => esc_html__('Style Three', 'vernex-core'),
                    'style_four' => esc_html__('Style Four', 'vernex-core'),
                    'style_five' => esc_html__('Style Five', 'vernex-core'),
                    'style_six' => esc_html__('Style Six', 'vernex-core'),

                ],
                'default' => 'style_one',
            ]
        );

        $this->add_control(
            'vernex_about_section_genaral_subtitle',
            [
                'label'       => esc_html__('Subtitle', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Building Trust Since 2005', 'vernex-core'),
                'placeholder' => esc_html__('write your subtitle here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_about_section_genaral_style_selection' => ['style_one', 'style_two', 'style_three', 'style_five'],
                ]
            ]
        );

        $this->add_control(
            'vernex_about_section_genaral_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Experts in Construction Your Excellence.', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_about_section_genaral_video_url',
            [
                'label' => esc_html__('Video URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => 'https://www.youtube.com/watch?v=MLpWrANjFbI&ab_channel=eidelchteinadvogados',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
                'condition' => [
                    'vernex_about_section_genaral_style_selection' => ['style_one'],
                ]
            ]
        );

        $this->add_control(
            'vernex_about_section_genaral_short_description',
            [
                'label'       => esc_html__('Short Description', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default' => wp_kses('Sed nisl eros, condimentum nec risus sit amet, finibus conguese.Fusen fringilla est libero, sed tempus urna feugiat eu. Curabitur eu feugiat ligu Suspendisse nectoraba porttitor velit go this week and more about.', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your description here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_about_section_genaral_button_text',
            [
                'label'       => esc_html__('Button Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('About Us More', 'vernex-core'),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_about_section_genaral_style_selection' => ['style_one', 'style_two', 'style_four', 'style_five'],
                ]
            ]
        );

        $this->add_control(
            'vernex_about_section_genaral_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
                'condition' => [
                    'vernex_about_section_genaral_style_selection' => ['style_one', 'style_two', 'style_four', 'style_five'],
                ]
            ]
        );

        $content = new \Elementor\Repeater();

        $content->add_control(
            'vernex_about_style_one_content_title',
            [
                'label'       => esc_html__('Content Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Who we are', 'vernex-core'),
                'placeholder' => esc_html__('write your text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $content->add_control(
            'vernex_about_style_one_content_description',
            [
                'label'       => esc_html__('Content Description', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default'     => esc_html__('Sed nisl eros, condimentum nec risussit amet finibus cons sem fusce. Advantage of thes limited-time offers & start.', 'vernex-core'),
                'placeholder' => esc_html__('write your text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_about_style_one_content_list',
            [
                'label'     => esc_html__('Content List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $content->get_controls(),
                'default'   => [
                    [
                        'vernex_about_style_one_content_title'    => esc_html__('Who we are', 'vernex-core'),
                        'vernex_about_style_one_content_description'    => esc_html__('Sed nisl eros, condimentum nec risussit amet finibus cons sem fusce. Advantage of thes limited-time offers & start.', 'vernex-core'),

                    ],
                    [
                        'vernex_about_style_one_content_title'    => esc_html__('Our Mission', 'vernex-core'),
                        'vernex_about_style_one_content_description'    => esc_html__('Sed nisl eros, condimentum nec risussit amet finibus cons sem fusce. Advantage of thes limited-time offers & start.', 'vernex-core'),


                    ],
                    [
                        'vernex_about_style_one_content_title'    => esc_html__('Core value', 'vernex-core'),
                        'vernex_about_style_one_content_description'    => esc_html__('Sed nisl eros, condimentum nec risussit amet finibus cons sem fusce. Advantage of thes limited-time offers & start.', 'vernex-core'),


                    ],

                ],
                'title_field'    => '{{{ vernex_about_style_one_content_title }}}',
                'condition' => [
                    'vernex_about_section_genaral_style_selection' => ['style_one', 'style_two', 'style_three', 'style_four', 'style_six'],
                ]
            ]
        );

        $this->add_control(
            'vernex_about_style_one_banner_image',
            [
                'label' => esc_html__('Banner Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'vernex_about_section_genaral_style_selection' => ['style_one', 'style_two', 'style_three', 'style_four', 'style_six'],
                ]

            ]
        );

        $this->add_control(
            'vernex_about_style_five_banner_image_one',
            [
                'label' => esc_html__('Banner Image One', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'vernex_about_section_genaral_style_selection' => ['style_five'],
                ]

            ]
        );

        $this->add_control(
            'vernex_about_style_five_banner_content_description_one',
            [
                'label'       => esc_html__('Content Description One', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default'     => esc_html__('We understand your needs and deliver digital marketing through unique selling One proposition. Our team of experts is passionate about helping you SEO company. Foi adjective] approach. Let us show you how we can help you achieve desired that to phrase "ready to build together.', 'vernex-core'),
                'placeholder' => esc_html__('write your text here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_about_section_genaral_style_selection' => ['style_five'],
                ]
            ]
        );

        $this->add_control(
            'vernex_about_style_five_banner_image_two',
            [
                'label' => esc_html__('Banner Image Two', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'vernex_about_section_genaral_style_selection' => ['style_five'],
                ]

            ]
        );

        $this->add_control(
            'vernex_about_style_five_banner_content_description_two',
            [
                'label'       => esc_html__('Content Description Two', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default' => wp_kses('We are attracted to truly discoveri the ideas <span>and people working behind the</span> stages of your business.', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your text here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_about_section_genaral_style_selection' => ['style_five'],
                ]
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_about_style_one_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_about_section_genaral_style_selection' => ['style_one'],
                ]
            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_one_style_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_one_style_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_video_button',
            [
                'label'     => esc_html__('Play Video Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_one_style_general_video_button_typ',
                'selector' => '{{WRAPPER}} .home1-about-section .about-top-area .about-title-area .video-and-content .video-area .icon .video-circle',

            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_video_button_icon_one_color',
            [
                'label'     => esc_html__('Icon One Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-about-section .about-top-area .about-title-area .video-and-content .video-area .icon .video-circle' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_video_button_icon_two_color',
            [
                'label'     => esc_html__('Icon Two Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-about-section .about-top-area .about-title-area .video-and-content .video-area .icon .play-icon' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_description',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_one_style_general_description_typ',
                'selector' => '{{WRAPPER}} .home1-about-section .about-top-area .about-title-area .video-and-content .content p',

            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-about-section .about-top-area .about-title-area .video-and-content .content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_one_style_general_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn',

            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_button_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-about-section .about-top-area .about-btn .bg svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_about_style_one_style_general_button_underline_color',
            [
                'label'     => esc_html__('Underline Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn svg' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_button_after-icon_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_button_hover_background_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-about-section .about-top-area .about-btn:hover .bg svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_content_title',
            [
                'label'     => esc_html__('Content Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_one_style_general_content_title_typ',
                'selector' => '{{WRAPPER}} .home1-about-section .about-content ul li h5',

            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_content_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-about-section .about-content ul li h5' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_content_description',
            [
                'label'     => esc_html__('Content Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_one_style_general_content_description_typ',
                'selector' => '{{WRAPPER}} .home1-about-section .about-content ul li p',

            ]
        );

        $this->add_control(
            'vernex_about_style_one_style_general_content_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-about-section .about-content ul li p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_about_style_two_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_about_section_genaral_style_selection' => ['style_two'],
                ]
            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_two_style_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title.two span',

            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.two span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_subtitle_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.two span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_two_style_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_description',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_two_style_general_description_typ',
                'selector' => '{{WRAPPER}} .home2-about-section .about-content p',
            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-about-section .about-content p span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_description_span_color',
            [
                'label'     => esc_html__('Span Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-about-section .about-content p span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_two_style_general_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn2 span',

            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_button_bg_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_button_bg_icon_color_after',
            [
                'label'     => esc_html__('Icon Color After', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_button_bg_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_button_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_content_title',
            [
                'label'     => esc_html__('Content Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_two_style_general_content_title_typ',
                'selector' => '{{WRAPPER}} .home2-about-section .about-content .about-bottom-content ul li h5',

            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_content_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-about-section .about-content .about-bottom-content ul li h5' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_content_description',
            [
                'label'     => esc_html__('Content Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_two_style_general_content_description_typ',
                'selector' => '{{WRAPPER}} .home2-about-section .about-content .about-bottom-content ul li p',

            ]
        );

        $this->add_control(
            'vernex_about_style_two_style_general_content_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-about-section .about-content .about-bottom-content ul li p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_about_style_three_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_about_section_genaral_style_selection' => ['style_three'],
                ]
            ]
        );

        $this->add_control(
            'vernex_about_style_three_style_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_three_style_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_about_style_three_style_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_three_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_three_style_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_about_style_three_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_about_style_three_style_general_description',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_three_style_general_description_typ',
                'selector' => '{{WRAPPER}} .section-title p',

            ]
        );

        $this->add_control(
            'vernex_about_style_three_style_general_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_three_style_general_content_title',
            [
                'label'     => esc_html__('Content Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_three_style_general_content_title_typ',
                'selector' => '{{WRAPPER}} .home3-about-section .about-content .single-content h5',

            ]
        );

        $this->add_control(
            'vernex_about_style_three_style_general_content_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-about-section .about-content .single-content h5' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_three_style_general_content_description',
            [
                'label'     => esc_html__('Content Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_three_style_general_content_description_typ',
                'selector' => '{{WRAPPER}} .home3-about-section .about-content .single-content p',

            ]
        );

        $this->add_control(
            'vernex_about_style_three_style_general_content_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-about-section .about-content .single-content p' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();


        //style start
        $this->start_controls_section(
            'vernex_about_style_four_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_about_section_genaral_style_selection' => ['style_four'],
                ]
            ]
        );

        $this->add_control(
            'vernex_about_style_four_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_four_style_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title2 h2',

            ]
        );

        $this->add_control(
            'vernex_about_style_four_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title2 h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_four_style_general_description',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_four_style_general_description_typ',
                'selector' => '{{WRAPPER}} .home4-about-section .section-title2 p',

            ]
        );

        $this->add_control(
            'vernex_about_style_four_style_general_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-about-section .section-title2 p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_four_style_general_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_four_style_general_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn2',

            ]
        );

        $this->add_control(
            'vernex_about_style_four_style_general_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_four_style_general_button_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_four_style_general_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_four_style_general_button_icon_color_after',
            [
                'label'     => esc_html__('Icon Color After', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_four_style_general_button_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_four_style_general_content_title',
            [
                'label'     => esc_html__('Content Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_four_style_general_content_title_typ',
                'selector' => '{{WRAPPER}} .home4-about-section .about-wrapper .about-content ul li h5',

            ]
        );

        $this->add_control(
            'vernex_about_style_four_style_general_content_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-about-section .about-wrapper .about-content ul li h5' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_four_style_general_content_description',
            [
                'label'     => esc_html__('Content Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_four_style_general_content_description_typ',
                'selector' => '{{WRAPPER}} .home4-about-section .about-wrapper .about-content ul li p',

            ]
        );

        $this->add_control(
            'vernex_about_style_four_style_general_content_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home4-about-section .about-wrapper .about-content ul li p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();



        //style start
        $this->start_controls_section(
            'vernex_about_style_five_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_about_section_genaral_style_selection' => ['style_five'],
                ]
            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_five_style_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title.four span',

            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.four span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_subtitle_after_color',
            [
                'label'     => esc_html__('After Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_five_style_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_short_description',
            [
                'label'     => esc_html__('Short Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_five_style_general_short_description_typ',
                'selector' => '{{WRAPPER}} .section-title p',

            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_short_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_short_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_five_style_general_short_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn',

            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_short_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_about_style_five_style_general_short_button_underline_color',
            [
                'label'     => esc_html__('Underline Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_short_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_short_button_after_icon_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn::after svg' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_short_button_hover_background_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-about-section .section-title .primary-btn::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_content_description_one',
            [
                'label'     => esc_html__('Content Description One', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_five_style_general_content_description_one_typ',
                'selector' => '{{WRAPPER}} .home5-about-section .single-about .about-content p',

            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_content_description_one_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-about-section .single-about .about-content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_content_description_two',
            [
                'label'     => esc_html__('Content Description Two', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_five_style_general_content_description_two_typ',
                'selector' => '{{WRAPPER}} .home5-about-section .single-about .about-content h3',

            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_content_description_two_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-about-section .single-about .about-content h3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_five_style_general_content_description_two_span_color',
            [
                'label'     => esc_html__('Span Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-about-section .single-about .about-content h3 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_about_style_six_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_about_section_genaral_style_selection' => ['style_six'],
                ]
            ]
        );

        $this->add_control(
            'vernex_about_style_six_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_six_style_general_title_typ',
                'selector' => '{{WRAPPER}} .home6-about-section .about-top-area h2',

            ]
        );

        $this->add_control(
            'vernex_about_style_six_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-about-section .about-top-area h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_six_style_general_title_span_color',
            [
                'label'     => esc_html__('Span Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-about-section .about-top-area h2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_six_style_general_description',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_six_style_general_description_typ',
                'selector' => '{{WRAPPER}} .home6-about-section .about-top-area p',

            ]
        );

        $this->add_control(
            'vernex_about_style_six_style_general_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-about-section .about-top-area p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_six_style_general_description_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-about-section .about-top-area p::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_about_style_six_style_general_content_title',
            [
                'label'     => esc_html__('Content Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_six_style_general_content_title_typ',
                'selector' => '{{WRAPPER}} .home6-about-section .about-content ul li span',

            ]
        );

        $this->add_control(
            'vernex_about_style_six_style_general_content_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-about-section .about-content ul li span' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_about_style_six_style_general_content_description',
            [
                'label'     => esc_html__('Content Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_about_style_six_style_general_content_description_typ',
                'selector' => '{{WRAPPER}} .home6-about-section .about-content ul li',

            ]
        );

        $this->add_control(
            'vernex_about_style_six_style_general_content_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-about-section .about-content ul li' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $contents = $settings['vernex_about_style_one_content_list'];
?>

        <?php if ($settings['vernex_about_section_genaral_style_selection'] == 'style_one') : ?>
            <div class="home1-about-section">
                <div class="container">
                    <div class="about-top-area mb-50">
                        <div class="row g-4 align-items-center justify-content-between">
                            <div class="col-lg-8 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <div class="about-title-area">
                                    <div class="section-title">
                                        <?php if (!empty($settings['vernex_about_section_genaral_subtitle'])) : ?>
                                            <span><?php echo esc_html($settings['vernex_about_section_genaral_subtitle']); ?></span>
                                        <?php endif; ?>
                                        <?php if (!empty($settings['vernex_about_section_genaral_title'])) : ?>
                                            <h2><?php echo esc_html($settings['vernex_about_section_genaral_title']); ?></h2>
                                        <?php endif; ?>
                                    </div>
                                    <div class="video-and-content">
                                        <?php if (!empty($settings['vernex_about_section_genaral_video_url']['url'])) : ?>
                                            <a data-fancybox="video-player" href="<?php echo esc_url($settings['vernex_about_section_genaral_video_url']['url']); ?>" class="video-area">
                                                <div class="icon">
                                                    <svg class="video-circle" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                                        x="0px" y="0px" width="77px" viewBox="0 0 206 206" style="enable-background:new 0 0 206 206;" xml:space="preserve">
                                                        <circle class="circle" stroke-miterlimit="10" cx="103" cy="103" r="100"></circle>
                                                        <path class="circle-half top-half" stroke-width="4" stroke-miterlimit="10"
                                                            d="M16.4,53C44,5.2,105.2-11.2,153,16.4s64.2,88.8,36.6,136.6"></path>
                                                        <path class="circle-half bottom-half" stroke-width="4" stroke-miterlimit="10"
                                                            d="M189.6,153C162,200.8,100.8,217.2,53,189.6S-11.2,100.8,16.4,53"></path>
                                                    </svg>
                                                    <svg class="play-icon" width="23" height="28" viewBox="0 0 23 28" xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M22.8424 14.2559C22.8424 13.4843 22.4449 12.7737 21.7784 12.3539L3.78608 1.03446C3.05833 0.577358 2.17083 0.543963 1.40902 0.947257C0.649591 1.35033 0.195312 2.09429 0.195312 2.93663V25.5738C0.195312 26.4162 0.649555 27.1599 1.41018 27.5632C1.76475 27.7501 2.14507 27.8431 2.52543 27.8431C2.96275 27.8431 3.39718 27.7197 3.78584 27.476L21.7782 16.1583C22.4449 15.7383 22.8424 15.0277 22.8424 14.2561V14.2559ZM21.1289 15.177L3.13659 26.4947C2.78345 26.7165 2.35329 26.7315 1.98441 26.5376C1.61553 26.3424 1.39473 25.9822 1.39473 25.5736V2.93642C1.39473 2.52778 1.61553 2.16621 1.98441 1.97237C2.15681 1.88239 2.34185 1.83669 2.52569 1.83669C2.73791 1.83669 2.9487 1.8963 3.13685 2.0155L21.1292 13.335C21.4568 13.5414 21.6447 13.8781 21.6447 14.2575C21.6444 14.6356 21.4565 14.9707 21.1289 15.177Z" />
                                                    </svg>
                                                </div>
                                            </a>
                                        <?php endif; ?>
                                        <?php if (!empty($settings['vernex_about_section_genaral_short_description'])) : ?>
                                            <div class="content">
                                                <p><?php echo esc_html($settings['vernex_about_section_genaral_short_description']); ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php if (!empty($settings['vernex_about_section_genaral_button_text'])) : ?>
                                <div class="col-xl-2 col-lg-3 d-flex justify-content-lg-end">
                                    <a href="<?php echo esc_url($settings['vernex_about_section_genaral_button_url']['url']); ?>" class="about-btn btn_wrapper">
                                        <div class="bg">
                                            <svg width="170" height="170" viewBox="0 0 170 170" xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M77.3692 2.27213C82.1102 -0.382126 87.8898 -0.382126 92.6308 2.27213C95.8749 4.08835 99.6604 4.68792 103.307 3.96307C108.636 2.90377 114.133 4.68978 117.822 8.67916C120.346 11.409 123.761 13.149 127.453 13.5865C132.848 14.2258 137.524 17.623 139.8 22.557C141.357 25.9332 144.067 28.6434 147.443 30.2003C152.377 32.4757 155.774 37.1516 156.414 42.5472C156.851 46.2393 158.591 49.6543 161.321 52.1784C165.31 55.8671 167.096 61.3638 166.037 66.693C165.312 70.3396 165.912 74.1251 167.728 77.3692C170.382 82.1102 170.382 87.8898 167.728 92.6308C165.912 95.8749 165.312 99.6604 166.037 103.307C167.096 108.636 165.31 114.133 161.321 117.822C158.591 120.346 156.851 123.761 156.414 127.453C155.774 132.848 152.377 137.524 147.443 139.8C144.067 141.357 141.357 144.067 139.8 147.443C137.524 152.377 132.848 155.774 127.453 156.414C123.761 156.851 120.346 158.591 117.822 161.321C114.133 165.31 108.636 167.096 103.307 166.037C99.6604 165.312 95.8749 165.912 92.6308 167.728C87.8898 170.382 82.1102 170.382 77.3692 167.728C74.1251 165.912 70.3396 165.312 66.693 166.037C61.3638 167.096 55.8671 165.31 52.1784 161.321C49.6543 158.591 46.2393 156.851 42.5472 156.414C37.1516 155.774 32.4757 152.377 30.2003 147.443C28.6434 144.067 25.9332 141.357 22.557 139.8C17.623 137.524 14.2258 132.848 13.5865 127.453C13.149 123.761 11.409 120.346 8.67916 117.822C4.68978 114.133 2.90377 108.636 3.96307 103.307C4.68792 99.6604 4.08835 95.8749 2.27213 92.6308C-0.382126 87.8898 -0.382126 82.1102 2.27213 77.3692C4.08835 74.1251 4.68792 70.3396 3.96307 66.693C2.90377 61.3638 4.68977 55.8671 8.67916 52.1784C11.409 49.6543 13.149 46.2393 13.5865 42.5472C14.2258 37.1516 17.623 32.4757 22.557 30.2003C25.9332 28.6434 28.6434 25.9332 30.2003 22.557C32.4757 17.623 37.1516 14.2258 42.5472 13.5865C46.2393 13.149 49.6543 11.409 52.1784 8.67916C55.8671 4.68977 61.3638 2.90377 66.693 3.96307C70.3396 4.68792 74.1251 4.08835 77.3692 2.27213Z" />
                                                <path
                                                    d="M77.6135 2.70841C82.2027 0.139114 87.7973 0.139114 92.3865 2.70841C95.7345 4.58277 99.6412 5.20153 103.404 4.45348C108.563 3.42808 113.884 5.15692 117.455 9.01861C120.059 11.8358 123.584 13.6315 127.394 14.083C132.617 14.7019 137.143 17.9903 139.346 22.7664C140.952 26.2507 143.749 29.0476 147.234 30.6544C152.01 32.8569 155.298 37.3831 155.917 42.6061C156.368 46.4163 158.164 49.9406 160.981 52.5455C164.843 56.1161 166.572 61.437 165.547 66.5955C164.798 70.3588 165.417 74.2655 167.292 77.6135C169.861 82.2027 169.861 87.7973 167.292 92.3865C165.417 95.7345 164.798 99.6412 165.547 103.404C166.572 108.563 164.843 113.884 160.981 117.455C158.164 120.059 156.368 123.584 155.917 127.394C155.298 132.617 152.01 137.143 147.234 139.346C143.749 140.952 140.952 143.749 139.346 147.234C137.143 152.01 132.617 155.298 127.394 155.917C123.584 156.368 120.059 158.164 117.455 160.981C113.884 164.843 108.563 166.572 103.404 165.547C99.6412 164.798 95.7345 165.417 92.3865 167.292C87.7973 169.861 82.2027 169.861 77.6135 167.292C74.2655 165.417 70.3588 164.798 66.5955 165.547C61.437 166.572 56.1161 164.843 52.5455 160.981C49.9406 158.164 46.4163 156.368 42.6061 155.917C37.3831 155.298 32.8569 152.01 30.6544 147.234C29.0476 143.749 26.2507 140.952 22.7664 139.346C17.9903 137.143 14.7019 132.617 14.083 127.394C13.6315 123.584 11.8358 120.059 9.01861 117.455C5.15692 113.884 3.42808 108.563 4.45348 103.404C5.20153 99.6412 4.58277 95.7345 2.70841 92.3865C0.139114 87.7973 0.139114 82.2027 2.70841 77.6135C4.58277 74.2655 5.20153 70.3588 4.45348 66.5955C3.42808 61.437 5.15692 56.1161 9.01861 52.5455C11.8358 49.9406 13.6315 46.4163 14.083 42.606C14.7019 37.3831 17.9903 32.8569 22.7664 30.6544C26.2507 29.0476 29.0476 26.2507 30.6544 22.7664C32.8569 17.9903 37.3831 14.7019 42.606 14.083C46.4163 13.6315 49.9406 11.8358 52.5455 9.01861C56.1161 5.15692 61.437 3.42808 66.5955 4.45348C70.3588 5.20153 74.2655 4.58277 77.6135 2.70841Z" stroke-opacity="0.1" />
                                            </svg>
                                        </div>

                                        <div class="primary-btn">
                                            <?php echo esc_html($settings['vernex_about_section_genaral_button_text']); ?>
                                            <svg viewBox="0 0 13 20">
                                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                            </svg>
                                        </div>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="row align-items-center">
                        <div class="col-lg-5">
                            <div class="about-content">
                                <ul>
                                    <?php foreach ($contents as $content) : ?>
                                        <li>
                                            <?php if (!empty($content['vernex_about_style_one_content_title'])) : ?>
                                                <h5><?php echo esc_html($content['vernex_about_style_one_content_title']); ?></h5>
                                            <?php endif; ?>
                                            <?php if (!empty($content['vernex_about_style_one_content_description'])) : ?>
                                                <p><?php echo esc_html($content['vernex_about_style_one_content_description']); ?></p>
                                            <?php endif; ?>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                        <?php if (!empty($settings['vernex_about_style_one_banner_image']['url'])) : ?>
                            <div class="col-lg-7 d-lg-block d-none">
                                <div class="about-img magnetic-item">
                                    <img src="<?php echo esc_url($settings['vernex_about_style_one_banner_image']['url']); ?>" alt="<?php echo esc_attr__('banner-image', 'vernex-core'); ?>">
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_about_section_genaral_style_selection'] == 'style_two') : ?>
            <div class="home2-about-section">
                <div class="container">
                    <div class="row mb-60 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-lg-7">
                            <div class="section-title two">
                                <?php if (!empty($settings['vernex_about_section_genaral_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_about_section_genaral_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_about_section_genaral_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_about_section_genaral_title']); ?></h2>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="row gy-lg-5 gy-4">
                        <?php if (!empty($settings['vernex_about_style_one_banner_image']['url'])) : ?>
                            <div class="col-lg-5">
                                <div class="about-img magnetic-item">
                                    <img src="<?php echo esc_url($settings['vernex_about_style_one_banner_image']['url']); ?>" alt="<?php echo esc_attr__('banner-image', 'vernex-core'); ?>">
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="col-lg-7 d-flex align-items-lg-end wow animate fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="about-content">
                                <?php if (!empty($settings['vernex_about_section_genaral_short_description'])) : ?>
                                    <p><?php echo wp_kses($settings['vernex_about_section_genaral_short_description'], wp_kses_allowed_html('post')); ?></p>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_about_section_genaral_button_text'])) : ?>
                                    <a href="<?php echo esc_url($settings['vernex_about_section_genaral_button_url']['url']); ?>" class="primary-btn2">
                                        <span>
                                            <?php echo esc_html($settings['vernex_about_section_genaral_button_text']); ?>
                                            <svg viewBox="0 0 13 20">
                                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                            </svg>
                                        </span>
                                    </a>
                                <?php endif; ?>
                                <div class="about-bottom-content">
                                    <ul>
                                        <?php foreach ($contents as $content) : ?>
                                            <li>
                                                <?php if (!empty($content['vernex_about_style_one_content_title'])) : ?>
                                                    <h5><?php echo esc_html($content['vernex_about_style_one_content_title']); ?></h5>
                                                <?php endif; ?>
                                                <?php if (!empty($content['vernex_about_style_one_content_description'])) : ?>
                                                    <p><?php echo esc_html($content['vernex_about_style_one_content_description']); ?></p>
                                                <?php endif; ?>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>



        <?php if ($settings['vernex_about_section_genaral_style_selection'] == 'style_three') : ?>
            <div class="home3-about-section">
                <div class="container">
                    <div class="row mb-80 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-lg-8">
                            <div class="section-title three">
                                <?php if (!empty($settings['vernex_about_section_genaral_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_about_section_genaral_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_about_section_genaral_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_about_section_genaral_title']); ?></h2>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_about_section_genaral_short_description'])) : ?>
                                    <p><?php echo wp_kses($settings['vernex_about_section_genaral_short_description'], wp_kses_allowed_html('post')); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="about-content mb-80">
                        <div class="row justify-content-lg-end">
                            <div class="col-xl-10 col-lg-11">
                                <div class="row g-4">
                                    <?php foreach ($contents as $content) : ?>
                                        <div class="col-md-4 col-sm-6">
                                            <div class="single-content">
                                                <?php if (!empty($content['vernex_about_style_one_content_title'])) : ?>
                                                    <h5><?php echo esc_html($content['vernex_about_style_one_content_title']); ?></h5>
                                                <?php endif; ?>
                                                <?php if (!empty($content['vernex_about_style_one_content_description'])) : ?>
                                                    <p><?php echo esc_html($content['vernex_about_style_one_content_description']); ?></p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="about-img wow animate fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <img src="<?php echo esc_url($settings['vernex_about_style_one_banner_image']['url']); ?>" alt="<?php echo esc_attr__('banner-image', 'vernex-core'); ?>">
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_about_section_genaral_style_selection'] == 'style_four') : ?>
            <div class="home4-about-section">
                <div class="container">
                    <div class="row g-4 align-items-center justify-content-between">
                        <div class="col-xl-6 col-lg-8 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="section-title2">
                                <?php if (!empty($settings['vernex_about_section_genaral_title'])) : ?>
                                    <h2><?php echo wp_kses($settings['vernex_about_section_genaral_title'], wp_kses_allowed_html('post')); ?></h2>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_about_section_genaral_short_description'])) : ?>
                                    <p><?php echo wp_kses($settings['vernex_about_section_genaral_short_description'], wp_kses_allowed_html('post')); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if (!empty($settings['vernex_about_section_genaral_button_text'])) : ?>
                            <div class="col-lg-3 d-flex justify-content-lg-center btn_wrapper">
                                <a href="<?php echo esc_url($settings['vernex_about_section_genaral_button_url']['url']); ?>" class="primary-btn2 transparent">
                                    <span>
                                        <?php echo esc_html($settings['vernex_about_section_genaral_button_text']); ?>
                                        <svg viewBox="0 0 13 20">
                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                        </svg>
                                    </span>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="about-wrapper">
                        <div class="row justify-content-end">
                            <div class="col-xl-11">
                                <div class="row g-4 justify-content-between">
                                    <?php if (!empty($settings['vernex_about_style_one_banner_image']['url'])) : ?>
                                        <div class="col-lg-8">
                                            <div class="about-img">
                                                <img src="<?php echo esc_url($settings['vernex_about_style_one_banner_image']['url']); ?>" alt="<?php echo esc_attr__('banner-image', 'vernex-core'); ?>">
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <div class="col-lg-4 d-flex justify-content-lg-center">
                                        <div class="about-content">
                                            <ul>
                                                <?php foreach ($contents as $content) : ?>
                                                    <li>
                                                        <?php if (!empty($content['vernex_about_style_one_content_title'])) : ?>
                                                            <h5><?php echo esc_html($content['vernex_about_style_one_content_title']); ?></h5>
                                                        <?php endif; ?>
                                                        <?php if (!empty($content['vernex_about_style_one_content_description'])) : ?>
                                                            <p><?php echo esc_html($content['vernex_about_style_one_content_description']); ?></p>
                                                        <?php endif; ?>
                                                    </li>
                                                <?php endforeach; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_about_section_genaral_style_selection'] == 'style_five') : ?>
            <div class="home5-about-section">
                <div class="container">
                    <div class="row justify-content-center wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-xxl-6 col-xl-7 col-lg-8">
                            <div class="section-title four text-center">
                                <?php if (!empty($settings['vernex_about_section_genaral_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_about_section_genaral_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_about_section_genaral_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_about_section_genaral_title']); ?></h2>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_about_section_genaral_short_description'])) : ?>
                                    <p><?php echo esc_html($settings['vernex_about_section_genaral_short_description']); ?></p>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_about_section_genaral_button_text'])) : ?>
                                    <a href="<?php echo esc_url($settings['vernex_about_section_genaral_button_url']['url']); ?>" class="primary-btn">
                                        <?php echo esc_html($settings['vernex_about_section_genaral_button_text']); ?>
                                        <svg viewBox="0 0 13 20">
                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                        </svg>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="about-content-wrap">
                        <div class="row gy-sm-5 gy-4">
                            <div class="col-lg-6 pt-120">
                                <div class="single-about">
                                    <?php if (!empty($settings['vernex_about_style_five_banner_image_one'])) : ?>
                                        <div class="about-img btn_wrapper">
                                            <img src="<?php echo esc_url($settings['vernex_about_style_five_banner_image_one']['url']); ?>" alt="<?php echo esc_attr__('banner-image-one', 'vernex-core'); ?>">
                                        </div>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_about_style_five_banner_content_description_one'])) : ?>
                                        <div class="about-content">
                                            <p><?php echo esc_html($settings['vernex_about_style_five_banner_content_description_one']); ?></p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="single-about">
                                    <?php if (!empty($settings['vernex_about_style_five_banner_image_two']['url'])) : ?>
                                        <div class="about-img btn_wrapper">
                                            <img src="<?php echo esc_url($settings['vernex_about_style_five_banner_image_two']['url']); ?>" alt="<?php echo esc_attr__('banner-image-two', 'vernex-core'); ?>">
                                        </div>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_about_style_five_banner_content_description_two'])) : ?>
                                        <div class="about-content">
                                            <h3><?php echo wp_kses($settings['vernex_about_style_five_banner_content_description_two'], wp_kses_allowed_html('post')); ?></h3>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>




        <?php if ($settings['vernex_about_section_genaral_style_selection'] == 'style_six') : ?>
            <div class="home6-about-section">
                <div class="container">
                    <div class="about-top-area">
                        <div class="row justify-content-center wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="col-lg-10">
                                <div class="title">
                                    <?php if (!empty($settings['vernex_about_section_genaral_title'])) : ?>
                                        <h2><?php echo wp_kses($settings['vernex_about_section_genaral_title'], wp_kses_allowed_html('post')); ?></h2>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php if (!empty($settings['vernex_about_section_genaral_short_description'])) : ?>
                            <p><?php echo esc_html($settings['vernex_about_section_genaral_short_description']); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="about-bottom-area">
                        <div class="row g-4 align-items-lg-end">
                            <?php if (!empty($settings['vernex_about_style_one_banner_image']['url'])) : ?>
                                <div class="col-lg-7">
                                    <div class="about-img magnetic-item">
                                        <img src="<?php echo esc_url($settings['vernex_about_style_one_banner_image']['url']); ?>" alt="<?php echo  esc_attr__('banner-image', 'vernex-core'); ?>">
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($contents)) : ?>
                                <div class="col-lg-5">
                                    <div class="about-content">
                                        <ul>
                                            <?php foreach ($contents as $content) : ?>
                                                <li><?php if (!empty($content['vernex_about_style_one_content_title'])): ?><span><?php echo esc_html($content['vernex_about_style_one_content_title']); ?></span><?php endif; ?> <?php if (!empty($content['vernex_about_style_one_content_description'])) : ?> <?php echo esc_html($content['vernex_about_style_one_content_description']); ?><?php endif; ?></li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_About_Widget());
