<?php

/**
 * The main template file
 *
 * Template Name: Blog Grid With Sidebar
 *
 * @link https: //developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package vernex
 * @since 1.0.0
 * 
 */


use Egns\Inc\Blog_Helper;

get_header();

if (!is_front_page()) {
    // Include breadcrumb template
    Egns\Helper\Egns_Helper::egns_template_part('breadcrumb', 'templates/breadcrumb-archive');
}


?>
<div class="blog-sidebar-page pt-120 mb-120">
    <div class="container">
        <div class="row gy-5">
            <div class="col-lg-8">
                <div class="row gy-5">
                    <?php

                    $args = array(
                        'post_type'      => 'post',
                        'posts_per_page' => 8,
                        'post_status'    => 'publish',
                        'paged'          => (get_query_var('paged')) ? get_query_var('paged') : 1
                    );

                    $wp_query = new WP_Query($args);

                    if ($wp_query->have_posts()) {
                        while ($wp_query->have_posts()): $wp_query->the_post();

                    ?>
                            <div class="col-md-6 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <div class="blog-card magnetic-item">
                                    <?php
                                    Egns\Helper\Egns_Helper::egns_template_part('blog', 'templates/common/grid/thumbnail');
                                    ?>
                                    <?php
                                    Egns\Helper\Egns_Helper::egns_template_part('blog', 'templates/common/grid/content');
                                    ?>
                                </div>
                            </div>
                    <?php
                        endwhile;  // End of the loop.

                    } else {
                        // Include global posts not found
                        Egns\Helper\Egns_Helper::egns_template_part('content', 'templates/posts-not-found');
                    }
                    ?>
                </div>
                <div class="row">
                    <div class="col-lg-12 d-flex justify-content-center">
                        <div class="innerpage-pagination-area">
                            <?php
                            // Pagination
                            echo Egns\Inc\Blog_Helper::egns_pagination();
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            // Include page content sidebar
            Egns\Helper\Egns_Helper::egns_template_part('sidebar', 'templates/sidebar');
            ?>

        </div>
    </div>
</div>
<?php
get_footer();
?>