<?php
$enable_breadcrumb_by_theme = Egns\Helper\Egns_Helper::egns_get_theme_option('breadcrumb_enable');
$breadcrumb_enable_by_page = Egns\Helper\Egns_Helper::egns_page_option_value('enable_breadcrumb');
$page_breadcrumb_image = Egns\Helper\Egns_Helper::egns_page_option_value('breadcrumb_page_bg_image');

if (Egns\Helper\Egns_Helper::is_enabled($enable_breadcrumb_by_theme, $breadcrumb_enable_by_page)) { ?>

    <div class="breadcrumb-section">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="banner-wrapper">
                        <div class="banner-content">
                            <?php if (!empty(Egns\Helper\Egns_Helper::egns_page_option_value('page_breadcrumb_subtitle_text'))) : ?>
                                <span><?php echo esc_html(Egns\Helper\Egns_Helper::egns_page_option_value('page_breadcrumb_subtitle_text')); ?></span>
                            <?php else : ?>
                                <span><?php echo esc_html(Egns\Helper\Egns_Helper::egns_get_theme_option('breadcrumb_subtitle_text')); ?></span>
                            <?php endif; ?>
                            <h1>
                                <?php
                                $term = get_queried_object();
                                if (is_category()) {
                                    echo esc_html__('Category : ', 'vernex');
                                    single_cat_title();
                                } elseif (is_tag()) {
                                    echo esc_html__('Tag : ', 'vernex');
                                    single_tag_title();
                                } elseif (is_author()) {
                                    echo esc_html__('Author : ', 'vernex');
                                    the_author();
                                } elseif (is_date()) {
                                    echo esc_html__('Date : ', 'vernex');
                                    if (is_day()) {
                                        echo get_the_time('F j, Y');
                                    } else if (is_month()) {
                                        echo get_the_time('F, Y');
                                    } else if (is_year()) {
                                        echo get_the_time('Y');
                                    }
                                } elseif (is_tax() && $term->taxonomy == 'project-category' && $term) {
                                    Egns\Helper\Egns_Helper::egns_translate_with_escape_('Category: ');
                                    echo sprintf(__('%s', 'vernex'), $term->name);
                                } elseif (is_tax() && $term->taxonomy == 'properties-type' && $term) {
                                    Egns\Helper\Egns_Helper::egns_translate_with_escape_('Type: ');
                                    echo sprintf(__('%s', 'vernex'), $term->name);
                                } elseif (is_tax() && $term->taxonomy == 'properties-location' && $term) {
                                    Egns\Helper\Egns_Helper::egns_translate_with_escape_('Location: ');
                                    echo sprintf(__('%s', 'vernex'), $term->name);
                                } elseif (is_tax() && $term) {
                                    echo sprintf(__('%s', 'vernex'), $term->taxonomy) . ": " . sprintf(__('%s', 'vernex'), $term->name);
                                } elseif (is_home()) {
                                    Egns\Helper\Egns_Helper::egns_translate_with_escape_('Blog');
                                } elseif (is_post_type_archive('product')) {
                                    Egns\Helper\Egns_Helper::egns_translate_with_escape_('Shop');
                                } elseif (is_post_type_archive('project')) {
                                    Egns\Helper\Egns_Helper::egns_translate_with_escape_('Project');
                                } elseif (is_post_type_archive('properties')) {
                                    Egns\Helper\Egns_Helper::egns_translate_with_escape_('Properties');
                                } else {
                                    the_title();
                                }
                                ?>
                            </h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
}
?>