<?php

use Egns\Inc\Blog_Helper;
?>
<div class="blog-content">
    <div class="blog-meta">
        <ul>
            <li>
                <a href="<?php echo esc_url(home_url(get_the_date('Y/m/d'))) ?>" class="blog-date">
                    <?php echo get_the_date('F d, Y'); ?>
                </a>
            </li>
            <li><?php Blog_Helper::the_first_category() ?></li>
        </ul>
    </div>
    <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
    <p><?php echo wp_trim_words(get_the_content(), 40, '...'); ?></p>
    <a href="<?php the_permalink(); ?>"><?php echo esc_html__('Read More', 'vernex'); ?> <i class="bi bi-chevron-right"></i></a>
</div>