<?php
function add_query_vars_filter($vars)
{
    // add custom query vars that will be public
    // https://codex.wordpress.org/WordPress_Query_Vars

    // Get name same as field name 
    $vars[] .= 'properties_type';
    $vars[] .= 'properties_status';
    $vars[] .= 'properties_location';

    return $vars;
}
add_filter('query_vars', 'add_query_vars_filter');
/**
 * Override Vehicle Archive Query
 * https:   //codex.wordpress.org/Plugin_API/Action_Reference/pre_get_posts
 */

function egns_properties_filter($query)
{

    if ($query->is_archive('properties') && $query->is_main_query() && !is_admin()) {

        // Get name same as field name 
        $properties_status   = get_query_var('properties_status');
        $properties_type     = get_query_var('properties_type');
        $properties_location = get_query_var('properties_location');

        // Start meta query
        $meta_query_array = array('relation' => 'AND');

        $properties_status ? array_push($meta_query_array, array('key' => 'EGNS_PROPERTIES_META_ID', 'value' => $properties_status, 'compare' => 'LIKE')) : null;

        // final meta_query
        $query->set('meta_query', $meta_query_array);

        // Start taxonomy query
        $tax_query_array = array('relation' => 'AND');

        if (!empty($properties_type)) {
            $properties_type ? array_push($tax_query_array, array('taxonomy' => 'properties-type', 'field' => 'slug', 'terms' => $properties_type)) : null;
        }
        if (!empty($properties_location)) {
            $properties_location ? array_push($tax_query_array, array('taxonomy' => 'properties-location', 'field' => 'slug', 'terms' => $properties_location)) : null;
        }
        // final tax_query
        $query->set('tax_query', $tax_query_array);
    }
}
add_action('pre_get_posts', 'egns_properties_filter');
