<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package vernex
 */

get_header();

?>

<?php if (class_exists('CSF')) : ?>
    <div class="error-page sec-mar">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-10">
                    <div class="error-wrapper">
                        <?php if (!empty(Egns\Helper\Egns_Helper::egns_get_theme_option('404_image', 'url'))) : ?>
                            <div class="error-img">
                                <img src="<?php echo esc_url(Egns\Helper\Egns_Helper::egns_get_theme_option('404_image', 'url')) ?>" alt="<?php echo esc_attr__('404-image', 'vernex'); ?>">
                            </div>
                        <?php endif; ?>
                        <div class="error-content">
                            <h1><?php echo wp_kses(Egns\Helper\Egns_Helper::egns_get_theme_option('404_title'), wp_kses_allowed_html('post')) ?></h1>
                            <p><?php echo wp_kses(Egns\Helper\Egns_Helper::egns_get_theme_option('404_content'), wp_kses_allowed_html('post')) ?></p>
                            <a href="<?php echo esc_url(home_url('/')); ?>" class="primary-btn3 two">
                                <span>
                                    <?php echo wp_kses(Egns\Helper\Egns_Helper::egns_get_theme_option('404_button_text'), wp_kses_allowed_html('post')) ?>
                                    <svg viewBox="0 0 13 20">
                                        <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                    </svg>
                                </span>
                                <i class="corner tl"></i>
                                <i class="corner tr"></i>
                                <i class="corner br"></i>
                                <i class="corner bl"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php else : ?>
    <div class="error-page sec-mar">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-10">
                    <div class="error-wrapper">
                        <div class="error-img">
                            <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/img/inner-pages/error-img.png') ?>" alt="<?php echo esc_attr__('error-image', 'vernex'); ?>">
                        </div>
                        <div class="error-content">
                            <h1><?php echo esc_html__('Sorry! Page not found.', 'vernex'); ?></h1>
                            <p><?php echo esc_html__('The page you are looking for was moved, removed, renamed or never existed. we are open for this constructions & architecture', 'vernex'); ?></p>
                            <a href="<?php echo esc_url(home_url('/')); ?>" class="primary-btn3 two">
                                <span>
                                    <?php echo esc_html__('Take Me Home', 'vernex'); ?>
                                    <svg viewBox="0 0 13 20">
                                        <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                    </svg>
                                </span>
                                <i class="corner tl"></i>
                                <i class="corner tr"></i>
                                <i class="corner br"></i>
                                <i class="corner bl"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif ?>
<?php
get_footer();
