<?php

//rPost Tags custom widget

class Egns_Post_Tags_Widget extends WP_Widget
{

    function __construct()
    {
        parent::__construct(

            // Base ID of our widget
            'egns_post_tags',

            // Widget name
            __('Egns Post Tags', 'vernex-core'),

            // Widget description
            array('description' => __('Display your post tags', 'vernex-core'),)
        );
    }

    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        $number_of_tags = isset($instance['number_of_tags']) ? $instance['number_of_tags'] : 3;

        echo $args['before_widget'];

        // Display widget title
        if (!empty($title)) {
            echo $args['before_title'] . $title . $args['after_title'];
        }
        //Fetch tags limited 
        $tags = get_tags(array(
            'number' => $number_of_tags,
            'orderby' => 'count',
            'order'   => 'DESC'
        ));
?>

            <ul class="tag-list">
                <?php
                foreach ($tags as $tag) {
                    $tag_id = $tag->term_id;
                    $tag_link = get_tag_link($tag_id);
                    $tag_name = $tag->name;
                
                    ?>
                    <li>
                        <a href="<?php echo esc_url($tag_link); ?>">#<?php echo esc_html($tag_name); ?> </a>
                    </li>
                <?php } ?>
            </ul>

    <?php
        echo $args['after_widget'];
    }

    // Widget Backend
    public function form($instance)
    {
        $title = '';
        if (isset($instance['title'])) {
            $title = $instance['title'];
            $number_of_tags = isset($instance['number_of_tags']) ? $instance['number_of_tags'] : 3;
        }
    ?>
        <!--Title-->
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'vernex-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <input class="tiny-text" id="<?php echo esc_attr($this->get_field_id('number_of_tags')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('number_of_tags')); ?>" type="number" 
                   step="1" min="1" value="<?php echo esc_attr($number_of_tags); ?>" size="3">
        </p>
<?php
    }

    // Updating widget replacing old instances with
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? sanitize_text_field($new_instance['title']) : '';
        $instance['number_of_tags'] = (!empty($new_instance['number_of_tags'])) ? intval($new_instance['number_of_tags']) : 3;
        return $instance;
    }
}

if (!function_exists('Egns_Post_Tags_Widget')) {
    function Egns_Post_Tags_Widget()
    {
        register_widget('Egns_Post_Tags_Widget');
    }
    add_action('widgets_init', 'Egns_Post_Tags_Widget');
}