<?php

class Custom_Footer_Widget extends WP_Widget
{

    function __construct()
    {
        parent::__construct(
            // Base ID of our widget
            'custom_footer_widget',

            // Widget name
            __('Egns Footer Subscribe and Contact', 'vernex-core'),

            // Widget description
            array('description' => __('Add custom Contact to the footer.', 'vernex-core'))
        );
    }

    public function widget($args, $instance)
    {
        echo $args['before_widget'];

        // Output the custom content here
?>
        <div class="newletter-and-payment-wrap">
            <div class="newletter-area">
                <?php if (!empty($instance['subscribe_title'])) : ?>
                    <h4><?php echo esc_html($instance['subscribe_title']) ?></h4>
                <?php endif; ?>
                <?php echo do_shortcode($instance['subscribe_shortcode']) ?>
            </div>
            <div class="payment-area">
                <?php if (!empty($instance['payment_title'])) : ?>
                    <h6><?php echo esc_html($instance['payment_title']) ?></h6>
                <?php endif; ?>
                <?php if (!empty($instance['payment_image'])) : ?>
                    <ul class="payment-options">
                        <li><img src="<?php echo esc_url($instance['payment_image']); ?>" alt="<?php echo esc_attr_e('payment-image', 'vernex-core'); ?>"></li>
                    </ul>
                <?php endif; ?>
            </div>
        </div>

    <?php

        echo $args['after_widget'];
    }

    public function form($instance)
    {
        // Widget settings form
        $subscribe_title = !empty($instance['subscribe_title']) ? $instance['subscribe_title'] : '';
        $payment_title = !empty($instance['payment_title']) ? $instance['payment_title'] : '';
        $subscribe_shortcode = !empty($instance['subscribe_shortcode']) ? $instance['subscribe_shortcode'] : '';
        $payment_image = !empty($instance['payment_image']) ? $instance['payment_image'] : '';

    ?>

        <p>
            <label for="<?php echo $this->get_field_id('subscribe_title'); ?>"> <?php echo esc_html('Subscribe Title ') ?> </label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('subscribe_title'); ?>" name="<?php echo $this->get_field_name('subscribe_title'); ?>" value="<?php echo esc_attr($subscribe_title); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('subscribe_shortcode'); ?>"><?php echo esc_html('Subscribe Shortcode ') ?> </label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('subscribe_shortcode'); ?>" name="<?php echo $this->get_field_name('subscribe_shortcode'); ?>" value="<?php echo esc_attr($subscribe_shortcode); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('payment_title'); ?>"> <?php echo esc_html('Payment Title ') ?> </label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('payment_title'); ?>" name="<?php echo $this->get_field_name('payment_title'); ?>" value="<?php echo esc_attr($payment_title); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('payment_image'); ?>"><?php echo esc_html('Payment Image URL:') ?> </label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('payment_image'); ?>" name="<?php echo $this->get_field_name('payment_image'); ?>" value="<?php echo esc_attr($payment_image); ?>">
        </p>

<?php
    }

    public function update($new_instance, $old_instance)
    {
        // Save widget settings
        $instance = array();
        $instance['subscribe_title'] = !empty($new_instance['subscribe_title']) ? sanitize_text_field($new_instance['subscribe_title']) : '';
        $instance['subscribe_shortcode'] = !empty($new_instance['subscribe_shortcode']) ? sanitize_text_field($new_instance['subscribe_shortcode']) : '';
        $instance['payment_title'] = !empty($new_instance['payment_title']) ? sanitize_text_field($new_instance['payment_title']) : '';
        $instance['payment_image'] = !empty($new_instance['payment_image']) ? sanitize_text_field($new_instance['payment_image']) : '';
        return $instance;
    }
}


function register_custom_footer_widget()
{
    register_widget('Custom_Footer_Widget');
}
add_action('widgets_init', 'register_custom_footer_widget');
